/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.annotation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotation;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationGroup;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotationManager;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.core.gui.SpoonInterface;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.refinery.publish.util.ObjectUtils;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.annotation.ModelAnnotationMeta;
import org.pentaho.di.trans.util.TransUtil;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.steps.annotation.WarningDialog;
import org.pentaho.di.ui.trans.steps.common.ModelAnnotationEvent;
import org.pentaho.di.ui.trans.steps.common.ModelAnnotationsTableComposite;
import org.pentaho.metastore.api.exceptions.MetaStoreException;

public abstract class BaseAnnotationStepDialog
extends BaseStepDialog
implements StepDialogInterface {
    protected static Class<?> PKG = ModelAnnotationMeta.class;
    protected final int margin = 4;
    protected final int LEFT_MARGIN_OFFSET = 10;
    protected final int RIGHT_MARGIN_OFFSET = -10;
    protected final int SHELL_MIN_WIDTH = 900;
    protected final int SHELL_MIN_HEIGHT = 670;
    protected StyledText wDescription;
    protected Button wApply;
    protected Button wHelp;
    protected Label wIcon;
    protected Label wBottomHorizontalSeparator;
    protected ModelAnnotationMeta input;
    protected ModifyListener lsMod;
    protected Listener lsApply;
    protected Listener lsGroups;
    protected Listener lsAddGroup;
    protected Listener lsCopyGroup;
    protected Listener lsCheckForVariables;
    protected final Stack<String> markedForDeletion = new Stack();
    protected boolean modelAnnotationDirty;
    protected boolean preventNewOrRename;

    public BaseAnnotationStepDialog(Shell parent, Object baseStepMeta, TransMeta transMeta, String stepname) {
        super(parent, (StepMetaInterface)baseStepMeta, transMeta, stepname);
        this.input = (ModelAnnotationMeta)((Object)baseStepMeta);
        TransUtil.resetParams((AbstractMeta)transMeta, transMeta.getLogChannel());
    }

    public String open() {
        this.configureShell();
        this.initializeListeners();
        this.createOkCancelButtons();
        Control topWidget = this.createStepNameWidget();
        this.createContent(topWidget);
        this.afterOpen();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.getParent().getDisplay().readAndDispatch()) continue;
            this.getParent().getDisplay().sleep();
        }
        return this.stepname;
    }

    protected void configureShell() {
        this.shell = new Shell(this.getParent(), 3312);
        FormLayout shellLayout = new FormLayout();
        shellLayout.marginWidth = 5;
        shellLayout.marginHeight = 5;
        this.shell.setLayout((Layout)shellLayout);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        this.shell.setText(this.getDialogTitle());
        this.shell.setMinimumSize(900, 670);
        this.shell.setSize(900, 670);
    }

    protected void initializeListeners() {
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BaseAnnotationStepDialog.this.input.setChanged();
            }
        };
        this.lsApply = new Listener(){

            public void handleEvent(Event event) {
                if (BaseAnnotationStepDialog.this.applyChanges()) {
                    BaseAnnotationStepDialog.this.modelAnnotationDirty = false;
                    BaseAnnotationStepDialog.this.wApply.setEnabled(false);
                }
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                BaseAnnotationStepDialog.this.okay();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                BaseAnnotationStepDialog.this.cancel();
            }
        };
        this.lsCheckForVariables = new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode != 13 && event.keyCode != 0) {
                    return;
                }
                if (StringUtils.equals((String)BaseAnnotationStepDialog.this.getWGroups().getText(), (String)BaseAnnotationStepDialog.this.getTableComposite().getData().getName()) || Const.isEmpty((String)BaseAnnotationStepDialog.this.getWGroups().getText())) {
                    return;
                }
                if (StringUtil.isVariable((String)BaseAnnotationStepDialog.this.getWGroups().getText())) {
                    BaseAnnotationStepDialog.this.populateTableFromMetastore(false);
                    int idx = BaseAnnotationStepDialog.this.getWGroups().getCComboWidget().indexOf(BaseAnnotationStepDialog.this.envSub(BaseAnnotationStepDialog.this.getWGroups().getText()));
                    if (idx >= 0) {
                        String varName = BaseAnnotationStepDialog.this.getWGroups().getText();
                        BaseAnnotationStepDialog.this.getWGroups().getCComboWidget().select(idx);
                        BaseAnnotationStepDialog.this.getWGroups().setText(varName);
                    }
                    BaseAnnotationStepDialog.this.setAnnotationsEditEnabled(false);
                    BaseAnnotationStepDialog.this.modelAnnotationDirty = false;
                } else {
                    BaseAnnotationStepDialog.this.handleNewOrRenameGroups();
                }
            }
        };
        this.lsGroups = new Listener(){

            public void handleEvent(Event event) {
                if (BaseAnnotationStepDialog.this.checkDirtyGroupDiscard()) {
                    BaseAnnotationStepDialog.this.populateTableFromMetastore();
                }
                BaseAnnotationStepDialog.this.getWGroups().setEditable(false);
            }
        };
        this.lsAddGroup = new Listener(){

            public void handleEvent(Event event) {
                if (BaseAnnotationStepDialog.this.checkDirtyGroupDiscard()) {
                    BaseAnnotationStepDialog.this.getWGroups().setText("");
                    BaseAnnotationStepDialog.this.getWGroups().setEditable(true);
                    BaseAnnotationStepDialog.this.populateTable(BaseAnnotationStepDialog.this.createNewAnnotationGroup());
                }
            }
        };
        this.lsCopyGroup = new Listener(){

            public void handleEvent(Event event) {
                if (BaseAnnotationStepDialog.this.checkDirtyGroupDiscard()) {
                    String originalName = BaseAnnotationStepDialog.this.getWGroups().getText();
                    ModelAnnotationGroup currentGroup = BaseAnnotationStepDialog.this.getTableComposite().getData();
                    if (StringUtils.isNotBlank((String)originalName) && currentGroup != null) {
                        BaseAnnotationStepDialog.this.getWGroups().setText(BaseMessages.getString(PKG, (String)"ModelAnnotation.NewAnnotation.CopyOf", (String[])new String[]{originalName}));
                        BaseAnnotationStepDialog.this.getWGroups().setEditable(true);
                        ModelAnnotationGroup modelAnnotations = ObjectUtils.deepClone(currentGroup);
                        modelAnnotations.setName(BaseAnnotationStepDialog.this.getWGroups().getText());
                        BaseAnnotationStepDialog.this.populateTable(modelAnnotations);
                    }
                }
            }
        };
    }

    protected ModelAnnotationGroup createNewAnnotationGroup() {
        return new ModelAnnotationGroup();
    }

    protected void handleNewOrRenameGroups() {
        if (this.preventNewOrRename) {
            return;
        }
        final String currentGroupName = this.getTableComposite().getData().getName();
        if (this.groupNameExists()) {
            LinkedHashMap<String, Listener> listenerMap = new LinkedHashMap<String, Listener>();
            listenerMap.put(BaseMessages.getString(PKG, (String)"System.Button.No", (String[])new String[0]), new Listener(){

                public void handleEvent(Event event) {
                    BaseAnnotationStepDialog.this.getWGroups().setText(currentGroupName == null ? "" : currentGroupName);
                    BaseAnnotationStepDialog.this.getWGroups().getCComboWidget().setFocus();
                    BaseAnnotationStepDialog.this.getWGroups().getCComboWidget().setEditable(true);
                }
            });
            listenerMap.put(BaseMessages.getString(PKG, (String)"System.Button.Yes", (String[])new String[0]), new Listener(){

                public void handleEvent(Event event) {
                    BaseAnnotationStepDialog.this.onModelAnnotationDirty();
                    BaseAnnotationStepDialog.this.lsGroups.handleEvent(null);
                }
            });
            WarningDialog warningDialog = new WarningDialog(this.shell, BaseMessages.getString(PKG, (String)"ModelAnnotation.UnableToRename.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ModelAnnotation.UnableToRename.Message", (String[])new String[]{this.getWGroups().getCComboWidget().getText()}), listenerMap);
            warningDialog.open();
        } else {
            if (StringUtils.isBlank((String)currentGroupName)) {
                this.logDebug("New Group...");
            } else {
                this.logDebug("Renamed " + currentGroupName + " to " + this.getWGroups().getText());
                this.markedForDeletion.push(currentGroupName);
            }
            this.onModelAnnotationDirty();
        }
        this.setAnnotationsEditEnabled(true);
    }

    protected boolean groupNameExists() {
        String name = StringUtils.trim((String)this.getWGroups().getText());
        String[] groupNames = this.getWGroups().getCComboWidget().getItems();
        if (groupNames != null) {
            for (String groupName : groupNames) {
                if (!StringUtils.equalsIgnoreCase((String)StringUtils.trim((String)groupName), (String)StringUtils.trim((String)name))) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkDirtyGroupDiscard() {
        if (this.modelAnnotationDirty) {
            this.preventNewOrRename = true;
            Listener lsWarningYes = new Listener(){

                public void handleEvent(Event event) {
                    try {
                        BaseAnnotationStepDialog.this.input.saveToMetaStore(BaseAnnotationStepDialog.this.getMetaStore(), BaseAnnotationStepDialog.this.getTableComposite().getData());
                        BaseAnnotationStepDialog.this.modelAnnotationDirty = false;
                        BaseAnnotationStepDialog.this.onModelAnnotationDirty();
                        BaseAnnotationStepDialog.this.preventNewOrRename = false;
                    }
                    catch (Exception e) {
                        BaseAnnotationStepDialog.this.showError(BaseMessages.getString(PKG, (String)"ModelAnnotation.MetaStoreSaveError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ModelAnnotation.MetaStoreSaveError.Message", (String[])new String[]{e.getLocalizedMessage()}));
                    }
                }
            };
            Listener lsWarningNo = new Listener(){

                public void handleEvent(Event event) {
                    String groupName = BaseAnnotationStepDialog.this.getTableComposite().getData().getName();
                    if (groupName != null) {
                        BaseAnnotationStepDialog.this.removeItem(BaseAnnotationStepDialog.this.getWGroups(), groupName);
                    }
                    BaseAnnotationStepDialog.this.modelAnnotationDirty = false;
                    BaseAnnotationStepDialog.this.onModelAnnotationDirty();
                    BaseAnnotationStepDialog.this.preventNewOrRename = false;
                }
            };
            Listener lsWarningCancel = new Listener(){

                public void handleEvent(Event event) {
                    String name = BaseAnnotationStepDialog.this.getTableComposite().getData().getName();
                    if (name != null) {
                        BaseAnnotationStepDialog.this.getWGroups().setText(BaseAnnotationStepDialog.this.getTableComposite().getData().getName());
                    }
                    BaseAnnotationStepDialog.this.preventNewOrRename = false;
                }
            };
            LinkedHashMap<String, Listener> listenerMap = new LinkedHashMap<String, Listener>();
            listenerMap.put(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]), lsWarningCancel);
            listenerMap.put(BaseMessages.getString(PKG, (String)"System.Button.No", (String[])new String[0]), lsWarningNo);
            listenerMap.put(BaseMessages.getString(PKG, (String)"ModelAnnotation.UnsavedChangesWarning.Yes", (String[])new String[0]), lsWarningYes);
            WarningDialog warningDialog = new WarningDialog(this.shell, BaseMessages.getString(PKG, (String)"ModelAnnotation.UnsavedChangesWarning.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ModelAnnotation.UnsavedChangesWarning.Message", (String[])new String[]{this.getTableComposite().getData().getName()}), listenerMap);
            warningDialog.open();
        } else {
            this.setAnnotationsEditEnabled(true);
            this.modelAnnotationDirty = false;
            this.onModelAnnotationDirty();
        }
        return !this.modelAnnotationDirty;
    }

    protected void okay() {
        if (this.applyChanges()) {
            this.dispose();
        }
    }

    protected void cancel() {
        this.stepname = null;
        this.dispose();
    }

    public void dispose() {
        super.dispose();
    }

    protected void createOkCancelButtons() {
        this.wBottomHorizontalSeparator = new Label((Composite)this.shell, 258);
        FormData fdSepator = new FormData();
        fdSepator.left = new FormAttachment(0, 10);
        fdSepator.right = new FormAttachment(100, -10);
        fdSepator.bottom = new FormAttachment((Control)this.wHelp, -15);
        this.wBottomHorizontalSeparator.setLayoutData((Object)fdSepator);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setAlignment(0x1000000);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]) + "  ");
        FormData fdCancel = new FormData();
        fdCancel.top = new FormAttachment((Control)this.wHelp, 0, 128);
        fdCancel.right = new FormAttachment(100, -10);
        this.wCancel.setLayoutData((Object)fdCancel);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setAlignment(0x1000000);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        FormData fdOK = new FormData();
        fdOK.top = new FormAttachment((Control)this.wCancel, 0, 128);
        fdOK.right = new FormAttachment((Control)this.wCancel, -4, 16384);
        this.wOK.setLayoutData((Object)fdOK);
        FormData fdApplyCont = new FormData();
        fdApplyCont.top = new FormAttachment((Control)this.wOK, 0, 128);
        fdApplyCont.right = new FormAttachment((Control)this.wOK, -4, 16384);
        fdApplyCont.left = new FormAttachment((Control)this.wHelp, 4, 131072);
        Composite comp = new Composite((Composite)this.shell, 0);
        comp.setLayoutData((Object)fdApplyCont);
        RowLayout rl = new RowLayout();
        rl.pack = true;
        rl.justify = true;
        rl.marginTop = 0;
        comp.setLayout((Layout)rl);
        this.props.setLook((Control)comp);
        this.wApply = new Button(comp, 8);
        this.wApply.setAlignment(0x1000000);
        this.wApply.setEnabled(false);
        this.wApply.setText(BaseMessages.getString(PKG, (String)"System.Button.Apply", (String[])new String[0]));
        RowData fdApply = new RowData();
        this.wApply.setLayoutData((Object)fdApply);
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.wApply.addListener(13, this.lsApply);
    }

    protected Button createHelpButton(Shell shell, StepMeta stepMeta, PluginInterface plugin) {
        this.wHelp = super.createHelpButton(shell, stepMeta, plugin);
        FormData fdHelp = new FormData();
        fdHelp.bottom = new FormAttachment(100, -10);
        fdHelp.left = new FormAttachment(0, 10);
        this.wHelp.setLayoutData((Object)fdHelp);
        return this.wHelp;
    }

    protected Control createStepNameWidget() {
        this.wlStepname = new Label((Composite)this.shell, 16384);
        this.wlStepname.setText(this.getStepName());
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 10);
        this.fdlStepname.top = new FormAttachment(0, 10);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.wStepname.addModifyListener(this.lsMod);
        this.props.setLook((Control)this.wStepname);
        this.fdStepname = new FormData();
        this.fdStepname.top = new FormAttachment((Control)this.wlStepname, 5);
        this.fdStepname.left = new FormAttachment(0, 12);
        this.fdStepname.right = new FormAttachment(0, 262);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        Label wSeparator = new Label((Composite)this.shell, 258);
        FormData fdSepator = new FormData();
        fdSepator.top = new FormAttachment((Control)this.wStepname, 15, 1024);
        fdSepator.left = new FormAttachment(0, 12);
        fdSepator.right = new FormAttachment(100, -10);
        wSeparator.setLayoutData((Object)fdSepator);
        this.wIcon = new Label((Composite)this.shell, 0x1000000);
        this.wIcon.setImage(this.getImageIcon());
        FormData fdIcon = new FormData();
        fdIcon.top = new FormAttachment(0, 15);
        fdIcon.right = new FormAttachment(100, -10);
        this.wIcon.setLayoutData((Object)fdIcon);
        this.props.setLook((Control)this.wIcon);
        return wSeparator;
    }

    protected Control createDescription(Control topWidget) {
        Label wlDescription = new Label((Composite)this.shell, 16384);
        wlDescription.setText(BaseMessages.getString(PKG, (String)"SharedDimension.Dialog.Description.Label", (String[])new String[0]));
        this.props.setLook((Control)wlDescription);
        FormData fdlDescription = new FormData();
        fdlDescription.top = new FormAttachment(topWidget, 10);
        fdlDescription.left = new FormAttachment(0, 10);
        fdlDescription.right = new FormAttachment(100, -10);
        wlDescription.setLayoutData((Object)fdlDescription);
        this.wDescription = new StyledText((Composite)this.shell, 2114);
        this.props.setLook((Control)this.wDescription);
        FormData fdDescription = new FormData();
        fdDescription.height = 50;
        fdDescription.top = new FormAttachment((Control)wlDescription, 5);
        fdDescription.left = new FormAttachment(0, 10);
        fdDescription.right = new FormAttachment(100, -10);
        this.wDescription.setLayoutData((Object)fdDescription);
        this.wDescription.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                if (BaseAnnotationStepDialog.this.input.getModelAnnotations() != null && BaseAnnotationStepDialog.this.textChanged(BaseAnnotationStepDialog.this.wDescription, StringUtils.defaultIfBlank((String)BaseAnnotationStepDialog.this.input.getModelAnnotations().getDescription(), (String)""))) {
                    BaseAnnotationStepDialog.this.modelAnnotationDirty = true;
                    BaseAnnotationStepDialog.this.onModelAnnotationDirty();
                }
            }
        });
        return this.wDescription;
    }

    protected void afterOpen() {
    }

    protected String envSub(String var) {
        return this.transMeta.environmentSubstitute(var);
    }

    protected void setDirtyFlag(ModelAnnotationGroup g1, ModelAnnotationGroup g2) {
        if (this.groupChanged(g1, g2)) {
            this.modelAnnotationDirty = true;
            this.onModelAnnotationDirty();
        } else {
            this.modelAnnotationDirty = false;
        }
    }

    private boolean groupChanged(ModelAnnotationGroup g1, ModelAnnotationGroup g2) {
        try {
            if (!EqualsBuilder.reflectionEquals((Object)g1, (Object)g2)) {
                return true;
            }
            for (int i = 0; i < g1.size(); ++i) {
                Map g2Properties;
                if (!EqualsBuilder.reflectionEquals((Object)g1.get(i), (Object)g2.get(i), (String[])new String[]{"annotation"})) {
                    return true;
                }
                Map g1Properties = ((ModelAnnotation)g1.get(i)).describeAnnotation();
                if (!EqualsBuilder.reflectionEquals((Object)g1Properties, (Object)(g2Properties = ((ModelAnnotation)g2.get(i)).describeAnnotation()))) {
                    return true;
                }
                if (g1Properties == null || g2Properties == null || g1Properties.equals(g2Properties)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    protected void getFields() {
        final ModelAnnotationGroup groupCopy = ObjectUtils.deepClone(this.getTableComposite().getData());
        this.getTableComposite().getFields(this.getParent(), this.input, this.transMeta, this.stepname, new Listener(){

            public void handleEvent(Event event) {
                if (event instanceof ModelAnnotationEvent) {
                    ModelAnnotationEvent e = (ModelAnnotationEvent)event;
                    BaseAnnotationStepDialog.this.setDirtyFlag(groupCopy, e.getModelAnnotations());
                }
            }
        });
    }

    protected void editAnnotation() {
        final ModelAnnotationGroup groupCopy = ObjectUtils.deepClone(this.getTableComposite().getData());
        this.getTableComposite().editAnnotation(this.shell, this.input, this.transMeta, this.stepname, this.getMetaStore(), new Listener(){

            public void handleEvent(Event event) {
                if (event instanceof ModelAnnotationEvent) {
                    ModelAnnotationEvent e = (ModelAnnotationEvent)event;
                    if (!BaseAnnotationStepDialog.this.modelAnnotationDirty) {
                        BaseAnnotationStepDialog.this.setDirtyFlag(groupCopy, e.getModelAnnotations());
                    }
                    BaseAnnotationStepDialog.this.populateTable(e.getModelAnnotations());
                }
            }
        });
    }

    protected void deleteAnnotation() {
        this.getTableComposite().deleteAnnotation();
        this.modelAnnotationDirty = true;
        this.onModelAnnotationDirty();
    }

    protected void populateTableFromMetastore() {
        this.populateTableFromMetastore(!StringUtil.isVariable((String)this.getSelectedModelAnnotationGroupName()));
    }

    protected void populateTableFromMetastore(boolean warnNotFound) {
        try {
            String groupName = this.envSub(this.getSelectedModelAnnotationGroupName());
            ModelAnnotationGroup modelAnnotations = null;
            if (!StringUtil.isEmpty((String)groupName)) {
                modelAnnotations = this.getModelAnnotationManger().readGroup(groupName, this.getMetaStore());
            }
            if (modelAnnotations == null) {
                if (warnNotFound) {
                    LinkedHashMap<String, Listener> listenerMap = new LinkedHashMap<String, Listener>();
                    listenerMap.put(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]), new Listener(){

                        public void handleEvent(Event event) {
                        }
                    });
                    WarningDialog warningDialog = new WarningDialog(this.shell, BaseMessages.getString(PKG, (String)this.missingTitleKey(), (String[])new String[0]), BaseMessages.getString(PKG, (String)this.missingMessageKey(), (String[])new String[]{this.getSelectedModelAnnotationGroupName()}), listenerMap);
                    warningDialog.open();
                }
                modelAnnotations = this.createNewAnnotationGroup();
            }
            this.populateTable(modelAnnotations);
        }
        catch (MetaStoreException e) {
            this.log.logError(e.getLocalizedMessage(), (Throwable)e);
            this.populateTable(new ModelAnnotationGroup());
        }
    }

    protected abstract String missingMessageKey();

    protected abstract String missingTitleKey();

    protected void populateCategories(String selectedCategory, boolean sharedDimensions) {
        boolean isShared;
        boolean bl = isShared = selectedCategory != null;
        if (this.getWGroups().getItemCount() > 0) {
            this.getWGroups().removeAll();
        }
        try {
            List<String> groupNames = this.getGroupNames(sharedDimensions);
            boolean foundCategory = false;
            for (int i = 0; i < groupNames.size(); ++i) {
                String groupName = groupNames.get(i);
                this.getWGroups().add(groupName);
                if (!isShared || !this.input.getModelAnnotationCategory().equals(groupName)) continue;
                this.getWGroups().select(i);
                foundCategory = true;
            }
            if (isShared && !foundCategory || StringUtils.isNotBlank((String)this.input.getModelAnnotationCategory()) && StringUtils.equals((String)selectedCategory, (String)this.envSub(this.input.getModelAnnotationCategory()))) {
                this.getWGroups().setText(this.input.getModelAnnotationCategory());
            }
        }
        catch (Exception e) {
            this.log.logError(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected void setAnnotationsEditEnabled(boolean enabled) {
        this.getTableComposite().setEnabled(enabled);
        this.wDescription.setEnabled(enabled);
        if (enabled) {
            this.props.setLook((Control)this.wDescription);
        } else {
            this.wDescription.setBackground(GUIResource.getInstance().getColorDemoGray());
        }
    }

    protected void populateTable(ModelAnnotationGroup modelAnnotations) {
        this.getTableComposite().populateTable(modelAnnotations, this.transMeta, this.stepname, this.shell);
        if (this.wDescription != null && modelAnnotations != null) {
            this.wDescription.setText(StringUtils.defaultIfBlank((String)modelAnnotations.getDescription(), (String)""));
        }
    }

    protected boolean textChanged(StyledText textWidget, String text) {
        return textWidget != null && !StringUtils.equals((String)textWidget.getText(), (String)text);
    }

    protected List<String> getGroupNames(boolean sharedDimension) {
        ArrayList<String> filteredGroupNames = new ArrayList<String>();
        try {
            List groupNames = this.getModelAnnotationManger().listGroups(this.getMetaStore());
            if (groupNames != null) {
                for (ModelAnnotationGroup modelAnnotationGroup : groupNames) {
                    if (sharedDimension) {
                        if (!modelAnnotationGroup.isSharedDimension()) continue;
                        filteredGroupNames.add(modelAnnotationGroup.getName());
                        continue;
                    }
                    if (modelAnnotationGroup.isSharedDimension()) continue;
                    filteredGroupNames.add(modelAnnotationGroup.getName());
                }
            }
        }
        catch (Exception e) {
            this.log.logError(e.getLocalizedMessage(), (Throwable)e);
        }
        return filteredGroupNames;
    }

    protected boolean removeItem(ComboVar combo, String elementName) {
        int idx = combo.getCComboWidget().indexOf(elementName);
        if (idx >= 0) {
            combo.getCComboWidget().remove(idx);
            return true;
        }
        return false;
    }

    public void linkAnnotations(final ComboVar combo, String name, final String description, final Event parent) {
        final String groupName = this.envSub(name);
        if (!this.checkValidName(name)) {
            parent.doit = false;
            return;
        }
        try {
            ModelAnnotationGroup modelAnnotations = this.getModelAnnotationManger().readGroup(groupName, this.getMetaStore());
            if (modelAnnotations != null) {
                Listener lsWarningYes = new Listener(){

                    public void handleEvent(Event event) {
                        BaseAnnotationStepDialog.this.linkAnnotations(combo, groupName, description);
                    }
                };
                Listener lsWarningNo = new Listener(){

                    public void handleEvent(Event event) {
                        parent.doit = false;
                    }
                };
                LinkedHashMap<String, Listener> listenerMap = new LinkedHashMap<String, Listener>();
                listenerMap.put(BaseMessages.getString(PKG, (String)"System.Button.No", (String[])new String[0]), lsWarningNo);
                listenerMap.put(BaseMessages.getString(PKG, (String)"ModelAnnotation.AnnotationGroupExists.Yes", (String[])new String[0]), lsWarningYes);
                WarningDialog warningDialog = new WarningDialog(this.shell, BaseMessages.getString(PKG, (String)"ModelAnnotation.AnnotationGroupExists.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ModelAnnotation.AnnotationGroupExists.Message", (String[])new String[]{groupName}), listenerMap);
                warningDialog.open();
            } else {
                this.linkAnnotations(combo, groupName, description);
            }
        }
        catch (MetaStoreException e) {
            this.log.logError(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected void linkAnnotations(ComboVar combo, String groupName, String description) {
        this.removeItem(combo, groupName);
        combo.add(groupName);
        combo.select(combo.getItemCount() - 1);
        if (this.wDescription != null) {
            this.wDescription.setText(StringUtils.defaultIfBlank((String)description, (String)""));
        }
        this.getTableComposite().getData().setDescription(description);
        this.getTableComposite().getData().setName(groupName);
        this.modelAnnotationDirty = true;
        this.onLinkAnnotations();
    }

    protected boolean checkValidName(String name) {
        try {
            this.input.checkValidName(name);
            return true;
        }
        catch (KettleException e) {
            this.showError(BaseMessages.getString(PKG, (String)"ModelAnnotation.MetaStoreInvalidName.Title", (String[])new String[0]), e.getLocalizedMessage());
            return false;
        }
    }

    protected void discardAll(ComboVar combo, String selectItem) {
        this.getTableComposite().getData().clear();
        this.getTableComposite().refresh();
        String[] items = combo.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].equals(selectItem)) continue;
            combo.select(i);
        }
        this.populateTableFromMetastore();
        this.onDiscardAll();
    }

    protected void deleteStaleGroups(boolean sharedDimensions) {
        while (!this.markedForDeletion.empty()) {
            try {
                String groupName = this.markedForDeletion.pop();
                if (!this.getModelAnnotationManger().containsGroup(groupName, this.getMetaStore())) continue;
                this.getModelAnnotationManger().deleteGroup(groupName, this.getMetaStore());
            }
            catch (MetaStoreException e) {
                this.logError(e.getLocalizedMessage(), e);
            }
        }
        this.populateCategories(this.getWGroups().getText(), sharedDimensions);
    }

    public void showInfo(String title, String message) {
        SpoonInterface spoon = this.getSpoon();
        spoon.messageBox(message, title, false, 3);
    }

    public void showError(String title, String message) {
        HashMap<String, Listener> listenerMap = new HashMap<String, Listener>();
        listenerMap.put(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]), new Listener(){

            public void handleEvent(Event event) {
            }
        });
        new WarningDialog(this.shell, title, message, listenerMap).open();
    }

    protected void resizeSummaryColumn(final ModelAnnotationsTableComposite tableComposite) {
        this.shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (tableComposite != null) {
                    int width = 0;
                    for (int i = 0; i < 3; ++i) {
                        width += tableComposite.getTable().getColumn(i).getWidth();
                    }
                    tableComposite.getTable().getColumn(2).setWidth(tableComposite.getTable().getSize().x - width);
                }
            }
        });
    }

    protected SpoonInterface getSpoon() {
        return SpoonFactory.getInstance();
    }

    protected void onLinkAnnotations() {
        this.onModelAnnotationDirty();
    }

    protected void onDiscardAll() {
        this.onModelAnnotationDirty();
    }

    protected void onModelAnnotationDirty() {
        this.wApply.setEnabled(true);
    }

    protected abstract String getDialogTitle();

    protected abstract String getStepName();

    protected abstract Image getImageIcon();

    protected abstract void createContent(Control var1);

    protected abstract ModelAnnotationManager getModelAnnotationManger();

    protected abstract ModelAnnotationsTableComposite getTableComposite();

    protected abstract String getSelectedModelAnnotationGroupName();

    protected abstract boolean applyChanges();

    protected abstract ComboVar getWGroups();
}

