/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.pentaho.agilebi.modeler.BaseModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.ColumnBackedNode;
import org.pentaho.agilebi.modeler.IModelerSource;
import org.pentaho.agilebi.modeler.IModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.ModelerConversionUtil;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerMode;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.ModelerTreeHelper;
import org.pentaho.agilebi.modeler.geo.GeoContext;
import org.pentaho.agilebi.modeler.nodes.AbstractMetaDataModelNode;
import org.pentaho.agilebi.modeler.nodes.AvailableField;
import org.pentaho.agilebi.modeler.nodes.AvailableItemCollection;
import org.pentaho.agilebi.modeler.nodes.AvailableTable;
import org.pentaho.agilebi.modeler.nodes.BaseColumnBackedMetaData;
import org.pentaho.agilebi.modeler.nodes.CategoryMetaData;
import org.pentaho.agilebi.modeler.nodes.DimensionMetaData;
import org.pentaho.agilebi.modeler.nodes.FieldMetaData;
import org.pentaho.agilebi.modeler.nodes.HierarchyMetaData;
import org.pentaho.agilebi.modeler.nodes.IAvailableItem;
import org.pentaho.agilebi.modeler.nodes.LevelMetaData;
import org.pentaho.agilebi.modeler.nodes.MainModelNode;
import org.pentaho.agilebi.modeler.nodes.MeasureMetaData;
import org.pentaho.agilebi.modeler.nodes.MemberPropertyMetaData;
import org.pentaho.agilebi.modeler.nodes.RelationalModelNode;
import org.pentaho.agilebi.modeler.nodes.TimeRole;
import org.pentaho.agilebi.modeler.nodes.annotations.AnalyzerDateFormatAnnotationFactory;
import org.pentaho.agilebi.modeler.nodes.annotations.GeoAnnotationFactory;
import org.pentaho.agilebi.modeler.nodes.annotations.IMemberAnnotation;
import org.pentaho.agilebi.modeler.nodes.annotations.MemberAnnotationFactory;
import org.pentaho.agilebi.modeler.strategy.MultiTableAutoModelStrategy;
import org.pentaho.agilebi.modeler.strategy.SimpleAutoModelStrategy;
import org.pentaho.agilebi.modeler.strategy.StarSchemaAutoModelStrategy;
import org.pentaho.metadata.model.Category;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.IPhysicalColumn;
import org.pentaho.metadata.model.IPhysicalModel;
import org.pentaho.metadata.model.IPhysicalTable;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.metadata.model.concept.types.LocalizedString;
import org.pentaho.metadata.model.olap.OlapAnnotation;
import org.pentaho.metadata.model.olap.OlapCube;
import org.pentaho.metadata.model.olap.OlapDimension;
import org.pentaho.metadata.model.olap.OlapHierarchy;
import org.pentaho.metadata.model.olap.OlapHierarchyLevel;
import org.pentaho.metadata.model.olap.OlapMeasure;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.stereotype.Bindable;

public class ModelerWorkspace
extends XulEventSourceAdapter
implements Serializable {
    private static final long serialVersionUID = 2058731810283858276L;
    private AvailableItemCollection availableTables = new AvailableItemCollection();
    private MainModelNode model;
    private RelationalModelNode relationalModel;
    private String sourceName;
    private transient IModelerSource source;
    private String selectedVisualization;
    private String schemaName;
    private Domain domain;
    private boolean dirty = true;
    private String fileName;
    private boolean modelIsChanging;
    private boolean isTemporary = true;
    private AbstractMetaDataModelNode selectedNode;
    private IAvailableItem selectedAvailableItem;
    private IModelerWorkspaceHelper workspaceHelper;
    private AbstractMetaDataModelNode selectedRelationalNode;
    private transient ModelerMode currentModellingMode = ModelerMode.ANALYSIS_AND_REPORTING;
    private transient ModelerPerspective currentModelerPerspective = ModelerPerspective.ANALYSIS;
    private transient SimpleAutoModelStrategy simpleAutoModelStrategy;
    private transient MultiTableAutoModelStrategy multiTableAutoModelStrategy;
    private transient StarSchemaAutoModelStrategy starSchemaAutoModelStrategy;
    private GeoContext geoContext;
    private transient ModelerTreeHelper currentModelerTreeHelper;

    public ModelerWorkspace(IModelerWorkspaceHelper helper) {
        this(helper, null);
    }

    public ModelerWorkspace(IModelerWorkspaceHelper helper, GeoContext geoContext) {
        this.workspaceHelper = helper;
        this.setModel(new MainModelNode(this));
        this.setRelationalModel(new RelationalModelNode(this));
        this.geoContext = geoContext;
        this.simpleAutoModelStrategy = new SimpleAutoModelStrategy(this.workspaceHelper.getLocale(), geoContext);
        this.multiTableAutoModelStrategy = new MultiTableAutoModelStrategy(this.workspaceHelper.getLocale());
        this.starSchemaAutoModelStrategy = new StarSchemaAutoModelStrategy(this.workspaceHelper.getLocale(), geoContext);
        AnalyzerDateFormatAnnotationFactory.register();
    }

    public GeoContext getGeoContext() {
        return this.geoContext;
    }

    @Bindable
    public MainModelNode getModel() {
        return this.model;
    }

    @Bindable
    public void setModel(MainModelNode model) {
        this.model = model;
        model.addPropertyChangeListener("children", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                if (!ModelerWorkspace.this.modelIsChanging) {
                    ModelerWorkspace.this.fireModelChanged();
                }
            }
        });
        model.addPropertyChangeListener("valid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ModelerWorkspace.this.isValid();
            }
        });
    }

    @Bindable
    public RelationalModelNode getRelationalModel() {
        return this.relationalModel;
    }

    @Bindable
    public void setRelationalModel(RelationalModelNode model) {
        this.relationalModel = model;
        this.relationalModel.addPropertyChangeListener("children", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!ModelerWorkspace.this.modelIsChanging) {
                    ModelerWorkspace.this.fireRelationalModelChanged();
                }
            }
        });
        this.relationalModel.addPropertyChangeListener("valid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ModelerWorkspace.this.isValid();
            }
        });
    }

    @Bindable
    public void setFileName(String fileName) {
        String prevVal = this.fileName;
        String prevFriendly = this.getShortFileName();
        this.fileName = fileName;
        this.firePropertyChange("fileName", prevVal, fileName);
        this.firePropertyChange("shortFileName", prevFriendly, this.getShortFileName());
    }

    @Bindable
    public String getShortFileName() {
        int sepPos;
        if (this.fileName == null) {
            return null;
        }
        int extensionPos = this.fileName.lastIndexOf(46);
        if (extensionPos == -1) {
            extensionPos = this.fileName.length();
        }
        sepPos = (sepPos = this.fileName.replace('\\', '/').lastIndexOf(47)) == -1 ? 0 : ++sepPos;
        return this.fileName.substring(sepPos, extensionPos);
    }

    @Bindable
    public String getFileName() {
        return this.fileName;
    }

    @Bindable
    public String getSourceName() {
        return this.sourceName;
    }

    @Bindable
    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
        this.firePropertyChange("sourceName", null, sourceName);
    }

    @Bindable
    public String getModelName() {
        return this.model.getName();
    }

    @Bindable
    public void setModelName(String modelName) {
        String prevVal = this.model.getName();
        this.model.setName(modelName);
        this.setDirty(true);
        this.firePropertyChange("modelName", prevVal, modelName);
    }

    @Bindable
    public String getRelationalModelName() {
        return this.relationalModel.getName();
    }

    @Bindable
    public void setRelationalModelName(String modelName) {
        String prevVal = this.model.getName();
        this.relationalModel.setName(modelName);
        this.setDirty(true);
        this.firePropertyChange("relationalModelName", prevVal, modelName);
    }

    @Bindable
    public boolean isDirty() {
        return this.dirty;
    }

    @Bindable
    public boolean isValid() {
        boolean valid = false;
        switch (this.getModellingMode()) {
            case ANALYSIS_AND_REPORTING: {
                valid = this.model.isValid() && this.relationalModel.isValid();
                break;
            }
            case REPORTING_ONLY: {
                valid = this.relationalModel.isValid();
            }
        }
        this.firePropertyChange("valid", null, valid);
        return valid;
    }

    @Bindable
    public List<String> getValidationMessages() {
        Set<String> modelMsg = this.model.getValidationMessages();
        Set<String> relModelMsg = this.relationalModel.getValidationMessages();
        modelMsg.addAll(relModelMsg);
        return new ArrayList<String>(modelMsg);
    }

    @Bindable
    public void setDirty(boolean dirty) {
        boolean prevVal = this.dirty;
        this.dirty = dirty;
        this.firePropertyChange("dirty", prevVal, this.dirty);
    }

    @Bindable
    public AvailableItemCollection getAvailableTables() {
        return this.availableTables;
    }

    @Bindable
    public void setSelectedVisualization(String aVisualization) {
        this.selectedVisualization = aVisualization;
    }

    @Bindable
    public String getSelectedVisualization() {
        return this.selectedVisualization;
    }

    public DimensionMetaData createDimensionFromNode(ColumnBackedNode obj) {
        DimensionMetaData dimension = new DimensionMetaData(obj.getName());
        dimension.setExpanded(true);
        HierarchyMetaData hierarchy = this.createHierarchyForParentWithNode(dimension, obj);
        hierarchy.setParent(dimension);
        hierarchy.setExpanded(true);
        dimension.add(hierarchy);
        return dimension;
    }

    public DimensionMetaData createDimensionFromAvailableTable(AvailableTable tbl) {
        DimensionMetaData dimension = new DimensionMetaData(tbl.getName());
        dimension.setExpanded(true);
        HierarchyMetaData hierarchy = new HierarchyMetaData(tbl.getName());
        hierarchy.setExpanded(true);
        for (AvailableField field : tbl.getChildren()) {
            ColumnBackedNode node = this.createColumnBackedNode(field, ModelerPerspective.ANALYSIS);
            LevelMetaData level = this.createLevelForParentWithNode(hierarchy, node);
            hierarchy.add(level);
        }
        hierarchy.setParent(dimension);
        hierarchy.setExpanded(true);
        dimension.add(hierarchy);
        return dimension;
    }

    public DimensionMetaData createDimensionWithName(String dimName) {
        DimensionMetaData dimension = new DimensionMetaData(dimName);
        dimension.setExpanded(true);
        HierarchyMetaData hierarchy = this.createHierarchyForParentWithNode(dimension, null);
        hierarchy.setParent(dimension);
        hierarchy.setExpanded(true);
        dimension.add(hierarchy);
        return dimension;
    }

    public void addDimensionFromNode(ColumnBackedNode obj) {
        this.addDimension(this.createDimensionFromNode(obj));
    }

    public void addDimension(DimensionMetaData dim) {
        boolean prevChangeState = this.modelIsChanging;
        this.setModelIsChanging(true);
        this.model.getDimensions().add(dim);
        this.setModelIsChanging(prevChangeState);
    }

    public void addCategory(CategoryMetaData cat) {
        boolean prevChangeState = this.modelIsChanging;
        this.setRelationalModelIsChanging(true);
        this.relationalModel.getCategories().add(cat);
        this.setRelationalModelIsChanging(prevChangeState);
    }

    public LevelMetaData createLevelForParentWithNode(HierarchyMetaData parent, ColumnBackedNode obj) {
        LevelMetaData level = new LevelMetaData(parent, obj.getName());
        level.setParent(parent);
        level.setLogicalColumn(obj.getLogicalColumn());
        return level;
    }

    public LevelMetaData createLevelForParentWithNode(HierarchyMetaData parent, String name) {
        LevelMetaData level = new LevelMetaData(parent, name);
        level.setParent(parent);
        level.setLogicalColumn(this.findLogicalColumn(name));
        return level;
    }

    public MemberPropertyMetaData createMemberPropertyForParentWithNode(LevelMetaData parent, ColumnBackedNode obj) {
        MemberPropertyMetaData memberProp = new MemberPropertyMetaData(parent, obj.getName());
        memberProp.setParent(parent);
        memberProp.setLogicalColumn(obj.getLogicalColumn());
        return memberProp;
    }

    public MemberPropertyMetaData createMemberPropertyForParentWithNode(LevelMetaData parent, String name) {
        MemberPropertyMetaData memberProp = new MemberPropertyMetaData(parent, name);
        memberProp.setParent(parent);
        memberProp.setLogicalColumn(this.findLogicalColumn(name));
        return memberProp;
    }

    public FieldMetaData createFieldForParentWithNode(CategoryMetaData parent, AvailableField selectedField) {
        FieldMetaData field = new FieldMetaData(parent, selectedField.getName(), "", selectedField.getDisplayName(), this.workspaceHelper.getLocale());
        ColumnBackedNode node = this.createColumnBackedNode(selectedField, ModelerPerspective.REPORTING);
        field.setLogicalColumn(node.getLogicalColumn());
        field.setFieldTypeDesc(node.getLogicalColumn().getDataType().getName());
        return field;
    }

    public HierarchyMetaData createHierarchyForParentWithNode(DimensionMetaData parent, ColumnBackedNode obj) {
        HierarchyMetaData hier = new HierarchyMetaData(obj.getName());
        hier.setParent(parent);
        hier.setExpanded(true);
        if (obj != null) {
            LevelMetaData level = this.createLevelForParentWithNode(hier, obj);
            hier.add(level);
        }
        return hier;
    }

    private void fireTablesChanged() {
        if (this.availableTables.size() > 1) {
            if (this.availableTables.findFactTable() != null) {
                this.workspaceHelper.setAutoModelStrategy(this.starSchemaAutoModelStrategy);
            } else {
                this.workspaceHelper.setAutoModelStrategy(this.multiTableAutoModelStrategy);
            }
        } else {
            this.workspaceHelper.setAutoModelStrategy(this.simpleAutoModelStrategy);
        }
        this.firePropertyChange("availableTables", null, (Object)this.availableTables);
    }

    private void fireModelChanged() {
        this.firePropertyChange("model", null, this.model);
        this.setDirty(true);
    }

    private void fireRelationalModelChanged() {
        this.firePropertyChange("relationalModel", null, this.relationalModel);
        this.setDirty(true);
    }

    public MeasureMetaData createMeasureForNode(AvailableField selectedField) {
        MeasureMetaData meta = new MeasureMetaData(selectedField.getName(), "", selectedField.getDisplayName(), this.workspaceHelper.getLocale());
        ColumnBackedNode node = this.createColumnBackedNode(selectedField, ModelerPerspective.ANALYSIS);
        meta.setLogicalColumn(node.getLogicalColumn());
        return meta;
    }

    public void addMeasure(MeasureMetaData measure) {
        boolean prevChangeState = this.isModelChanging();
        this.setModelIsChanging(true);
        this.model.getMeasures().add(measure);
        this.setModelIsChanging(prevChangeState);
    }

    public LogicalColumn findLogicalColumn(String id) {
        LogicalColumn col = null;
        for (LogicalColumn c : ((LogicalTable)this.getLogicalModel(this.currentModelerPerspective).getLogicalTables().get(0)).getLogicalColumns()) {
            if (!c.getName(this.workspaceHelper.getLocale()).equals(id)) continue;
            col = c;
            break;
        }
        return col;
    }

    public LogicalTable findLogicalTable(IPhysicalTable table) {
        return this.findLogicalTable(table, this.currentModelerPerspective);
    }

    public LogicalTable findLogicalTable(IPhysicalTable table, ModelerPerspective perspective) {
        LogicalModel logicalModel = this.getLogicalModel(perspective);
        if (logicalModel == null) {
            return null;
        }
        for (LogicalTable logicalTable : logicalModel.getLogicalTables()) {
            if (!logicalTable.getPhysicalTable().equals(table) && !logicalTable.getPhysicalTable().getId().equals(table.getId()) && !logicalTable.getId().equals(table.getId())) continue;
            return logicalTable;
        }
        return null;
    }

    public void setModelSource(IModelerSource source) {
        this.source = source;
    }

    public IModelerSource getModelSource() {
        return this.source;
    }

    public void setFields(List<MeasureMetaData> fields) {
        this.model.getMeasures().clear();
        this.model.getMeasures().addAll(fields);
    }

    public void refresh(ModelerMode mode) throws ModelerException {
        if (this.source == null) {
            return;
        }
        Domain newDomain = this.source.generateDomain(mode == ModelerMode.ANALYSIS_AND_REPORTING);
        this.refresh(newDomain);
    }

    public boolean supportsOlap(Domain d) {
        if (d.getLogicalModels().size() < 2) {
            return false;
        }
        LogicalModel lModel = (LogicalModel)d.getLogicalModels().get(1);
        return "true".equals(lModel.getProperty("DUAL_MODELING_SCHEMA")) || lModel.getProperty("MondrianCatalogRef") != null;
    }

    public void refresh(Domain newDomain) throws ModelerException {
        ArrayList<IAvailableItem> items = new ArrayList<IAvailableItem>();
        for (IPhysicalTable table : ((IPhysicalModel)newDomain.getPhysicalModels().get(0)).getPhysicalTables()) {
            boolean isFact = table.getProperty("FACT_TABLE") != null ? (Boolean)table.getProperty("FACT_TABLE") : false;
            items.add(new AvailableTable(table, isFact));
        }
        this.availableTables.setChildren(items);
        this.setModelIsChanging(true);
        this.setRelationalModelIsChanging(true);
        if (this.supportsOlap(newDomain)) {
            this.setModellingMode(ModelerMode.ANALYSIS_AND_REPORTING);
        } else {
            this.setModellingMode(ModelerMode.REPORTING_ONLY);
            this.model.getDimensions().clear();
        }
        List<AvailableTable> tablesList = this.availableTables.getAsAvailableTablesList();
        this.fireTablesChanged();
        this.domain = newDomain;
        Iterator i$ = this.model.getMeasures().iterator();
        while (i$.hasNext()) {
            MeasureMetaData measure = (MeasureMetaData)i$.next();
            boolean found = false;
            if (measure.getLogicalColumn() == null) continue;
            block4: for (AvailableTable table : tablesList) {
                for (AvailableField f : table.getAvailableFields()) {
                    if (!f.getPhysicalColumn().getId().equals(measure.getLogicalColumn().getPhysicalColumn().getId()) || !f.getPhysicalColumn().getPhysicalTable().getId().equals(measure.getLogicalColumn().getPhysicalColumn().getPhysicalTable().getId())) continue;
                    measure.setLogicalColumn(this.createColumnBackedNode(f, this.currentModelerPerspective).getLogicalColumn());
                    found = true;
                    break block4;
                }
            }
            if (found) continue;
            measure.setLogicalColumn(null);
        }
        try {
            i$ = this.model.getDimensions().iterator();
            while (i$.hasNext()) {
                DimensionMetaData dm = (DimensionMetaData)i$.next();
                Iterator i$2 = dm.iterator();
                while (i$2.hasNext()) {
                    HierarchyMetaData hm = (HierarchyMetaData)i$2.next();
                    Iterator i$3 = hm.iterator();
                    while (i$3.hasNext()) {
                        LevelMetaData lm = (LevelMetaData)i$3.next();
                        boolean found = false;
                        if (lm.getLogicalColumn() != null) {
                            block9: for (AvailableTable table : tablesList) {
                                for (AvailableField f : table.getAvailableFields()) {
                                    if (!f.getPhysicalColumn().getId().equals(lm.getLogicalColumn().getPhysicalColumn().getId()) || !f.getPhysicalColumn().getPhysicalTable().getId().equals(lm.getLogicalColumn().getPhysicalColumn().getPhysicalTable().getId())) continue;
                                    lm.setLogicalColumn(this.createColumnBackedNode(f, this.currentModelerPerspective).getLogicalColumn());
                                    found = true;
                                    break block9;
                                }
                            }
                        }
                        if (found) continue;
                        lm.setLogicalColumn(null);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        i$ = this.relationalModel.getCategories().iterator();
        while (i$.hasNext()) {
            CategoryMetaData category = (CategoryMetaData)i$.next();
            Iterator i$4 = category.iterator();
            while (i$4.hasNext()) {
                FieldMetaData field = (FieldMetaData)i$4.next();
                boolean found = false;
                if (field.getLogicalColumn() == null) continue;
                block13: for (AvailableTable table : tablesList) {
                    for (AvailableField f : table.getAvailableFields()) {
                        if (!f.getPhysicalColumn().getId().equals(field.getLogicalColumn().getPhysicalColumn().getId()) || !f.getPhysicalColumn().getPhysicalTable().getId().equals(field.getLogicalColumn().getPhysicalColumn().getPhysicalTable().getId())) continue;
                        found = true;
                        break block13;
                    }
                }
                if (found) continue;
                field.setLogicalColumn(null);
            }
        }
        LogicalModel newLModel = this.getLogicalModel(ModelerPerspective.ANALYSIS);
        if (newLModel != null) {
            List theCubes;
            List theDimensions = (List)newLModel.getProperty("olap_dimensions");
            if (theDimensions != null) {
                theDimensions.clear();
            }
            if ((theCubes = (List)newLModel.getProperty("olap_cubes")) != null) {
                theCubes.clear();
            }
        }
        this.setModelIsChanging(false);
        this.setRelationalModelIsChanging(false);
    }

    public String getDatabaseName() {
        return this.source.getDatabaseName();
    }

    @Bindable
    public String getSchemaName() {
        return this.schemaName;
    }

    @Bindable
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setAvailableTables(AvailableItemCollection tables) {
        this.availableTables = tables;
        this.fireTablesChanged();
    }

    public void setDomain(Domain d) {
        this.setDomain(d, true);
    }

    protected void setDomain(Domain d, boolean upConvertDesired) {
        this.domain = d;
        this.setModelIsChanging(true);
        this.setRelationalModelIsChanging(true);
        this.model.getDimensions().clear();
        this.model.getMeasures().clear();
        this.relationalModel.getCategories().clear();
        this.availableTables.clear();
        if (upConvertDesired) {
            this.upConvertLegacyModel();
        }
        ArrayList<IAvailableItem> items = new ArrayList<IAvailableItem>();
        Iterator i$ = ((IPhysicalModel)this.domain.getPhysicalModels().get(0)).getPhysicalTables().iterator();
        while (i$.hasNext()) {
            IPhysicalTable table;
            Boolean isFact = (Boolean)(table = (IPhysicalTable)i$.next()).getProperty("FACT_TABLE");
            items.add(new AvailableTable(table, isFact == null ? false : isFact));
        }
        this.availableTables.setChildren(items);
        this.fireTablesChanged();
        LogicalModel lModel = (LogicalModel)this.domain.getLogicalModels().get(0);
        this.setModelName(lModel.getName(this.workspaceHelper.getLocale()));
        this.setRelationalModelName(lModel.getName(this.workspaceHelper.getLocale()));
        if (this.supportsOlap(this.domain)) {
            this.setModellingMode(ModelerMode.ANALYSIS_AND_REPORTING);
        } else {
            this.setModellingMode(ModelerMode.REPORTING_ONLY);
        }
        lModel = this.getLogicalModel(ModelerPerspective.ANALYSIS);
        List theDimensions = null;
        if (lModel != null) {
            theDimensions = (List)lModel.getProperty("olap_dimensions");
        }
        if (theDimensions != null) {
            for (OlapDimension theDimension : theDimensions) {
                DimensionMetaData theDimensionMD = new DimensionMetaData(theDimension.getName(), theDimension.getType());
                theDimensionMD.setTimeDimension(theDimension.isTimeDimension());
                List theHierarchies = theDimension.getHierarchies();
                for (OlapHierarchy theHierarchy : theHierarchies) {
                    HierarchyMetaData theHierarchyMD = new HierarchyMetaData(theHierarchy.getName());
                    List theLevels = theHierarchy.getHierarchyLevels();
                    for (OlapHierarchyLevel theLevel : theLevels) {
                        List annotations;
                        String refID;
                        LogicalColumn olapCol;
                        TimeRole role;
                        LevelMetaData theLevelMD = new LevelMetaData(theHierarchyMD, theLevel.getName());
                        theLevelMD.setParent(theHierarchyMD);
                        theLevelMD.setUniqueMembers(theLevel.isHavingUniqueMembers());
                        if (theDimensionMD.isTimeDimension() && (role = TimeRole.fromMondrianAttributeValue(theLevel.getLevelType())) != null) {
                            theLevelMD.setDataRole(role);
                        }
                        if ((olapCol = theLevel.getReferenceColumn()) != null) {
                            refID = olapCol.getId();
                            if (!refID.endsWith("_OLAP") && !refID.contains("_OLAP_")) {
                                olapCol = ModelerConversionUtil.findCorrespondingOlapColumn(olapCol, lModel);
                                theLevel.setReferenceColumn(olapCol);
                            }
                            theLevelMD.setLogicalColumn(olapCol);
                        }
                        if ((olapCol = theLevel.getReferenceOrdinalColumn()) != null) {
                            refID = olapCol.getId();
                            if (!refID.endsWith("_OLAP") && !refID.contains("_OLAP_")) {
                                olapCol = ModelerConversionUtil.findCorrespondingOlapColumn(olapCol, lModel);
                                theLevel.setReferenceOrdinalColumn(olapCol);
                            }
                            theLevelMD.setLogicalOrdinalColumn(olapCol);
                        }
                        if ((olapCol = theLevel.getReferenceCaptionColumn()) != null) {
                            refID = olapCol.getId();
                            if (!refID.endsWith("_OLAP") && !refID.contains("_OLAP_")) {
                                olapCol = ModelerConversionUtil.findCorrespondingOlapColumn(olapCol, lModel);
                                theLevel.setReferenceCaptionColumn(olapCol);
                            }
                            theLevelMD.setLogicalCaptionColumn(olapCol);
                        }
                        if (theLevel.getLogicalColumns() != null && theLevel.getLogicalColumns().size() > 0) {
                            for (LogicalColumn lc : theLevel.getLogicalColumns()) {
                                if (lc == null) continue;
                                if (!lc.getId().endsWith("_OLAP") && !lc.getId().contains("_OLAP_")) {
                                    lc = ModelerConversionUtil.findCorrespondingOlapColumn(lc, lModel);
                                }
                                MemberPropertyMetaData memberProp = new MemberPropertyMetaData(theLevelMD, lc.getName(this.workspaceHelper.getLocale()));
                                memberProp.setLogicalColumn(lc);
                                memberProp.setDescription(lc.getDescription(this.workspaceHelper.getLocale()));
                                theLevelMD.add(memberProp);
                            }
                        }
                        if ((annotations = theLevel.getAnnotations()) != null) {
                            for (OlapAnnotation anno : annotations) {
                                IMemberAnnotation annoMeta = MemberAnnotationFactory.create(anno);
                                theLevelMD.getMemberAnnotations().put(anno.getName(), annoMeta);
                            }
                        }
                        theHierarchyMD.add(theLevelMD);
                    }
                    theHierarchyMD.setParent(theDimensionMD);
                    theDimensionMD.add(theHierarchyMD);
                }
                this.model.getDimensions().add(theDimensionMD);
            }
        }
        List theCubes = null;
        if (lModel != null) {
            theCubes = (List)lModel.getProperty("olap_cubes");
        }
        if (theCubes != null) {
            for (OlapCube theCube : theCubes) {
                List theMeasures = theCube.getOlapMeasures();
                for (OlapMeasure theMeasure : theMeasures) {
                    LogicalColumn lCol;
                    Set locales;
                    String[] stringLocals;
                    MeasureMetaData theMeasureMD = new MeasureMetaData(this.workspaceHelper.getLocale());
                    if (theMeasure.getName() == null || theMeasure.getName().length() == 0) {
                        theMeasureMD.setName(theMeasure.getLogicalColumn().getName(this.workspaceHelper.getLocale()));
                    } else {
                        theMeasureMD.setName(theMeasure.getName());
                    }
                    theMeasureMD.setFormat((String)theMeasure.getLogicalColumn().getProperty("mask"));
                    theMeasureMD.setDefaultAggregation(theMeasure.getLogicalColumn().getAggregationType());
                    String possibleMeasureName = theMeasure.getLogicalColumn().getId();
                    if (!theMeasure.getLogicalColumn().getId().endsWith("_OLAP") && !theMeasure.getLogicalColumn().getId().contains("_OLAP_")) {
                        LogicalColumn olapCol = ModelerConversionUtil.findCorrespondingOlapColumn(theMeasure.getLogicalColumn(), lModel);
                        theMeasure.setLogicalColumn(olapCol);
                    }
                    if ((stringLocals = (locales = (lCol = theMeasure.getLogicalColumn()).getName().getLocales()).toArray(new String[0])) != null && stringLocals.length > 0) {
                        if (theMeasure.getName() == null || theMeasure.getName().trim().length() == 0) {
                            theMeasure.setName(possibleMeasureName);
                        }
                        lCol.setName(new LocalizedString(stringLocals[0], theMeasure.getName()));
                    }
                    theMeasureMD.setLogicalColumn(lCol);
                    this.model.getMeasures().add(theMeasureMD);
                }
            }
        }
        lModel = this.getLogicalModel(ModelerPerspective.REPORTING);
        int i = 1;
        for (Category cat : lModel.getCategories()) {
            String catName = BaseModelerWorkspaceHelper.getCleanCategoryName(cat.getName(this.workspaceHelper.getLocale()), this, i++);
            CategoryMetaData catMeta = new CategoryMetaData(catName);
            for (LogicalColumn col : cat.getLogicalColumns()) {
                LogicalTable table = col.getLogicalTable();
                if (!table.getLogicalColumns().contains(col)) {
                    table.addLogicalColumn(col);
                }
                Object formatMask = col.getProperty("mask");
                String colName = col.getName(this.workspaceHelper.getLocale());
                AggregationType aggType = col.getAggregationType();
                FieldMetaData field = new FieldMetaData(catMeta, colName, formatMask == null ? null : formatMask.toString(), colName, this.workspaceHelper.getLocale());
                if (aggType != null) {
                    field.setDefaultAggregation(aggType);
                } else {
                    field.setDefaultAggregation(AggregationType.NONE);
                }
                field.setLogicalColumn(col);
                catMeta.add(field);
            }
            this.getRelationalModel().getCategories().add(catMeta);
        }
        this.setModelIsChanging(false, true);
        this.setRelationalModelIsChanging(false, true);
    }

    private void upConvertMeasuresAndDimensions() {
        if (this.domain.getLogicalModels().size() == 1) {
            return;
        }
        LogicalModel model = (LogicalModel)this.domain.getLogicalModels().get(1);
        for (LogicalTable table : model.getLogicalTables()) {
            table.getLogicalColumns().clear();
        }
        Iterator i$ = this.getModel().getDimensions().iterator();
        while (i$.hasNext()) {
            DimensionMetaData dim = (DimensionMetaData)i$.next();
            Iterator i$2 = dim.iterator();
            while (i$2.hasNext()) {
                HierarchyMetaData hier = (HierarchyMetaData)i$2.next();
                Iterator i$3 = hier.iterator();
                while (i$3.hasNext()) {
                    LevelMetaData level = (LevelMetaData)i$3.next();
                    AvailableField field = new AvailableField(level.getLogicalColumn().getPhysicalColumn());
                    ColumnBackedNode node = this.createColumnBackedNode(field, ModelerPerspective.ANALYSIS);
                    level.setLogicalColumn(node.getLogicalColumn());
                }
            }
        }
        i$ = this.getModel().getMeasures().iterator();
        while (i$.hasNext()) {
            MeasureMetaData measure = (MeasureMetaData)i$.next();
            AvailableField field = new AvailableField(measure.getLogicalColumn().getPhysicalColumn());
            ColumnBackedNode node = this.createColumnBackedNode(field, ModelerPerspective.ANALYSIS);
            measure.setLogicalColumn(node.getLogicalColumn());
        }
        ModelerConversionUtil.duplicateRelationshipsForOlap((LogicalModel)this.domain.getLogicalModels().get(0), model);
    }

    protected boolean upConvertLegacyModel() {
        double version = ModelerConversionUtil.upConvertDomain(this.domain);
        return version < Double.parseDouble("3.0");
    }

    public void resolveConnectionFromDomain() {
        if (this.domain != null && this.source != null) {
            this.domain.getPhysicalModels().get(0);
        }
    }

    public Domain getDomain() {
        return this.updateDomain();
    }

    private Domain updateDomain() {
        return this.domain;
    }

    public void setModelIsChanging(boolean changing) {
        this.setModelIsChanging(changing, true);
    }

    public void setModelIsChanging(boolean changing, boolean fireChanged) {
        this.modelIsChanging = changing;
        if (!changing && fireChanged) {
            this.fireTablesChanged();
            this.model.validateTree();
            this.isValid();
            this.fireModelChanged();
        }
    }

    public void setRelationalModelIsChanging(boolean changing) {
        this.setRelationalModelIsChanging(changing, true);
    }

    public void setRelationalModelIsChanging(boolean changing, boolean fireChanged) {
        this.modelIsChanging = changing;
        if (!changing && fireChanged) {
            this.fireTablesChanged();
            this.relationalModel.validateTree();
            this.isValid();
            this.fireRelationalModelChanged();
        }
    }

    @Bindable
    public boolean isModelChanging() {
        return this.modelIsChanging;
    }

    @Bindable
    public void setTemporary(boolean isTempoarary) {
        this.isTemporary = isTempoarary;
    }

    @Bindable
    public boolean isTemporary() {
        return this.isTemporary;
    }

    @Bindable
    public AbstractMetaDataModelNode getSelectedNode() {
        return this.selectedNode;
    }

    @Bindable
    public void setSelectedNode(AbstractMetaDataModelNode node) {
        AbstractMetaDataModelNode prevVal = this.selectedNode;
        this.selectedNode = node;
        this.firePropertyChange("selectedNode", prevVal, node);
    }

    @Bindable
    public IAvailableItem getSelectedAvailableItem() {
        return this.selectedAvailableItem;
    }

    @Bindable
    public void setSelectedAvailableItem(IAvailableItem selectedAvailableItem) {
        IAvailableItem prev = this.selectedAvailableItem;
        this.selectedAvailableItem = selectedAvailableItem;
        this.firePropertyChange("selectedAvailableItem", prev, selectedAvailableItem);
    }

    @Bindable
    public AbstractMetaDataModelNode getSelectedRelationalNode() {
        return this.selectedRelationalNode;
    }

    @Bindable
    public void setSelectedRelationalNode(AbstractMetaDataModelNode node) {
        AbstractMetaDataModelNode prevVal = this.selectedRelationalNode;
        this.selectedRelationalNode = node;
        this.firePropertyChange("selectedRelationalNode", prevVal, node);
    }

    public IModelerWorkspaceHelper getWorkspaceHelper() {
        return this.workspaceHelper;
    }

    public void setWorkspaceHelper(IModelerWorkspaceHelper workspaceHelper) {
        this.workspaceHelper = workspaceHelper;
    }

    @Bindable
    public ModelerMode getModellingMode() {
        return this.currentModellingMode;
    }

    @Bindable
    public void setModellingMode(ModelerMode currentModellingMode) {
        ModelerMode prevVal = this.currentModellingMode;
        this.currentModellingMode = currentModellingMode;
        this.firePropertyChange("modellingMode", (Object)prevVal, (Object)this.currentModellingMode);
        this.isValid();
    }

    public void setGeoContext(GeoContext geoContext) {
        this.geoContext = geoContext;
        this.simpleAutoModelStrategy.setGeoContext(geoContext);
        this.starSchemaAutoModelStrategy.setGeoContext(geoContext);
        GeoAnnotationFactory fact = new GeoAnnotationFactory(geoContext);
        MemberAnnotationFactory.registerFactory("Geo.Role", fact);
        MemberAnnotationFactory.registerFactory("Data.Role", fact);
        MemberAnnotationFactory.registerFactory("Geo.RequiredParents", fact);
    }

    @Bindable
    public ModelerPerspective getCurrentModelerPerspective() {
        return this.currentModelerPerspective;
    }

    @Bindable
    public void setCurrentModelerPerspective(ModelerPerspective currentModelerPerspective) {
        this.currentModelerPerspective = currentModelerPerspective;
        this.firePropertyChange("currentModelerPerspective", null, (Object)currentModelerPerspective);
    }

    public ColumnBackedNode createColumnBackedNode(AvailableField field, ModelerPerspective perspective) {
        String locale = this.workspaceHelper.getLocale();
        BaseColumnBackedMetaData node = new BaseColumnBackedMetaData(field.getName());
        LogicalTable lTab = this.findLogicalTable(field.getPhysicalColumn().getPhysicalTable(), perspective);
        LogicalColumn lCol = null;
        if (lCol == null) {
            lCol = new LogicalColumn();
            lCol.setLogicalTable(lTab);
            lCol.setPhysicalColumn(field.getPhysicalColumn());
            lCol.setDataType(field.getPhysicalColumn().getDataType());
            if (field.getPhysicalColumn().getAggregationList() != null) {
                lCol.setAggregationList(field.getPhysicalColumn().getAggregationList());
            }
            if (field.getPhysicalColumn().getAggregationType() != null) {
                lCol.setAggregationType(field.getPhysicalColumn().getAggregationType());
            }
            lCol.setName(new LocalizedString(locale, field.getPhysicalColumn().getName(locale)));
            String colId = "LC_" + ModelerWorkspace.toId(lTab.getPhysicalTable().getName(locale)) + "_" + ModelerWorkspace.toId(field.getPhysicalColumn().getId());
            if (perspective == ModelerPerspective.ANALYSIS) {
                colId = colId + "_OLAP";
            }
            colId = BaseModelerWorkspaceHelper.uniquify(colId, lTab.getLogicalColumns());
            lCol.setId(colId);
            lTab.addLogicalColumn(lCol);
        }
        node.setLogicalColumn(lCol);
        return node;
    }

    public LogicalColumn findLogicalColumn(IPhysicalColumn column, ModelerPerspective perspective) {
        LogicalColumn col = null;
        IPhysicalTable physicalTable = column.getPhysicalTable();
        LogicalModel logicalModel = this.getLogicalModel(perspective);
        if (logicalModel == null) {
            return col;
        }
        for (LogicalTable table : logicalModel.getLogicalTables()) {
            if (!table.getPhysicalTable().getId().equals(physicalTable.getId()) || (perspective != ModelerPerspective.ANALYSIS || !table.getId().endsWith("_OLAP")) && (perspective != ModelerPerspective.REPORTING || table.getId().endsWith("_OLAP"))) continue;
            for (LogicalColumn lCol : table.getLogicalColumns()) {
                if (!lCol.getPhysicalColumn().getId().equals(column.getId())) continue;
                return lCol;
            }
        }
        return col;
    }

    @Bindable
    public ModelerTreeHelper getCurrentModelerTreeHelper() {
        return this.currentModelerTreeHelper;
    }

    @Bindable
    public void setCurrentModelerTreeHelper(ModelerTreeHelper currentModelerTreeHelper) {
        this.currentModelerTreeHelper = currentModelerTreeHelper;
    }

    public LogicalModel getLogicalModel() {
        return this.getLogicalModel(ModelerPerspective.REPORTING);
    }

    public LogicalModel getLogicalModel(ModelerPerspective type) {
        switch (type) {
            case ANALYSIS: {
                if (this.getDomain().getLogicalModels().size() == 1) {
                    return null;
                }
                return (LogicalModel)this.getDomain().getLogicalModels().get(1);
            }
        }
        return (LogicalModel)this.getDomain().getLogicalModels().get(0);
    }

    public static final String toId(String name) {
        if (name == null) {
            return name;
        }
        name = name.replaceAll("[ .,:(){}\\[\\]]", "_");
        name = name.replaceAll("[\"`']", "");
        name = name.replaceAll("_+", "_");
        return name;
    }

    public static final String removeQuotes(String name) {
        if (name == null) {
            return name;
        }
        name = name.replaceAll("[\"`']", "");
        return name;
    }
}

