/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.models.annotations;

import java.util.Iterator;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.models.annotations.AnnotationType;
import org.pentaho.agilebi.modeler.models.annotations.ModelAnnotation;
import org.pentaho.agilebi.modeler.models.annotations.ModelProperty;
import org.pentaho.agilebi.modeler.nodes.DimensionMetaData;
import org.pentaho.agilebi.modeler.nodes.HierarchyMetaData;
import org.pentaho.agilebi.modeler.nodes.LevelMetaData;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.persist.MetaStoreAttribute;
import org.pentaho.metastore.persist.MetaStoreElementType;
import org.w3c.dom.Document;

@MetaStoreElementType(name="RemoveAttribute", description="RemoveAttribute Annotation")
public class RemoveAttribute
extends AnnotationType {
    private static final long serialVersionUID = 6421805119523455990L;
    private static transient Logger logger = Logger.getLogger(AnnotationType.class.getName());
    private static final String NAME_ID = "name";
    private static final String NAME_NAME = "Name";
    private static final int NAME_ORDER = 0;
    private static final String LEVEL_ID = "level";
    private static final String LEVEL_NAME = "Level";
    private static final int LEVEL_ORDER = 1;
    @MetaStoreAttribute
    @ModelProperty(id="name", name="Name", order=0)
    private String name;
    @MetaStoreAttribute
    @ModelProperty(id="level", name="Level", order=1)
    private String level;

    @Override
    public boolean apply(ModelerWorkspace workspace, IMetaStore metaStore) throws ModelerException {
        LevelMetaData existingLevel = this.locateLevelFromFormula(workspace, this.level);
        boolean isApplied = false;
        if (existingLevel != null && workspace != null) {
            this.removeLevel(workspace, existingLevel);
            workspace.getWorkspaceHelper().populateDomain(workspace);
            isApplied = true;
        }
        return isApplied;
    }

    private LevelMetaData locateLevelFromFormula(ModelerWorkspace workspace, String formula) {
        if (formula == null || workspace == null) {
            return null;
        }
        Iterator i$ = workspace.getModel().getDimensions().iterator();
        while (i$.hasNext()) {
            DimensionMetaData dimensionMetaData = (DimensionMetaData)i$.next();
            Iterator i$2 = dimensionMetaData.iterator();
            while (i$2.hasNext()) {
                HierarchyMetaData hierarchyMetaData = (HierarchyMetaData)i$2.next();
                Iterator i$3 = hierarchyMetaData.iterator();
                while (i$3.hasNext()) {
                    LevelMetaData levelMetaData = (LevelMetaData)i$3.next();
                    StringBuffer formulaBuffer = new StringBuffer();
                    formulaBuffer.append("[");
                    formulaBuffer.append(dimensionMetaData.getName());
                    if (StringUtils.isNotEmpty((String)hierarchyMetaData.getName())) {
                        formulaBuffer.append(".");
                        formulaBuffer.append(hierarchyMetaData.getName());
                    }
                    formulaBuffer.append("].[");
                    formulaBuffer.append(levelMetaData.getName());
                    formulaBuffer.append("]");
                    if (!formula.equals(formulaBuffer.toString())) continue;
                    return levelMetaData;
                }
            }
        }
        return null;
    }

    private void removeLevel(ModelerWorkspace workspace, LevelMetaData levelMetaData) {
        if (levelMetaData == null) {
            return;
        }
        HierarchyMetaData hierarchyMetaData = levelMetaData.getHierarchyMetaData();
        if (hierarchyMetaData.getLevels().size() == 1) {
            this.removeAutoLevel(workspace, levelMetaData);
        } else if (hierarchyMetaData.contains(levelMetaData)) {
            hierarchyMetaData.remove(levelMetaData);
        }
    }

    @Override
    public boolean apply(Document schema) throws ModelerException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void validate() throws ModelerException {
        if (StringUtils.isBlank((String)this.getLevel())) {
            throw new ModelerException(BaseMessages.getString((Class)MSG_CLASS, (String)"ModelAnnotation.RemoveAttribute.validation.FIELD_NAME_REQUIRED", (String[])new String[0]));
        }
    }

    @Override
    public ModelAnnotation.Type getType() {
        return ModelAnnotation.Type.REMOVE_ATTRIBUTE;
    }

    private String summaryMsgKey() {
        return "Modeler.RemoveAttribute.Summary";
    }

    @Override
    public String getSummary() {
        return BaseMessages.getString((Class)MSG_CLASS, (String)this.summaryMsgKey(), (String[])new String[]{this.getName()});
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    @Override
    public String getField() {
        return null;
    }
}

