/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.models.annotations.util;

import java.util.HashMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import mondrian.olap.MondrianDef;
import org.apache.commons.lang.StringUtils;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.models.annotations.util.XMLUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MondrianSchemaHandler {
    protected static final Class<?> MSG_CLASS = MondrianSchemaHandler.class;
    public static final String XPATH_SEPARATOR = "/";
    public static final String SCHEMA_XPATH_EXPR = "/Schema";
    public static final String CUBE_XPATH_EXPR = "/Schema/Cube";
    public static final String MEASURE_ELEMENT_NAME = "Measure";
    public static final String MEASURE_NAME_ATTRIBUTE = "name";
    public static final String MEASURE_COLUMN_ATTRIBUTE = "column";
    public static final String MEASURE_AGGREGATOR_ATTRIBUTE = "aggregator";
    public static final String MEASURE_DIMENSION = "Measure";
    public static final String DIMENSION = "Dimension";
    public static final String MEASURE_FORMAT_STRING_ATTRIBUTE = "formatString";
    public static final String CALCULATED_MEMBER_FORMAT_STRING_ATTRIBUTE = "formatString";
    private Document schema;

    public MondrianSchemaHandler() {
    }

    public MondrianSchemaHandler(Document schema) {
        this.schema = schema;
    }

    public void addMeasure(String cubeName, MondrianDef.Measure measure) throws ModelerException {
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            StringBuffer xPathExpr = new StringBuffer();
            String cubeXPathPart = CUBE_XPATH_EXPR;
            if (cubeName != null) {
                cubeXPathPart = cubeXPathPart + "[@name=\"" + cubeName + "\"]";
            }
            xPathExpr.append(cubeXPathPart);
            XPathExpression xPathExpression = xPath.compile(xPathExpr.toString());
            Node cube = (Node)xPathExpression.evaluate(this.schema, XPathConstants.NODE);
            Element measureElement = this.schema.createElement("Measure");
            NodeList calculatedMemberNodeList = this.schema.getElementsByTagName("CalculatedMember");
            if (calculatedMemberNodeList != null && calculatedMemberNodeList.getLength() > 0) {
                Node firstCalculatedMemberNode = calculatedMemberNodeList.item(0);
                cube.insertBefore(measureElement, firstCalculatedMemberNode);
            } else {
                cube.appendChild(measureElement);
            }
            measureElement.setAttribute(MEASURE_NAME_ATTRIBUTE, measure.name);
            measureElement.setAttribute(MEASURE_COLUMN_ATTRIBUTE, measure.column);
            measureElement.setAttribute(MEASURE_AGGREGATOR_ATTRIBUTE, measure.aggregator);
            if (measure.formatString != null) {
                measureElement.setAttribute("formatString", measure.formatString);
            }
        }
        catch (XPathExpressionException e) {
            throw new ModelerException(e);
        }
    }

    public void addCalculatedMember(String cubeName, MondrianDef.CalculatedMember calculatedMember) throws ModelerException {
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            StringBuilder xPathExpr = new StringBuilder();
            String cubeXPathPart = CUBE_XPATH_EXPR;
            if (cubeName != null) {
                cubeXPathPart = cubeXPathPart + "[@name=\"" + cubeName + "\"]";
            }
            xPathExpr.append(cubeXPathPart);
            XPathExpression xPathExpression = xPath.compile(xPathExpr.toString());
            Node cube = (Node)xPathExpression.evaluate(this.schema, XPathConstants.NODE);
            Element measureElement = this.schema.createElement("CalculatedMember");
            cube.appendChild(measureElement);
            measureElement.setAttribute(MEASURE_NAME_ATTRIBUTE, calculatedMember.name);
            measureElement.setAttribute("caption", calculatedMember.caption);
            measureElement.setAttribute("description", calculatedMember.description);
            measureElement.setAttribute("dimension", calculatedMember.dimension);
            measureElement.setAttribute("formula", calculatedMember.formula);
            measureElement.setAttribute("visible", calculatedMember.visible.toString());
            measureElement.setAttribute("formatString", calculatedMember.formatString);
            if (calculatedMember.annotations != null) {
                Element annotationsElement = this.schema.createElement("Annotations");
                for (MondrianDef.Annotation annot : calculatedMember.annotations.array) {
                    Element annotationElement = this.schema.createElement("Annotation");
                    annotationElement.setAttribute(MEASURE_NAME_ATTRIBUTE, annot.name);
                    annotationElement.setTextContent(annot.cdata);
                    annotationsElement.appendChild(annotationElement);
                }
                measureElement.appendChild(annotationsElement);
            }
            if (calculatedMember.memberProperties != null) {
                this.addCalculatedMemberProperties(calculatedMember, measureElement);
            }
        }
        catch (XPathExpressionException e) {
            throw new ModelerException(e);
        }
    }

    private Node getMeasureNode(String cubeName, String measureName) throws ModelerException {
        if (StringUtils.isBlank((String)measureName)) {
            return null;
        }
        String cubeXPathPart = CUBE_XPATH_EXPR;
        if (!StringUtils.isBlank((String)cubeName)) {
            cubeXPathPart = cubeXPathPart + "[@name=\"" + cubeName + "\"]";
        }
        if (measureName.contains("[")) {
            measureName = measureName.substring(measureName.lastIndexOf("[") + 1, measureName.lastIndexOf("]"));
        }
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            StringBuffer xPathExpr = new StringBuffer();
            xPathExpr.append(cubeXPathPart + "//" + "Measure" + "[@name=\"" + measureName + "\"]");
            XPathExpression xPathExpression = xPath.compile(xPathExpr.toString());
            return (Node)xPathExpression.evaluate(this.schema, XPathConstants.NODE);
        }
        catch (Exception e) {
            throw new ModelerException(e);
        }
    }

    public boolean updateMeasure(String cubeName, String measureName, MondrianDef.Measure measure) throws ModelerException {
        if (StringUtils.isBlank((String)measureName)) {
            throw new ModelerException(BaseMessages.getString(MSG_CLASS, (String)"MondrianSchemaHelper.updateMeasure.UNABLE_TO_FIND_MEASURE", (String[])new String[0]));
        }
        if (measureName.contains("[")) {
            measureName = measureName.substring(measureName.lastIndexOf("[") + 1, measureName.lastIndexOf("]"));
        }
        try {
            Node duplicateMeasure = this.getMeasureNode(cubeName, measure.name);
            if (!measureName.equals(measure.name) && duplicateMeasure != null) {
                return false;
            }
            Node measureNode = this.getMeasureNode(cubeName, measureName);
            if (measureNode == null) {
                return false;
            }
            NamedNodeMap measureAttrs = measureNode.getAttributes();
            if (!StringUtils.isBlank((String)measure.aggregator)) {
                Node aggNode = measureAttrs.getNamedItem(MEASURE_AGGREGATOR_ATTRIBUTE);
                aggNode.setNodeValue(measure.aggregator);
            }
            Node formatNode = measureAttrs.getNamedItem("formatString");
            formatNode.setNodeValue(measure.formatString);
            if (!StringUtils.isBlank((String)measure.name)) {
                Node nameNode = measureAttrs.getNamedItem(MEASURE_NAME_ATTRIBUTE);
                nameNode.setNodeValue(measure.name);
            }
        }
        catch (Exception e) {
            throw new ModelerException(e);
        }
        return true;
    }

    public boolean updateCalculatedMember(String cubeName, String calculatedMemberName, MondrianDef.CalculatedMember updatedCalculatedMember) throws ModelerException {
        if (StringUtils.isBlank((String)calculatedMemberName)) {
            throw new ModelerException(BaseMessages.getString(MSG_CLASS, (String)"MondrianSchemaHelper.updateMeasure.UNABLE_TO_FIND_MEASURE", (String[])new String[0]));
        }
        try {
            Element annotationsNode;
            NodeList annotationsNodes;
            Element existingCalculatedMemberNode = this.getCalculatedMeasureNode(cubeName, calculatedMemberName);
            if (existingCalculatedMemberNode == null) {
                return false;
            }
            if (!StringUtils.isBlank((String)updatedCalculatedMember.formatString)) {
                XMLUtil.addOrUpdateAttribute(existingCalculatedMemberNode, "formatString", updatedCalculatedMember.formatString);
            }
            if (!StringUtils.isBlank((String)updatedCalculatedMember.name)) {
                XMLUtil.addOrUpdateAttribute(existingCalculatedMemberNode, MEASURE_NAME_ATTRIBUTE, updatedCalculatedMember.name);
            }
            if (!StringUtils.isBlank((String)updatedCalculatedMember.caption)) {
                XMLUtil.addOrUpdateAttribute(existingCalculatedMemberNode, "caption", updatedCalculatedMember.caption);
            }
            if (!StringUtils.isBlank((String)updatedCalculatedMember.description)) {
                XMLUtil.addOrUpdateAttribute(existingCalculatedMemberNode, "description", updatedCalculatedMember.description);
            }
            if (!StringUtils.isBlank((String)updatedCalculatedMember.formula)) {
                XMLUtil.addOrUpdateAttribute(existingCalculatedMemberNode, "formula", updatedCalculatedMember.formula);
            }
            if (!StringUtils.isBlank((String)updatedCalculatedMember.dimension)) {
                XMLUtil.addOrUpdateAttribute(existingCalculatedMemberNode, "dimension", updatedCalculatedMember.dimension);
            }
            if (!StringUtils.isBlank((String)updatedCalculatedMember.hierarchy)) {
                XMLUtil.addOrUpdateAttribute(existingCalculatedMemberNode, "hierarchy", updatedCalculatedMember.hierarchy);
            }
            if (!StringUtils.isBlank((String)updatedCalculatedMember.parent)) {
                XMLUtil.addOrUpdateAttribute(existingCalculatedMemberNode, "parent", updatedCalculatedMember.parent);
            }
            if (!StringUtils.isBlank((String)updatedCalculatedMember.visible.toString())) {
                XMLUtil.addOrUpdateAttribute(existingCalculatedMemberNode, "visible", updatedCalculatedMember.visible.toString());
            }
            if ((annotationsNodes = existingCalculatedMemberNode.getElementsByTagName("Annotations")) == null || annotationsNodes.getLength() <= 0) {
                annotationsNode = this.schema.createElement("Annotations");
                existingCalculatedMemberNode.appendChild(annotationsNode);
            } else {
                annotationsNode = (Element)annotationsNodes.item(0);
            }
            NodeList annotationNodes = annotationsNode.getElementsByTagName("Annotation");
            HashMap<String, Node> annotationMap = new HashMap<String, Node>();
            for (int y = 0; y <= annotationNodes.getLength() - 1; ++y) {
                Node annotationNode = annotationNodes.item(y);
                annotationMap.put(annotationNode.getAttributes().getNamedItem(MEASURE_NAME_ATTRIBUTE).getTextContent(), annotationNode);
            }
            if (updatedCalculatedMember.annotations.array != null) {
                for (int x = 0; x <= updatedCalculatedMember.annotations.array.length - 1; ++x) {
                    if (annotationMap.containsKey(updatedCalculatedMember.annotations.array[x].name)) {
                        ((Node)annotationMap.get(updatedCalculatedMember.annotations.array[x].name)).setTextContent(updatedCalculatedMember.annotations.array[x].cdata);
                        continue;
                    }
                    Element newAnnotation = this.schema.createElement("Annotation");
                    newAnnotation.setAttribute(MEASURE_NAME_ATTRIBUTE, updatedCalculatedMember.annotations.array[x].name);
                    newAnnotation.setTextContent(updatedCalculatedMember.annotations.array[x].cdata);
                    annotationsNode.appendChild(newAnnotation);
                }
            }
            this.deleteCalculatedMemberProperties(existingCalculatedMemberNode);
            if (updatedCalculatedMember.memberProperties != null) {
                this.addCalculatedMemberProperties(updatedCalculatedMember, existingCalculatedMemberNode);
            }
        }
        catch (Exception e) {
            throw new ModelerException(e);
        }
        return true;
    }

    private void deleteCalculatedMemberProperties(Element existingCalculatedMemberNode) {
        NodeList calculatedMemberProperties = existingCalculatedMemberNode.getElementsByTagName("CalculatedMemberProperty");
        if (calculatedMemberProperties != null && calculatedMemberProperties.getLength() > 0) {
            for (int x = 0; x <= calculatedMemberProperties.getLength() - 1; ++x) {
                Element calculatedMemberProperty = (Element)calculatedMemberProperties.item(x);
                calculatedMemberProperty.getParentNode().removeChild(calculatedMemberProperty);
            }
        }
    }

    private void addCalculatedMemberProperties(MondrianDef.CalculatedMember updatedCalculatedMember, Element node) {
        for (MondrianDef.CalculatedMemberProperty property : updatedCalculatedMember.memberProperties) {
            Element propertyElement = this.schema.createElement("CalculatedMemberProperty");
            propertyElement.setAttribute(MEASURE_NAME_ATTRIBUTE, property.name);
            propertyElement.setAttribute("value", property.value);
            node.appendChild(propertyElement);
        }
    }

    private Element getLevelNode(String cubeName, String dimensionName, String hierarchyName, String levelName) throws ModelerException {
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            String inlineWithHierarchy = String.format("Schema/Cube[@name=\"%s\"]/Dimension[@name=\"%s\"]/Hierarchy[@name=\"%s\"]/Level[@name=\"%s\"]", cubeName, dimensionName, hierarchyName, levelName);
            Element levelElement = (Element)xPath.compile(inlineWithHierarchy).evaluate(this.schema, XPathConstants.NODE);
            if (levelElement == null) {
                String sharedCompleteXPath;
                String dimensionUageXPath;
                Element usageElement;
                if (dimensionName.equals(hierarchyName)) {
                    String inlineDefaultHierarchy = String.format("Schema/Cube[@name=\"%s\"]/Dimension[@name=\"%s\"]/Hierarchy[not(@name) or @name=\"\"]/Level[@name=\"%s\"]", cubeName, dimensionName, levelName);
                    levelElement = (Element)xPath.compile(inlineDefaultHierarchy).evaluate(this.schema, XPathConstants.NODE);
                }
                if (levelElement == null && (usageElement = (Element)xPath.compile(dimensionUageXPath = String.format("Schema/Cube[@name=\"%s\"]/DimensionUsage[@name=\"%s\"]", cubeName, dimensionName)).evaluate(this.schema, XPathConstants.NODE)) != null && (levelElement = (Element)xPath.compile(sharedCompleteXPath = String.format("Schema/Dimension[@name=\"%s\"]/Hierarchy[@name=\"%s\"]/Level[@name=\"%s\"]", usageElement.getAttribute("source"), hierarchyName, levelName)).evaluate(this.schema, XPathConstants.NODE)) == null && dimensionName.equals(hierarchyName)) {
                    String sharedDefaultHierarchyXPath = String.format("Schema/Dimension[@name=\"%s\"]/Hierarchy[not(@name)]/Level[@name=\"%s\"]", usageElement.getAttribute("source"), levelName);
                    levelElement = (Element)xPath.compile(sharedDefaultHierarchyXPath).evaluate(this.schema, XPathConstants.NODE);
                }
            }
            return levelElement;
        }
        catch (Exception e) {
            throw new ModelerException(e);
        }
    }

    private Element getCalculatedMeasureNode(String cubeName, String measureName) throws ModelerException {
        try {
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            String inlineWithHierarchy = String.format("Schema/Cube[@name=\"%s\"]/CalculatedMember[@name=\"%s\" and @dimension=\"Measures\"]", cubeName, measureName);
            return (Element)xPath.compile(inlineWithHierarchy).evaluate(this.schema, XPathConstants.NODE);
        }
        catch (Exception e) {
            throw new ModelerException(e);
        }
    }

    public boolean showHideMeasure(String cubeName, String measureName, boolean visible) throws ModelerException {
        Element measureNode = (Element)this.getMeasureNode(cubeName, measureName);
        if (measureNode == null) {
            measureNode = this.getCalculatedMeasureNode(cubeName, measureName);
        }
        if (measureNode != null) {
            this.showHideElement(measureNode, visible);
            return true;
        }
        return false;
    }

    public boolean showHideAttribute(String cubeName, String dimensionName, String hierarchyName, String levelName, boolean visible) throws ModelerException {
        Element levelNode = this.getLevelNode(cubeName, dimensionName, hierarchyName, levelName);
        if (levelNode != null) {
            this.showHideElement(levelNode, visible);
            return true;
        }
        return false;
    }

    private void showHideElement(Element levelNode, boolean visible) {
        levelNode.setAttribute("visible", Boolean.toString(visible));
    }

    public Document getSchema() {
        return this.schema;
    }

    public void setSchema(Document schema) {
        this.schema = schema;
    }
}

