/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.strategy;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.pentaho.agilebi.modeler.BaseModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.geo.GeoContext;
import org.pentaho.agilebi.modeler.nodes.AvailableField;
import org.pentaho.agilebi.modeler.nodes.AvailableTable;
import org.pentaho.agilebi.modeler.nodes.CategoryMetaData;
import org.pentaho.agilebi.modeler.nodes.DimensionMetaData;
import org.pentaho.agilebi.modeler.nodes.DimensionMetaDataCollection;
import org.pentaho.agilebi.modeler.nodes.MainModelNode;
import org.pentaho.agilebi.modeler.nodes.MeasureMetaData;
import org.pentaho.agilebi.modeler.nodes.MeasuresCollection;
import org.pentaho.agilebi.modeler.nodes.RelationalModelNode;
import org.pentaho.agilebi.modeler.strategy.AutoModelStrategy;
import org.pentaho.metadata.model.IPhysicalModel;
import org.pentaho.metadata.model.IPhysicalTable;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.concept.types.DataType;

public class SimpleAutoModelStrategy
implements AutoModelStrategy {
    private String locale;
    protected GeoContext geoContext;

    public SimpleAutoModelStrategy(String locale) {
        this(locale, null);
    }

    public SimpleAutoModelStrategy(String locale, GeoContext geoContext) {
        this.locale = locale;
        this.geoContext = geoContext;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public GeoContext getGeoContext() {
        return this.geoContext;
    }

    public void setGeoContext(GeoContext geoContext) {
        this.geoContext = geoContext;
    }

    @Override
    public void autoModelOlap(ModelerWorkspace workspace, MainModelNode mainModel) throws ModelerException {
        mainModel.setName(workspace.getModelName());
        workspace.setModel(mainModel);
        DimensionMetaDataCollection dims = workspace.getModel().getDimensions();
        dims.clear();
        dims.setExpanded(true);
        MeasuresCollection measures = workspace.getModel().getMeasures();
        measures.setExpanded(false);
        measures.clear();
        boolean prevChangeState = workspace.isModelChanging();
        workspace.setModelIsChanging(true, !mainModel.getSuppressEvents());
        for (LogicalTable table : workspace.getLogicalModel(ModelerPerspective.ANALYSIS).getLogicalTables()) {
            if (!table.getId().endsWith("_OLAP")) continue;
            table.getLogicalColumns().clear();
        }
        HashSet<String> existingMeasures = new HashSet<String>();
        List<AvailableTable> tableList = workspace.getAvailableTables().getAsAvailableTablesList();
        for (AvailableTable table : tableList) {
            for (AvailableField field : table.getAvailableFields()) {
                if (this.isGeoField(field)) continue;
                DataType dataType = field.getPhysicalColumn().getDataType();
                if (dataType == DataType.NUMERIC && !existingMeasures.contains(field.getName())) {
                    MeasureMetaData measure = workspace.createMeasureForNode(field);
                    workspace.getModel().getMeasures().add(measure);
                    existingMeasures.add(field.getName());
                }
                workspace.addDimensionFromNode(workspace.createColumnBackedNode(field, ModelerPerspective.ANALYSIS));
            }
        }
        this.addGeoDimensions((List<DimensionMetaData>)((Object)dims), workspace);
        Iterator i$ = dims.iterator();
        while (i$.hasNext()) {
            DimensionMetaData dim = (DimensionMetaData)i$.next();
            dim.setExpanded(false);
        }
        if (!mainModel.getSuppressEvents()) {
            workspace.setModelIsChanging(prevChangeState);
            workspace.setSelectedNode(workspace.getModel());
        }
    }

    @Override
    public void autoModelRelational(ModelerWorkspace workspace, RelationalModelNode relationalModelNode) throws ModelerException {
        relationalModelNode.setName(workspace.getRelationalModelName());
        workspace.setRelationalModel(relationalModelNode);
        boolean prevChangeState = workspace.isModelChanging();
        workspace.getRelationalModel().getCategories().clear();
        workspace.setRelationalModelIsChanging(true, !relationalModelNode.getSuppressEvents());
        for (LogicalTable table : ((LogicalModel)workspace.getDomain().getLogicalModels().get(0)).getLogicalTables()) {
            if (table.getId().endsWith("_OLAP")) continue;
            table.getLogicalColumns().clear();
        }
        List tables = ((IPhysicalModel)workspace.getDomain().getPhysicalModels().get(0)).getPhysicalTables();
        HashSet<String> tableIds = new HashSet<String>();
        List<AvailableTable> tablesList = workspace.getAvailableTables().getAsAvailableTablesList();
        for (IPhysicalTable table : tables) {
            if (tableIds.contains(table.getId())) continue;
            tableIds.add(table.getId());
            String catName = BaseModelerWorkspaceHelper.getCleanCategoryName(table.getName(this.locale), workspace, tableIds.size());
            CategoryMetaData category = new CategoryMetaData(catName);
            category.setExpanded(true);
            for (AvailableTable aTable : tablesList) {
                if (!aTable.isSameUnderlyingPhysicalTable(table)) continue;
                for (AvailableField field : aTable.getAvailableFields()) {
                    if (!field.getPhysicalColumn().getPhysicalTable().getId().equals(table.getId())) continue;
                    category.add(workspace.createFieldForParentWithNode(category, field));
                }
            }
            relationalModelNode.getCategories().add(category);
        }
        if (!relationalModelNode.getSuppressEvents()) {
            workspace.setRelationalModelIsChanging(prevChangeState);
            workspace.setSelectedRelationalNode(workspace.getRelationalModel());
        }
    }

    protected boolean isGeoField(AvailableField field) {
        if (this.geoContext != null) {
            return this.geoContext.matchFieldToGeoRole(field) != null;
        }
        return false;
    }

    protected void addGeoDimensions(List<DimensionMetaData> dims, ModelerWorkspace workspace) {
        if (this.geoContext != null) {
            List<DimensionMetaData> geoDims = this.geoContext.buildDimensions(workspace);
            dims.addAll(geoDims);
            Collections.sort(dims, new Comparator<DimensionMetaData>(){

                @Override
                public int compare(DimensionMetaData dimMeta1, DimensionMetaData dimMeta2) {
                    return dimMeta1.getDisplayName().compareToIgnoreCase(dimMeta2.getDisplayName());
                }
            });
        }
    }
}

