/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat2;
import org.apache.hadoop.hbase.mapreduce.KeyValueSerialization;
import org.apache.hadoop.hbase.mapreduce.MutationSerialization;
import org.apache.hadoop.hbase.mapreduce.PutCombiner;
import org.apache.hadoop.hbase.mapreduce.PutSortReducer;
import org.apache.hadoop.hbase.mapreduce.ResultSerialization;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TextSortReducer;
import org.apache.hadoop.hbase.mapreduce.TsvImporterMapper;
import org.apache.hadoop.hbase.mapreduce.TsvImporterTextMapper;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ImportTsv
extends Configured
implements Tool {
    protected static final Log LOG = LogFactory.getLog(ImportTsv.class);
    static final String NAME = "importtsv";
    public static final String MAPPER_CONF_KEY = "importtsv.mapper.class";
    public static final String BULK_OUTPUT_CONF_KEY = "importtsv.bulk.output";
    public static final String TIMESTAMP_CONF_KEY = "importtsv.timestamp";
    public static final String JOB_NAME_CONF_KEY = "mapreduce.job.name";
    public static final String DRY_RUN_CONF_KEY = "importtsv.dry.run";
    public static final String LOG_BAD_LINES_CONF_KEY = "importtsv.log.bad.lines";
    public static final String SKIP_LINES_CONF_KEY = "importtsv.skip.bad.lines";
    public static final String COLUMNS_CONF_KEY = "importtsv.columns";
    public static final String SEPARATOR_CONF_KEY = "importtsv.separator";
    public static final String ATTRIBUTE_SEPERATOR_CONF_KEY = "attributes.seperator";
    public static final String CREDENTIALS_LOCATION = "credentials_location";
    static final String DEFAULT_SEPARATOR = "\t";
    static final String DEFAULT_ATTRIBUTES_SEPERATOR = "=>";
    static final String DEFAULT_MULTIPLE_ATTRIBUTES_SEPERATOR = ",";
    static final Class DEFAULT_MAPPER = TsvImporterMapper.class;
    public static final String CREATE_TABLE_CONF_KEY = "create.table";
    public static final String NO_STRICT_COL_FAMILY = "no.strict";
    private static boolean dryRunTableCreated;

    /*
     * Unable to fully structure code
     */
    protected static Job createSubmittableJob(Configuration conf, String[] args) throws IOException, ClassNotFoundException {
        job = null;
        isDryRun = conf.getBoolean("importtsv.dry.run", false);
        connection = ConnectionFactory.createConnection((Configuration)conf);
        var5_5 = null;
        try {
            admin = connection.getAdmin();
            var7_9 = null;
            try {
                actualSeparator = conf.get("importtsv.separator");
                if (actualSeparator != null) {
                    conf.set("importtsv.separator", Base64.encodeBytes((byte[])actualSeparator.getBytes()));
                }
                mapperClass = (mapperClassName = conf.get("importtsv.mapper.class")) != null ? Class.forName(mapperClassName) : ImportTsv.DEFAULT_MAPPER;
                tableName = TableName.valueOf((String)args[0]);
                inputDir = new Path(args[1]);
                jobName = conf.get("mapreduce.job.name", "importtsv_" + tableName.getNameAsString());
                job = Job.getInstance((Configuration)conf, (String)jobName);
                job.setJarByClass(mapperClass);
                FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inputDir});
                job.setInputFormatClass(TextInputFormat.class);
                job.setMapperClass(mapperClass);
                job.setMapOutputKeyClass(ImmutableBytesWritable.class);
                hfileOutPath = conf.get("importtsv.bulk.output");
                columns = conf.getStrings("importtsv.columns");
                if (StringUtils.isNotEmpty((String)conf.get("credentials_location"))) {
                    fileLoc = conf.get("credentials_location");
                    cred = Credentials.readTokenStorageFile((File)new File(fileLoc), (Configuration)conf);
                    job.getCredentials().addAll(cred);
                }
                if (hfileOutPath != null) {
                    if (!admin.tableExists(tableName)) {
                        ImportTsv.LOG.warn((Object)String.format("Table '%s' does not exist.", new Object[]{tableName}));
                        if ("yes".equalsIgnoreCase(conf.get("create.table", "yes"))) {
                            ImportTsv.createTable(admin, tableName, columns);
                            if (isDryRun) {
                                ImportTsv.LOG.warn((Object)"Dry run: Table will be deleted at end of dry run.");
                                ImportTsv.dryRunTableCreated = true;
                            }
                        } else {
                            errorMsg = String.format("Table '%s' does not exist and '%s' is set to no.", new Object[]{tableName, "create.table"});
                            ImportTsv.LOG.error((Object)errorMsg);
                            throw new TableNotFoundException(errorMsg);
                        }
                    }
                    table = (HTable)connection.getTable(tableName);
                    var17_21 = null;
                    try {
                        noStrict = conf.getBoolean("no.strict", false);
                        if (!noStrict) {
                            unmatchedFamilies = new ArrayList<String>();
                            cfSet = ImportTsv.getColumnFamilies(columns);
                            tDesc = table.getTableDescriptor();
                            for (String cf : cfSet) {
                                if (tDesc.getFamily(Bytes.toBytes((String)cf)) != null) continue;
                                unmatchedFamilies.add(cf);
                            }
                            if (unmatchedFamilies.size() > 0) {
                                familyNames = new ArrayList<String>();
                                for (HColumnDescriptor family : table.getTableDescriptor().getFamilies()) {
                                    familyNames.add(family.getNameAsString());
                                }
                                msg = "Column Families " + unmatchedFamilies + " specified in " + "importtsv.columns" + " does not match with any of the table " + tableName + " column families " + familyNames + ".\n" + "To disable column family check, use -D" + "no.strict" + "=true.\n";
                                ImportTsv.usage(msg);
                                System.exit(-1);
                            }
                        }
                        if (mapperClass.equals(TsvImporterTextMapper.class)) {
                            job.setMapOutputValueClass(Text.class);
                            job.setReducerClass(TextSortReducer.class);
                        } else {
                            job.setMapOutputValueClass(Put.class);
                            job.setCombinerClass(PutCombiner.class);
                            job.setReducerClass(PutSortReducer.class);
                        }
                        if (isDryRun) ** GOTO lbl98
                        outputDir = new Path(hfileOutPath);
                        FileOutputFormat.setOutputPath((Job)job, (Path)outputDir);
                        HFileOutputFormat2.configureIncrementalLoad(job, (Table)table, (RegionLocator)table);
                    }
                    catch (Throwable var18_24) {
                        var17_21 = var18_24;
                        throw var18_24;
                    }
                    finally {
                        if (table != null) {
                            if (var17_21 != null) {
                                try {
                                    table.close();
                                }
                                catch (Throwable x2) {
                                    var17_21.addSuppressed(x2);
                                }
                            } else {
                                table.close();
                            }
                        }
                    }
                } else {
                    if (!admin.tableExists(tableName)) {
                        errorMsg = String.format("Table '%s' does not exist.", new Object[]{tableName});
                        ImportTsv.LOG.error((Object)errorMsg);
                        throw new TableNotFoundException(errorMsg);
                    }
                    if (mapperClass.equals(TsvImporterTextMapper.class)) {
                        ImportTsv.usage(TsvImporterTextMapper.class.toString() + " should not be used for non bulkloading case. use " + TsvImporterMapper.class.toString() + " or custom mapper whose value type is Put.");
                        System.exit(-1);
                    }
                    if (!isDryRun) {
                        TableMapReduceUtil.initTableReducerJob(tableName.getNameAsString(), null, job);
                    }
                    job.setNumReduceTasks(0);
                }
lbl98:
                // 3 sources

                if (isDryRun) {
                    job.setOutputFormatClass(NullOutputFormat.class);
                    job.getConfiguration().setStrings("io.serializations", new String[]{job.getConfiguration().get("io.serializations"), MutationSerialization.class.getName(), ResultSerialization.class.getName(), KeyValueSerialization.class.getName()});
                }
                TableMapReduceUtil.addDependencyJars(job);
                TableMapReduceUtil.addDependencyJars(job.getConfiguration(), new Class[]{Function.class});
            }
            catch (Throwable var8_12) {
                var7_9 = var8_12;
                throw var8_12;
            }
            finally {
                if (admin != null) {
                    if (var7_9 != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable x2) {
                            var7_9.addSuppressed(x2);
                        }
                    } else {
                        admin.close();
                    }
                }
            }
        }
        catch (Throwable var6_8) {
            var5_5 = var6_8;
            throw var6_8;
        }
        finally {
            if (connection != null) {
                if (var5_5 != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable x2) {
                        var5_5.addSuppressed(x2);
                    }
                } else {
                    connection.close();
                }
            }
        }
        return job;
    }

    private static void createTable(Admin admin, TableName tableName, String[] columns) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(tableName);
        Set<String> cfSet = ImportTsv.getColumnFamilies(columns);
        for (String cf : cfSet) {
            HColumnDescriptor hcd = new HColumnDescriptor(Bytes.toBytes((String)cf));
            htd.addFamily(hcd);
        }
        LOG.warn((Object)String.format("Creating table '%s' with '%s' columns and default descriptors.", tableName, cfSet));
        admin.createTable(htd);
    }

    private static void deleteTable(Configuration conf, String[] args) {
        TableName tableName = TableName.valueOf((String)args[0]);
        try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
             Admin admin = connection.getAdmin();){
            try {
                admin.disableTable(tableName);
            }
            catch (TableNotEnabledException e) {
                LOG.debug((Object)("Dry mode: Table: " + tableName + " already disabled, so just deleting it."));
            }
            admin.deleteTable(tableName);
        }
        catch (IOException e) {
            LOG.error((Object)String.format("***Dry run: Failed to delete table '%s'.***\n%s", tableName, e.toString()));
            return;
        }
        LOG.info((Object)String.format("Dry run: Deleted table '%s'.", tableName));
    }

    private static Set<String> getColumnFamilies(String[] columns) {
        HashSet<String> cfSet = new HashSet<String>();
        for (String aColumn : columns) {
            if ("HBASE_ROW_KEY".equals(aColumn) || "HBASE_TS_KEY".equals(aColumn) || "HBASE_CELL_VISIBILITY".equals(aColumn) || "HBASE_CELL_TTL".equals(aColumn) || "HBASE_ATTRIBUTES_KEY".equals(aColumn)) continue;
            cfSet.add(aColumn.split(":", 2)[0]);
        }
        return cfSet;
    }

    private static void usage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        String usage = "Usage: importtsv -Dimporttsv.columns=a,b,c <tablename> <inputdir>\n\nImports the given input directory of TSV data into the specified table.\n\nThe column names of the TSV data must be specified using the -Dimporttsv.columns\noption. This option takes the form of comma-separated column names, where each\ncolumn name is either a simple column family, or a columnfamily:qualifier. The special\ncolumn name HBASE_ROW_KEY is used to designate that this column should be used\nas the row key for each imported record. You must specify exactly one column\nto be the row key, and you must specify a column name for every column that exists in the\ninput data. Another special columnHBASE_TS_KEY designates that this column should be\nused as timestamp for each record. Unlike HBASE_ROW_KEY, HBASE_TS_KEY is optional.\nYou must specify at most one column as timestamp key for each imported record.\nRecord with invalid timestamps (blank, non-numeric) will be treated as bad record.\nNote: if you use this option, then 'importtsv.timestamp' option will be ignored.\n\nHBASE_ATTRIBUTES_KEY can be used to specify Operation Attributes per record.\n Should be specified as key=>value where -1 is used \n as the seperator.  Note that more than one OperationAttributes can be specified.\nBy default importtsv will load data directly into HBase. To instead generate\nHFiles of data to prepare for a bulk data load, pass the option:\n  -Dimporttsv.bulk.output=/path/for/output\n  Note: if you do not use this option, then the target table must already exist in HBase\n\nOther options that may be specified with -D include:\n  -Dimporttsv.dry.run=true - Dry run mode. Data is not actually populated into table. If table does not exist, it is created but deleted in the end.\n  -Dimporttsv.skip.bad.lines=false - fail if encountering an invalid line\n  -Dimporttsv.log.bad.lines=true - logs invalid lines to stderr\n  '-Dimporttsv.separator=|' - eg separate on pipes instead of tabs\n  -Dimporttsv.timestamp=currentTimeAsLong - use the specified timestamp for the import\n  -Dimporttsv.mapper.class=my.Mapper - A user-defined Mapper to use instead of " + DEFAULT_MAPPER.getName() + "\n" + "  -D" + JOB_NAME_CONF_KEY + "=jobName - use the specified mapreduce job name for the import\n" + "  -D" + CREATE_TABLE_CONF_KEY + "=no - can be used to avoid creation of table by this tool\n" + "  Note: if you set this to 'no', then the target table must already exist in HBase\n" + "  -D" + NO_STRICT_COL_FAMILY + "=true - ignore column family check in hbase table. " + "Default is false\n\n" + "For performance consider the following options:\n" + "  -Dmapreduce.map.speculative=false\n" + "  -Dmapreduce.reduce.speculative=false";
        System.err.println(usage);
    }

    public int run(String[] args) throws Exception {
        this.setConf(HBaseConfiguration.create((Configuration)this.getConf()));
        String[] otherArgs = new GenericOptionsParser(this.getConf(), args).getRemainingArgs();
        if (otherArgs.length < 2) {
            ImportTsv.usage("Wrong number of arguments: " + otherArgs.length);
            return -1;
        }
        if (null == this.getConf().get(MAPPER_CONF_KEY)) {
            String[] columns = this.getConf().getStrings(COLUMNS_CONF_KEY);
            if (columns == null) {
                ImportTsv.usage("No columns specified. Please specify with -Dimporttsv.columns=...");
                return -1;
            }
            int rowkeysFound = 0;
            for (String col : columns) {
                if (!col.equals("HBASE_ROW_KEY")) continue;
                ++rowkeysFound;
            }
            if (rowkeysFound != 1) {
                ImportTsv.usage("Must specify exactly one column as HBASE_ROW_KEY");
                return -1;
            }
            int tskeysFound = 0;
            for (String col : columns) {
                if (!col.equals("HBASE_TS_KEY")) continue;
                ++tskeysFound;
            }
            if (tskeysFound > 1) {
                ImportTsv.usage("Must specify at most one column as HBASE_TS_KEY");
                return -1;
            }
            int attrKeysFound = 0;
            for (String col : columns) {
                if (!col.equals("HBASE_ATTRIBUTES_KEY")) continue;
                ++attrKeysFound;
            }
            if (attrKeysFound > 1) {
                ImportTsv.usage("Must specify at most one column as HBASE_ATTRIBUTES_KEY");
                return -1;
            }
            if (columns.length - (rowkeysFound + tskeysFound + attrKeysFound) < 1) {
                ImportTsv.usage("One or more columns in addition to the row key and timestamp(optional) are required");
                return -1;
            }
        }
        long timstamp = this.getConf().getLong(TIMESTAMP_CONF_KEY, System.currentTimeMillis());
        this.getConf().setLong(TIMESTAMP_CONF_KEY, timstamp);
        dryRunTableCreated = false;
        Job job = ImportTsv.createSubmittableJob(this.getConf(), otherArgs);
        boolean success = job.waitForCompletion(true);
        if (dryRunTableCreated) {
            ImportTsv.deleteTable(this.getConf(), args);
        }
        return success ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int status = ToolRunner.run((Tool)new ImportTsv(), (String[])args);
        System.exit(status);
    }

    public static class TsvParser {
        private final byte[][] families;
        private final byte[][] qualifiers;
        private final byte separatorByte;
        private int rowKeyColumnIndex;
        private int maxColumnCount;
        public static final int DEFAULT_TIMESTAMP_COLUMN_INDEX = -1;
        private int timestampKeyColumnIndex = -1;
        public static final String ROWKEY_COLUMN_SPEC = "HBASE_ROW_KEY";
        public static final String TIMESTAMPKEY_COLUMN_SPEC = "HBASE_TS_KEY";
        public static final String ATTRIBUTES_COLUMN_SPEC = "HBASE_ATTRIBUTES_KEY";
        public static final String CELL_VISIBILITY_COLUMN_SPEC = "HBASE_CELL_VISIBILITY";
        public static final String CELL_TTL_COLUMN_SPEC = "HBASE_CELL_TTL";
        private int attrKeyColumnIndex = -1;
        public static final int DEFAULT_ATTRIBUTES_COLUMN_INDEX = -1;
        public static final int DEFAULT_CELL_VISIBILITY_COLUMN_INDEX = -1;
        public static final int DEFAULT_CELL_TTL_COLUMN_INDEX = -1;
        private int cellVisibilityColumnIndex = -1;
        private int cellTTLColumnIndex = -1;

        public TsvParser(String columnsSpecification, String separatorStr) {
            byte[] separator = Bytes.toBytes((String)separatorStr);
            Preconditions.checkArgument((separator.length == 1 ? 1 : 0) != 0, (Object)"TsvParser only supports single-byte separators");
            this.separatorByte = separator[0];
            ArrayList columnStrings = Lists.newArrayList((Iterable)Splitter.on((char)',').trimResults().split((CharSequence)columnsSpecification));
            this.maxColumnCount = columnStrings.size();
            this.families = new byte[this.maxColumnCount][];
            this.qualifiers = new byte[this.maxColumnCount][];
            for (int i = 0; i < columnStrings.size(); ++i) {
                String str = (String)columnStrings.get(i);
                if (ROWKEY_COLUMN_SPEC.equals(str)) {
                    this.rowKeyColumnIndex = i;
                    continue;
                }
                if (TIMESTAMPKEY_COLUMN_SPEC.equals(str)) {
                    this.timestampKeyColumnIndex = i;
                    continue;
                }
                if (ATTRIBUTES_COLUMN_SPEC.equals(str)) {
                    this.attrKeyColumnIndex = i;
                    continue;
                }
                if (CELL_VISIBILITY_COLUMN_SPEC.equals(str)) {
                    this.cellVisibilityColumnIndex = i;
                    continue;
                }
                if (CELL_TTL_COLUMN_SPEC.equals(str)) {
                    this.cellTTLColumnIndex = i;
                    continue;
                }
                String[] parts = str.split(":", 2);
                if (parts.length == 1) {
                    this.families[i] = str.getBytes();
                    this.qualifiers[i] = HConstants.EMPTY_BYTE_ARRAY;
                    continue;
                }
                this.families[i] = parts[0].getBytes();
                this.qualifiers[i] = parts[1].getBytes();
            }
        }

        public boolean hasTimestamp() {
            return this.timestampKeyColumnIndex != -1;
        }

        public int getTimestampKeyColumnIndex() {
            return this.timestampKeyColumnIndex;
        }

        public boolean hasAttributes() {
            return this.attrKeyColumnIndex != -1;
        }

        public boolean hasCellVisibility() {
            return this.cellVisibilityColumnIndex != -1;
        }

        public boolean hasCellTTL() {
            return this.cellTTLColumnIndex != -1;
        }

        public int getAttributesKeyColumnIndex() {
            return this.attrKeyColumnIndex;
        }

        public int getCellVisibilityColumnIndex() {
            return this.cellVisibilityColumnIndex;
        }

        public int getCellTTLColumnIndex() {
            return this.cellTTLColumnIndex;
        }

        public int getRowKeyColumnIndex() {
            return this.rowKeyColumnIndex;
        }

        public byte[] getFamily(int idx) {
            return this.families[idx];
        }

        public byte[] getQualifier(int idx) {
            return this.qualifiers[idx];
        }

        public ParsedLine parse(byte[] lineBytes, int length) throws BadTsvLineException {
            ArrayList<Integer> tabOffsets = new ArrayList<Integer>(this.maxColumnCount);
            for (int i = 0; i < length; ++i) {
                if (lineBytes[i] != this.separatorByte) continue;
                tabOffsets.add(i);
            }
            if (tabOffsets.isEmpty()) {
                throw new BadTsvLineException("No delimiter");
            }
            tabOffsets.add(length);
            if (tabOffsets.size() > this.maxColumnCount) {
                throw new BadTsvLineException("Excessive columns");
            }
            if (tabOffsets.size() <= this.getRowKeyColumnIndex()) {
                throw new BadTsvLineException("No row key");
            }
            if (this.hasTimestamp() && tabOffsets.size() <= this.getTimestampKeyColumnIndex()) {
                throw new BadTsvLineException("No timestamp");
            }
            if (this.hasAttributes() && tabOffsets.size() <= this.getAttributesKeyColumnIndex()) {
                throw new BadTsvLineException("No attributes specified");
            }
            if (this.hasCellVisibility() && tabOffsets.size() <= this.getCellVisibilityColumnIndex()) {
                throw new BadTsvLineException("No cell visibility specified");
            }
            if (this.hasCellTTL() && tabOffsets.size() <= this.getCellTTLColumnIndex()) {
                throw new BadTsvLineException("No cell TTL specified");
            }
            return new ParsedLine(tabOffsets, lineBytes);
        }

        public Pair<Integer, Integer> parseRowKey(byte[] lineBytes, int length) throws BadTsvLineException {
            int rkColumnIndex = 0;
            int startPos = 0;
            int endPos = 0;
            for (int i = 0; i <= length; ++i) {
                if (i == length || lineBytes[i] == this.separatorByte) {
                    endPos = i - 1;
                    if (rkColumnIndex++ == this.getRowKeyColumnIndex()) {
                        if (endPos + 1 != startPos) break;
                        throw new BadTsvLineException("Empty value for ROW KEY.");
                    }
                    startPos = endPos + 2;
                }
                if (i != length) continue;
                throw new BadTsvLineException("Row key does not exist as number of columns in the line are less than row key position.");
            }
            return new Pair((Object)startPos, (Object)(endPos - startPos + 1));
        }

        public static class BadTsvLineException
        extends Exception {
            private static final long serialVersionUID = 1L;

            public BadTsvLineException(String err) {
                super(err);
            }
        }

        class ParsedLine {
            private final ArrayList<Integer> tabOffsets;
            private byte[] lineBytes;

            ParsedLine(ArrayList<Integer> tabOffsets, byte[] lineBytes) {
                this.tabOffsets = tabOffsets;
                this.lineBytes = lineBytes;
            }

            public int getRowKeyOffset() {
                return this.getColumnOffset(TsvParser.this.rowKeyColumnIndex);
            }

            public int getRowKeyLength() {
                return this.getColumnLength(TsvParser.this.rowKeyColumnIndex);
            }

            public long getTimestamp(long ts) throws BadTsvLineException {
                if (!TsvParser.this.hasTimestamp()) {
                    return ts;
                }
                String timeStampStr = Bytes.toString((byte[])this.lineBytes, (int)this.getColumnOffset(TsvParser.this.timestampKeyColumnIndex), (int)this.getColumnLength(TsvParser.this.timestampKeyColumnIndex));
                try {
                    return Long.parseLong(timeStampStr);
                }
                catch (NumberFormatException nfe) {
                    throw new BadTsvLineException("Invalid timestamp " + timeStampStr);
                }
            }

            private String getAttributes() {
                if (!TsvParser.this.hasAttributes()) {
                    return null;
                }
                return Bytes.toString((byte[])this.lineBytes, (int)this.getColumnOffset(TsvParser.this.attrKeyColumnIndex), (int)this.getColumnLength(TsvParser.this.attrKeyColumnIndex));
            }

            public String[] getIndividualAttributes() {
                String attributes = this.getAttributes();
                if (attributes != null) {
                    return attributes.split(ImportTsv.DEFAULT_MULTIPLE_ATTRIBUTES_SEPERATOR);
                }
                return null;
            }

            public int getAttributeKeyOffset() {
                if (TsvParser.this.hasAttributes()) {
                    return this.getColumnOffset(TsvParser.this.attrKeyColumnIndex);
                }
                return -1;
            }

            public int getAttributeKeyLength() {
                if (TsvParser.this.hasAttributes()) {
                    return this.getColumnLength(TsvParser.this.attrKeyColumnIndex);
                }
                return -1;
            }

            public int getCellVisibilityColumnOffset() {
                if (TsvParser.this.hasCellVisibility()) {
                    return this.getColumnOffset(TsvParser.this.cellVisibilityColumnIndex);
                }
                return -1;
            }

            public int getCellVisibilityColumnLength() {
                if (TsvParser.this.hasCellVisibility()) {
                    return this.getColumnLength(TsvParser.this.cellVisibilityColumnIndex);
                }
                return -1;
            }

            public String getCellVisibility() {
                if (!TsvParser.this.hasCellVisibility()) {
                    return null;
                }
                return Bytes.toString((byte[])this.lineBytes, (int)this.getColumnOffset(TsvParser.this.cellVisibilityColumnIndex), (int)this.getColumnLength(TsvParser.this.cellVisibilityColumnIndex));
            }

            public int getCellTTLColumnOffset() {
                if (TsvParser.this.hasCellTTL()) {
                    return this.getColumnOffset(TsvParser.this.cellTTLColumnIndex);
                }
                return -1;
            }

            public int getCellTTLColumnLength() {
                if (TsvParser.this.hasCellTTL()) {
                    return this.getColumnLength(TsvParser.this.cellTTLColumnIndex);
                }
                return -1;
            }

            public long getCellTTL() {
                if (!TsvParser.this.hasCellTTL()) {
                    return 0L;
                }
                return Bytes.toLong((byte[])this.lineBytes, (int)this.getColumnOffset(TsvParser.this.cellTTLColumnIndex), (int)this.getColumnLength(TsvParser.this.cellTTLColumnIndex));
            }

            public int getColumnOffset(int idx) {
                if (idx > 0) {
                    return this.tabOffsets.get(idx - 1) + 1;
                }
                return 0;
            }

            public int getColumnLength(int idx) {
                return this.tabOffsets.get(idx) - this.getColumnOffset(idx);
            }

            public int getColumnCount() {
                return this.tabOffsets.size();
            }

            public byte[] getLineBytes() {
                return this.lineBytes;
            }
        }
    }
}

