/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.quotas.QuotaState;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.UserQuotaState;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class QuotaUtil
extends QuotaTableUtil {
    private static final Log LOG = LogFactory.getLog(QuotaUtil.class);
    public static final String QUOTA_CONF_KEY = "hbase.quota.enabled";
    private static final boolean QUOTA_ENABLED_DEFAULT = false;
    public static final HTableDescriptor QUOTA_TABLE_DESC = new HTableDescriptor(QUOTA_TABLE_NAME);

    public static boolean isQuotaEnabled(Configuration conf) {
        return conf.getBoolean(QUOTA_CONF_KEY, false);
    }

    public static void addTableQuota(Configuration conf, TableName table, QuotaProtos.Quotas data) throws IOException {
        QuotaUtil.addQuotas(conf, QuotaUtil.getTableRowKey((TableName)table), data);
    }

    public static void deleteTableQuota(Configuration conf, TableName table) throws IOException {
        QuotaUtil.deleteQuotas(conf, QuotaUtil.getTableRowKey((TableName)table));
    }

    public static void addNamespaceQuota(Configuration conf, String namespace, QuotaProtos.Quotas data) throws IOException {
        QuotaUtil.addQuotas(conf, QuotaUtil.getNamespaceRowKey((String)namespace), data);
    }

    public static void deleteNamespaceQuota(Configuration conf, String namespace) throws IOException {
        QuotaUtil.deleteQuotas(conf, QuotaUtil.getNamespaceRowKey((String)namespace));
    }

    public static void addUserQuota(Configuration conf, String user, QuotaProtos.Quotas data) throws IOException {
        QuotaUtil.addQuotas(conf, QuotaUtil.getUserRowKey((String)user), data);
    }

    public static void addUserQuota(Configuration conf, String user, TableName table, QuotaProtos.Quotas data) throws IOException {
        QuotaUtil.addQuotas(conf, QuotaUtil.getUserRowKey((String)user), QuotaUtil.getSettingsQualifierForUserTable((TableName)table), data);
    }

    public static void addUserQuota(Configuration conf, String user, String namespace, QuotaProtos.Quotas data) throws IOException {
        QuotaUtil.addQuotas(conf, QuotaUtil.getUserRowKey((String)user), QuotaUtil.getSettingsQualifierForUserNamespace((String)namespace), data);
    }

    public static void deleteUserQuota(Configuration conf, String user) throws IOException {
        QuotaUtil.deleteQuotas(conf, QuotaUtil.getUserRowKey((String)user));
    }

    public static void deleteUserQuota(Configuration conf, String user, TableName table) throws IOException {
        QuotaUtil.deleteQuotas(conf, QuotaUtil.getUserRowKey((String)user), QuotaUtil.getSettingsQualifierForUserTable((TableName)table));
    }

    public static void deleteUserQuota(Configuration conf, String user, String namespace) throws IOException {
        QuotaUtil.deleteQuotas(conf, QuotaUtil.getUserRowKey((String)user), QuotaUtil.getSettingsQualifierForUserNamespace((String)namespace));
    }

    private static void addQuotas(Configuration conf, byte[] rowKey, QuotaProtos.Quotas data) throws IOException {
        QuotaUtil.addQuotas(conf, rowKey, QUOTA_QUALIFIER_SETTINGS, data);
    }

    private static void addQuotas(Configuration conf, byte[] rowKey, byte[] qualifier, QuotaProtos.Quotas data) throws IOException {
        Put put = new Put(rowKey);
        put.add(QUOTA_FAMILY_INFO, qualifier, QuotaUtil.quotasToData((QuotaProtos.Quotas)data));
        QuotaUtil.doPut(conf, put);
    }

    private static void deleteQuotas(Configuration conf, byte[] rowKey) throws IOException {
        QuotaUtil.deleteQuotas(conf, rowKey, null);
    }

    private static void deleteQuotas(Configuration conf, byte[] rowKey, byte[] qualifier) throws IOException {
        Delete delete = new Delete(rowKey);
        if (qualifier != null) {
            delete.deleteColumns(QUOTA_FAMILY_INFO, qualifier);
        }
        QuotaUtil.doDelete(conf, delete);
    }

    public static Map<String, UserQuotaState> fetchUserQuotas(Configuration conf, List<Get> gets) throws IOException {
        long nowTs = EnvironmentEdgeManager.currentTime();
        Result[] results = QuotaUtil.doGet((Configuration)conf, gets);
        HashMap<String, UserQuotaState> userQuotas = new HashMap<String, UserQuotaState>(results.length);
        for (int i = 0; i < results.length; ++i) {
            byte[] key = gets.get(i).getRow();
            assert (QuotaUtil.isUserRowKey((byte[])key));
            String user = QuotaUtil.getUserFromRowKey((byte[])key);
            final UserQuotaState quotaInfo = new UserQuotaState(nowTs);
            userQuotas.put(user, quotaInfo);
            if (results[i].isEmpty()) continue;
            assert (Bytes.equals((byte[])key, (byte[])results[i].getRow()));
            try {
                QuotaUtil.parseUserResult((String)user, (Result)results[i], (QuotaTableUtil.UserQuotasVisitor)new QuotaTableUtil.UserQuotasVisitor(){

                    public void visitUserQuotas(String userName, String namespace, QuotaProtos.Quotas quotas) {
                        quotaInfo.setQuotas(namespace, quotas);
                    }

                    public void visitUserQuotas(String userName, TableName table, QuotaProtos.Quotas quotas) {
                        quotaInfo.setQuotas(table, quotas);
                    }

                    public void visitUserQuotas(String userName, QuotaProtos.Quotas quotas) {
                        quotaInfo.setQuotas(quotas);
                    }
                });
                continue;
            }
            catch (IOException e) {
                LOG.error((Object)("Unable to parse user '" + user + "' quotas"), (Throwable)e);
                userQuotas.remove(user);
            }
        }
        return userQuotas;
    }

    public static Map<TableName, QuotaState> fetchTableQuotas(Configuration conf, List<Get> gets) throws IOException {
        return QuotaUtil.fetchGlobalQuotas("table", conf, gets, new KeyFromRow<TableName>(){

            @Override
            public TableName getKeyFromRow(byte[] row) {
                assert (QuotaTableUtil.isTableRowKey((byte[])row));
                return QuotaTableUtil.getTableFromRowKey((byte[])row);
            }
        });
    }

    public static Map<String, QuotaState> fetchNamespaceQuotas(Configuration conf, List<Get> gets) throws IOException {
        return QuotaUtil.fetchGlobalQuotas("namespace", conf, gets, new KeyFromRow<String>(){

            @Override
            public String getKeyFromRow(byte[] row) {
                assert (QuotaTableUtil.isNamespaceRowKey((byte[])row));
                return QuotaTableUtil.getNamespaceFromRowKey((byte[])row);
            }
        });
    }

    public static <K> Map<K, QuotaState> fetchGlobalQuotas(String type, Configuration conf, List<Get> gets, KeyFromRow<K> kfr) throws IOException {
        long nowTs = EnvironmentEdgeManager.currentTime();
        Result[] results = QuotaUtil.doGet((Configuration)conf, gets);
        HashMap<K, QuotaState> globalQuotas = new HashMap<K, QuotaState>(results.length);
        for (int i = 0; i < results.length; ++i) {
            byte[] row = gets.get(i).getRow();
            K key = kfr.getKeyFromRow(row);
            QuotaState quotaInfo = new QuotaState(nowTs);
            globalQuotas.put(key, quotaInfo);
            if (results[i].isEmpty()) continue;
            assert (Bytes.equals((byte[])row, (byte[])results[i].getRow()));
            byte[] data = results[i].getValue(QUOTA_FAMILY_INFO, QUOTA_QUALIFIER_SETTINGS);
            if (data == null) continue;
            try {
                QuotaProtos.Quotas quotas = QuotaUtil.quotasFromData((byte[])data);
                quotaInfo.setQuotas(quotas);
                continue;
            }
            catch (IOException e) {
                LOG.error((Object)("Unable to parse " + type + " '" + key + "' quotas"), (Throwable)e);
                globalQuotas.remove(key);
            }
        }
        return globalQuotas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doPut(Configuration conf, Put put) throws IOException {
        try (HTable table = new HTable(conf, QUOTA_TABLE_NAME);){
            table.put(put);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doDelete(Configuration conf, Delete delete) throws IOException {
        try (HTable table = new HTable(conf, QUOTA_TABLE_NAME);){
            table.delete(delete);
        }
    }

    public static long calculateMutationSize(Mutation mutation) {
        long size = 0L;
        for (Map.Entry entry : mutation.getFamilyCellMap().entrySet()) {
            for (Cell cell : (List)entry.getValue()) {
                size += (long)KeyValueUtil.length((Cell)cell);
            }
        }
        return size;
    }

    public static long calculateResultSize(Result result) {
        long size = 0L;
        for (Cell cell : result.rawCells()) {
            size += (long)KeyValueUtil.length((Cell)cell);
        }
        return size;
    }

    public static long calculateResultSize(List<Result> results) {
        long size = 0L;
        for (Result result : results) {
            for (Cell cell : result.rawCells()) {
                size += (long)KeyValueUtil.length((Cell)cell);
            }
        }
        return size;
    }

    static {
        QUOTA_TABLE_DESC.addFamily(new HColumnDescriptor(QUOTA_FAMILY_INFO).setScope(0).setBloomFilterType(BloomType.ROW).setMaxVersions(1));
        QUOTA_TABLE_DESC.addFamily(new HColumnDescriptor(QUOTA_FAMILY_USAGE).setScope(0).setBloomFilterType(BloomType.ROW).setMaxVersions(1));
    }

    private static interface KeyFromRow<T> {
        public T getKeyFromRow(byte[] var1);
    }
}

