/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.jsoninput;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.json.simple.JSONArray;
import org.json.simple.JSONValue;
import org.jsonpath.JsonJar;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.jsoninput.JsonInputMeta;
import org.pentaho.di.trans.steps.jsoninput.NJSONArray;

@Deprecated
public class JsonReader {
    private static Class<?> PKG = JsonInputMeta.class;
    private static final String JAVA_SCRIPT = "JavaScript";
    private static final String JSON_SCRIPT = "json.js";
    private static final String JSON_PATH_SCRIPT = "jsonpath.js";
    private static final String EVAL_FALSE = "false";
    private static final String EVAL = "var obj=";
    private static final String JSON_PATH = "jsonPath";
    private ScriptEngine jsEngine;
    private boolean ignoreMissingPath;

    public JsonReader() throws KettleException {
        this.init();
        this.ignoreMissingPath = false;
    }

    @Deprecated
    public void SetIgnoreMissingPath(boolean value) {
        this.setIgnoreMissingPath(value);
    }

    public void setIgnoreMissingPath(boolean value) {
        this.ignoreMissingPath = value;
    }

    private void init() throws KettleException {
        try {
            ScriptEngineManager sm = new ScriptEngineManager();
            this.setEngine(sm.getEngineByName(JAVA_SCRIPT));
            if (this.getEngine() == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"JsonReader.Error.NoScriptEngineFound", (String[])new String[0]));
            }
            this.loadJsonScript(JSON_SCRIPT);
            this.loadJsonScript(JSON_PATH_SCRIPT);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JsonReader.Error.EngineInit", (String[])new String[]{e.getMessage()}), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadJsonScript(String script) throws Exception {
        InputStream is = null;
        InputStreamReader isr = null;
        try {
            is = JsonJar.class.getResource(script).openStream();
            isr = new InputStreamReader(is);
            this.getEngine().eval(new BufferedReader(isr));
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (isr != null) {
                    isr.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private ScriptEngine getEngine() {
        return this.jsEngine;
    }

    private void setEngine(ScriptEngine script) {
        this.jsEngine = script;
    }

    private Invocable getInvocable() {
        return (Invocable)((Object)this.getEngine());
    }

    public void readFile(String filename) throws KettleException {
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(KettleVFS.getInputStream((String)filename));
            Object o = JSONValue.parseWithException((Reader)isr);
            if (o == null) {
                throw new Exception(BaseMessages.getString(PKG, (String)"JsonReader.Error.ReadFile.Null", (String[])new String[0]));
            }
            this.eval(o);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JsonReader.Error.ParsingFile", (Object[])new Object[]{e}));
        }
        finally {
            try {
                if (isr != null) {
                    isr.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void readString(String value) throws KettleException {
        try {
            Object o = JSONValue.parseWithException((String)value);
            if (o == null) {
                throw new Exception(BaseMessages.getString(PKG, (String)"JsonReader.Error.ReadString.Null", (String[])new String[0]));
            }
            this.eval(o);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JsonReader.Error.ParsingString", (Object[])new Object[]{e}));
        }
    }

    public void readUrl(String value) throws KettleException {
        InputStreamReader is = null;
        try {
            URL url = new URL(value);
            is = new InputStreamReader(url.openConnection().getInputStream());
            Object o = JSONValue.parse((Reader)is);
            if (o == null) {
                throw new Exception(BaseMessages.getString(PKG, (String)"JsonReader.Error.ReadUrl.Null", (String[])new String[0]));
            }
            this.eval(o);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JsonReader.Error.ParsingUrl", (Object[])new Object[]{e}));
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void readInput(InputStream in) throws KettleException {
        try (InputStreamReader is = new InputStreamReader(in);){
            Object o = JSONValue.parse((Reader)is);
            if (o == null) {
                throw new Exception(BaseMessages.getString(PKG, (String)"JsonReader.Error.ReadUrl.Null", (String[])new String[0]));
            }
            this.eval(o);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JsonReader.Error.ParsingUrl", (Object[])new Object[]{e}));
        }
    }

    private void eval(Object o) throws Exception {
        this.getEngine().eval(EVAL + o.toString());
    }

    public List<?> executePath(String value) throws KettleException {
        try {
            String ro = this.getInvocable().invokeFunction(JSON_PATH, value).toString();
            if (!ro.equals(EVAL_FALSE)) {
                JSONArray ra = (JSONArray)JSONValue.parse((String)ro);
                return ra;
            }
            if (!this.isIgnoreMissingPath()) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"JsonReader.Error.CanNotFindPath", (String[])new String[]{value}));
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    @Deprecated
    public NJSONArray getPath(String value) throws KettleException {
        return new NJSONArray((JSONArray)this.executePath(value));
    }

    public boolean isIgnoreMissingPath() {
        return this.ignoreMissingPath;
    }
}

