/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.jsonoutput;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.jsonoutput.JsonOutput;
import org.pentaho.di.trans.steps.jsonoutput.JsonOutputData;
import org.pentaho.di.trans.steps.jsonoutput.JsonOutputField;
import org.pentaho.di.trans.steps.jsonoutput.JsonOutputMetaInjection;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="JsonOutput", image="JSO.svg", i18nPackageName="org.pentaho.di.trans.steps.jsonoutput", name="JsonOutput.name", description="JsonOutput.description", categoryDescription="JsonOutput.category")
public class JsonOutputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = JsonOutputMeta.class;
    private int operationType;
    public static final String[] operationTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"JsonOutputMeta.operationType.OutputValue", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JsonOutputMeta.operationType.WriteToFile", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JsonOutputMeta.operationType.Both", (String[])new String[0])};
    public static final String[] operationTypeCode = new String[]{"outputvalue", "writetofile", "both"};
    public static final int OPERATION_TYPE_OUTPUT_VALUE = 0;
    public static final int OPERATION_TYPE_WRITE_TO_FILE = 1;
    public static final int OPERATION_TYPE_BOTH = 2;
    private String encoding;
    private String outputValue;
    private String jsonBloc;
    private String nrRowsInBloc;
    private JsonOutputField[] outputFields;
    private boolean AddToResult;
    private boolean servletOutput;
    private String fileName;
    private String extension;
    private boolean fileAppended;
    private boolean compatibilityMode;
    private boolean stepNrInFilename;
    private boolean partNrInFilename;
    private boolean dateInFilename;
    private boolean timeInFilename;
    private boolean createparentfolder;
    private boolean DoNotOpenNewFileInit;

    public boolean isDoNotOpenNewFileInit() {
        return this.DoNotOpenNewFileInit;
    }

    public void setDoNotOpenNewFileInit(boolean DoNotOpenNewFileInit) {
        this.DoNotOpenNewFileInit = DoNotOpenNewFileInit;
    }

    public boolean isCreateParentFolder() {
        return this.createparentfolder;
    }

    public void setCreateParentFolder(boolean createparentfolder) {
        this.createparentfolder = createparentfolder;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public boolean isFileAppended() {
        return this.fileAppended;
    }

    public void setFileAppended(boolean fileAppended) {
        this.fileAppended = fileAppended;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isTimeInFilename() {
        return this.timeInFilename;
    }

    public boolean isDateInFilename() {
        return this.dateInFilename;
    }

    public void setDateInFilename(boolean dateInFilename) {
        this.dateInFilename = dateInFilename;
    }

    public void setTimeInFilename(boolean timeInFilename) {
        this.timeInFilename = timeInFilename;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean AddToResult() {
        return this.AddToResult;
    }

    public int getOperationType() {
        return this.operationType;
    }

    public static int getOperationTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < operationTypeDesc.length; ++i) {
            if (!operationTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return JsonOutputMeta.getOperationTypeByCode(tt);
    }

    public void setOperationType(int operationType) {
        this.operationType = operationType;
    }

    public static String getOperationTypeDesc(int i) {
        if (i < 0 || i >= operationTypeDesc.length) {
            return operationTypeDesc[0];
        }
        return operationTypeDesc[i];
    }

    private static int getOperationTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < operationTypeCode.length; ++i) {
            if (!operationTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public JsonOutputField[] getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(JsonOutputField[] outputFields) {
        this.outputFields = outputFields;
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields) {
        this.outputFields = new JsonOutputField[nrfields];
    }

    public Object clone() {
        JsonOutputMeta retval = (JsonOutputMeta)((Object)super.clone());
        int nrfields = this.outputFields.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.outputFields[i] = (JsonOutputField)this.outputFields[i].clone();
        }
        return retval;
    }

    public void setAddToResult(boolean AddToResult) {
        this.AddToResult = AddToResult;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.outputValue = XMLHandler.getTagValue((Node)stepnode, (String)"outputValue");
            this.jsonBloc = XMLHandler.getTagValue((Node)stepnode, (String)"jsonBloc");
            this.nrRowsInBloc = XMLHandler.getTagValue((Node)stepnode, (String)"nrRowsInBloc");
            this.operationType = JsonOutputMeta.getOperationTypeByCode(Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"operation_type"), (String)""));
            this.compatibilityMode = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"compatibility_mode"));
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            this.AddToResult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"AddToResult"));
            this.fileName = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"name");
            this.createparentfolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"create_parent_folder"));
            this.extension = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"extention");
            this.fileAppended = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"append"));
            this.stepNrInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"split"));
            this.partNrInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"haspartno"));
            this.dateInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"add_date"));
            this.timeInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"add_time"));
            this.DoNotOpenNewFileInit = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"DoNotOpenNewFileInit"));
            this.servletOutput = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"servlet_output"));
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.outputFields[i] = new JsonOutputField();
                this.outputFields[i].setFieldName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                this.outputFields[i].setElementName(XMLHandler.getTagValue((Node)fnode, (String)"element"));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void setDefault() {
        this.encoding = "UTF-8";
        this.outputValue = "outputValue";
        this.jsonBloc = "data";
        this.nrRowsInBloc = "1";
        this.operationType = 1;
        this.extension = "js";
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.outputFields[i] = new JsonOutputField();
            this.outputFields[i].setFieldName("field" + i);
            this.outputFields[i].setElementName("field" + i);
        }
    }

    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (this.getOperationType() != 1) {
            ValueMetaString v = new ValueMetaString(space.environmentSubstitute(this.getOutputValue()));
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(500);
        retval.append("    ").append(XMLHandler.addTagValue((String)"outputValue", (String)this.outputValue));
        retval.append("    ").append(XMLHandler.addTagValue((String)"jsonBloc", (String)this.jsonBloc));
        retval.append("    ").append(XMLHandler.addTagValue((String)"nrRowsInBloc", (String)this.nrRowsInBloc));
        retval.append("    ").append(XMLHandler.addTagValue((String)"operation_type", (String)JsonOutputMeta.getOperationTypeCode(this.operationType)));
        retval.append("    ").append(XMLHandler.addTagValue((String)"compatibility_mode", (boolean)this.compatibilityMode));
        retval.append("    ").append(XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    ").append(XMLHandler.addTagValue((String)"addtoresult", (boolean)this.AddToResult));
        retval.append("    <file>" + Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.fileName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"extention", (String)this.extension));
        retval.append("      ").append(XMLHandler.addTagValue((String)"append", (boolean)this.fileAppended));
        retval.append("      ").append(XMLHandler.addTagValue((String)"split", (boolean)this.stepNrInFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"haspartno", (boolean)this.partNrInFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_date", (boolean)this.dateInFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_time", (boolean)this.timeInFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"create_parent_folder", (boolean)this.createparentfolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"DoNotOpenNewFileInit", (boolean)this.DoNotOpenNewFileInit));
        retval.append("      ").append(XMLHandler.addTagValue((String)"servlet_output", (boolean)this.servletOutput));
        retval.append("      </file>" + Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.outputFields.length; ++i) {
            JsonOutputField field = this.outputFields[i];
            if (field.getFieldName() == null || field.getFieldName().length() == 0) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)field.getFieldName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"element", (String)field.getElementName()));
            retval.append("    </field>" + Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.outputValue = rep.getStepAttributeString(id_step, "outputValue");
            this.jsonBloc = rep.getStepAttributeString(id_step, "jsonBloc");
            this.nrRowsInBloc = rep.getStepAttributeString(id_step, "nrRowsInBloc");
            this.operationType = JsonOutputMeta.getOperationTypeByCode(Const.NVL((String)rep.getStepAttributeString(id_step, "operation_type"), (String)""));
            this.compatibilityMode = rep.getStepAttributeBoolean(id_step, "compatibility_mode");
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            this.AddToResult = rep.getStepAttributeBoolean(id_step, "addtoresult");
            this.fileName = rep.getStepAttributeString(id_step, "file_name");
            this.extension = rep.getStepAttributeString(id_step, "file_extention");
            this.fileAppended = rep.getStepAttributeBoolean(id_step, "file_append");
            this.stepNrInFilename = rep.getStepAttributeBoolean(id_step, "file_add_stepnr");
            this.partNrInFilename = rep.getStepAttributeBoolean(id_step, "file_add_partnr");
            this.dateInFilename = rep.getStepAttributeBoolean(id_step, "file_add_date");
            this.timeInFilename = rep.getStepAttributeBoolean(id_step, "file_add_time");
            this.createparentfolder = rep.getStepAttributeBoolean(id_step, "create_parent_folder");
            this.DoNotOpenNewFileInit = rep.getStepAttributeBoolean(id_step, "DoNotOpenNewFileInit");
            this.servletOutput = rep.getStepAttributeBoolean(id_step, "file_servlet_output");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.outputFields[i] = new JsonOutputField();
                this.outputFields[i].setFieldName(rep.getStepAttributeString(id_step, i, "field_name"));
                this.outputFields[i].setElementName(rep.getStepAttributeString(id_step, i, "field_element"));
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    private static String getOperationTypeCode(int i) {
        if (i < 0 || i >= operationTypeCode.length) {
            return operationTypeCode[0];
        }
        return operationTypeCode[i];
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "outputValue", this.outputValue);
            rep.saveStepAttribute(id_transformation, id_step, "jsonBloc", this.jsonBloc);
            rep.saveStepAttribute(id_transformation, id_step, "nrRowsInBloc", this.nrRowsInBloc);
            rep.saveStepAttribute(id_transformation, id_step, "operation_type", JsonOutputMeta.getOperationTypeCode(this.operationType));
            rep.saveStepAttribute(id_transformation, id_step, "compatibility_mode", this.compatibilityMode);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            rep.saveStepAttribute(id_transformation, id_step, "addtoresult", this.AddToResult);
            rep.saveStepAttribute(id_transformation, id_step, "file_name", this.fileName);
            rep.saveStepAttribute(id_transformation, id_step, "file_extention", this.extension);
            rep.saveStepAttribute(id_transformation, id_step, "file_append", this.fileAppended);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_stepnr", this.stepNrInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_partnr", this.partNrInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_date", this.dateInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_time", this.timeInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "create_parent_folder", this.createparentfolder);
            rep.saveStepAttribute(id_transformation, id_step, "DoNotOpenNewFileInit", this.DoNotOpenNewFileInit);
            rep.saveStepAttribute(id_transformation, id_step, "file_servlet_output", this.servletOutput);
            for (int i = 0; i < this.outputFields.length; ++i) {
                JsonOutputField field = this.outputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", field.getFieldName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_element", field.getElementName());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    public String[] getFiles(String fileName) {
        int nr;
        int copies = 1;
        int splits = 1;
        int parts = 1;
        if (this.stepNrInFilename) {
            copies = 3;
        }
        if (this.partNrInFilename) {
            parts = 3;
        }
        if ((nr = copies * parts * splits) > 1) {
            ++nr;
        }
        String[] retval = new String[nr];
        int i = 0;
        for (int copy = 0; copy < copies; ++copy) {
            for (int part = 0; part < parts; ++part) {
                for (int split = 0; split < splits; ++split) {
                    retval[i] = this.buildFilename(fileName, copy, split);
                    ++i;
                }
            }
        }
        if (i < nr) {
            retval[i] = "...";
        }
        return retval;
    }

    public String buildFilename(String fileName, int stepnr, int splitnr) {
        SimpleDateFormat daf = new SimpleDateFormat();
        String retval = fileName;
        Date now = new Date();
        if (this.dateInFilename) {
            daf.applyPattern("yyyMMdd");
            String d = daf.format(now);
            retval = retval + "_" + d;
        }
        if (this.timeInFilename) {
            daf.applyPattern("HHmmss.SSS");
            String t = daf.format(now);
            retval = retval + "_" + t;
        }
        if (this.stepNrInFilename) {
            retval = retval + "_" + stepnr;
        }
        if (this.extension != null && this.extension.length() != 0) {
            retval = retval + "." + this.extension;
        }
        return retval;
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (this.getOperationType() != 1 && Const.isEmpty((String)transMeta.environmentSubstitute(this.getOutputValue()))) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JsonOutput.Error.MissingOutputFieldName", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (Const.isEmpty((String)transMeta.environmentSubstitute(this.getFileName()))) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JsonOutput.Error.MissingTargetFilename", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JsonOutputMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            String error_message = "";
            boolean error_found = false;
            for (int i = 0; i < this.outputFields.length; ++i) {
                int idx = prev.indexOfValue(this.outputFields[i].getFieldName());
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.outputFields[i].getFieldName() + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = BaseMessages.getString(PKG, (String)"JsonOutputMeta.CheckResult.FieldsNotFound", (String[])new String[]{error_message});
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JsonOutputMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JsonOutputMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JsonOutputMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        cr = new CheckResult(2, BaseMessages.getString(PKG, (String)"JsonOutputMeta.CheckResult.FilesNotChecked", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new JsonOutput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new JsonOutputData();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getJsonBloc() {
        return this.jsonBloc;
    }

    public void setJsonBloc(String jsonBloc) {
        this.jsonBloc = jsonBloc;
    }

    public String getNrRowsInBloc() {
        return this.nrRowsInBloc;
    }

    public void setNrRowsInBloc(String nrRowsInBloc) {
        this.nrRowsInBloc = nrRowsInBloc;
    }

    public String getOutputValue() {
        return this.outputValue;
    }

    public void setOutputValue(String outputValue) {
        this.outputValue = outputValue;
    }

    public boolean isServletOutput() {
        return this.servletOutput;
    }

    public void setServletOutput(boolean servletOutput) {
        this.servletOutput = servletOutput;
    }

    public boolean isCompatibilityMode() {
        return this.compatibilityMode;
    }

    public void setCompatibilityMode(boolean compatibilityMode) {
        this.compatibilityMode = compatibilityMode;
    }

    public StepMetaInjectionInterface getStepMetaInjectionInterface() {
        return new JsonOutputMetaInjection(this);
    }
}

