/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.aggmatcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.recorder.MessageRecorder;
import mondrian.resource.MondrianResource;
import mondrian.rolap.HierarchyUsage;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapStar;
import mondrian.rolap.aggmatcher.DefaultRules;
import mondrian.rolap.aggmatcher.JdbcSchema;
import mondrian.rolap.aggmatcher.Recognizer;
import mondrian.util.Pair;

class DefaultRecognizer
extends Recognizer {
    private static final MondrianResource mres = MondrianResource.instance();
    private final DefaultRules aggDefault;

    DefaultRecognizer(DefaultRules aggDefault, RolapStar star, JdbcSchema.Table dbFactTable, JdbcSchema.Table aggTable, MessageRecorder msgRecorder) {
        super(star, dbFactTable, aggTable, msgRecorder);
        this.aggDefault = aggDefault;
    }

    DefaultRules getRules() {
        return this.aggDefault;
    }

    @Override
    protected Recognizer.Matcher getIgnoreMatcher() {
        return this.getRules().getIgnoreMatcher();
    }

    @Override
    protected Recognizer.Matcher getFactCountMatcher() {
        return this.getRules().getFactCountMatcher();
    }

    protected Recognizer.Matcher getMeasureMatcher(JdbcSchema.Table.Column.Usage factUsage) {
        String measureName = factUsage.getSymbolicName();
        String measureColumnName = factUsage.getColumn().getName();
        String aggregateName = factUsage.getAggregator().getName();
        return this.getRules().getMeasureMatcher(measureName, measureColumnName, aggregateName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int checkMeasures() {
        this.msgRecorder.pushContextName("DefaultRecognizer.checkMeasures");
        try {
            int measureCountCount = 0;
            Iterator<JdbcSchema.Table.Column.Usage> it = this.dbFactTable.getColumnUsages(JdbcSchema.UsageType.MEASURE);
            while (it.hasNext()) {
                JdbcSchema.Table.Column.Usage factUsage = it.next();
                Recognizer.Matcher matcher = this.getMeasureMatcher(factUsage);
                int matchCount = 0;
                for (JdbcSchema.Table.Column aggColumn : this.aggTable.getColumns()) {
                    if (aggColumn.hasUsage(JdbcSchema.UsageType.IGNORE) || !matcher.matches(aggColumn.getName())) continue;
                    this.makeMeasure(factUsage, aggColumn);
                    ++measureCountCount;
                    ++matchCount;
                }
                if (matchCount <= true) continue;
                String msg = DefaultRecognizer.mres.AggMultipleMatchingMeasure.str(this.msgRecorder.getContext(), this.aggTable.getName(), this.dbFactTable.getName(), matchCount, factUsage.getSymbolicName(), factUsage.getColumn().getName(), factUsage.getAggregator().getName());
                this.msgRecorder.reportError(msg);
                this.returnValue = false;
            }
            int n = measureCountCount;
            return n;
        }
        finally {
            this.msgRecorder.popContextName();
        }
    }

    @Override
    protected int matchForeignKey(JdbcSchema.Table.Column.Usage factUsage) {
        JdbcSchema.Table.Column factColumn = factUsage.getColumn();
        Recognizer.Matcher matcher = this.getRules().getForeignKeyMatcher(factColumn.getName());
        int matchCount = 0;
        for (JdbcSchema.Table.Column aggColumn : this.aggTable.getColumns()) {
            if (aggColumn.hasUsage(JdbcSchema.UsageType.IGNORE) || !matcher.matches(aggColumn.getName())) continue;
            this.makeForeignKey(factUsage, aggColumn, null);
            ++matchCount;
        }
        return matchCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void matchLevels(Hierarchy hierarchy, HierarchyUsage hierarchyUsage) {
        this.msgRecorder.pushContextName("DefaultRecognizer.matchLevel");
        try {
            boolean collapsed;
            ArrayList<Pair<RolapLevel, JdbcSchema.Table.Column>> levelMatches = new ArrayList<Pair<RolapLevel, JdbcSchema.Table.Column>>();
            block5: for (Level level : hierarchy.getLevels()) {
                if (level.isAll()) continue;
                RolapLevel rLevel = (RolapLevel)level;
                String usagePrefix = hierarchyUsage.getUsagePrefix();
                String hierName = hierarchy.getName();
                String levelName = rLevel.getName();
                String levelColumnName = this.getColumnName(rLevel.getKeyExp());
                Recognizer.Matcher matcher = this.getRules().getLevelMatcher(usagePrefix, hierName, levelName, levelColumnName);
                for (JdbcSchema.Table.Column aggColumn : this.aggTable.getColumns()) {
                    if (!matcher.matches(aggColumn.getName())) continue;
                    levelMatches.add(new Pair<RolapLevel, JdbcSchema.Table.Column>(rLevel, aggColumn));
                    continue block5;
                }
            }
            if (levelMatches.size() == 0) {
                return;
            }
            Collections.sort(levelMatches, new Comparator<Pair<RolapLevel, JdbcSchema.Table.Column>>(){

                @Override
                public int compare(Pair<RolapLevel, JdbcSchema.Table.Column> o1, Pair<RolapLevel, JdbcSchema.Table.Column> o2) {
                    return Integer.valueOf(((RolapLevel)o1.left).getDepth()).compareTo(((RolapLevel)o2.left).getDepth());
                }
            });
            for (Pair pair : levelMatches) {
                collapsed = true;
                if (levelMatches.indexOf(pair) == 0 && ((RolapLevel)pair.left).getDepth() > 1) {
                    collapsed = false;
                }
                if (levelMatches.indexOf(pair) > 0 && ((RolapLevel)pair.left).getDepth() - 1 != ((RolapLevel)((Pair)levelMatches.get((int)(levelMatches.indexOf((Object)pair) - 1))).left).getDepth()) {
                    this.msgRecorder.reportError("The aggregate table " + this.aggTable.getName() + " contains the column " + ((JdbcSchema.Table.Column)pair.right).getName() + " which maps to the level " + ((RolapLevel)pair.left).getUniqueName() + " but its parent level is not part of that aggregation.");
                }
                if (collapsed || ((RolapLevel)pair.left).isUnique()) continue;
                this.msgRecorder.reportError("The aggregate table " + this.aggTable.getName() + " contains the column " + ((JdbcSchema.Table.Column)pair.right).getName() + " which maps to the level " + ((RolapLevel)pair.left).getUniqueName() + " but that level doesn't have unique members and this level is marked as non collapsed.");
            }
            if (this.msgRecorder.hasErrors()) {
                return;
            }
            for (Pair pair : levelMatches) {
                collapsed = true;
                if (levelMatches.indexOf(pair) == 0 && ((RolapLevel)pair.left).getDepth() > 1) {
                    collapsed = false;
                }
                this.makeLevelColumnUsage((JdbcSchema.Table.Column)pair.right, hierarchy, hierarchyUsage, ((JdbcSchema.Table.Column)pair.right).column.name, this.getColumnName(((RolapLevel)pair.left).getKeyExp()), ((RolapLevel)pair.left).getName(), collapsed, (RolapLevel)pair.left, null, null, null);
            }
        }
        finally {
            this.msgRecorder.popContextName();
        }
    }
}

