/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.cluster;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.cluster.SlaveConnectionManager;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;

public class HttpUtil {
    public static final int ZIP_BUFFER_SIZE = 8192;
    private static final String PROTOCOL_UNSECURE = "http";
    private static final String PROTOCOL_SECURE = "https";

    private static HttpClient getClient(VariableSpace space, String hostname, String port, String webAppName, String username, String password, String proxyHostname, String proxyPort, String nonProxyHosts) {
        HttpClient client = SlaveConnectionManager.getInstance().createHttpClient();
        HttpUtil.addCredentials(client, space, hostname, port, webAppName, username, password);
        HttpUtil.addProxy(client, space, hostname, proxyHostname, proxyPort, nonProxyHosts);
        return client;
    }

    public static PostMethod execService(VariableSpace space, String hostname, String port, String webAppName, String urlString, String username, String password, String proxyHostname, String proxyPort, String nonProxyHosts, Iterable<Header> headers, Map<String, Object> parameters, Map<String, String> arguments) throws Exception {
        HttpClient client = HttpUtil.getClient(space, hostname, port, webAppName, username, password, proxyHostname, proxyPort, nonProxyHosts);
        client.getHttpConnectionManager().getParams().setConnectionTimeout(0);
        client.getHttpConnectionManager().getParams().setSoTimeout(0);
        PostMethod method = new PostMethod(urlString);
        method.setDoAuthentication(true);
        for (Header header : headers) {
            method.addRequestHeader(header);
        }
        for (Map.Entry entry : parameters.entrySet()) {
            method.getParams().setParameter((String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : arguments.entrySet()) {
            method.addParameter((String)entry.getKey(), (String)entry.getValue());
        }
        HttpUtil.execMethod(client, (HttpMethod)method);
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String execService(VariableSpace space, String hostname, String port, String webAppName, String serviceAndArguments, String username, String password, String proxyHostname, String proxyPort, String nonProxyHosts, boolean isSecure) throws Exception {
        HttpClient client = HttpUtil.getClient(space, hostname, port, webAppName, username, password, proxyHostname, proxyPort, nonProxyHosts);
        String urlString = HttpUtil.constructUrl(space, hostname, port, webAppName, serviceAndArguments, isSecure);
        GetMethod method = new GetMethod(urlString);
        try {
            HttpUtil.execMethod(client, (HttpMethod)method);
            String string = method.getResponseBodyAsString();
            return string;
        }
        finally {
            method.releaseConnection();
        }
    }

    public static String execService(VariableSpace space, String hostname, String port, String webAppName, String serviceAndArguments, String username, String password, String proxyHostname, String proxyPort, String nonProxyHosts) throws Exception {
        return HttpUtil.execService(space, hostname, port, webAppName, serviceAndArguments, username, password, proxyHostname, proxyPort, nonProxyHosts, false);
    }

    public static int execMethod(HttpClient client, HttpMethod method) throws Exception {
        int result;
        try {
            result = client.executeMethod(method);
        }
        catch (Exception e) {
            throw new KettleException("You don't seem to be getting a connection to the server. Check the host and port you're using and make sure the sever is up and running.");
        }
        if (result == 500) {
            throw new KettleException("There was an error reading data from the server.");
        }
        if (result == 401) {
            throw new KettleException("Nice try-but we couldn't log you in. Check your username and password and try again.");
        }
        if (result != 200) {
            throw new KettleException(method.getResponseBodyAsString());
        }
        return result;
    }

    public static String constructUrl(VariableSpace space, String hostname, String port, String webAppName, String serviceAndArguments) throws UnsupportedEncodingException {
        return HttpUtil.constructUrl(space, hostname, port, webAppName, serviceAndArguments, false);
    }

    public static String constructUrl(VariableSpace space, String hostname, String port, String webAppName, String serviceAndArguments, boolean isSecure) throws UnsupportedEncodingException {
        String realHostname = space.environmentSubstitute(hostname);
        if (!StringUtils.isEmpty((String)webAppName)) {
            serviceAndArguments = "/" + space.environmentSubstitute(webAppName) + serviceAndArguments;
        }
        String protocol = isSecure ? PROTOCOL_SECURE : PROTOCOL_UNSECURE;
        String retval = protocol + "://" + realHostname + HttpUtil.getPortSpecification(space, port) + serviceAndArguments;
        retval = Const.replace(retval, " ", "%20");
        return retval;
    }

    public static String getPortSpecification(VariableSpace space, String port) {
        String realPort = space.environmentSubstitute(port);
        String portSpec = ":" + realPort;
        if (Const.isEmpty(realPort) || port.equals("80")) {
            portSpec = "";
        }
        return portSpec;
    }

    public static void addProxy(HttpClient client, VariableSpace space, String hostname, String proxyHostname, String proxyPort, String nonProxyHosts) {
        String host = space.environmentSubstitute(hostname);
        String phost = space.environmentSubstitute(proxyHostname);
        String pport = space.environmentSubstitute(proxyPort);
        String nonprox = space.environmentSubstitute(nonProxyHosts);
        if (!Const.isEmpty(phost) && !Const.isEmpty(pport)) {
            if (!Const.isEmpty(nonprox) && !Const.isEmpty(host) && host.matches(nonprox)) {
                return;
            }
            client.getHostConfiguration().setProxy(phost, Integer.parseInt(pport));
        }
    }

    public static void addCredentials(HttpClient client, VariableSpace space, String hostname, String port, String webAppName, String username, String password) {
        if (StringUtils.isEmpty((String)webAppName)) {
            client.getState().setCredentials(new AuthScope(space.environmentSubstitute(hostname), Const.toInt(space.environmentSubstitute(port), 80), "Kettle"), (Credentials)new UsernamePasswordCredentials(space.environmentSubstitute(username), Encr.decryptPasswordOptionallyEncrypted(space.environmentSubstitute(password))));
        } else {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(space.environmentSubstitute(username), Encr.decryptPasswordOptionallyEncrypted(space.environmentSubstitute(password)));
            client.getState().setCredentials(AuthScope.ANY, (Credentials)creds);
            client.getParams().setAuthenticationPreemptive(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decodeBase64ZippedString(String loggingString64) throws IOException {
        if (loggingString64 == null || loggingString64.isEmpty()) {
            return "";
        }
        StringWriter writer = new StringWriter();
        byte[] bytes64 = Base64.decodeBase64((byte[])loggingString64.getBytes());
        ByteArrayInputStream zip = new ByteArrayInputStream(bytes64);
        GZIPInputStream unzip = null;
        InputStreamReader reader = null;
        BufferedInputStream in = null;
        try {
            unzip = new GZIPInputStream((InputStream)zip, 8192);
            in = new BufferedInputStream(unzip, 8192);
            reader = new InputStreamReader((InputStream)in, "UTF-8");
            writer = new StringWriter();
            char[] buff = new char[8192];
            int length = 0;
            while ((length = reader.read(buff)) > 0) {
                writer.write(buff, 0, length);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (unzip != null) {
                try {
                    unzip.close();
                }
                catch (IOException iOException) {}
            }
        }
        return writer.toString();
    }

    public static String encodeBase64ZippedString(String in) throws IOException {
        Charset charset = Charset.forName("UTF-8");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzos = new GZIPOutputStream(baos);
        gzos.write(in.getBytes(charset));
        gzos.close();
        return new String(Base64.encodeBase64((byte[])baos.toByteArray()));
    }
}

