/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.extension;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.extension.ExtensionPointPluginType;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeListener;

public class ExtensionPointMap {
    private static LogChannelInterface log = new LogChannel("ExtensionPointMap");
    private static ExtensionPointMap INSTANCE = new ExtensionPointMap(PluginRegistry.getInstance());
    private final PluginRegistry registry;
    private Table<String, String, Supplier<ExtensionPointInterface>> extensionPointPluginMap;

    private ExtensionPointMap(PluginRegistry pluginRegistry) {
        this.registry = pluginRegistry;
        this.extensionPointPluginMap = HashBasedTable.create();
        this.registry.addPluginListener(ExtensionPointPluginType.class, new PluginTypeListener(){

            @Override
            public void pluginAdded(Object serviceObject) {
                ExtensionPointMap.this.addExtensionPoint((PluginInterface)serviceObject);
            }

            @Override
            public void pluginRemoved(Object serviceObject) {
                ExtensionPointMap.this.removeExtensionPoint((PluginInterface)serviceObject);
            }

            @Override
            public void pluginChanged(Object serviceObject) {
                ExtensionPointMap.this.removeExtensionPoint((PluginInterface)serviceObject);
                ExtensionPointMap.this.addExtensionPoint((PluginInterface)serviceObject);
            }
        });
        List extensionPointPlugins = this.registry.getPlugins(ExtensionPointPluginType.class);
        for (PluginInterface extensionPointPlugin : extensionPointPlugins) {
            this.addExtensionPoint(extensionPointPlugin);
        }
    }

    public static ExtensionPointMap getInstance() {
        return INSTANCE;
    }

    public Map<String, Map<String, Supplier<ExtensionPointInterface>>> getMap() {
        return this.extensionPointPluginMap.rowMap();
    }

    public void addExtensionPoint(PluginInterface extensionPointPlugin) {
        for (String id : extensionPointPlugin.getIds()) {
            this.extensionPointPluginMap.put((Object)extensionPointPlugin.getName(), (Object)id, this.createLazyLoader(extensionPointPlugin));
        }
    }

    public void removeExtensionPoint(PluginInterface extensionPointPlugin) {
        for (String id : extensionPointPlugin.getIds()) {
            this.extensionPointPluginMap.remove((Object)extensionPointPlugin.getName(), (Object)id);
        }
    }

    public Map<String, ExtensionPointInterface> get(String id) {
        return Maps.transformValues((Map)this.extensionPointPluginMap.row((Object)id), (Function)Suppliers.supplierFunction());
    }

    public void reInitialize() {
        this.extensionPointPluginMap = HashBasedTable.create();
        PluginRegistry registry = PluginRegistry.getInstance();
        List extensionPointPlugins = registry.getPlugins(ExtensionPointPluginType.class);
        for (PluginInterface extensionPointPlugin : extensionPointPlugins) {
            this.addExtensionPoint(extensionPointPlugin);
        }
    }

    Supplier<ExtensionPointInterface> createLazyLoader(PluginInterface extensionPointPlugin) {
        return Suppliers.memoize((Supplier)new ExtensionPointLoader(extensionPointPlugin));
    }

    public static LogChannelInterface getLog() {
        if (log == null) {
            log = new LogChannel("ExtensionPointMap");
        }
        return log;
    }

    private class ExtensionPointLoader
    implements Supplier<ExtensionPointInterface> {
        private final PluginInterface extensionPointPlugin;

        private ExtensionPointLoader(PluginInterface extensionPointPlugin) {
            this.extensionPointPlugin = extensionPointPlugin;
        }

        public ExtensionPointInterface get() {
            try {
                return ExtensionPointMap.this.registry.loadClass(this.extensionPointPlugin, ExtensionPointInterface.class);
            }
            catch (Exception e) {
                ExtensionPointMap.getLog().logError("Unable to load extension point for name = [" + (this.extensionPointPlugin != null ? this.extensionPointPlugin.getName() : "null") + "]", e);
                return null;
            }
        }
    }
}

