/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LoggingObject;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.util.EnvUtil;

public class LoggingRegistry {
    private static LoggingRegistry registry = new LoggingRegistry();
    private Map<String, LoggingObjectInterface> map;
    private Map<String, List<String>> childrenMap;
    private Date lastModificationTime;
    private int maxSize;
    private final int DEFAULT_MAX_SIZE = 10000;
    private Object syncObject = new Object();

    private LoggingRegistry() {
        this.map = new ConcurrentHashMap<String, LoggingObjectInterface>();
        this.childrenMap = new ConcurrentHashMap<String, List<String>>();
        this.lastModificationTime = new Date();
        this.maxSize = Const.toInt(EnvUtil.getSystemProperty("KETTLE_MAX_LOGGING_REGISTRY_SIZE"), 10000);
    }

    public static LoggingRegistry getInstance() {
        return registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String registerLoggingSource(Object object) {
        Object object2 = this.syncObject;
        synchronized (object2) {
            String parentLogChannelId;
            this.maxSize = Const.toInt(EnvUtil.getSystemProperty("KETTLE_MAX_LOGGING_REGISTRY_SIZE"), 10000);
            LoggingObject loggingSource = new LoggingObject(object);
            LoggingObjectInterface found = this.findExistingLoggingSource(loggingSource);
            if (found != null) {
                LoggingObjectInterface foundParent = found.getParent();
                LoggingObjectInterface loggingSourceParent = loggingSource.getParent();
                if (foundParent != null && loggingSourceParent != null) {
                    String foundLogChannelId;
                    String foundParentLogChannelId = foundParent.getLogChannelId();
                    String sourceParentLogChannelId = loggingSourceParent.getLogChannelId();
                    if (foundParentLogChannelId != null && sourceParentLogChannelId != null && foundParentLogChannelId.equals(sourceParentLogChannelId) && (foundLogChannelId = found.getLogChannelId()) != null) {
                        return foundLogChannelId;
                    }
                }
            }
            String logChannelId = UUID.randomUUID().toString();
            loggingSource.setLogChannelId(logChannelId);
            this.map.put(logChannelId, loggingSource);
            if (loggingSource.getParent() != null && (parentLogChannelId = loggingSource.getParent().getLogChannelId()) != null) {
                List<String> parentChildren = this.childrenMap.get(parentLogChannelId);
                if (parentChildren == null) {
                    parentChildren = new ArrayList<String>();
                    this.childrenMap.put(parentLogChannelId, parentChildren);
                }
                parentChildren.add(logChannelId);
            }
            this.lastModificationTime = new Date();
            loggingSource.setRegistrationDate(this.lastModificationTime);
            if (this.maxSize > 0 && this.map.size() > this.maxSize) {
                ArrayList<LoggingObjectInterface> all = new ArrayList<LoggingObjectInterface>(this.map.values());
                Collections.sort(all, new Comparator<LoggingObjectInterface>(){

                    @Override
                    public int compare(LoggingObjectInterface o1, LoggingObjectInterface o2) {
                        if (o1 == null && o2 != null) {
                            return -1;
                        }
                        if (o1 != null && o2 == null) {
                            return 1;
                        }
                        if (o1 == null && o2 == null) {
                            return 0;
                        }
                        if (o1.getRegistrationDate() == null && o2.getRegistrationDate() != null) {
                            return -1;
                        }
                        if (o1.getRegistrationDate() != null && o2.getRegistrationDate() == null) {
                            return 1;
                        }
                        if (o1.getRegistrationDate() == null && o2.getRegistrationDate() == null) {
                            return 0;
                        }
                        return o1.getRegistrationDate().compareTo(o2.getRegistrationDate());
                    }
                });
                int cutCount = this.maxSize < 1000 ? this.maxSize : 1000;
                for (int i = 0; i < cutCount; ++i) {
                    LoggingObjectInterface toRemove = (LoggingObjectInterface)all.get(i);
                    this.map.remove(toRemove.getLogChannelId());
                }
                this.removeOrphans();
            }
            return logChannelId;
        }
    }

    public LoggingObjectInterface findExistingLoggingSource(LoggingObjectInterface loggingObject) {
        LoggingObjectInterface found = null;
        for (LoggingObjectInterface verify : this.map.values()) {
            if (!loggingObject.equals(verify)) continue;
            found = verify;
            break;
        }
        return found;
    }

    public LoggingObjectInterface getLoggingObject(String logChannelId) {
        return this.map.get(logChannelId);
    }

    public Map<String, LoggingObjectInterface> getMap() {
        return this.map;
    }

    public List<String> getLogChannelChildren(String parentLogChannelId) {
        if (parentLogChannelId == null) {
            return null;
        }
        List<String> list = this.getLogChannelChildren(new ArrayList<String>(), parentLogChannelId);
        list.add(parentLogChannelId);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getLogChannelChildren(List<String> children, String parentLogChannelId) {
        Object object = this.syncObject;
        synchronized (object) {
            List<String> list = this.childrenMap.get(parentLogChannelId);
            if (list == null) {
                return children;
            }
            for (String logChannelId : list) {
                this.getLogChannelChildren(children, logChannelId);
                children.add(logChannelId);
            }
        }
        return children;
    }

    public Date getLastModificationTime() {
        return this.lastModificationTime;
    }

    public String dump(boolean includeGeneral) {
        StringBuffer out = new StringBuffer(50000);
        for (LoggingObjectInterface o : this.map.values()) {
            if (!includeGeneral && o.getObjectType().equals((Object)LoggingObjectType.GENERAL)) continue;
            out.append(o.getContainerObjectId());
            out.append("\t");
            out.append(o.getLogChannelId());
            out.append("\t");
            out.append(o.getObjectType().name());
            out.append("\t");
            out.append(o.getObjectName());
            out.append("\t");
            out.append(o.getParent() != null ? o.getParent().getLogChannelId() : "-");
            out.append("\t");
            out.append(o.getParent() != null ? o.getParent().getObjectType().name() : "-");
            out.append("\t");
            out.append(o.getParent() != null ? o.getParent().getObjectName() : "-");
            out.append("\n");
        }
        return out.toString();
    }

    Map<String, LoggingObjectInterface> dumpItems() {
        return Collections.unmodifiableMap(this.map);
    }

    Map<String, List<String>> dumpChildren() {
        return Collections.unmodifiableMap(this.childrenMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIncludingChildren(String logChannelId) {
        Map<String, LoggingObjectInterface> map = this.map;
        synchronized (map) {
            List<String> children = this.getLogChannelChildren(logChannelId);
            for (String child : children) {
                this.map.remove(child);
            }
            this.map.remove(logChannelId);
            this.removeOrphans();
        }
    }

    public void removeOrphans() {
        this.childrenMap.keySet().retainAll(this.map.keySet());
    }
}

