/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.clients;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.exception.KettleSQLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.sql.SQL;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.dataservice.DataServiceExecutor;
import org.pentaho.di.trans.dataservice.clients.Query;

class DualQueryService
implements Query.Service {
    public static final String DUMMY_TABLE_NAME = "dual";
    @VisibleForTesting
    protected static final byte[] DATA;

    DualQueryService() {
    }

    @Override
    public Query prepareQuery(String sqlString, int maxRows, Map<String, String> parameters) {
        SQL sql;
        try {
            sql = new SQL(sqlString);
        }
        catch (KettleSQLException e) {
            return null;
        }
        if (sql.getServiceName() == null || sql.getServiceName().equals(DUMMY_TABLE_NAME)) {
            return new DualQuery();
        }
        return null;
    }

    static {
        try {
            ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(arrayOutputStream);
            DataServiceExecutor.writeMetadata(dos, DUMMY_TABLE_NAME, "", "", "", "");
            RowMeta rowMeta = new RowMeta();
            rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString("DUMMY"));
            rowMeta.writeMeta(dos);
            Object[] row = new Object[]{"x"};
            rowMeta.writeData(dos, row);
            DATA = arrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private class DualQuery
    implements Query {
        @Override
        public void writeTo(OutputStream outputStream) throws IOException {
            outputStream.write(DATA);
        }

        @Override
        public List<Trans> getTransList() {
            return ImmutableList.of();
        }
    }
}

