/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.concurrent.Callable;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.dataservice.DataServiceExecutor;
import org.pentaho.di.trans.dataservice.optimization.OptimizationImpactInfo;
import org.pentaho.di.trans.dataservice.optimization.PushDownOptimizationMeta;
import org.pentaho.di.trans.dataservice.optimization.PushDownType;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMetaDataCombi;

public abstract class StepOptimization
implements PushDownType {
    @Override
    public ListenableFuture<Boolean> activate(final DataServiceExecutor executor, final PushDownOptimizationMeta meta) {
        ListenableFutureTask future = ListenableFutureTask.create((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                StepInterface stepInterface = executor.getServiceTrans().findRunThread(meta.getStepName());
                return StepOptimization.this.activate(executor, stepInterface);
            }
        });
        executor.getListenerMap().put((Object)DataServiceExecutor.ExecutionPoint.OPTIMIZE, (Object)future);
        return future;
    }

    @Override
    public OptimizationImpactInfo preview(DataServiceExecutor executor, PushDownOptimizationMeta meta) {
        OptimizationImpactInfo info = new OptimizationImpactInfo(meta.getStepName());
        Trans serviceTrans = executor.getServiceTrans();
        try {
            serviceTrans.prepareExecution(null);
            info = this.preview(executor, serviceTrans.findRunThread(meta.getStepName()));
            for (StepMetaDataCombi stepMetaDataCombi : serviceTrans.getSteps()) {
                stepMetaDataCombi.step.setOutputDone();
                stepMetaDataCombi.step.dispose(stepMetaDataCombi.meta, stepMetaDataCombi.data);
                stepMetaDataCombi.step.markStop();
            }
        }
        catch (Exception e) {
            info.setErrorMsg(e.getMessage());
        }
        return info;
    }

    protected abstract boolean activate(DataServiceExecutor var1, StepInterface var2);

    protected abstract OptimizationImpactInfo preview(DataServiceExecutor var1, StepInterface var2);
}

