/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization.cache;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.cache.Cache;
import javax.cache.CacheException;
import org.pentaho.caching.api.PentahoCacheManager;
import org.pentaho.caching.api.PentahoCacheTemplateConfiguration;
import org.pentaho.di.trans.dataservice.DataServiceExecutor;
import org.pentaho.di.trans.dataservice.optimization.PushDownFactory;
import org.pentaho.di.trans.dataservice.optimization.cache.CachedService;
import org.pentaho.di.trans.dataservice.optimization.cache.CachedServiceLoader;
import org.pentaho.di.trans.dataservice.optimization.cache.ServiceCache;
import org.pentaho.di.trans.dataservice.optimization.cache.ServiceObserver;
import org.pentaho.di.trans.dataservice.optimization.cache.ui.ServiceCacheController;
import org.pentaho.di.trans.dataservice.optimization.cache.ui.ServiceCacheOverlay;

public class ServiceCacheFactory
implements PushDownFactory {
    private final PentahoCacheManager cacheManager;
    private final ListeningExecutorService executorService;

    public ServiceCacheFactory(PentahoCacheManager cacheManager, ExecutorService executorService) {
        this.cacheManager = cacheManager;
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)executorService);
    }

    @Override
    public String getName() {
        return "Service Cache";
    }

    public Class<ServiceCache> getType() {
        return ServiceCache.class;
    }

    @Override
    public ServiceCache createPushDown() {
        return new ServiceCache(this);
    }

    @Override
    public ServiceCacheOverlay createOverlay() {
        return new ServiceCacheOverlay(this);
    }

    public ServiceCacheController createController() {
        return new ServiceCacheController(this);
    }

    public ListeningExecutorService getExecutorService() {
        return this.executorService;
    }

    public PentahoCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public Cache<CachedService.CacheKey, CachedService> getCache(ServiceCache serviceCache, String dataServiceName) throws CacheException {
        Optional<Cache<CachedService.CacheKey, CachedService>> cache = this.getCache(dataServiceName);
        if (cache.isPresent()) {
            return (Cache)cache.get();
        }
        return this.getPentahoCacheTemplateConfiguration(serviceCache).createCache(this.cacheName(dataServiceName), CachedService.CacheKey.class, CachedService.class);
    }

    public PentahoCacheTemplateConfiguration getPentahoCacheTemplateConfiguration(ServiceCache serviceCache) {
        String templateName = serviceCache.getTemplateName();
        Map templates = this.cacheManager.getTemplates();
        Preconditions.checkState((!Strings.isNullOrEmpty((String)templateName) && templates.containsKey(templateName) ? 1 : 0) != 0, (String)"Cache Template is invalid", (Object[])new Object[]{templateName});
        return ((PentahoCacheTemplateConfiguration)templates.get(templateName)).overrideProperties(serviceCache.getTemplateOverrides());
    }

    public Optional<Cache<CachedService.CacheKey, CachedService>> getCache(String dataServiceName) {
        try {
            return Optional.fromNullable((Object)this.cacheManager.getCache(this.cacheName(dataServiceName), CachedService.CacheKey.class, CachedService.class));
        }
        catch (Exception e) {
            this.cacheManager.destroyCache(this.cacheName(dataServiceName));
            return Optional.absent();
        }
    }

    public String cacheName(String dataServiceName) {
        return "SERVICE_CACHE." + dataServiceName;
    }

    public ServiceObserver createObserver(DataServiceExecutor executor) {
        return new ServiceObserver(executor);
    }

    public CachedServiceLoader createCachedServiceLoader(CachedService cachedService) {
        return new CachedServiceLoader(cachedService, (Executor)this.executorService);
    }

    public Iterable<String> getTemplateNames() {
        return this.cacheManager.getTemplates().keySet();
    }

    public Map<String, String> getPropertiesByTemplateName(String templateName) {
        return ((PentahoCacheTemplateConfiguration)this.cacheManager.getTemplates().get(templateName)).getProperties();
    }
}

