/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.optimization.cache;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.LinkedList;
import java.util.List;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.dataservice.DataServiceExecutor;
import org.pentaho.di.trans.dataservice.optimization.cache.CachedService;
import org.pentaho.di.trans.step.RowAdapter;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepAdapter;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepListener;
import org.pentaho.di.trans.step.StepMeta;

public class ServiceObserver
extends AbstractFuture<CachedService>
implements Runnable {
    private final DataServiceExecutor executor;

    public ServiceObserver(DataServiceExecutor executor) {
        this.executor = executor;
    }

    public ListenableFuture<CachedService> install() {
        List serviceReady = this.executor.getListenerMap().get((Object)DataServiceExecutor.ExecutionPoint.READY);
        if (Iterables.any((Iterable)serviceReady, (Predicate)Predicates.instanceOf(ServiceObserver.class))) {
            this.setException(new IllegalStateException("More than one cache is configured for this data service."));
        } else {
            serviceReady.add(this);
        }
        return this;
    }

    @Override
    public void run() {
        final LinkedList rowMetaAndData = Lists.newLinkedList();
        StepInterface serviceStep = this.executor.getServiceTrans().findRunThread(this.executor.getService().getStepname());
        serviceStep.addRowListener((RowListener)new RowAdapter(){

            public synchronized void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) {
                rowMetaAndData.add(new RowMetaAndData(rowMeta, row));
            }
        });
        serviceStep.addStepListener((StepListener)new StepAdapter(){

            public void stepFinished(Trans trans, StepMeta stepMeta, StepInterface step) {
                if (ServiceObserver.this.executor.getGenTrans().getErrors() > 0) {
                    ServiceObserver.this.setException(new KettleException("Dynamic transformation finished with errors, could not cache results"));
                } else if (step.isStopped()) {
                    ServiceObserver.this.set(CachedService.partial(rowMetaAndData, ServiceObserver.this.executor));
                } else {
                    ServiceObserver.this.set(CachedService.complete(rowMetaAndData));
                }
            }
        });
    }
}

