/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.serialization;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.serialization.MetaStoreElement;
import org.pentaho.metastore.persist.MetaStoreAttribute;
import org.pentaho.metastore.persist.MetaStoreElementType;

@MetaStoreElementType(name="Data Service Transformation", description="Pointer to a saved transformation that supplies a data service")
public class ServiceTrans
implements MetaStoreElement {
    private String name;
    @MetaStoreAttribute(key="trans_references")
    private List<Reference> references = Lists.newArrayList();

    public static ServiceTrans create(DataServiceMeta dataServiceMeta) {
        return ServiceTrans.create(dataServiceMeta.getName(), dataServiceMeta.getServiceTrans());
    }

    public static ServiceTrans create(String name, TransMeta transMeta) {
        ServiceTrans serviceTrans = new ServiceTrans();
        serviceTrans.setName(name);
        serviceTrans.getReferences().addAll(ServiceTrans.references(transMeta));
        return serviceTrans;
    }

    public static List<Reference> references(TransMeta transMeta) {
        ArrayList references = Lists.newArrayList();
        Repository repository = transMeta.getRepository();
        if (transMeta.getRepository() != null) {
            ObjectId oid;
            if (repository.getRepositoryMeta().getRepositoryCapabilities().supportsReferences() && (oid = transMeta.getObjectId()) != null) {
                references.add(new Reference(StorageMethod.REPO_ID, oid.getId()));
            }
            references.add(new Reference(StorageMethod.REPO_PATH, transMeta.getPathAndName()));
        } else {
            references.add(new Reference(StorageMethod.FILE, transMeta.getFilename()));
        }
        return references;
    }

    public static Predicate<ServiceTrans> isReferenceTo(final TransMeta transMeta) {
        return new Predicate<ServiceTrans>(){
            final Set<Reference> references;
            {
                this.references = ImmutableSet.copyOf(ServiceTrans.references(transMeta));
            }

            public boolean apply(ServiceTrans serviceTrans) {
                return Iterables.any(serviceTrans.getReferences(), (Predicate)Predicates.in(this.references));
            }
        };
    }

    public static Predicate<ServiceTrans> isValid(final Repository repository) {
        return new Predicate<ServiceTrans>(){

            public boolean apply(ServiceTrans input) {
                return Iterables.any(input.getReferences(), Reference.isValid(repository));
            }
        };
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public List<Reference> getReferences() {
        return this.references;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("references", this.references).toString();
    }

    public static enum StorageMethod {
        FILE{

            @Override
            public boolean exists(Repository repository, String location) {
                return !Strings.isNullOrEmpty((String)location) && new File(location).exists();
            }

            @Override
            public TransMeta load(Repository repository, String location) throws KettleException {
                return new TransMeta(location);
            }
        }
        ,
        REPO_PATH{

            @Override
            public TransMeta load(Repository repository, String location) throws KettleException {
                String name;
                String path;
                int lastSlashIndex = location.lastIndexOf(47);
                if (lastSlashIndex >= 0) {
                    path = location.substring(0, lastSlashIndex + 1);
                    name = location.substring(lastSlashIndex + 1);
                } else {
                    path = "/";
                    name = location;
                }
                RepositoryDirectoryInterface root = repository.loadRepositoryDirectoryTree();
                RepositoryDirectoryInterface rd = root.findDirectory(path);
                if (rd == null) {
                    rd = root;
                }
                return repository.loadTransformation(repository.getTransformationID(name, rd), null);
            }
        }
        ,
        REPO_ID{

            @Override
            public TransMeta load(Repository repository, String location) throws KettleException {
                return repository.loadTransformation((ObjectId)new StringObjectId(location), null);
            }
        };


        public abstract TransMeta load(Repository var1, String var2) throws KettleException;

        public boolean exists(Repository repository, String location) {
            return true;
        }
    }

    public static class Reference {
        @MetaStoreAttribute(key="transformation_location")
        private String location;
        @MetaStoreAttribute(key="transformation_storage_method")
        private StorageMethod method;

        @Deprecated
        public Reference() {
        }

        public Reference(StorageMethod method, String location) {
            this.location = location;
            this.method = method;
        }

        public static Predicate<Reference> isValid(final Repository repository) {
            return new Predicate<Reference>(){

                public boolean apply(Reference reference) {
                    return reference.exists(repository);
                }
            };
        }

        public String getLocation() {
            return this.location;
        }

        public void setLocation(String location) {
            this.location = location;
        }

        public StorageMethod getMethod() {
            return this.method;
        }

        public void setMethod(StorageMethod method) {
            this.method = method;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("method", (Object)this.method).add("location", (Object)this.location).toString();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.location, this.method});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Reference reference = (Reference)o;
            return Objects.equal((Object)this.location, (Object)reference.location) && Objects.equal((Object)((Object)this.method), (Object)((Object)reference.method));
        }

        public boolean exists(Repository repository) {
            return this.method.exists(repository, this.location);
        }

        public TransMeta load(Repository repository) throws KettleException {
            return this.method.load(repository, this.location);
        }
    }
}

