/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.serialization;

import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPoint;
import org.pentaho.di.core.extension.ExtensionPointInterface;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceContext;
import org.pentaho.di.trans.dataservice.serialization.SynchronizationService;

@ExtensionPoint(id="TransOpenedExtensionPointPlugin", extensionPointId="TransAfterOpen", description="Registers a ContentChangedListener and StepMetaChangeListener on each TransMeta to synchronize Data Services with the MetaStore")
public class TransOpenedExtensionPointPlugin
implements ExtensionPointInterface {
    private final SynchronizationService synchronizationService;

    public TransOpenedExtensionPointPlugin(DataServiceContext context) {
        this.synchronizationService = context.getDataServiceDelegate().createSyncService();
    }

    public void callExtensionPoint(LogChannelInterface log, Object object) throws KettleException {
        TransMeta transMeta = (TransMeta)object;
        this.synchronizationService.install(transMeta);
    }
}

