/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.ui.controller;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.core.logging.MetricsRegistry;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.sql.SQL;
import org.pentaho.di.core.sql.SQLField;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.dataservice.DataServiceContext;
import org.pentaho.di.trans.dataservice.DataServiceExecutor;
import org.pentaho.di.trans.dataservice.DataServiceMeta;
import org.pentaho.di.trans.dataservice.optimization.PushDownOptimizationMeta;
import org.pentaho.di.trans.dataservice.ui.DataServiceTestCallback;
import org.pentaho.di.trans.dataservice.ui.DataServiceTestDialog;
import org.pentaho.di.trans.dataservice.ui.model.DataServiceTestModel;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.tableinput.TableInputMeta;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.components.XulMenuList;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;

public class DataServiceTestController
extends AbstractXulEventHandler {
    public static final int POLL_DELAY_MILLIS = 500;
    public static final int POLL_PERIOD_MILLIS = 500;
    public static Class<?> PKG = DataServiceTestDialog.class;
    private final DataServiceTestModel model;
    private static final String NAME = "dataServiceTestController";
    private final String transName;
    private DataServiceTestCallback callback;
    private final DataServiceMeta dataService;
    private final TransMeta transMeta;
    private final NamedParams startingParameterValues = new NamedParamsDefault();
    private XulMenuList<String> logLevels;
    private Timer completionPollTimer;
    private DataServiceExecutor dataServiceExec;
    private DataServiceContext context;
    private BindingFactory bindingFactory;
    private XulMenuList<String> maxRows;

    public DataServiceTestController(DataServiceTestModel model, DataServiceMeta dataService, DataServiceContext context) throws KettleException {
        this(model, dataService, (BindingFactory)new DefaultBindingFactory(), context);
    }

    public DataServiceTestController(DataServiceTestModel model, DataServiceMeta dataService, BindingFactory bindingFactory, DataServiceContext context) throws KettleException {
        this.model = model;
        this.dataService = dataService;
        this.transMeta = dataService.getServiceTrans();
        this.bindingFactory = bindingFactory;
        this.transName = this.transMeta.getName();
        this.context = context;
        model.setSql(this.getDefaultSql());
        this.initStartingParameterValues();
        this.setName(NAME);
    }

    void initStartingParameterValues() {
        this.startingParameterValues.copyParametersFrom((NamedParams)this.transMeta);
    }

    public void init() throws InvocationTargetException, XulException {
        this.bindingFactory.setDocument(this.getXulDomContainer().getDocumentRoot());
        this.bindLogLevelsCombo(this.bindingFactory);
        this.bindSqlText(this.bindingFactory);
        this.bindButtons(this.bindingFactory);
        this.bindMaxRowsCombo(this.bindingFactory);
        this.bindErrorAlert(this.bindingFactory);
        this.bindOptImpactInfo(this.bindingFactory);
    }

    private void bindButtons(BindingFactory bindingFactory) throws InvocationTargetException, XulException {
        this.bindButton(bindingFactory, (XulButton)this.document.getElementById("preview-opt-btn"));
        this.bindButton(bindingFactory, (XulButton)this.document.getElementById("exec-sql-btn"));
    }

    private void bindButton(BindingFactory bindingFactory, XulButton button) throws XulException, InvocationTargetException {
        bindingFactory.setBindingType(Binding.Type.ONE_WAY);
        Binding binding = bindingFactory.createBinding((Object)this.model, "executing", (Object)button, "disabled", new BindingConvertor[0]);
        binding.initialize();
        binding.fireSourceChanged();
    }

    private void bindErrorAlert(BindingFactory bindingFactory) throws InvocationTargetException, XulException {
        XulLabel errorAlert = (XulLabel)this.document.getElementById("error-alert");
        this.model.setAlertMessage("");
        bindingFactory.setBindingType(Binding.Type.ONE_WAY);
        Binding binding = bindingFactory.createBinding((Object)this.model, "alertMessage", (Object)errorAlert, "value", new BindingConvertor[0]);
        binding.initialize();
        binding.fireSourceChanged();
    }

    private void bindOptImpactInfo(BindingFactory bindingFactory) {
        XulTextbox maxRows = (XulTextbox)this.document.getElementById("optimization-impact-info");
        bindingFactory.setBindingType(Binding.Type.ONE_WAY);
        Binding binding = bindingFactory.createBinding((Object)this.model, "optimizationImpactDescription", (Object)maxRows, "value", new BindingConvertor[0]);
        binding.initialize();
    }

    private void bindMaxRowsCombo(BindingFactory bindingFactory) throws InvocationTargetException, XulException {
        this.bindMaxRowsComboValues(bindingFactory);
        this.bindSelectedMaxRows(bindingFactory);
    }

    private void bindMaxRowsComboValues(BindingFactory bindingFactory) throws InvocationTargetException, XulException {
        assert (this.document.getElementById("maxrows-combo") instanceof XulMenuList);
        this.maxRows = (XulMenuList)this.document.getElementById("maxrows-combo");
        bindingFactory.setBindingType(Binding.Type.ONE_WAY);
        bindingFactory.createBinding((Object)this.model, "allMaxRows", this.maxRows, "elements", new BindingConvertor[0]).fireSourceChanged();
    }

    private void bindSelectedMaxRows(BindingFactory bindingFactory) throws InvocationTargetException, XulException {
        Binding binding = bindingFactory.createBinding((Object)this.model, "maxRows", this.maxRows, "selectedItem", new BindingConvertor[0]);
        binding.setBindingType(Binding.Type.BI_DIRECTIONAL);
        BindingConvertor<Integer, Integer> maxRowsConverter = new BindingConvertor<Integer, Integer>(){

            public Integer sourceToTarget(Integer value) {
                return DataServiceTestModel.MAXROWS_CHOICES.indexOf(value);
            }

            public Integer targetToSource(Integer value) {
                return DataServiceTestModel.MAXROWS_CHOICES.indexOf(value);
            }
        };
        binding.setConversion((BindingConvertor)maxRowsConverter);
        binding.initialize();
        binding.fireSourceChanged();
    }

    private void bindLogLevelsCombo(BindingFactory bindingFactory) throws InvocationTargetException, XulException {
        this.bindLogLevelComboValues(bindingFactory);
        this.bindSelectedLogLevel(bindingFactory);
    }

    private void bindLogLevelComboValues(BindingFactory bindingFactory) throws XulException, InvocationTargetException {
        assert (this.document.getElementById("log-levels") instanceof XulMenuList);
        this.logLevels = (XulMenuList)this.document.getElementById("log-levels");
        bindingFactory.setBindingType(Binding.Type.ONE_WAY);
        bindingFactory.createBinding((Object)this.model, "allLogLevels", this.logLevels, "elements", new BindingConvertor[0]).fireSourceChanged();
    }

    private void bindSelectedLogLevel(BindingFactory bindingFactory) throws InvocationTargetException, XulException {
        Binding logBinding = bindingFactory.createBinding((Object)this.model, "logLevel", this.logLevels, "selectedItem", new BindingConvertor[0]);
        logBinding.setBindingType(Binding.Type.BI_DIRECTIONAL);
        BindingConvertor<LogLevel, String> logLevelConverter = new BindingConvertor<LogLevel, String>(){

            public String sourceToTarget(LogLevel value) {
                return value.getDescription();
            }

            public LogLevel targetToSource(String value) {
                for (LogLevel level : LogLevel.values()) {
                    if (!level.getDescription().equals(value)) continue;
                    return level;
                }
                throw new IllegalArgumentException(String.format("'%s' does not correspond to a valid LogLevel value.", value));
            }
        };
        logBinding.setConversion((BindingConvertor)logLevelConverter);
        logBinding.initialize();
        logBinding.fireSourceChanged();
    }

    private void bindSqlText(BindingFactory bindingFactory) {
        XulTextbox sqlTextBox = (XulTextbox)this.document.getElementById("sql-textbox");
        String initSql = this.getDefaultSql();
        this.model.setSql(initSql);
        sqlTextBox.setValue(initSql);
        bindingFactory.setBindingType(Binding.Type.BI_DIRECTIONAL);
        bindingFactory.createBinding((Object)this.model, "sql", (Object)sqlTextBox, "value", new BindingConvertor[0]);
    }

    private String getDefaultSql() {
        return "SELECT * FROM \"" + this.dataService.getName() + "\"";
    }

    public void executeSql() throws KettleException {
        this.resetMetrics();
        this.dataServiceExec = this.getNewDataServiceExecutor(true);
        this.updateOptimizationImpact(this.dataServiceExec);
        this.updateModel(this.dataServiceExec);
        this.callback.onLogChannelUpdate();
        this.dataServiceExec.executeQuery(this.getDataServiceRowListener());
        this.pollForCompletion(this.dataServiceExec);
    }

    private void pollForCompletion(final DataServiceExecutor dataServiceExec) {
        final Trans svcTrans = dataServiceExec.getServiceTrans();
        final Trans genTrans = dataServiceExec.getGenTrans();
        this.completionPollTimer = new Timer("DataServiceTesterTimer");
        final long startMillis = System.currentTimeMillis();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                DataServiceTestController.this.document.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (DataServiceTestController.this.model.isExecuting()) {
                            DataServiceTestController.this.checkMaxRows(dataServiceExec);
                            DataServiceTestController.this.checkForFailures(dataServiceExec);
                            DataServiceTestController.this.updateExecutingMessage(startMillis, dataServiceExec);
                            if (DataServiceTestController.this.anyTransErrors(dataServiceExec) || DataServiceTestController.this.transDone(svcTrans, genTrans)) {
                                DataServiceTestController.this.handleCompletion(dataServiceExec);
                                DataServiceTestController.this.completionPollTimer.cancel();
                            }
                        }
                    }
                });
            }
        };
        this.completionPollTimer.schedule(task, 500L, 500L);
    }

    private boolean transDone(Trans svcTrans, Trans genTrans) {
        return svcTrans.isFinishedOrStopped() && genTrans.isFinishedOrStopped();
    }

    private boolean anyTransErrors(DataServiceExecutor dataServiceExec) {
        return dataServiceExec.getServiceTrans().getErrors() > 0 || dataServiceExec.getGenTrans().getErrors() > 0;
    }

    private void checkForFailures(DataServiceExecutor dataServiceExec) {
        if (this.anyTransErrors(dataServiceExec)) {
            this.setErrorAlertMessage();
            this.stopDataService(dataServiceExec);
        }
    }

    private void checkMaxRows(DataServiceExecutor dataServiceExec) {
        if (this.model.getMaxRows() > 0 && this.model.getMaxRows() <= this.model.getResultRows().size()) {
            this.stopDataService(dataServiceExec);
        }
    }

    private void stopDataService(DataServiceExecutor dataServiceExec) {
        dataServiceExec.stop();
    }

    private void updateExecutingMessage(long start, DataServiceExecutor dataServiceExec) {
        if (!this.anyTransErrors(dataServiceExec)) {
            this.model.setAlertMessage(BaseMessages.getString(PKG, (String)"DataServiceTest.RowsReturned.Text", (Object[])new Object[]{this.model.getResultRows().size(), System.currentTimeMillis() - start}));
        }
    }

    private void handleCompletion(DataServiceExecutor dataServiceExec) {
        this.maybeSetErrorAlert(dataServiceExec);
        this.transMeta.setName(this.transName);
        this.model.setExecuting(false);
        this.callback.onExecuteComplete();
    }

    private void resetMetrics() {
        this.resetMetrics(this.model.getServiceTransLogChannel());
        this.resetMetrics(this.model.getGenTransLogChannel());
    }

    private void resetMetrics(LogChannelInterface logChannel) {
        LoggingRegistry loggingRegistry = LoggingRegistry.getInstance();
        MetricsRegistry metricsRegistry = MetricsRegistry.getInstance();
        if (logChannel != null) {
            for (String channelId : loggingRegistry.getLogChannelChildren(logChannel.getLogChannelId())) {
                metricsRegistry.getSnapshotLists().remove(channelId);
            }
        }
    }

    public void previewQueries() throws KettleException {
        DataServiceExecutor dataServiceExec = this.getNewDataServiceExecutor(false);
        this.updateOptimizationImpact(dataServiceExec);
    }

    private void updateOptimizationImpact(DataServiceExecutor dataServiceExec) {
        this.model.clearOptimizationImpact();
        for (PushDownOptimizationMeta optMeta : this.dataService.getPushDownOptimizationMeta()) {
            this.model.addOptimizationImpact(optMeta.preview(dataServiceExec));
        }
    }

    private void maybeSetErrorAlert(DataServiceExecutor dataServiceExec) {
        if (dataServiceExec.getGenTrans().getErrors() > 0 || dataServiceExec.getServiceTrans() != null && dataServiceExec.getServiceTrans().getErrors() > 0) {
            this.setErrorAlertMessage();
        }
    }

    private void setErrorAlertMessage() {
        this.model.setAlertMessage(BaseMessages.getString(PKG, (String)"DataServiceTest.Errors.Label", (String[])new String[0]));
    }

    protected DataServiceExecutor getNewDataServiceExecutor(boolean enableMetrics) throws KettleException {
        try {
            this.resetVariablesAndParameters();
            return new DataServiceExecutor.Builder(new SQL(this.model.getSql()), this.dataService, this.context).rowLimit(this.model.getMaxRows()).logLevel(this.model.getLogLevel()).enableMetrics(enableMetrics).build();
        }
        catch (KettleException e) {
            this.model.setAlertMessage(e.getMessage());
            throw e;
        }
    }

    private void resetVariablesAndParameters() throws KettleException {
        for (StepMeta stepMeta : this.transMeta.getSteps()) {
            DatabaseMeta dbMeta;
            if (!(stepMeta.getStepMetaInterface() instanceof TableInputMeta) || (dbMeta = ((TableInputMeta)stepMeta.getStepMetaInterface()).getDatabaseMeta()) == null) continue;
            dbMeta.copyVariablesFrom((VariableSpace)this.transMeta);
        }
        if (this.startingParameterValues.listParameters().length > 0) {
            this.transMeta.copyParametersFrom(this.startingParameterValues);
        }
    }

    private void updateModel(DataServiceExecutor dataServiceExec) throws KettleException {
        this.model.setExecuting(true);
        this.model.setResultRowMeta(this.sqlFieldsToRowMeta(dataServiceExec));
        this.model.clearResultRows();
        this.model.setAlertMessage("");
        this.model.setServiceTransLogChannel(dataServiceExec.getServiceTrans().getLogChannel());
        this.model.setGenTransLogChannel(dataServiceExec.getGenTrans().getLogChannel());
    }

    private RowMetaInterface sqlFieldsToRowMeta(DataServiceExecutor dataServiceExec) throws KettleException {
        List fields = dataServiceExec.getSql().getSelectFields().getFields();
        RowMetaInterface rowMeta = dataServiceExec.getSql().getRowMeta();
        RowMeta sqlFieldsRowMeta = new RowMeta();
        List<String> fieldNames = Arrays.asList(rowMeta.getFieldNames());
        for (SQLField field : fields) {
            int indexOfField = fieldNames.indexOf(field.getField());
            sqlFieldsRowMeta.addValueMeta(rowMeta.getValueMeta(indexOfField));
        }
        return sqlFieldsRowMeta;
    }

    private RowListener getDataServiceRowListener() {
        return new RowListener(){

            public void rowReadEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                DataServiceTestController.this.model.addResultRow(row);
                DataServiceTestController.this.model.setResultRowMeta(rowMeta);
            }

            public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
            }

            public void errorRowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                DataServiceTestController.this.model.addResultRow(row);
            }
        };
    }

    public void close() throws KettleException {
        this.cleanupCurrentExec();
        this.resetVariablesAndParameters();
        this.clearLogLines();
        this.callback.onClose();
    }

    private void cleanupCurrentExec() {
        if (this.completionPollTimer != null) {
            this.completionPollTimer.cancel();
        }
        if (this.dataServiceExec != null) {
            this.stopDataService(this.dataServiceExec);
        }
        this.model.setExecuting(false);
    }

    private void clearLogLines() {
        if (this.model.getGenTransLogChannel() != null) {
            KettleLogStore.discardLines((String)this.model.getGenTransLogChannel().getLogChannelId(), (boolean)true);
        }
        if (this.model.getServiceTransLogChannel() != null) {
            KettleLogStore.discardLines((String)this.model.getServiceTransLogChannel().getLogChannelId(), (boolean)true);
        }
    }

    public void setCallback(DataServiceTestCallback callback) {
        this.callback = callback;
    }
}

