/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.osgi.platform.plugin.deployer.impl.handlers.pluginxml;

import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginHandlingException;
import org.pentaho.osgi.platform.plugin.deployer.api.PluginMetadata;
import org.pentaho.osgi.platform.plugin.deployer.impl.JSONUtil;
import org.pentaho.osgi.platform.plugin.deployer.impl.handlers.PluginXmlFileHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PluginXmlStaticPathsHandler
extends PluginXmlFileHandler {
    public static final String STATIC_RESOURCES_FILE = "META-INF/js/staticResources.json";
    public static final String BLUEPRINT_BEAN_NS = "http://www.osgi.org/xmlns/blueprint/v1.0.0";
    public static final String BEAN = "bean";
    public static final String PROPERTY = "property";
    public static final String SERVICE = "service";
    public static final String ID_ATTR = "id";
    public static final String REF_ATTR = "ref";
    public static final String INTERFACE_ATTR = "interface";
    public static final String CLASS_ATTR = "class";
    public static final String NAME_ATTR = "name";
    public static final String VALUE_ATTR = "value";
    public static final String ALIAS = "alias";
    public static final String PATH = "path";
    public static final String RESOURCE_MAPPING = "org.ops4j.pax.web.extender.whiteboard.ResourceMapping";
    public static final String DEFAULT_RESOURCE_MAPPING = "org.ops4j.pax.web.extender.whiteboard.runtime.DefaultResourceMapping";
    private JSONUtil jsonUtil;

    public PluginXmlStaticPathsHandler() {
        super("//static-path");
    }

    public void setJsonUtil(JSONUtil jsonUtil) {
        this.jsonUtil = jsonUtil;
    }

    @Override
    protected void handle(String relativePath, List<Node> nodes, PluginMetadata pluginMetadata) throws PluginHandlingException {
        String topLevelFolder = relativePath.split("/")[0];
        Document blueprint = pluginMetadata.getBlueprint();
        boolean foundResources = false;
        HashMap<String, String> urlToResourceMapping = new HashMap<String, String>();
        for (Node node : nodes) {
            Map<String, String> attributes = this.getAttributes(node);
            String url = attributes.get("url");
            String localFolder = attributes.get("localFolder");
            if (url == null || localFolder == null) continue;
            url = "/content" + url;
            foundResources = true;
            Element bean = blueprint.createElementNS(BLUEPRINT_BEAN_NS, BEAN);
            Element aliasProperty = blueprint.createElementNS(BLUEPRINT_BEAN_NS, PROPERTY);
            Element pathProperty = blueprint.createElementNS(BLUEPRINT_BEAN_NS, PROPERTY);
            Element service = blueprint.createElementNS(BLUEPRINT_BEAN_NS, SERVICE);
            blueprint.getDocumentElement().appendChild(bean);
            bean.appendChild(aliasProperty);
            bean.appendChild(pathProperty);
            blueprint.getDocumentElement().appendChild(service);
            String id = this.getResourceMappingId(url, localFolder);
            this.setAttribute(blueprint, bean, ID_ATTR, id);
            this.setAttribute(blueprint, bean, CLASS_ATTR, DEFAULT_RESOURCE_MAPPING);
            this.setAttribute(blueprint, aliasProperty, NAME_ATTR, ALIAS);
            this.setAttribute(blueprint, aliasProperty, VALUE_ATTR, url);
            this.setAttribute(blueprint, pathProperty, NAME_ATTR, PATH);
            String path = "/" + topLevelFolder + "/" + localFolder;
            this.setAttribute(blueprint, pathProperty, VALUE_ATTR, path);
            this.setAttribute(blueprint, service, ID_ATTR, id + "Service");
            this.setAttribute(blueprint, service, REF_ATTR, id);
            this.setAttribute(blueprint, service, INTERFACE_ATTR, RESOURCE_MAPPING);
            urlToResourceMapping.put(url, path);
        }
        if (foundResources) {
            Map<String, String> imports = pluginMetadata.getManifestUpdater().getImports();
            imports.put("org.ops4j.pax.web.extender.whiteboard", null);
            imports.put("org.ops4j.pax.web.extender.whiteboard.runtime", null);
            imports.put("org.osgi.service.blueprint", "[1.0.0,2.0.0)");
            pluginMetadata.getManifestUpdater().getExportServices().add(RESOURCE_MAPPING);
            FileWriter fileWriter = null;
            try {
                fileWriter = pluginMetadata.getFileWriter(STATIC_RESOURCES_FILE);
                fileWriter.write(this.jsonUtil.prettyPrintMapStringString(urlToResourceMapping));
            }
            catch (IOException e) {
                throw new PluginHandlingException(e);
            }
            finally {
                if (fileWriter != null) {
                    try {
                        fileWriter.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    protected String getResourceMappingId(String url, String localFile) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.camelCaseJoin(url));
        sb.append("MappingTo");
        sb.append(this.camelCaseJoin(localFile));
        return sb.toString();
    }
}

