/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeDefinitionJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.GlobalSecondaryIndexJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.KeySchemaElementJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.LocalSecondaryIndexJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ProvisionedThroughputJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.StreamSpecificationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class CreateTableRequestMarshaller
implements Marshaller<Request<CreateTableRequest>, CreateTableRequest> {
    public Request<CreateTableRequest> marshall(CreateTableRequest createTableRequest) {
        if (createTableRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createTableRequest, "AmazonDynamoDBv2");
        request.addHeader("X-Amz-Target", "DynamoDB_20120810.CreateTable");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<GlobalSecondaryIndex> globalSecondaryIndexesList;
            List<LocalSecondaryIndex> localSecondaryIndexesList;
            List<KeySchemaElement> keySchemaList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            List<AttributeDefinition> attributeDefinitionsList = createTableRequest.getAttributeDefinitions();
            if (attributeDefinitionsList != null) {
                jsonWriter.key("AttributeDefinitions");
                jsonWriter.array();
                for (AttributeDefinition attributeDefinitionsListValue : attributeDefinitionsList) {
                    if (attributeDefinitionsListValue == null) continue;
                    AttributeDefinitionJsonMarshaller.getInstance().marshall(attributeDefinitionsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (createTableRequest.getTableName() != null) {
                jsonWriter.key("TableName").value((Object)createTableRequest.getTableName());
            }
            if ((keySchemaList = createTableRequest.getKeySchema()) != null) {
                jsonWriter.key("KeySchema");
                jsonWriter.array();
                for (KeySchemaElement keySchemaListValue : keySchemaList) {
                    if (keySchemaListValue == null) continue;
                    KeySchemaElementJsonMarshaller.getInstance().marshall(keySchemaListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if ((localSecondaryIndexesList = createTableRequest.getLocalSecondaryIndexes()) != null) {
                jsonWriter.key("LocalSecondaryIndexes");
                jsonWriter.array();
                for (LocalSecondaryIndex localSecondaryIndexesListValue : localSecondaryIndexesList) {
                    if (localSecondaryIndexesListValue == null) continue;
                    LocalSecondaryIndexJsonMarshaller.getInstance().marshall(localSecondaryIndexesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if ((globalSecondaryIndexesList = createTableRequest.getGlobalSecondaryIndexes()) != null) {
                jsonWriter.key("GlobalSecondaryIndexes");
                jsonWriter.array();
                for (GlobalSecondaryIndex globalSecondaryIndexesListValue : globalSecondaryIndexesList) {
                    if (globalSecondaryIndexesListValue == null) continue;
                    GlobalSecondaryIndexJsonMarshaller.getInstance().marshall(globalSecondaryIndexesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (createTableRequest.getProvisionedThroughput() != null) {
                jsonWriter.key("ProvisionedThroughput");
                ProvisionedThroughputJsonMarshaller.getInstance().marshall(createTableRequest.getProvisionedThroughput(), jsonWriter);
            }
            if (createTableRequest.getStreamSpecification() != null) {
                jsonWriter.key("StreamSpecification");
                StreamSpecificationJsonMarshaller.getInstance().marshall(createTableRequest.getStreamSpecification(), jsonWriter);
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

