/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.transform.AttributeDefinitionJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.GlobalSecondaryIndexDescriptionJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.KeySchemaElementJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.LocalSecondaryIndexDescriptionJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.ProvisionedThroughputDescriptionJsonMarshaller;
import com.amazonaws.services.dynamodbv2.model.transform.StreamSpecificationJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class TableDescriptionJsonMarshaller {
    private static TableDescriptionJsonMarshaller instance;

    public void marshall(TableDescription tableDescription, JSONWriter jsonWriter) {
        if (tableDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<GlobalSecondaryIndexDescription> globalSecondaryIndexesList;
            List<LocalSecondaryIndexDescription> localSecondaryIndexesList;
            List<KeySchemaElement> keySchemaList;
            jsonWriter.object();
            List<AttributeDefinition> attributeDefinitionsList = tableDescription.getAttributeDefinitions();
            if (attributeDefinitionsList != null) {
                jsonWriter.key("AttributeDefinitions");
                jsonWriter.array();
                for (AttributeDefinition attributeDefinitionsListValue : attributeDefinitionsList) {
                    if (attributeDefinitionsListValue == null) continue;
                    AttributeDefinitionJsonMarshaller.getInstance().marshall(attributeDefinitionsListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (tableDescription.getTableName() != null) {
                jsonWriter.key("TableName").value((Object)tableDescription.getTableName());
            }
            if ((keySchemaList = tableDescription.getKeySchema()) != null) {
                jsonWriter.key("KeySchema");
                jsonWriter.array();
                for (KeySchemaElement keySchemaListValue : keySchemaList) {
                    if (keySchemaListValue == null) continue;
                    KeySchemaElementJsonMarshaller.getInstance().marshall(keySchemaListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (tableDescription.getTableStatus() != null) {
                jsonWriter.key("TableStatus").value((Object)tableDescription.getTableStatus());
            }
            if (tableDescription.getCreationDateTime() != null) {
                jsonWriter.key("CreationDateTime").value(tableDescription.getCreationDateTime());
            }
            if (tableDescription.getProvisionedThroughput() != null) {
                jsonWriter.key("ProvisionedThroughput");
                ProvisionedThroughputDescriptionJsonMarshaller.getInstance().marshall(tableDescription.getProvisionedThroughput(), jsonWriter);
            }
            if (tableDescription.getTableSizeBytes() != null) {
                jsonWriter.key("TableSizeBytes").value((Object)tableDescription.getTableSizeBytes());
            }
            if (tableDescription.getItemCount() != null) {
                jsonWriter.key("ItemCount").value((Object)tableDescription.getItemCount());
            }
            if (tableDescription.getTableArn() != null) {
                jsonWriter.key("TableArn").value((Object)tableDescription.getTableArn());
            }
            if ((localSecondaryIndexesList = tableDescription.getLocalSecondaryIndexes()) != null) {
                jsonWriter.key("LocalSecondaryIndexes");
                jsonWriter.array();
                for (LocalSecondaryIndexDescription localSecondaryIndexesListValue : localSecondaryIndexesList) {
                    if (localSecondaryIndexesListValue == null) continue;
                    LocalSecondaryIndexDescriptionJsonMarshaller.getInstance().marshall(localSecondaryIndexesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if ((globalSecondaryIndexesList = tableDescription.getGlobalSecondaryIndexes()) != null) {
                jsonWriter.key("GlobalSecondaryIndexes");
                jsonWriter.array();
                for (GlobalSecondaryIndexDescription globalSecondaryIndexesListValue : globalSecondaryIndexesList) {
                    if (globalSecondaryIndexesListValue == null) continue;
                    GlobalSecondaryIndexDescriptionJsonMarshaller.getInstance().marshall(globalSecondaryIndexesListValue, jsonWriter);
                }
                jsonWriter.endArray();
            }
            if (tableDescription.getStreamSpecification() != null) {
                jsonWriter.key("StreamSpecification");
                StreamSpecificationJsonMarshaller.getInstance().marshall(tableDescription.getStreamSpecification(), jsonWriter);
            }
            if (tableDescription.getLatestStreamLabel() != null) {
                jsonWriter.key("LatestStreamLabel").value((Object)tableDescription.getLatestStreamLabel());
            }
            if (tableDescription.getLatestStreamArn() != null) {
                jsonWriter.key("LatestStreamArn").value((Object)tableDescription.getLatestStreamArn());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TableDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TableDescriptionJsonMarshaller();
        }
        return instance;
    }
}

