/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hbase.rowdecoder;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceLocator;
import org.pentaho.big.data.kettle.plugins.hbase.mapping.MappingEditor;
import org.pentaho.big.data.kettle.plugins.hbase.rowdecoder.HBaseRowDecoderMeta;
import org.pentaho.bigdata.api.hbase.mapping.Mapping;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.action.RuntimeTestActionService;

public class HBaseRowDecoderDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static final Class<?> PKG = HBaseRowDecoderMeta.class;
    private Label m_stepnameLabel;
    private Text m_stepnameText;
    private CTabFolder m_wTabFolder;
    private CTabItem m_wConfigTab;
    private CTabItem m_editorTab;
    private CCombo m_incomingKeyCombo;
    private CCombo m_incomingResultCombo;
    private MappingEditor m_mappingEditor;
    private final HBaseRowDecoderMeta m_currentMeta;
    private final HBaseRowDecoderMeta m_originalMeta;
    private final NamedClusterService namedClusterService;
    private final RuntimeTestActionService runtimeTestActionService;
    private final RuntimeTester runtimeTester;
    private final NamedClusterServiceLocator namedClusterServiceLocator;

    public HBaseRowDecoderDialog(Shell parent, Object in, TransMeta tr, String name, NamedClusterService namedClusterService, RuntimeTestActionService runtimeTestActionService, RuntimeTester runtimeTester, NamedClusterServiceLocator namedClusterServiceLocator) {
        super(parent, (BaseStepMeta)in, tr, name);
        this.namedClusterService = namedClusterService;
        this.runtimeTestActionService = runtimeTestActionService;
        this.runtimeTester = runtimeTester;
        this.namedClusterServiceLocator = namedClusterServiceLocator;
        this.m_currentMeta = (HBaseRowDecoderMeta)((Object)in);
        this.m_originalMeta = (HBaseRowDecoderMeta)((Object)this.m_currentMeta.clone());
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.m_currentMeta);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HBaseRowDecoderDialog.this.m_currentMeta.setChanged();
            }
        };
        this.changed = this.m_currentMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"HBaseRowDecoderDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.m_stepnameLabel = new Label((Composite)this.shell, 131072);
        this.m_stepnameLabel.setText(BaseMessages.getString(PKG, (String)"HBaseRowDecoderDialog.StepName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.m_stepnameLabel);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(middle, -margin);
        fd.top = new FormAttachment(0, margin);
        this.m_stepnameLabel.setLayoutData((Object)fd);
        this.m_stepnameText = new Text((Composite)this.shell, 18436);
        this.m_stepnameText.setText(this.stepname);
        this.props.setLook((Control)this.m_stepnameText);
        this.m_stepnameText.addModifyListener(lsMod);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment(0, margin);
        fd.right = new FormAttachment(100, 0);
        this.m_stepnameText.setLayoutData((Object)fd);
        this.m_wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.m_wTabFolder, 5);
        this.m_wTabFolder.setSimple(false);
        this.m_wConfigTab = new CTabItem(this.m_wTabFolder, 0);
        this.m_wConfigTab.setText(BaseMessages.getString(PKG, (String)"HBaseRowDecoderDialog.ConfigTab.TabTitle", (String[])new String[0]));
        Composite wConfigComp = new Composite((Composite)this.m_wTabFolder, 0);
        this.props.setLook((Control)wConfigComp);
        FormLayout configLayout = new FormLayout();
        configLayout.marginWidth = 3;
        configLayout.marginHeight = 3;
        wConfigComp.setLayout((Layout)configLayout);
        Label inKeyLab = new Label(wConfigComp, 131072);
        inKeyLab.setText(BaseMessages.getString(PKG, (String)"HBaseRowDecoderDialog.KeyField.Label", (String[])new String[0]));
        this.props.setLook((Control)inKeyLab);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, margin);
        fd.right = new FormAttachment(middle, -margin);
        inKeyLab.setLayoutData((Object)fd);
        this.m_incomingKeyCombo = new CCombo(wConfigComp, 2048);
        this.props.setLook((Control)this.m_incomingKeyCombo);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment(0, margin);
        fd.right = new FormAttachment(100, 0);
        this.m_incomingKeyCombo.setLayoutData((Object)fd);
        this.m_incomingKeyCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HBaseRowDecoderDialog.this.m_currentMeta.setChanged();
                HBaseRowDecoderDialog.this.m_incomingKeyCombo.setToolTipText(HBaseRowDecoderDialog.this.transMeta.environmentSubstitute(HBaseRowDecoderDialog.this.m_incomingKeyCombo.getText()));
            }
        });
        Label inResultLab = new Label(wConfigComp, 131072);
        inResultLab.setText(BaseMessages.getString(PKG, (String)"HBaseRowDecoderDialog.ResultField.Label", (String[])new String[0]));
        this.props.setLook((Control)inResultLab);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_incomingKeyCombo, margin);
        fd.right = new FormAttachment(middle, -margin);
        inResultLab.setLayoutData((Object)fd);
        this.m_incomingResultCombo = new CCombo(wConfigComp, 2048);
        this.props.setLook((Control)this.m_incomingResultCombo);
        fd = new FormData();
        fd.left = new FormAttachment(middle, 0);
        fd.top = new FormAttachment((Control)this.m_incomingKeyCombo, margin);
        fd.right = new FormAttachment(100, 0);
        this.m_incomingResultCombo.setLayoutData((Object)fd);
        this.m_incomingResultCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HBaseRowDecoderDialog.this.m_currentMeta.setChanged();
                HBaseRowDecoderDialog.this.m_incomingResultCombo.setToolTipText(HBaseRowDecoderDialog.this.transMeta.environmentSubstitute(HBaseRowDecoderDialog.this.m_incomingResultCombo.getText()));
            }
        });
        this.populateFieldsCombo();
        wConfigComp.layout();
        this.m_wConfigTab.setControl((Control)wConfigComp);
        this.m_editorTab = new CTabItem(this.m_wTabFolder, 0);
        this.m_editorTab.setText(BaseMessages.getString(PKG, (String)"HBaseRowDecoderDialog.MappingEditorTab.TabTitle", (String[])new String[0]));
        this.m_mappingEditor = new MappingEditor(this.shell, (Composite)this.m_wTabFolder, null, null, 65538, false, this.props, this.transMeta, this.namedClusterService, this.runtimeTestActionService, this.runtimeTester, this.namedClusterServiceLocator);
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, -margin * 2);
        fd.right = new FormAttachment(100, 0);
        this.m_mappingEditor.setLayoutData(fd);
        this.m_mappingEditor.layout();
        this.m_editorTab.setControl((Control)this.m_mappingEditor);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.m_stepnameText, margin);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, -50);
        this.m_wTabFolder.setLayoutData((Object)fd);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, (Control)this.m_wTabFolder);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                HBaseRowDecoderDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                HBaseRowDecoderDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                HBaseRowDecoderDialog.this.ok();
            }
        };
        this.m_stepnameText.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                HBaseRowDecoderDialog.this.cancel();
            }
        });
        this.m_wTabFolder.setSelection(0);
        this.setSize();
        this.getData();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void cancel() {
        this.stepname = null;
        this.m_currentMeta.setChanged(this.changed);
        this.dispose();
    }

    protected void ok() {
        if (Const.isEmpty((String)this.m_stepnameText.getText())) {
            return;
        }
        this.stepname = this.m_stepnameText.getText();
        this.m_currentMeta.setIncomingKeyField(this.m_incomingKeyCombo.getText());
        this.m_currentMeta.setIncomingResultField(this.m_incomingResultCombo.getText());
        ArrayList<String> problems = new ArrayList<String>();
        Mapping mapping = this.m_mappingEditor.getMapping(false, problems, false);
        if (problems.size() > 0) {
            StringBuffer p = new StringBuffer();
            for (String s : problems) {
                p.append(s).append("\n");
            }
            MessageDialog md = new MessageDialog(this.shell, BaseMessages.getString(PKG, (String)"HBaseRowDecoderDialog.Error.IssuesWithMapping.Title", (String[])new String[0]), null, BaseMessages.getString(PKG, (String)"HBaseRowDecoderDialog.Error.IssuesWithMapping", (String[])new String[0]) + ":\n\n" + p.toString(), 4, new String[]{BaseMessages.getString(PKG, (String)"HBaseRowDecoderDialog.Error.IssuesWithMapping.ButtonOK", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HBaseRowDecoderDialog.Error.IssuesWithMapping.ButtonCancel", (String[])new String[0])}, 0);
            MessageDialog.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
            int idx = md.open() & 0xFF;
            if (idx == 1 || idx == 255) {
                return;
            }
        }
        if (mapping != null) {
            this.m_currentMeta.setMapping(mapping);
        }
        if (!((Object)((Object)this.m_originalMeta)).equals((Object)this.m_currentMeta)) {
            this.m_currentMeta.setChanged();
            this.changed = this.m_currentMeta.hasChanged();
        }
        this.dispose();
    }

    protected void getData() {
        if (!Const.isEmpty((String)this.m_currentMeta.getIncomingKeyField())) {
            this.m_incomingKeyCombo.setText(this.m_currentMeta.getIncomingKeyField());
        }
        if (!Const.isEmpty((String)this.m_currentMeta.getIncomingResultField())) {
            this.m_incomingResultCombo.setText(this.m_currentMeta.getIncomingResultField());
        }
        if (this.m_currentMeta.getMapping() != null) {
            this.m_mappingEditor.setMapping(this.m_currentMeta.getMapping());
        }
    }

    private void populateFieldsCombo() {
        block14: {
            StepMeta stepMeta = this.transMeta.findStep(this.stepname);
            String currentKey = this.m_incomingKeyCombo.getText();
            String currentResult = this.m_incomingResultCombo.getText();
            int keyIndex = -1;
            int valueIndex = -1;
            if (stepMeta != null) {
                try {
                    RowMetaInterface rowMeta = this.transMeta.getPrevStepFields(stepMeta);
                    if (rowMeta != null && rowMeta.size() > 0) {
                        this.m_incomingKeyCombo.removeAll();
                        this.m_incomingResultCombo.removeAll();
                        for (int i = 0; i < rowMeta.size(); ++i) {
                            ValueMetaInterface vm = rowMeta.getValueMeta(i);
                            String fieldName = vm.getName();
                            if (fieldName.equalsIgnoreCase("key")) {
                                keyIndex = i;
                            } else if (fieldName.equalsIgnoreCase("value")) {
                                valueIndex = i;
                            }
                            this.m_incomingKeyCombo.add(fieldName);
                            this.m_incomingResultCombo.add(fieldName);
                        }
                        if (!Const.isEmpty((String)currentKey)) {
                            this.m_incomingKeyCombo.setText(currentKey);
                        } else if (keyIndex >= 0) {
                            this.m_incomingKeyCombo.select(keyIndex);
                        }
                        if (!Const.isEmpty((String)currentResult)) {
                            this.m_incomingResultCombo.setText(currentResult);
                        } else if (valueIndex >= 0) {
                            this.m_incomingResultCombo.select(valueIndex);
                        }
                    }
                }
                catch (KettleException ex) {
                    if (!this.log.isError()) break block14;
                    this.log.logError("Error populating fields", (Throwable)ex);
                }
            }
        }
    }
}

