/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.pdi.ws;

import com.pentaho.di.messages.Messages;
import com.pentaho.pdi.ws.IRepositorySyncWebService;
import com.pentaho.pdi.ws.RepositorySyncException;
import com.pentaho.pdi.ws.RepositorySyncStatus;
import com.sun.xml.bind.StringInputStream;
import java.io.InputStream;
import java.io.Serializable;
import javax.jws.WebService;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@WebService(endpointInterface="com.pentaho.pdi.ws.IRepositorySyncWebService", serviceName="repositorySync", portName="repositorySyncPort", targetNamespace="http://www.pentaho.org/ws/1.0")
public class RepositorySyncWebService
implements IRepositorySyncWebService,
Serializable {
    private static final long serialVersionUID = 743647084187858081L;
    private static Log log = LogFactory.getLog(RepositorySyncWebService.class);
    private static final String SINGLE_DI_SERVER_INSTANCE = "singleDiServerInstance";

    @Override
    public RepositorySyncStatus sync(String repositoryId, String repositoryUrl) throws RepositorySyncException {
        NodeList list;
        Element node;
        boolean singleDiServerInstance = "true".equals(PentahoSystem.getSystemSetting((String)SINGLE_DI_SERVER_INSTANCE, (String)"true"));
        if (singleDiServerInstance) {
            return RepositorySyncStatus.SINGLE_DI_SERVER_INSTANCE;
        }
        RepositoriesMeta repositoriesMeta = new RepositoriesMeta();
        try {
            repositoriesMeta.readData();
        }
        catch (Exception e) {
            log.error((Object)Messages.getInstance().getString("RepositorySyncWebService.UNABLE_TO_READ_DATA"), (Throwable)e);
            throw new RepositorySyncException(Messages.getInstance().getString("RepositorySyncWebService.UNABLE_TO_READ_DATA"), e);
        }
        RepositoryMeta repositoryMeta = repositoriesMeta.findRepository(repositoryId);
        if (repositoryMeta == null) {
            try {
                repositoryMeta = RepositorySyncWebService.getRepositoryMeta(repositoryId, repositoryUrl);
                if (repositoryMeta == null) {
                    log.error((Object)Messages.getInstance().getString("RepositorySyncWebService.UNABLE_TO_LOAD_PLUGIN"));
                    throw new RepositorySyncException(Messages.getInstance().getString("RepositorySyncWebService.UNABLE_TO_LOAD_PLUGIN"));
                }
                repositoriesMeta.addRepository(repositoryMeta);
                repositoriesMeta.writeData();
                return RepositorySyncStatus.REGISTERED;
            }
            catch (KettleException e) {
                log.error((Object)Messages.getInstance().getString("RepositorySyncWebService.UNABLE_TO_REGISTER_REPOSITORY", new Object[]{repositoryId}), (Throwable)e);
                throw new RepositorySyncException(Messages.getInstance().getString("RepositorySyncWebService.UNABLE_TO_REGISTER_REPOSITORY", new Object[]{repositoryId}), (Exception)((Object)e));
            }
        }
        String xml = repositoryMeta.getXML();
        try {
            node = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse((InputStream)new StringInputStream(xml)).getDocumentElement();
        }
        catch (Exception e) {
            node = null;
        }
        if (node != null && (list = node.getElementsByTagName("repository_location_url")) != null && list.getLength() == 1) {
            String url = list.item(0).getTextContent();
            if (url.equals(repositoryUrl)) {
                String fullyQualifiedServerUrl = null;
                if (PentahoSystem.getApplicationContext().getFullyQualifiedServerURL() != null) {
                    fullyQualifiedServerUrl = PentahoSystem.getApplicationContext().getFullyQualifiedServerURL();
                    if (url.endsWith("/")) {
                        url = url.substring(0, url.length() - 2);
                    }
                    if (fullyQualifiedServerUrl.endsWith("/")) {
                        fullyQualifiedServerUrl = fullyQualifiedServerUrl.substring(0, fullyQualifiedServerUrl.length() - 2);
                    }
                    if (url.startsWith(fullyQualifiedServerUrl)) {
                        return RepositorySyncStatus.ALREADY_REGISTERED;
                    }
                }
                log.error((Object)Messages.getInstance().getString("RepositorySyncWebService.FULLY_QUALIFIED_SERVER_URL_SYNC_PROBLEM", new Object[]{fullyQualifiedServerUrl, url}));
                throw new RepositorySyncException(Messages.getInstance().getString("RepositorySyncWebService.FULLY_QUALIFIED_SERVER_URL_SYNC_PROBLEM", new Object[]{fullyQualifiedServerUrl, url}));
            }
            log.error((Object)Messages.getInstance().getString("RepositorySyncWebService.REPOSITORY_URL_SYNC_PROBLEM", new Object[]{repositoryId, url, repositoryUrl}));
            throw new RepositorySyncException(Messages.getInstance().getString("RepositorySyncWebService.REPOSITORY_URL_SYNC_PROBLEM", new Object[]{repositoryId, url, repositoryUrl}));
        }
        log.error((Object)Messages.getInstance().getString("RepositorySyncWebService.REPOSITORY_URL_XML_PARSING_PROBLEM", new Object[]{repositoryId, xml}));
        throw new RepositorySyncException(Messages.getInstance().getString("RepositorySyncWebService.REPOSITORY_URL_XML_PARSING_PROBLEM_CLIENT_MESSAGE", new Object[]{repositoryId}));
    }

    private static RepositoryMeta getRepositoryMeta(String repositoryId, String repositoryUrl) throws KettleException {
        Element node;
        RepositoryMeta repMeta = (RepositoryMeta)PluginRegistry.getInstance().loadClass(RepositoryPluginType.class, "PentahoEnterpriseRepository", RepositoryMeta.class);
        if (repMeta == null) {
            return null;
        }
        String xml = "<repo><id>PentahoEnterpriseRepository</id><name>" + repositoryId + "</name>" + "<description>" + repositoryId + "</description>" + "<repository_location_url>" + repositoryUrl + "</repository_location_url> </repo>";
        try {
            node = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse((InputStream)new StringInputStream(xml)).getDocumentElement();
        }
        catch (Exception e) {
            node = null;
        }
        repMeta.loadXML(node, null);
        return repMeta;
    }
}

