/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.io.Serializable;
import java.util.List;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.BaseRepositoryMeta;
import org.pentaho.di.repository.RepositoryCapabilities;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.pur.PurRepositoryLocation;
import org.w3c.dom.Node;

public class PurRepositoryMeta
extends BaseRepositoryMeta
implements RepositoryMeta,
Serializable {
    private static final long serialVersionUID = -2456840196232185649L;
    public static String REPOSITORY_TYPE_ID = "PentahoEnterpriseRepository";
    private PurRepositoryLocation repositoryLocation;
    private boolean versionCommentMandatory;

    public PurRepositoryMeta() {
        super(REPOSITORY_TYPE_ID);
    }

    public PurRepositoryMeta(String id, String name, String description, PurRepositoryLocation repositoryLocation, boolean versionCommentMandatory) {
        super(id, name, description);
        this.repositoryLocation = repositoryLocation;
        this.versionCommentMandatory = versionCommentMandatory;
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(100);
        retval.append("  ").append(XMLHandler.openTag((String)"repository"));
        retval.append(super.getXML());
        retval.append("    ").append(XMLHandler.addTagValue((String)"repository_location_url", (String)this.repositoryLocation.getUrl()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"version_comment_mandatory", (boolean)this.versionCommentMandatory));
        retval.append("  ").append(XMLHandler.closeTag((String)"repository"));
        return retval.toString();
    }

    public void loadXML(Node repnode, List<DatabaseMeta> databases) throws KettleException {
        super.loadXML(repnode, databases);
        try {
            String url = XMLHandler.getTagValue((Node)repnode, (String)"repository_location_url");
            String urlTrim = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
            this.repositoryLocation = new PurRepositoryLocation(urlTrim);
            this.versionCommentMandatory = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)repnode, (String)"version_comment_mandatory"));
        }
        catch (Exception e) {
            throw new KettleException("Unable to load Kettle database repository meta object", (Throwable)e);
        }
    }

    public RepositoryCapabilities getRepositoryCapabilities() {
        return new RepositoryCapabilities(){

            public boolean supportsUsers() {
                return true;
            }

            public boolean managesUsers() {
                return true;
            }

            public boolean isReadOnly() {
                return false;
            }

            public boolean supportsRevisions() {
                return true;
            }

            public boolean supportsMetadata() {
                return true;
            }

            public boolean supportsLocking() {
                return true;
            }

            public boolean hasVersionRegistry() {
                return true;
            }

            public boolean supportsAcls() {
                return true;
            }

            public boolean supportsReferences() {
                return true;
            }
        };
    }

    public PurRepositoryLocation getRepositoryLocation() {
        return this.repositoryLocation;
    }

    public void setRepositoryLocation(PurRepositoryLocation repositoryLocation) {
        this.repositoryLocation = repositoryLocation;
    }

    public boolean isVersionCommentMandatory() {
        return this.versionCommentMandatory;
    }

    public void setVersionCommentMandatory(boolean versionCommentMandatory) {
        this.versionCommentMandatory = versionCommentMandatory;
    }

    public RepositoryMeta clone() {
        return new PurRepositoryMeta(REPOSITORY_TYPE_ID, this.getName(), this.getDescription(), this.getRepositoryLocation(), this.isVersionCommentMandatory());
    }
}

