/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.pur;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.ObjectRecipient;
import org.pentaho.di.repository.pur.model.ObjectAce;
import org.pentaho.di.repository.pur.model.ObjectAcl;
import org.pentaho.di.repository.pur.model.RepositoryObjectAce;
import org.pentaho.di.repository.pur.model.RepositoryObjectAcl;
import org.pentaho.di.repository.pur.model.RepositoryObjectRecipient;
import org.pentaho.di.ui.repository.pur.services.IConnectionAclService;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAce;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.repository2.unified.RepositoryFileSid;

public class UnifiedRepositoryConnectionAclService
implements IConnectionAclService {
    private final IUnifiedRepository pur;

    public UnifiedRepositoryConnectionAclService(IUnifiedRepository pur) {
        this.pur = pur;
    }

    @Override
    public ObjectAcl getAcl(ObjectId fileId, boolean forceParentInheriting) throws KettleException {
        List aces;
        RepositoryFileAcl acl = null;
        try {
            acl = this.pur.getAcl((Serializable)((Object)fileId.getId()));
        }
        catch (Exception drfe) {
            throw new KettleException((Throwable)drfe);
        }
        RepositoryFileSid sid = acl.getOwner();
        RepositoryObjectRecipient owner = new RepositoryObjectRecipient(sid.getName());
        if (sid.getType().equals((Object)RepositoryFileSid.Type.USER)) {
            owner.setType(ObjectRecipient.Type.USER);
        } else {
            owner.setType(ObjectRecipient.Type.ROLE);
        }
        RepositoryObjectAcl objectAcl = new RepositoryObjectAcl(owner);
        if (forceParentInheriting) {
            objectAcl.setEntriesInheriting(true);
            aces = this.pur.getEffectiveAces(acl.getId(), true);
        } else {
            objectAcl.setEntriesInheriting(acl.isEntriesInheriting());
            aces = acl.isEntriesInheriting() ? this.pur.getEffectiveAces(acl.getId()) : acl.getAces();
        }
        ArrayList<ObjectAce> objectAces = new ArrayList<ObjectAce>();
        for (RepositoryFileAce ace : aces) {
            EnumSet permissions = ace.getPermissions();
            EnumSet<RepositoryFilePermission> permissionSet = EnumSet.noneOf(RepositoryFilePermission.class);
            RepositoryFileSid aceSid = ace.getSid();
            RepositoryObjectRecipient recipient = new RepositoryObjectRecipient(aceSid.getName());
            if (aceSid.getType().equals((Object)RepositoryFileSid.Type.USER)) {
                recipient.setType(ObjectRecipient.Type.USER);
            } else {
                recipient.setType(ObjectRecipient.Type.ROLE);
            }
            permissionSet.addAll(permissions);
            objectAces.add(new RepositoryObjectAce(recipient, permissionSet));
        }
        objectAcl.setAces(objectAces);
        return objectAcl;
    }

    @Override
    public void setAcl(ObjectId fileId, ObjectAcl objectAcl) throws KettleException {
        try {
            RepositoryFileAcl acl = this.pur.getAcl((Serializable)((Object)fileId.getId()));
            RepositoryFileAcl.Builder newAclBuilder = new RepositoryFileAcl.Builder(acl).entriesInheriting(objectAcl.isEntriesInheriting()).clearAces();
            if (!objectAcl.isEntriesInheriting()) {
                List<ObjectAce> aces = objectAcl.getAces();
                for (ObjectAce objectAce : aces) {
                    EnumSet<RepositoryFilePermission> permissions = objectAce.getPermissions();
                    EnumSet<RepositoryFilePermission> permissionSet = EnumSet.noneOf(RepositoryFilePermission.class);
                    ObjectRecipient recipient = objectAce.getRecipient();
                    RepositoryFileSid sid = recipient.getType().equals((Object)ObjectRecipient.Type.ROLE) ? new RepositoryFileSid(recipient.getName(), RepositoryFileSid.Type.ROLE) : new RepositoryFileSid(recipient.getName());
                    if (permissions != null) {
                        permissionSet.addAll(permissions);
                    }
                    newAclBuilder.ace(sid, permissionSet);
                }
            }
            this.pur.updateAcl(newAclBuilder.build());
        }
        catch (Exception drfe) {
            throw new KettleException((Throwable)drfe);
        }
    }

    @Override
    public boolean hasAccess(ObjectId id, RepositoryFilePermission perm) throws KettleException {
        RepositoryFile repositoryFile = this.pur.getFileById((Serializable)((Object)id.getId()));
        return this.pur.hasAccess(repositoryFile.getPath(), EnumSet.of(perm));
    }
}

