/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.database.dialect;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.pentaho.database.DatabaseDialectException;
import org.pentaho.database.IDatabaseDialect;
import org.pentaho.database.IValueMeta;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.database.model.IDatabaseConnection;

public abstract class AbstractDatabaseDialect
implements IDatabaseDialect,
Serializable {
    private static final long serialVersionUID = 4949841921392501602L;
    public static final int CLOB_LENGTH = 9999999;
    public static final String CR = " ";

    @Override
    public int getDefaultDatabasePort() {
        return this.getDatabaseType().getDefaultDatabasePort();
    }

    @Override
    public boolean supportsSetCharacterStream() {
        return true;
    }

    @Override
    public boolean supportsAutoInc() {
        return true;
    }

    @Override
    public String getLimitClause(int nrRows) {
        return "";
    }

    @Override
    public int getNotFoundTK(boolean use_autoinc) {
        return 0;
    }

    @Override
    public String getSQLNextSequenceValue(String sequenceName) {
        return "";
    }

    @Override
    public String getSQLCurrentSequenceValue(String sequenceName) {
        return "";
    }

    @Override
    public String getSQLSequenceExists(String sequenceName) {
        return "";
    }

    @Override
    public boolean isFetchSizeSupported() {
        return true;
    }

    @Override
    public boolean needsPlaceHolder() {
        return false;
    }

    @Override
    public boolean supportsSchemas() {
        return true;
    }

    @Override
    public boolean supportsCatalogs() {
        return true;
    }

    @Override
    public boolean supportsEmptyTransactions() {
        return true;
    }

    @Override
    public String getFunctionSum() {
        return "SUM";
    }

    @Override
    public String getFunctionAverage() {
        return "AVG";
    }

    @Override
    public String getFunctionMinimum() {
        return "MIN";
    }

    @Override
    public String getFunctionMaximum() {
        return "MAX";
    }

    @Override
    public String getFunctionCount() {
        return "COUNT";
    }

    @Override
    public String getSchemaTableCombination(String schema_name, String table_part) {
        return schema_name + "." + table_part;
    }

    @Override
    public int getMaxTextFieldLength() {
        return 9999999;
    }

    @Override
    public int getMaxVARCHARLength() {
        return 9999999;
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsSequences() {
        return false;
    }

    @Override
    public boolean supportsBitmapIndex() {
        return true;
    }

    @Override
    public boolean supportsSetLong() {
        return true;
    }

    @Override
    public String getDropColumnStatement(String tablename, IValueMeta v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " DROP " + v.getName() + CR;
    }

    @Override
    public String[] getReservedWords() {
        return new String[0];
    }

    @Override
    public boolean quoteReservedWords() {
        return true;
    }

    @Override
    public String getStartQuote() {
        return "\"";
    }

    @Override
    public String getEndQuote() {
        return "\"";
    }

    @Override
    public boolean supportsRepository() {
        return true;
    }

    @Override
    public String[] getTableTypes() {
        return new String[]{"TABLE"};
    }

    @Override
    public String[] getViewTypes() {
        return new String[]{"VIEW"};
    }

    @Override
    public String[] getSynonymTypes() {
        return new String[]{"SYNONYM"};
    }

    @Override
    public boolean useSchemaNameForTableList() {
        return false;
    }

    @Override
    public boolean supportsViews() {
        return true;
    }

    @Override
    public boolean supportsSynonyms() {
        return false;
    }

    @Override
    public String getSQLListOfProcedures(IDatabaseConnection connection) {
        return null;
    }

    @Override
    public String getTruncateTableStatement(String tableName) {
        return "TRUNCATE TABLE " + tableName;
    }

    @Override
    public String getSQLQueryFields(String tableName) {
        return "SELECT * FROM " + tableName;
    }

    @Override
    public boolean supportsFloatRoundingOnUpdate() {
        return true;
    }

    @Override
    public String getSQLLockTables(String[] tableNames) {
        return null;
    }

    @Override
    public String getSQLUnlockTables(String[] tableNames) {
        return null;
    }

    @Override
    public boolean supportsTimeStampToDateConversion() {
        return true;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public boolean supportsBooleanDataType() {
        return true;
    }

    @Override
    public boolean isDefaultingToUppercase() {
        return true;
    }

    @Override
    public boolean supportsSetMaxRows() {
        return true;
    }

    @Override
    public String getSQLTableExists(String tablename) {
        return "SELECT 1 FROM " + tablename;
    }

    @Override
    public String getSQLColumnExists(String columnname, String tablename) {
        return "SELECT " + columnname + " FROM " + tablename;
    }

    @Override
    public boolean needsToLockAllTables() {
        return true;
    }

    @Override
    public boolean isRequiringTransactionsOnQueries() {
        return true;
    }

    @Override
    public abstract String getURL(IDatabaseConnection var1) throws DatabaseDialectException;

    @Override
    public String getURLWithExtraOptions(IDatabaseConnection connection) throws DatabaseDialectException {
        StringBuffer url = new StringBuffer(this.getURL(connection));
        if (this.supportsOptionsInURL()) {
            String optionIndicator = this.getExtraOptionIndicator();
            String optionSeparator = this.getExtraOptionSeparator();
            String valueSeparator = this.getExtraOptionValueSeparator();
            Map<String, String> map = connection.getExtraOptions();
            if (map.size() > 0) {
                Iterator<String> iterator = map.keySet().iterator();
                boolean first = true;
                while (iterator.hasNext()) {
                    String typedParameter = iterator.next();
                    int dotIndex = typedParameter.indexOf(46);
                    if (dotIndex < 0) continue;
                    String typeCode = typedParameter.substring(0, dotIndex);
                    String parameter = typedParameter.substring(dotIndex + 1);
                    String value = map.get(typedParameter);
                    if (!connection.getDatabaseType().getShortName().equals(typeCode)) continue;
                    if (first && url.indexOf(valueSeparator) == -1) {
                        url.append(optionIndicator);
                    } else {
                        url.append(optionSeparator);
                    }
                    url.append(parameter);
                    if (!AbstractDatabaseDialect.isEmpty(value)) {
                        url.append(valueSeparator).append(value);
                    }
                    first = false;
                }
            }
        }
        return url.toString();
    }

    @Override
    public abstract String getAddColumnStatement(String var1, IValueMeta var2, String var3, boolean var4, String var5, boolean var6);

    @Override
    public abstract String getModifyColumnStatement(String var1, IValueMeta var2, String var3, boolean var4, String var5, boolean var6);

    @Override
    public abstract String getFieldDefinition(IValueMeta var1, String var2, String var3, boolean var4, boolean var5, boolean var6);

    @Override
    public String getExtraOptionsHelpText() {
        return this.getDatabaseType().getExtraOptionsHelpUrl();
    }

    @Override
    public abstract String[] getUsedLibraries();

    @Override
    public abstract String getNativeDriver();

    @Override
    public boolean supportsOptionsInURL() {
        return true;
    }

    @Override
    public abstract String getNativeJdbcPre();

    @Override
    public IDatabaseConnection createNativeConnection(String jdbcUrl) {
        if (!jdbcUrl.startsWith(this.getNativeJdbcPre())) {
            throw new RuntimeException("JDBC URL " + jdbcUrl + " does not start with " + this.getNativeJdbcPre());
        }
        DatabaseConnection dbconn = new DatabaseConnection();
        dbconn.setDatabaseType(this.getDatabaseType());
        dbconn.setAccessType(DatabaseAccessType.NATIVE);
        String str = jdbcUrl.substring(this.getNativeJdbcPre().length());
        String hostname = null;
        String port = null;
        String databaseNameAndParams = null;
        if (str.indexOf(":") >= 0) {
            hostname = str.substring(0, str.indexOf(":"));
            if ((str = str.substring(str.indexOf(":") + 1)).indexOf("/") >= 0) {
                port = str.substring(0, str.indexOf("/"));
                databaseNameAndParams = str.substring(str.indexOf("/") + 1);
            } else {
                port = str;
            }
        } else if (str.indexOf("/") >= 0) {
            hostname = str.substring(0, str.indexOf("/"));
            databaseNameAndParams = str.substring(str.indexOf("/") + 1);
        } else {
            databaseNameAndParams = str;
        }
        if (hostname != null) {
            dbconn.setHostname(hostname);
        }
        if (port != null) {
            dbconn.setDatabasePort(port);
        }
        if (databaseNameAndParams != null) {
            this.setDatabaseNameAndParams(dbconn, databaseNameAndParams);
        }
        return dbconn;
    }

    protected void setDatabaseNameAndParams(DatabaseConnection dbconn, String databaseNameAndParams) {
        int paramIndex;
        if (this.supportsOptionsInURL() && (paramIndex = databaseNameAndParams.indexOf(this.getExtraOptionIndicator())) >= 0) {
            String[] paramData;
            String params = databaseNameAndParams.substring(paramIndex + 1);
            databaseNameAndParams = databaseNameAndParams.substring(0, paramIndex);
            for (String param : paramData = params.split(this.getExtraOptionSeparator())) {
                String[] nameAndValue = param.split(this.getExtraOptionValueSeparator());
                if (nameAndValue[0] == null || nameAndValue[0].trim().length() <= 0) continue;
                if (nameAndValue.length == 1) {
                    dbconn.addExtraOption(dbconn.getDatabaseType().getShortName(), nameAndValue[0], "");
                    continue;
                }
                dbconn.addExtraOption(dbconn.getDatabaseType().getShortName(), nameAndValue[0], nameAndValue[1]);
            }
        }
        dbconn.setDatabaseName(databaseNameAndParams);
    }

    @Override
    public String getDriverClass(IDatabaseConnection connection) {
        if (connection.getAccessType() == DatabaseAccessType.ODBC) {
            return "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        return this.getNativeDriver();
    }

    @Override
    public boolean supportsGetBlob() {
        return true;
    }

    @Override
    public String getExtraOptionSeparator() {
        return ";";
    }

    @Override
    public String getExtraOptionValueSeparator() {
        return "=";
    }

    @Override
    public String getExtraOptionIndicator() {
        return ";";
    }

    public static final boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static final int toInt(String str, int def) {
        int retval;
        try {
            retval = Integer.parseInt(str);
        }
        catch (Exception e) {
            retval = def;
        }
        return retval;
    }
}

