/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.database.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.database.IDatabaseDialect;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.model.IDatabaseType;
import org.pentaho.database.service.IDatabaseDialectService;

public class DatabaseDialectService
implements IDatabaseDialectService {
    private static ServiceLoader<IDatabaseDialect> dialectLoader = ServiceLoader.load(IDatabaseDialect.class);
    private static final Log logger = LogFactory.getLog(DatabaseDialectService.class);
    private static final List<IDatabaseDialect> validDatabaseDialects = new ArrayList<IDatabaseDialect>();
    private static final List<IDatabaseType> validDatabaseTypes = new ArrayList<IDatabaseType>();
    private static final Map<IDatabaseType, IDatabaseDialect> validTypeToDialectMap = new HashMap<IDatabaseType, IDatabaseDialect>();
    private static final List<IDatabaseDialect> allDatabaseDialects = new ArrayList<IDatabaseDialect>();
    private static final List<IDatabaseType> allDatabaseTypes = new ArrayList<IDatabaseType>();
    private static final Map<IDatabaseType, IDatabaseDialect> allTypeToDialectMap = new HashMap<IDatabaseType, IDatabaseDialect>();
    private boolean isOnlyReturnAvailable = true;

    private static void validateAndCatalogServices() {
        for (IDatabaseDialect dialect : dialectLoader) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Checking for presence of %s ( %s )", dialect.getDatabaseType().getName(), dialect.getNativeDriver()));
            }
            allDatabaseTypes.add(dialect.getDatabaseType());
            allTypeToDialectMap.put(dialect.getDatabaseType(), dialect);
            allDatabaseDialects.add(dialect);
            if (DatabaseDialectService.validateJdbcDriverClass(dialect.getNativeDriver())) {
                validDatabaseTypes.add(dialect.getDatabaseType());
                validTypeToDialectMap.put(dialect.getDatabaseType(), dialect);
                validDatabaseDialects.add(dialect);
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)String.format("%s not detected.", dialect.getDatabaseType().getName()));
        }
    }

    private static boolean validateJdbcDriverClass(String classname) {
        block7: {
            if (classname == null) {
                return true;
            }
            try {
                Class.forName(classname);
                return true;
            }
            catch (NoClassDefFoundError e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"classExists returning false", (Throwable)e);
                }
            }
            catch (ClassNotFoundException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"classExists returning false", (Throwable)e);
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block7;
                logger.debug((Object)"classExists returning false", (Throwable)e);
            }
        }
        return false;
    }

    public DatabaseDialectService() {
        this(true);
    }

    public DatabaseDialectService(boolean validateClasses) {
        this.isOnlyReturnAvailable = validateClasses;
    }

    @Override
    public void registerDatabaseDialect(IDatabaseDialect databaseDialect) {
    }

    @Override
    public void registerDatabaseDialect(IDatabaseDialect databaseDialect, boolean validateClassExists) {
    }

    @Override
    public boolean validateJdbcDriverClassExists(String classname) {
        return DatabaseDialectService.validateJdbcDriverClass(classname);
    }

    @Override
    public List<IDatabaseType> getDatabaseTypes() {
        return Collections.unmodifiableList(this.isOnlyReturnAvailable ? validDatabaseTypes : allDatabaseTypes);
    }

    @Override
    public IDatabaseDialect getDialect(IDatabaseType databaseType) {
        if (this.isOnlyReturnAvailable) {
            return validTypeToDialectMap.get(databaseType);
        }
        return allTypeToDialectMap.get(databaseType);
    }

    @Override
    public IDatabaseDialect getDialect(IDatabaseConnection connection) {
        if (this.isOnlyReturnAvailable) {
            return validTypeToDialectMap.get(connection.getDatabaseType());
        }
        return allTypeToDialectMap.get(connection.getDatabaseType());
    }

    @Override
    public List<IDatabaseDialect> getDatabaseDialects() {
        return Collections.unmodifiableList(this.isOnlyReturnAvailable ? validDatabaseDialects : allDatabaseDialects);
    }

    static {
        DatabaseDialectService.validateAndCatalogServices();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Valid databaseDialects list ...");
            for (IDatabaseDialect dialect : validDatabaseDialects) {
                logger.debug((Object)String.format(" ... %s ( %s )", dialect.getDatabaseType().getName(), dialect.getDatabaseType().getShortName()));
            }
            logger.debug((Object)"All databaseDialects list ...");
            for (IDatabaseDialect dialect : allDatabaseDialects) {
                logger.debug((Object)String.format(" ... %s ( %s )", dialect.getDatabaseType().getName(), dialect.getDatabaseType().getShortName()));
            }
        }
    }
}

