/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.Command;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserSpace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class CommandList
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    static final long serialVersionUID = 6L;
    public static final String ALL = "*ALL";
    private AS400 sys_;
    private String lib_;
    private String cmd_;
    private static final ProgramParameter parm0_ = new ProgramParameter(new byte[]{-61, -44, -60, -45, -30, -29, 64, 64, 64, 64, -40, -29, -59, -44, -41, 64, 64, 64, 64, 64, 64});
    private static final ProgramParameter parm1_ = new ProgramParameter(new byte[]{-42, -62, -47, -45, -16, -14, -16, -16});
    private static final ProgramParameter parm3_ = new ProgramParameter(new byte[]{92, -61, -44, -60, 64, 64, 64, 64, 64, 64});
    private static final ProgramParameter parm4_ = new ProgramParameter(new byte[4]);
    private transient PropertyChangeSupport propertyChangeListeners_ = new PropertyChangeSupport(this);

    public CommandList() {
        this.initializeTransient();
    }

    public CommandList(AS400 aS400, String string, String string2) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("library");
        }
        if (string2 == null) {
            throw new NullPointerException("command");
        }
        this.sys_ = aS400;
        this.lib_ = string;
        this.cmd_ = string2;
        this.initializeTransient();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeListeners_.addPropertyChangeListener(propertyChangeListener);
    }

    public String getCommand() {
        return this.cmd_;
    }

    public String getLibrary() {
        return this.lib_;
    }

    public AS400 getSystem() {
        return this.sys_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Command[] generateList() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Generating list of commands using library filter '" + this.lib_ + "' and command filter '" + this.cmd_ + "'.");
        }
        if (this.sys_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.lib_ == null) {
            throw new ExtendedIllegalStateException("library", 4);
        }
        if (this.cmd_ == null) {
            throw new ExtendedIllegalStateException("command", 4);
        }
        AS400 aS400 = this.sys_;
        synchronized (aS400) {
            UserSpace userSpace = new UserSpace(this.sys_, "/QSYS.LIB/QTEMP.LIB/CMDLST.USRSPC");
            userSpace.setMustUseProgramCall(true);
            userSpace.create(140, true, " ", (byte)0, "", ALL);
            CharConverter charConverter = new CharConverter(37);
            String string = this.cmd_.toUpperCase().trim();
            while (string.length() < 10) {
                string = string + ' ';
            }
            String string2 = this.lib_.toUpperCase().trim();
            while (string2.length() < 10) {
                string2 = string2 + ' ';
            }
            ProgramParameter[] programParameterArray = new ProgramParameter[]{parm0_, parm1_, new ProgramParameter(charConverter.stringToByteArray(string + string2)), parm3_, parm4_};
            CharConverter charConverter2 = new CharConverter(this.sys_.getCcsid());
            ProgramCall programCall = new ProgramCall(this.sys_, "/QSYS.LIB/QUSLOBJ.PGM", programParameterArray);
            programCall.setThreadSafe(true);
            if (!programCall.run()) {
                AS400Message[] aS400MessageArray = programCall.getMessageList();
                throw new AS400Exception(aS400MessageArray);
            }
            byte[] byArray = new byte[140];
            userSpace.read(byArray, 0, 0, 140);
            int n = BinaryConverter.byteArrayToInt(byArray, 124);
            int n2 = BinaryConverter.byteArrayToInt(byArray, 132);
            int n3 = BinaryConverter.byteArrayToInt(byArray, 136);
            int n4 = n + n2 * n3;
            byArray = new byte[n4];
            userSpace.read(byArray, 0, 0, n4);
            userSpace.close();
            Command[] commandArray = new Command[n2];
            int n5 = n;
            for (int i = 0; i < n2; ++i) {
                String string3 = charConverter2.byteArrayToString(byArray, n5, 10).trim();
                String string4 = charConverter2.byteArrayToString(byArray, n5 + 10, 10).trim();
                String string5 = charConverter2.byteArrayToString(byArray, n5 + 41, 50).trim();
                String string6 = QSYSObjectPathName.toPath(string4, string3, "CMD");
                commandArray[i] = new Command(this.sys_, string6, string5);
                n5 += n3;
            }
            if (Trace.isTraceOn()) {
                Trace.log(1, "Successfully generated command list with " + n2 + " entries.");
            }
            return commandArray;
        }
    }

    private void initializeTransient() {
        this.propertyChangeListeners_ = new PropertyChangeSupport(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        this.propertyChangeListeners_.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCommand(String string) {
        if (string == null) {
            throw new NullPointerException("command");
        }
        CommandList commandList = this;
        synchronized (commandList) {
            String string2 = this.cmd_;
            this.cmd_ = string;
            this.propertyChangeListeners_.firePropertyChange("command", string2, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLibrary(String string) {
        if (string == null) {
            throw new NullPointerException("library");
        }
        CommandList commandList = this;
        synchronized (commandList) {
            String string2 = this.lib_;
            this.lib_ = string;
            this.propertyChangeListeners_.firePropertyChange("library", string2, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSystem(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        CommandList commandList = this;
        synchronized (commandList) {
            AS400 aS4002 = this.sys_;
            this.sys_ = aS400;
            this.propertyChangeListeners_.firePropertyChange("system", aS4002, aS400);
        }
    }

    public String toString() {
        return super.toString() + "[" + this.lib_ + ";" + this.cmd_ + "]";
    }
}

