/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

class PoolItemProperties {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private long creationTime_;
    private long lastUseTime_ = 0L;
    private long timeIdleInPool_ = this.creationTime_ = System.currentTimeMillis();
    private int timesUsedCount_ = 0;

    public void clear() {
        this.creationTime_ = 0L;
        this.timeIdleInPool_ = 0L;
        this.lastUseTime_ = 0L;
        this.timesUsedCount_ = 0;
    }

    private long getElapsedTime(long l) {
        if (l == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - l;
    }

    public long getInactivityTime() {
        return this.getElapsedTime(this.timeIdleInPool_);
    }

    public long getInUseTime() {
        if (this.isInUse()) {
            return this.getElapsedTime(this.lastUseTime_);
        }
        return this.lastUseTime_;
    }

    public long getLifeSpan() {
        return this.getElapsedTime(this.creationTime_);
    }

    public int getUseCount() {
        return this.timesUsedCount_;
    }

    public boolean isInUse() {
        return this.lastUseTime_ != 0L;
    }

    void setInUse(boolean bl) {
        if (bl) {
            this.timeIdleInPool_ = 0L;
            this.lastUseTime_ = System.currentTimeMillis();
            ++this.timesUsedCount_;
        } else {
            this.timeIdleInPool_ = System.currentTimeMillis();
            this.lastUseTime_ = 0L;
        }
    }
}

