/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.runtime;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.optimizer.ParallelismSetter;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.optimizer.TezEstimatedParallelismClearer;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.VertexManagerPluginContext;
import org.apache.tez.dag.api.event.VertexState;
import org.apache.tez.dag.api.event.VertexStateUpdate;
import org.apache.tez.dag.library.vertexmanager.ShuffleVertexManager;

public class PigGraceShuffleVertexManager
extends ShuffleVertexManager {
    private TezOperPlan tezPlan;
    private List<String> grandParents = new ArrayList<String>();
    private List<String> finishedGrandParents = new ArrayList<String>();
    private long bytesPerTask;
    private Configuration conf;
    private PigContext pc;
    private int thisParallelism = -1;
    private boolean parallelismSet = false;
    private static final Log LOG = LogFactory.getLog(PigGraceShuffleVertexManager.class);

    public PigGraceShuffleVertexManager(VertexManagerPluginContext context) {
        super(context);
    }

    public synchronized void initialize() {
        try {
            this.conf = TezUtils.createConfFromUserPayload((UserPayload)this.getContext().getUserPayload());
            this.bytesPerTask = this.conf.getLong("pig.exec.reducers.bytes.per.reducer", 1000000000L);
            this.pc = (PigContext)ObjectSerializer.deserialize(this.conf.get("pig.pigContext"));
            this.tezPlan = (TezOperPlan)ObjectSerializer.deserialize(this.conf.get("pig.tez.plan"));
            TezEstimatedParallelismClearer clearer = new TezEstimatedParallelismClearer(this.tezPlan);
            try {
                clearer.visit();
            }
            catch (VisitorException e) {
                throw new TezUncheckedException((Throwable)e);
            }
            TezOperator op = (TezOperator)this.tezPlan.getOperator(OperatorKey.fromString(this.getContext().getVertexName()));
            Function<TezOperator, String> tezOpToString = new Function<TezOperator, String>(){

                public String apply(TezOperator op) {
                    return op.getOperatorKey().toString();
                }
            };
            this.grandParents = Lists.transform(TezOperPlan.getGrandParentsForGraceParallelism(this.tezPlan, op), (Function)tezOpToString);
        }
        catch (IOException e) {
            throw new TezUncheckedException((Throwable)e);
        }
        for (String grandParent : this.grandParents) {
            this.getContext().registerForVertexStateUpdates(grandParent, EnumSet.of(VertexState.SUCCEEDED));
        }
        super.initialize();
    }

    public synchronized void onVertexStateUpdated(VertexStateUpdate stateUpdate) {
        List<TezOperator> predPreds;
        super.onVertexStateUpdated(stateUpdate);
        if (this.parallelismSet) {
            return;
        }
        String vertexName = stateUpdate.getVertexName();
        if (this.grandParents.contains(vertexName) && !this.finishedGrandParents.contains(vertexName)) {
            this.finishedGrandParents.add(vertexName);
        }
        TezOperator op = (TezOperator)this.tezPlan.getOperator(OperatorKey.fromString(this.getContext().getVertexName()));
        List<TezOperator> preds = this.tezPlan.getPredecessors(op);
        boolean anyPredAboutToStart = false;
        for (TezOperator pred : preds) {
            predPreds = this.tezPlan.getPredecessors(pred);
            boolean predAboutToStart = true;
            for (TezOperator predPred : predPreds) {
                if (this.finishedGrandParents.contains(predPred.getOperatorKey().toString())) continue;
                predAboutToStart = false;
                break;
            }
            if (!predAboutToStart) continue;
            LOG.info((Object)("All predecessors for " + pred.getOperatorKey().toString() + " are finished, time to " + "set parallelism for " + this.getContext().getVertexName()));
            anyPredAboutToStart = true;
            break;
        }
        if (anyPredAboutToStart) {
            for (TezOperator pred : preds) {
                if (pred.getRequestedParallelism() != -1 || (predPreds = this.tezPlan.getPredecessors(pred)) == null) continue;
                for (TezOperator predPred : predPreds) {
                    String predPredVertexName = predPred.getOperatorKey().toString();
                    if (!this.finishedGrandParents.contains(predPredVertexName)) continue;
                    long outputSize = this.getContext().getVertexStatistics(predPredVertexName).getOutputStatistics(pred.getOperatorKey().toString()).getDataSize();
                    int desiredNumReducers = (int)Math.ceil((double)outputSize / (double)this.bytesPerTask);
                    predPred.setEstimatedParallelism(desiredNumReducers);
                    LOG.info((Object)(this.getContext().getVertexName() + ": Grandparent " + predPred.getOperatorKey().toString() + " finished with actual output " + outputSize + " (desired parallelism " + desiredNumReducers + ")"));
                }
            }
            try {
                ParallelismSetter parallelismSetter = new ParallelismSetter(this.tezPlan, this.pc);
                parallelismSetter.visit();
                this.thisParallelism = op.getEstimatedParallelism();
            }
            catch (IOException e) {
                throw new TezUncheckedException((Throwable)e);
            }
            HashMap edgeManagers = new HashMap();
            for (Map.Entry entry : this.getContext().getInputVertexEdgeProperties().entrySet()) {
                EdgeProperty edge = (EdgeProperty)entry.getValue();
                edge = EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)edge.getDataSourceType(), (EdgeProperty.SchedulingType)edge.getSchedulingType(), (OutputDescriptor)edge.getEdgeSource(), (InputDescriptor)edge.getEdgeDestination());
                edgeManagers.put(entry.getKey(), edge);
            }
            this.getContext().reconfigureVertex(this.thisParallelism, null, edgeManagers);
            this.parallelismSet = true;
            LOG.info((Object)("Initialize parallelism for " + this.getContext().getVertexName() + " to " + this.thisParallelism));
        }
    }
}

