/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.util;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezEdgeDescriptor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POLocalRearrangeTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POStoreTez;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.operator.POValueOutputTez;
import org.apache.pig.builtin.RoundRobinPartitioner;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.runtime.library.input.UnorderedKVInput;
import org.apache.tez.runtime.library.output.UnorderedKVOutput;
import org.apache.tez.runtime.library.output.UnorderedPartitionedKVOutput;

public class TezCompilerUtil {
    public static String TUPLE_CLASS = TupleFactory.getInstance().tupleClass().getName();

    private TezCompilerUtil() {
    }

    public static void simpleConnectTwoVertex(TezOperPlan tezPlan, TezOperator op1, TezOperator op2, String scope, NodeIdGenerator nig) throws PlanException {
        PhysicalPlan ep = new PhysicalPlan();
        POProject prjStar = new POProject(new OperatorKey(scope, nig.getNextNodeId(scope)));
        prjStar.setResultType((byte)110);
        prjStar.setStar(true);
        ep.add(prjStar);
        ArrayList<PhysicalPlan> eps = new ArrayList<PhysicalPlan>();
        eps.add(ep);
        POLocalRearrangeTez lr = new POLocalRearrangeTez(new OperatorKey(scope, nig.getNextNodeId(scope)));
        try {
            lr.setIndex(0);
        }
        catch (ExecException e) {
            int errCode = 2058;
            String msg = "Unable to set index on the newly created POLocalRearrange.";
            throw new PlanException(msg, errCode, 4, (Throwable)e);
        }
        lr.setKeyType((byte)110);
        lr.setPlans(eps);
        lr.setResultType((byte)110);
        lr.setOutputKey(op2.getOperatorKey().toString());
        op1.plan.addAsLeaf(lr);
        POPackage pkg = new POPackage(new OperatorKey(scope, nig.getNextNodeId(scope)));
        pkg.getPkgr().setKeyType((byte)110);
        pkg.setNumInps(1);
        boolean[] inner = new boolean[]{false};
        pkg.getPkgr().setInner(inner);
        op2.plan.add(pkg);
        op2.plan.addAsLeaf(TezCompilerUtil.getForEachPlain(scope, nig));
        TezCompilerUtil.connect(tezPlan, op1, op2);
    }

    public static TezEdgeDescriptor connect(TezOperPlan plan, TezOperator from, TezOperator to) throws PlanException {
        PhysicalOperator leaf;
        plan.connect(from, to);
        if (!from.plan.isEmpty() && (leaf = (PhysicalOperator)from.plan.getLeaves().get(0)) instanceof POLocalRearrangeTez) {
            POLocalRearrangeTez lr = (POLocalRearrangeTez)leaf;
            lr.setOutputKey(to.getOperatorKey().toString());
        }
        TezEdgeDescriptor edge = new TezEdgeDescriptor();
        to.inEdges.put(from.getOperatorKey(), edge);
        from.outEdges.put(to.getOperatorKey(), edge);
        return edge;
    }

    public static void connectNoLRReconnect(TezOperPlan plan, TezOperator from, TezOperator to, TezEdgeDescriptor edge) throws PlanException {
        plan.connect(from, to);
        to.inEdges.put(from.getOperatorKey(), edge);
        from.outEdges.put(to.getOperatorKey(), edge);
    }

    public static POForEach getForEach(POProject project, int rp, String scope, NodeIdGenerator nig) {
        PhysicalPlan forEachPlan = new PhysicalPlan();
        forEachPlan.add(project);
        ArrayList forEachPlans = Lists.newArrayList();
        forEachPlans.add(forEachPlan);
        ArrayList flatten = Lists.newArrayList();
        flatten.add(true);
        POForEach forEach = new POForEach(new OperatorKey(scope, nig.getNextNodeId(scope)), rp, forEachPlans, flatten);
        forEach.setResultType((byte)120);
        return forEach;
    }

    public static POForEach getForEachPlain(String scope, NodeIdGenerator nig) {
        POProject project = new POProject(new OperatorKey(scope, nig.getNextNodeId(scope)));
        project.setResultType((byte)110);
        project.setStar(false);
        project.setColumn(1);
        project.setOverloaded(true);
        return TezCompilerUtil.getForEach(project, -1, scope, nig);
    }

    public static POStore getStore(String scope, NodeIdGenerator nig) {
        POStoreTez st = new POStoreTez(new OperatorKey(scope, nig.getNextNodeId(scope)));
        st.setIsTmpStore(true);
        return st;
    }

    public static void setCustomPartitioner(String customPartitioner, TezOperator tezOp) throws IOException {
        if (customPartitioner != null) {
            for (TezEdgeDescriptor edge : tezOp.inEdges.values()) {
                edge.partitionerClass = PigContext.resolveClassName(customPartitioner);
            }
        }
    }

    public static void configureValueOnlyTupleOutput(TezEdgeDescriptor edge, EdgeProperty.DataMovementType dataMovementType) {
        edge.dataMovementType = dataMovementType;
        if (dataMovementType == EdgeProperty.DataMovementType.BROADCAST || dataMovementType == EdgeProperty.DataMovementType.ONE_TO_ONE) {
            edge.outputClassName = UnorderedKVOutput.class.getName();
            edge.inputClassName = UnorderedKVInput.class.getName();
        } else if (dataMovementType == EdgeProperty.DataMovementType.SCATTER_GATHER) {
            edge.outputClassName = UnorderedPartitionedKVOutput.class.getName();
            edge.inputClassName = UnorderedKVInput.class.getName();
            edge.partitionerClass = RoundRobinPartitioner.class;
        }
        edge.setIntermediateOutputKeyClass(POValueOutputTez.EmptyWritable.class.getName());
        edge.setIntermediateOutputValueClass(TUPLE_CLASS);
    }

    public static boolean isIntermediateReducer(TezOperator tezOper) throws VisitorException {
        boolean intermediateReducer = false;
        LinkedList<POStore> stores = tezOper.getStores();
        if (stores.size() <= 0 && (tezOper.getLoaderInfo().getLoads() == null || tezOper.getLoaderInfo().getLoads().size() <= 0)) {
            intermediateReducer = true;
        }
        return intermediateReducer;
    }
}

