/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.scripting;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.ExecType;
import org.apache.pig.impl.util.UDFContext;

public class ScriptingOutputCapturer {
    private static Log log = LogFactory.getLog(ScriptingOutputCapturer.class);
    private static Map<String, String> outputFileNames = new HashMap<String, String>();
    private static String runId = UUID.randomUUID().toString();
    private static boolean captureOutput = false;
    private boolean instancedCapturingOutput = false;
    private ExecType execType;

    public ScriptingOutputCapturer(ExecType execType) {
        this.execType = execType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String getStandardOutputRootWriteLocation() throws IOException {
        conf = UDFContext.getUDFContext().getJobConf();
        jobId = conf.get("mapred.job.id");
        taskId = conf.get("mapred.task.id");
        hadoopLogDir = System.getProperty("yarn.app.container.log.dir");
        if (hadoopLogDir == null) {
            hadoopLogDir = conf.get("yarn.app.container.log.dir");
        }
        if (hadoopLogDir == null) {
            hadoopLogDir = System.getProperty("hadoop.log.dir");
        }
        if (hadoopLogDir == null) {
            hadoopLogDir = conf.get("hadoop.log.dir");
        }
        tmpDir = conf.get("hadoop.tmp.dir");
        v0 = fallbackToTmp = hadoopLogDir == null;
        if (!fallbackToTmp) {
            try {
                if (!new File(hadoopLogDir).canWrite()) {
                    fallbackToTmp = true;
                }
                ** if (!fallbackToTmp) goto lbl-1000
            }
            catch (SecurityException e) {
                try {
                    fallbackToTmp = true;
                    ** if (!fallbackToTmp) goto lbl-1000
                }
                catch (Throwable var8_10) {
                    if (fallbackToTmp) {
                        ScriptingOutputCapturer.log.warn((Object)String.format("Insufficient permission to write into %s. Change path to: %s", new Object[]{hadoopLogDir, tmpDir}));
                    }
                    throw var8_10;
                }
lbl-1000:
                // 1 sources

                {
                    ScriptingOutputCapturer.log.warn((Object)String.format("Insufficient permission to write into %s. Change path to: %s", new Object[]{hadoopLogDir, tmpDir}));
                }
lbl-1000:
                // 2 sources

                {
                }
            }
lbl-1000:
            // 1 sources

            {
                ScriptingOutputCapturer.log.warn((Object)String.format("Insufficient permission to write into %s. Change path to: %s", new Object[]{hadoopLogDir, tmpDir}));
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        if (fallbackToTmp) {
            hadoopLogDir = tmpDir;
        }
        ScriptingOutputCapturer.log.debug((Object)("JobId: " + jobId));
        ScriptingOutputCapturer.log.debug((Object)("TaskId: " + taskId));
        ScriptingOutputCapturer.log.debug((Object)("hadoopLogDir: " + hadoopLogDir));
        if (this.execType.isLocal() || conf.getBoolean("pig.job.converted.fetch", false)) {
            logDir = System.getProperty("pig.udf.scripting.log.dir");
            if (logDir == null) {
                logDir = ".";
            }
            return logDir + "/" + (taskId == null ? "" : taskId + "_");
        }
        taskLogDir = this.getTaskLogDir(jobId, taskId, hadoopLogDir);
        return taskLogDir + "/";
    }

    public String getTaskLogDir(String jobId, String taskId, String hadoopLogDir) throws IOException {
        String taskLogDir;
        String defaultUserLogDir = hadoopLogDir + File.separator + "userlogs";
        if (new File(defaultUserLogDir + File.separator + jobId).exists()) {
            taskLogDir = defaultUserLogDir + File.separator + jobId + File.separator + taskId;
        } else if (new File(defaultUserLogDir + File.separator + taskId).exists()) {
            taskLogDir = defaultUserLogDir + File.separator + taskId;
        } else if (new File(defaultUserLogDir).exists()) {
            taskLogDir = defaultUserLogDir;
        } else {
            taskLogDir = hadoopLogDir + File.separator + "udfOutput";
            File dir = new File(taskLogDir);
            dir.mkdirs();
            if (!dir.exists()) {
                throw new IOException("Could not create directory: " + taskLogDir);
            }
        }
        return taskLogDir;
    }

    public static void startCapturingOutput() {
        captureOutput = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getUdfOutput() throws IOException {
        HashMap<String, String> udfFuncNameToOutput = new HashMap<String, String>();
        for (Map.Entry<String, String> funcToOutputFileName : outputFileNames.entrySet()) {
            StringBuffer udfOutput = new StringBuffer();
            FileInputStream fis = new FileInputStream(funcToOutputFileName.getValue());
            InputStreamReader fr = new InputStreamReader((InputStream)fis, Charsets.UTF_8);
            BufferedReader br = new BufferedReader(fr);
            try {
                String line = br.readLine();
                while (line != null) {
                    udfOutput.append("\t" + line + "\n");
                    line = br.readLine();
                }
            }
            finally {
                br.close();
            }
            udfFuncNameToOutput.put(funcToOutputFileName.getKey(), udfOutput.toString());
        }
        return udfFuncNameToOutput;
    }

    public void registerOutputLocation(String functionName, String fileName) {
        outputFileNames.put(functionName, fileName);
    }

    public static String getRunId() {
        return runId;
    }

    public static boolean isClassCapturingOutput() {
        return captureOutput;
    }

    public boolean isInstanceCapturingOutput() {
        return this.instancedCapturingOutput;
    }

    public void setInstanceCapturingOutput(boolean instanceCapturingOutput) {
        this.instancedCapturingOutput = instanceCapturingOutput;
    }
}

