/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.cassandraoutput;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.cassandraoutput.CassandraOutput;
import org.pentaho.di.trans.steps.cassandraoutput.CassandraOutputData;
import org.w3c.dom.Node;

@Step(id="CassandraOutput", image="Cassandraout.svg", name="Cassandra Output", description="Writes to a Cassandra table", categoryDescription="Big Data")
public class CassandraOutputMeta
extends BaseStepMeta
implements StepMetaInterface {
    public static final Class<?> PKG = CassandraOutputMeta.class;
    protected String m_cassandraHost = "localhost";
    protected String m_cassandraPort = "9160";
    protected String m_username;
    protected String m_password;
    protected String m_cassandraKeyspace;
    protected String m_schemaHost;
    protected String m_schemaPort;
    protected String m_columnFamily = "";
    protected String m_consistency = "";
    protected String m_batchSize = "100";
    protected boolean m_unloggedBatch = false;
    protected boolean m_useCompression = false;
    protected boolean m_createColumnFamily = true;
    protected String m_createTableWithClause;
    protected String m_keyField = "";
    protected String m_socketTimeout = "";
    protected String m_cqlBatchTimeout = "";
    protected String m_cqlSubBatchSize = "10";
    protected boolean m_insertFieldsNotInMeta = false;
    protected boolean m_updateCassandraMeta = false;
    protected boolean m_truncateColumnFamily = false;
    protected String m_aprioriCQL = "";
    protected boolean m_dontComplainAboutAprioriCQLFailing;
    protected boolean m_useThriftIO = false;
    protected boolean m_useCQL3 = false;
    protected String m_ttl = "";
    protected String m_ttlUnit = TTLUnits.NONE.toString();

    public void setSchemaHost(String s) {
        this.m_schemaHost = s;
    }

    public String getSchemaHost() {
        return this.m_schemaHost;
    }

    public void setSchemaPort(String p) {
        this.m_schemaPort = p;
    }

    public String getSchemaPort() {
        return this.m_schemaPort;
    }

    public void setCQLSubBatchSize(String f) {
        this.m_cqlSubBatchSize = f;
    }

    public String getCQLSubBatchSize() {
        return this.m_cqlSubBatchSize;
    }

    public void setCQLBatchInsertTimeout(String t) {
        this.m_cqlBatchTimeout = t;
    }

    public String getCQLBatchInsertTimeout() {
        return this.m_cqlBatchTimeout;
    }

    public void setSocketTimeout(String t) {
        this.m_socketTimeout = t;
    }

    public String getSocketTimeout() {
        return this.m_socketTimeout;
    }

    public void setCassandraHost(String host) {
        this.m_cassandraHost = host;
    }

    public String getCassandraHost() {
        return this.m_cassandraHost;
    }

    public void setCassandraPort(String port) {
        this.m_cassandraPort = port;
    }

    public String getCassandraPort() {
        return this.m_cassandraPort;
    }

    public void setUsername(String un) {
        this.m_username = un;
    }

    public String getUsername() {
        return this.m_username;
    }

    public void setPassword(String pass) {
        this.m_password = pass;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setCassandraKeyspace(String keyspace) {
        this.m_cassandraKeyspace = keyspace;
    }

    public String getCassandraKeyspace() {
        return this.m_cassandraKeyspace;
    }

    public void setColumnFamilyName(String colFam) {
        this.m_columnFamily = colFam;
    }

    public String getColumnFamilyName() {
        return this.m_columnFamily;
    }

    public void setCreateColumnFamily(boolean create) {
        this.m_createColumnFamily = create;
    }

    public boolean getCreateColumnFamily() {
        return this.m_createColumnFamily;
    }

    public void setCreateTableClause(String w) {
        this.m_createTableWithClause = w;
    }

    public String getCreateTableWithClause() {
        return this.m_createTableWithClause;
    }

    public void setConsistency(String consistency) {
        this.m_consistency = consistency;
    }

    public String getConsistency() {
        return this.m_consistency;
    }

    public void setBatchSize(String batchSize) {
        this.m_batchSize = batchSize;
    }

    public String getBatchSize() {
        return this.m_batchSize;
    }

    public void setUseUnloggedBatches(boolean u) {
        this.m_unloggedBatch = u;
    }

    public boolean getUseUnloggedBatch() {
        return this.m_unloggedBatch;
    }

    public void setUseCompression(boolean c) {
        this.m_useCompression = c;
    }

    public boolean getUseCompression() {
        return this.m_useCompression;
    }

    public void setInsertFieldsNotInMeta(boolean insert) {
        this.m_insertFieldsNotInMeta = insert;
    }

    public boolean getInsertFieldsNotInMeta() {
        return this.m_insertFieldsNotInMeta;
    }

    public void setKeyField(String keyField) {
        this.m_keyField = keyField;
    }

    public String getKeyField() {
        return this.m_keyField;
    }

    public void setUpdateCassandraMeta(boolean u) {
        this.m_updateCassandraMeta = u;
    }

    public boolean getUpdateCassandraMeta() {
        return this.m_updateCassandraMeta;
    }

    public void setTruncateColumnFamily(boolean t) {
        this.m_truncateColumnFamily = t;
    }

    public boolean getTruncateColumnFamily() {
        return this.m_truncateColumnFamily;
    }

    public void setAprioriCQL(String cql) {
        this.m_aprioriCQL = cql;
    }

    public String getAprioriCQL() {
        return this.m_aprioriCQL;
    }

    public void setDontComplainAboutAprioriCQLFailing(boolean c) {
        this.m_dontComplainAboutAprioriCQLFailing = c;
    }

    public boolean getDontComplainAboutAprioriCQLFailing() {
        return this.m_dontComplainAboutAprioriCQLFailing;
    }

    public void setUseThriftIO(boolean useThrift) {
        this.m_useThriftIO = useThrift;
    }

    public boolean getUseThriftIO() {
        return this.m_useThriftIO;
    }

    public void setUseCQL3(boolean cql3) {
        this.m_useCQL3 = cql3;
    }

    public boolean getUseCQL3() {
        return this.m_useCQL3;
    }

    public void setTTL(String ttl) {
        this.m_ttl = ttl;
    }

    public String getTTL() {
        return this.m_ttl;
    }

    public void setTTLUnit(String unit) {
        this.m_ttlUnit = unit;
    }

    public String getTTLUnit() {
        return this.m_ttlUnit;
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer();
        if (!Const.isEmpty((String)this.m_cassandraHost)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"cassandra_host", (String)this.m_cassandraHost));
        }
        if (!Const.isEmpty((String)this.m_cassandraPort)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"cassandra_port", (String)this.m_cassandraPort));
        }
        if (!Const.isEmpty((String)this.m_schemaHost)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"schema_host", (String)this.m_schemaHost));
        }
        if (!Const.isEmpty((String)this.m_schemaPort)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"schema_port", (String)this.m_schemaPort));
        }
        if (!Const.isEmpty((String)this.m_socketTimeout)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"socket_timeout", (String)this.m_socketTimeout));
        }
        if (!Const.isEmpty((String)this.m_password)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.m_password)));
        }
        if (!Const.isEmpty((String)this.m_username)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"username", (String)this.m_username));
        }
        if (!Const.isEmpty((String)this.m_cassandraKeyspace)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"cassandra_keyspace", (String)this.m_cassandraKeyspace));
        }
        if (!Const.isEmpty((String)this.m_cassandraKeyspace)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"cassandra_keyspace", (String)this.m_cassandraKeyspace));
        }
        if (!Const.isEmpty((String)this.m_columnFamily)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"column_family", (String)this.m_columnFamily));
        }
        if (!Const.isEmpty((String)this.m_keyField)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"key_field", (String)this.m_keyField));
        }
        if (!Const.isEmpty((String)this.m_consistency)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"consistency", (String)this.m_consistency));
        }
        if (!Const.isEmpty((String)this.m_batchSize)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"batch_size", (String)this.m_batchSize));
        }
        if (!Const.isEmpty((String)this.m_cqlBatchTimeout)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"cql_batch_timeout", (String)this.m_cqlBatchTimeout));
        }
        if (!Const.isEmpty((String)this.m_cqlSubBatchSize)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"cql_sub_batch_size", (String)this.m_cqlSubBatchSize));
        }
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"create_column_family", (boolean)this.m_createColumnFamily));
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"use_compression", (boolean)this.m_useCompression));
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"insert_fields_not_in_meta", (boolean)this.m_insertFieldsNotInMeta));
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"update_cassandra_meta", (boolean)this.m_updateCassandraMeta));
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"truncate_column_family", (boolean)this.m_truncateColumnFamily));
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"unlogged_batch", (boolean)this.m_unloggedBatch));
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"dont_complain_apriori_cql", (boolean)this.m_dontComplainAboutAprioriCQLFailing));
        if (!Const.isEmpty((String)this.m_aprioriCQL)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"apriori_cql", (String)this.m_aprioriCQL));
        }
        if (!Const.isEmpty((String)this.m_createTableWithClause)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"create_table_with_clause", (String)this.m_createTableWithClause));
        }
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"use_thrift_io", (boolean)this.m_useThriftIO));
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"use_cql3", (boolean)this.m_useCQL3));
        if (!Const.isEmpty((String)this.m_ttl)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"ttl", (String)this.m_ttl));
        }
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"ttl_unit", (String)this.m_ttlUnit));
        return retval.toString();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        String dontComplain;
        String unloggedBatch;
        String useCQL3;
        this.m_cassandraHost = XMLHandler.getTagValue((Node)stepnode, (String)"cassandra_host");
        this.m_cassandraPort = XMLHandler.getTagValue((Node)stepnode, (String)"cassandra_port");
        this.m_schemaHost = XMLHandler.getTagValue((Node)stepnode, (String)"schema_host");
        this.m_schemaPort = XMLHandler.getTagValue((Node)stepnode, (String)"schema_port");
        this.m_socketTimeout = XMLHandler.getTagValue((Node)stepnode, (String)"socket_timeout");
        this.m_username = XMLHandler.getTagValue((Node)stepnode, (String)"username");
        this.m_password = XMLHandler.getTagValue((Node)stepnode, (String)"password");
        if (!Const.isEmpty((String)this.m_password)) {
            this.m_password = Encr.decryptPasswordOptionallyEncrypted((String)this.m_password);
        }
        this.m_cassandraKeyspace = XMLHandler.getTagValue((Node)stepnode, (String)"cassandra_keyspace");
        this.m_columnFamily = XMLHandler.getTagValue((Node)stepnode, (String)"column_family");
        this.m_keyField = XMLHandler.getTagValue((Node)stepnode, (String)"key_field");
        this.m_consistency = XMLHandler.getTagValue((Node)stepnode, (String)"consistency");
        this.m_batchSize = XMLHandler.getTagValue((Node)stepnode, (String)"batch_size");
        this.m_cqlBatchTimeout = XMLHandler.getTagValue((Node)stepnode, (String)"cql_batch_timeout");
        this.m_cqlSubBatchSize = XMLHandler.getTagValue((Node)stepnode, (String)"cql_sub_batch_size");
        this.m_createColumnFamily = XMLHandler.getTagValue((Node)stepnode, (String)"create_column_family").equalsIgnoreCase("Y");
        this.m_useCompression = XMLHandler.getTagValue((Node)stepnode, (String)"use_compression").equalsIgnoreCase("Y");
        this.m_insertFieldsNotInMeta = XMLHandler.getTagValue((Node)stepnode, (String)"insert_fields_not_in_meta").equalsIgnoreCase("Y");
        this.m_updateCassandraMeta = XMLHandler.getTagValue((Node)stepnode, (String)"update_cassandra_meta").equalsIgnoreCase("Y");
        this.m_truncateColumnFamily = XMLHandler.getTagValue((Node)stepnode, (String)"truncate_column_family").equalsIgnoreCase("Y");
        this.m_aprioriCQL = XMLHandler.getTagValue((Node)stepnode, (String)"apriori_cql");
        this.m_createTableWithClause = XMLHandler.getTagValue((Node)stepnode, (String)"create_table_with_clause");
        String useThrift = XMLHandler.getTagValue((Node)stepnode, (String)"use_thrift_io");
        if (!Const.isEmpty((String)useThrift)) {
            this.m_useThriftIO = useThrift.equalsIgnoreCase("Y");
        }
        if (!Const.isEmpty((String)(useCQL3 = XMLHandler.getTagValue((Node)stepnode, (String)"use_cql3")))) {
            this.m_useCQL3 = useCQL3.equalsIgnoreCase("Y");
        }
        if (!Const.isEmpty((String)(unloggedBatch = XMLHandler.getTagValue((Node)stepnode, (String)"unlogged_batch")))) {
            this.m_unloggedBatch = unloggedBatch.equalsIgnoreCase("Y");
        }
        if (!Const.isEmpty((String)(dontComplain = XMLHandler.getTagValue((Node)stepnode, (String)"dont_complain_apriori_cql")))) {
            this.m_dontComplainAboutAprioriCQLFailing = dontComplain.equalsIgnoreCase("Y");
        }
        this.m_ttl = XMLHandler.getTagValue((Node)stepnode, (String)"ttl");
        this.m_ttlUnit = XMLHandler.getTagValue((Node)stepnode, (String)"ttl_unit");
        if (Const.isEmpty((String)this.m_ttlUnit)) {
            this.m_ttlUnit = TTLUnits.NONE.toString();
        }
    }

    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        this.m_cassandraHost = rep.getStepAttributeString(id_step, 0, "cassandra_host");
        this.m_cassandraPort = rep.getStepAttributeString(id_step, 0, "cassandra_port");
        this.m_schemaHost = rep.getStepAttributeString(id_step, 0, "schema_host");
        this.m_schemaPort = rep.getStepAttributeString(id_step, 0, "schema_port");
        this.m_socketTimeout = rep.getStepAttributeString(id_step, 0, "socket_timeout");
        this.m_username = rep.getStepAttributeString(id_step, 0, "username");
        this.m_password = rep.getStepAttributeString(id_step, 0, "password");
        if (!Const.isEmpty((String)this.m_password)) {
            this.m_password = Encr.decryptPasswordOptionallyEncrypted((String)this.m_password);
        }
        this.m_cassandraKeyspace = rep.getStepAttributeString(id_step, 0, "cassandra_keyspace");
        this.m_columnFamily = rep.getStepAttributeString(id_step, 0, "column_family");
        this.m_keyField = rep.getStepAttributeString(id_step, 0, "key_field");
        this.m_consistency = rep.getStepAttributeString(id_step, 0, "consistency");
        this.m_batchSize = rep.getStepAttributeString(id_step, 0, "batch_size");
        this.m_cqlBatchTimeout = rep.getStepAttributeString(id_step, 0, "cql_batch_timeout");
        this.m_cqlSubBatchSize = rep.getStepAttributeString(id_step, 0, "cql_sub_batch_size");
        this.m_createColumnFamily = rep.getStepAttributeBoolean(id_step, 0, "create_column_family");
        this.m_useCompression = rep.getStepAttributeBoolean(id_step, 0, "use_compression");
        this.m_insertFieldsNotInMeta = rep.getStepAttributeBoolean(id_step, 0, "insert_fields_not_in_meta");
        this.m_updateCassandraMeta = rep.getStepAttributeBoolean(id_step, 0, "update_cassandra_meta");
        this.m_truncateColumnFamily = rep.getStepAttributeBoolean(id_step, 0, "truncate_column_family");
        this.m_unloggedBatch = rep.getStepAttributeBoolean(id_step, 0, "unlogged_batch");
        this.m_aprioriCQL = rep.getStepAttributeString(id_step, 0, "apriori_cql");
        this.m_createTableWithClause = rep.getStepAttributeString(id_step, 0, "create_table_with_clause");
        this.m_useThriftIO = rep.getStepAttributeBoolean(id_step, 0, "use_thrift_io");
        this.m_dontComplainAboutAprioriCQLFailing = rep.getStepAttributeBoolean(id_step, 0, "dont_complain_aprior_cql");
        this.m_useCQL3 = rep.getStepAttributeBoolean(id_step, 0, "use_cql3");
        this.m_ttl = rep.getStepAttributeString(id_step, 0, "ttl");
        this.m_ttlUnit = rep.getStepAttributeString(id_step, 0, "ttl_unit");
        if (Const.isEmpty((String)this.m_ttlUnit)) {
            this.m_ttlUnit = TTLUnits.NONE.toString();
        }
    }

    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        if (!Const.isEmpty((String)this.m_cassandraHost)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "cassandra_host", this.m_cassandraHost);
        }
        if (!Const.isEmpty((String)this.m_cassandraPort)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "cassandra_port", this.m_cassandraPort);
        }
        if (!Const.isEmpty((String)this.m_schemaHost)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "schema_host", this.m_schemaHost);
        }
        if (!Const.isEmpty((String)this.m_schemaPort)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "schema_port", this.m_schemaPort);
        }
        if (!Const.isEmpty((String)this.m_socketTimeout)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "socket_timeout", this.m_socketTimeout);
        }
        if (!Const.isEmpty((String)this.m_username)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "username", this.m_username);
        }
        if (!Const.isEmpty((String)this.m_password)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "password", Encr.encryptPasswordIfNotUsingVariables((String)this.m_password));
        }
        if (!Const.isEmpty((String)this.m_cassandraKeyspace)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "cassandra_keyspace", this.m_cassandraKeyspace);
        }
        if (!Const.isEmpty((String)this.m_columnFamily)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "column_family", this.m_columnFamily);
        }
        if (!Const.isEmpty((String)this.m_keyField)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "key_field", this.m_keyField);
        }
        if (!Const.isEmpty((String)this.m_consistency)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "consistency", this.m_consistency);
        }
        if (!Const.isEmpty((String)this.m_batchSize)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "batch_size", this.m_batchSize);
        }
        if (!Const.isEmpty((String)this.m_cqlBatchTimeout)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "cql_batch_timeout", this.m_cqlBatchTimeout);
        }
        if (!Const.isEmpty((String)this.m_cqlSubBatchSize)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "cql_sub_batch_size", this.m_cqlSubBatchSize);
        }
        rep.saveStepAttribute(id_transformation, id_step, 0, "create_column_family", this.m_createColumnFamily);
        rep.saveStepAttribute(id_transformation, id_step, 0, "use_compression", this.m_useCompression);
        rep.saveStepAttribute(id_transformation, id_step, 0, "insert_fields_not_in_meta", this.m_insertFieldsNotInMeta);
        rep.saveStepAttribute(id_transformation, id_step, 0, "update_cassandra_meta", this.m_updateCassandraMeta);
        rep.saveStepAttribute(id_transformation, id_step, 0, "truncate_column_family", this.m_truncateColumnFamily);
        rep.saveStepAttribute(id_transformation, id_step, 0, "unlogged_batch", this.m_unloggedBatch);
        if (!Const.isEmpty((String)this.m_aprioriCQL)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "apriori_cql", this.m_aprioriCQL);
        }
        if (!Const.isEmpty((String)this.m_createTableWithClause)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "create_table_with_clause", this.m_aprioriCQL);
        }
        if (!Const.isEmpty((String)this.m_ttl)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "ttl", this.m_ttl);
        }
        rep.saveStepAttribute(id_transformation, id_step, 0, "ttl_unit", this.m_ttlUnit);
        rep.saveStepAttribute(id_transformation, id_step, 0, "use_thrift_io", this.m_useThriftIO);
        rep.saveStepAttribute(id_transformation, id_step, 0, "use_cql3", this.m_useCQL3);
        rep.saveStepAttribute(id_transformation, id_step, 0, "dont_complain_apriori_cql", this.m_dontComplainAboutAprioriCQLFailing);
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, "Not receiving any fields from previous steps!", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, "Step is connected to previous one, receiving " + prev.size() + " fields", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        return new CassandraOutput(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new CassandraOutputData();
    }

    public void setDefault() {
        this.m_cassandraHost = "localhost";
        this.m_cassandraPort = "9160";
        this.m_schemaHost = "localhost";
        this.m_schemaPort = "9160";
        this.m_columnFamily = "";
        this.m_batchSize = "100";
        this.m_useCompression = false;
        this.m_insertFieldsNotInMeta = false;
        this.m_updateCassandraMeta = false;
        this.m_truncateColumnFamily = false;
        this.m_aprioriCQL = "";
    }

    public String getDialogClassName() {
        return "org.pentaho.di.trans.steps.cassandraoutput.CassandraOutputDialog";
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public static enum TTLUnits {
        NONE(BaseMessages.getString(PKG, (String)"CassandraOutput.TTLUnit.None", (String[])new String[0])){

            @Override
            int convertToSeconds(int value) {
                return -1;
            }
        }
        ,
        SECONDS(BaseMessages.getString(PKG, (String)"CassandraOutput.TTLUnit.Seconds", (String[])new String[0])){

            @Override
            int convertToSeconds(int value) {
                return value;
            }
        }
        ,
        MINUTES(BaseMessages.getString(PKG, (String)"CassandraOutput.TTLUnit.Minutes", (String[])new String[0])){

            @Override
            int convertToSeconds(int value) {
                return value * 60;
            }
        }
        ,
        HOURS(BaseMessages.getString(PKG, (String)"CassandraOutput.TTLUnit.Hours", (String[])new String[0])){

            @Override
            int convertToSeconds(int value) {
                return value * 60 * 60;
            }
        }
        ,
        DAYS(BaseMessages.getString(PKG, (String)"CassandraOutput.TTLUnit.Days", (String[])new String[0])){

            @Override
            int convertToSeconds(int value) {
                return value * 60 * 60 * 24;
            }
        };

        private final String m_stringVal;

        private TTLUnits(String name) {
            this.m_stringVal = name;
        }

        public String toString() {
            return this.m_stringVal;
        }

        abstract int convertToSeconds(int var1);
    }
}

