/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.gpbulkloader;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ProvidesDatabaseConnectionInformation;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.gpbulkloader.GPBulkLoader;
import org.pentaho.di.trans.steps.gpbulkloader.GPBulkLoaderData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="GPBulkLoader", image="BLKGPL.svg", i18nPackageName="org.pentaho.di.trans.steps.gpbulkloader", name="GPBulkLoaderMeta.Name", description="GPBulkLoaderMeta.Description", categoryDescription="i18n:org.pentaho.di.job:JobCategory.Category.Deprecated", documentationUrl="http://wiki.pentaho.com/display/PMOPEN/GreenPlum+bulk+loader")
public class GPBulkLoaderMeta
extends BaseStepMeta
implements StepMetaInterface,
ProvidesDatabaseConnectionInformation {
    private static Class<?> PKG = GPBulkLoaderMeta.class;
    private String schemaName;
    private String tableName;
    private String PsqlPath;
    private String controlFile;
    private String dataFile;
    private String logFile;
    private DatabaseMeta databaseMeta;
    private String[] fieldTable;
    private String[] fieldStream;
    private String[] dateMask;
    private int maxErrors;
    private String loadMethod;
    private String loadAction;
    private String encoding;
    private boolean eraseFiles;
    private String dbNameOverride;
    public static final String ACTION_APPEND = "APPEND";
    public static final String ACTION_INSERT = "INSERT";
    public static final String ACTION_REPLACE = "REPLACE";
    public static final String ACTION_TRUNCATE = "TRUNCATE";
    public static final String METHOD_AUTO_END = "AUTO_END";
    public static final String METHOD_MANUAL = "MANUAL";
    public static final String DATE_MASK_DATE = "DATE";
    public static final String DATE_MASK_DATETIME = "DATETIME";

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getPsqlpath() {
        return this.PsqlPath;
    }

    public void setPsqlpath(String PsqlPath) {
        this.PsqlPath = PsqlPath;
    }

    public String[] getFieldTable() {
        return this.fieldTable;
    }

    public void setFieldTable(String[] fieldTable) {
        this.fieldTable = fieldTable;
    }

    public String[] getFieldStream() {
        return this.fieldStream;
    }

    public void setFieldStream(String[] fieldStream) {
        this.fieldStream = fieldStream;
    }

    public String[] getDateMask() {
        return this.dateMask;
    }

    public void setDateMask(String[] dateMask) {
        this.dateMask = dateMask;
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public void allocate(int nrvalues) {
        this.fieldTable = new String[nrvalues];
        this.fieldStream = new String[nrvalues];
        this.dateMask = new String[nrvalues];
    }

    public Object clone() {
        GPBulkLoaderMeta retval = (GPBulkLoaderMeta)((Object)super.clone());
        int nrvalues = this.fieldTable.length;
        retval.allocate(nrvalues);
        for (int i = 0; i < nrvalues; ++i) {
            retval.fieldTable[i] = this.fieldTable[i];
            retval.fieldStream[i] = this.fieldStream[i];
            retval.dateMask[i] = this.dateMask[i];
        }
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            String con = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)con);
            String serror = XMLHandler.getTagValue((Node)stepnode, (String)"errors");
            this.maxErrors = Const.toInt((String)serror, (int)50);
            this.schemaName = XMLHandler.getTagValue((Node)stepnode, (String)"schema");
            this.tableName = XMLHandler.getTagValue((Node)stepnode, (String)"table");
            this.loadMethod = XMLHandler.getTagValue((Node)stepnode, (String)"load_method");
            this.loadAction = XMLHandler.getTagValue((Node)stepnode, (String)"load_action");
            this.PsqlPath = XMLHandler.getTagValue((Node)stepnode, (String)"PsqlPath");
            this.controlFile = XMLHandler.getTagValue((Node)stepnode, (String)"control_file");
            this.dataFile = XMLHandler.getTagValue((Node)stepnode, (String)"data_file");
            this.logFile = XMLHandler.getTagValue((Node)stepnode, (String)"log_file");
            this.eraseFiles = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"erase_files"));
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            this.dbNameOverride = XMLHandler.getTagValue((Node)stepnode, (String)"dbname_override");
            int nrvalues = XMLHandler.countNodes((Node)stepnode, (String)"mapping");
            this.allocate(nrvalues);
            for (int i = 0; i < nrvalues; ++i) {
                String locDateMask;
                Node vnode = XMLHandler.getSubNodeByNr((Node)stepnode, (String)"mapping", (int)i);
                this.fieldTable[i] = XMLHandler.getTagValue((Node)vnode, (String)"stream_name");
                this.fieldStream[i] = XMLHandler.getTagValue((Node)vnode, (String)"field_name");
                if (this.fieldStream[i] == null) {
                    this.fieldStream[i] = this.fieldTable[i];
                }
                this.dateMask[i] = (locDateMask = XMLHandler.getTagValue((Node)vnode, (String)"date_mask")) == null ? "" : (DATE_MASK_DATE.equals(locDateMask) || DATE_MASK_DATETIME.equals(locDateMask) ? locDateMask : "");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.Exception.UnableToReadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.fieldTable = null;
        this.databaseMeta = null;
        this.maxErrors = 50;
        this.schemaName = "";
        this.tableName = BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.DefaultTableName", (String[])new String[0]);
        this.loadMethod = METHOD_AUTO_END;
        this.loadAction = ACTION_APPEND;
        this.PsqlPath = "PsqlPath";
        this.controlFile = "control${Internal.Step.CopyNr}.cfg";
        this.dataFile = "load${Internal.Step.CopyNr}.dat";
        this.logFile = "";
        this.encoding = "";
        this.dbNameOverride = "";
        this.eraseFiles = true;
        int nrvalues = 0;
        this.allocate(nrvalues);
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"errors", (int)this.maxErrors));
        retval.append("    ").append(XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"table", (String)this.tableName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"load_method", (String)this.loadMethod));
        retval.append("    ").append(XMLHandler.addTagValue((String)"load_action", (String)this.loadAction));
        retval.append("    ").append(XMLHandler.addTagValue((String)"PsqlPath", (String)this.PsqlPath));
        retval.append("    ").append(XMLHandler.addTagValue((String)"control_file", (String)this.controlFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"data_file", (String)this.dataFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"log_file", (String)this.logFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"erase_files", (boolean)this.eraseFiles));
        retval.append("    ").append(XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    ").append(XMLHandler.addTagValue((String)"dbname_override", (String)this.dbNameOverride));
        for (int i = 0; i < this.fieldTable.length; ++i) {
            retval.append("      <mapping>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"stream_name", (String)this.fieldTable[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"field_name", (String)this.fieldStream[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"date_mask", (String)this.dateMask[i]));
            retval.append("      </mapping>").append(Const.CR);
        }
        return retval.toString();
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.maxErrors = (int)rep.getStepAttributeInteger(id_step, "errors");
            this.schemaName = rep.getStepAttributeString(id_step, "schema");
            this.tableName = rep.getStepAttributeString(id_step, "table");
            this.loadMethod = rep.getStepAttributeString(id_step, "load_method");
            this.loadAction = rep.getStepAttributeString(id_step, "load_action");
            this.PsqlPath = rep.getStepAttributeString(id_step, "PsqlPath");
            this.controlFile = rep.getStepAttributeString(id_step, "control_file");
            this.dataFile = rep.getStepAttributeString(id_step, "data_file");
            this.logFile = rep.getStepAttributeString(id_step, "log_file");
            this.eraseFiles = rep.getStepAttributeBoolean(id_step, "erase_files");
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            this.dbNameOverride = rep.getStepAttributeString(id_step, "dbname_override");
            int nrvalues = rep.countNrStepAttributes(id_step, "stream_name");
            this.allocate(nrvalues);
            for (int i = 0; i < nrvalues; ++i) {
                this.fieldTable[i] = rep.getStepAttributeString(id_step, i, "stream_name");
                this.fieldStream[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.dateMask[i] = rep.getStepAttributeString(id_step, i, "date_mask");
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.Exception.UnexpectedErrorReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta);
            rep.saveStepAttribute(id_transformation, id_step, "errors", (long)this.maxErrors);
            rep.saveStepAttribute(id_transformation, id_step, "schema", this.schemaName);
            rep.saveStepAttribute(id_transformation, id_step, "table", this.tableName);
            rep.saveStepAttribute(id_transformation, id_step, "load_method", this.loadMethod);
            rep.saveStepAttribute(id_transformation, id_step, "load_action", this.loadAction);
            rep.saveStepAttribute(id_transformation, id_step, "PsqlPath", this.PsqlPath);
            rep.saveStepAttribute(id_transformation, id_step, "control_file", this.controlFile);
            rep.saveStepAttribute(id_transformation, id_step, "data_file", this.dataFile);
            rep.saveStepAttribute(id_transformation, id_step, "log_file", this.logFile);
            rep.saveStepAttribute(id_transformation, id_step, "erase_files", this.eraseFiles);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            rep.saveStepAttribute(id_transformation, id_step, "dbname_override", this.dbNameOverride);
            for (int i = 0; i < this.fieldTable.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "stream_name", this.fieldTable[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.fieldStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "date_mask", this.dateMask[i]);
            }
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getObjectId());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        String error_message = "";
        if (this.databaseMeta != null) {
            Database db = new Database(loggingObject, this.databaseMeta);
            db.shareVariablesWith((VariableSpace)transMeta);
            try {
                boolean error_found;
                boolean first;
                db.connect();
                if (!Const.isEmpty((String)this.tableName)) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.CheckResult.TableNameOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                    first = true;
                    error_found = false;
                    error_message = "";
                    String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(transMeta.environmentSubstitute(this.schemaName), transMeta.environmentSubstitute(this.tableName));
                    RowMetaInterface r = db.getTableFields(schemaTable);
                    if (r != null) {
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.CheckResult.TableExists", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                        first = true;
                        error_found = false;
                        error_message = "";
                        for (int i = 0; i < this.fieldTable.length; ++i) {
                            String field = this.fieldTable[i];
                            ValueMetaInterface v = r.searchValueMeta(field);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                error_message = error_message + BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.CheckResult.MissingFieldsToLoadInTargetTable", (String[])new String[0]) + Const.CR;
                            }
                            error_found = true;
                            error_message = error_message + "\t\t" + field + Const.CR;
                        }
                        cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.CheckResult.AllFieldsFoundInTargetTable", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    } else {
                        error_message = BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]);
                        cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.CheckResult.StepReceivingDatas", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                    first = true;
                    error_message = "";
                    error_found = false;
                    for (int i = 0; i < this.fieldStream.length; ++i) {
                        ValueMetaInterface v = prev.searchValueMeta(this.fieldStream[i]);
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            error_message = error_message + BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.CheckResult.MissingFieldsInInput", (String[])new String[0]) + Const.CR;
                        }
                        error_found = true;
                        error_message = error_message + "\t\t" + this.fieldStream[i] + Const.CR;
                    }
                    cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.CheckResult.AllFieldsFoundInInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                error_message = BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.CheckResult.MissingFieldsInInput3", (String[])new String[0]) + Const.CR;
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            catch (KettleException e) {
                error_message = BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.CheckResult.DatabaseErrorOccurred", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            error_message = BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.CheckResult.StepReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.CheckResult.NoInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, Repository repository, IMetaStore metaStore) throws KettleStepException {
        SQLStatement retval;
        block11: {
            retval = new SQLStatement(stepMeta.getName(), this.databaseMeta, null);
            if (this.databaseMeta != null) {
                if (prev != null && prev.size() > 0) {
                    RowMeta tableFields = new RowMeta();
                    for (int i = 0; i < this.fieldTable.length; ++i) {
                        ValueMetaInterface v = prev.searchValueMeta(this.fieldStream[i]);
                        if (v == null) {
                            throw new KettleStepException("Unable to find field [" + this.fieldStream[i] + "] in the input rows");
                        }
                        ValueMetaInterface tableField = v.clone();
                        tableField.setName(this.fieldTable[i]);
                        tableFields.addValueMeta(tableField);
                    }
                    if (!Const.isEmpty((String)this.tableName)) {
                        Database db = new Database(loggingObject, this.databaseMeta);
                        db.shareVariablesWith((VariableSpace)transMeta);
                        try {
                            db.connect();
                            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(transMeta.environmentSubstitute(this.schemaName), transMeta.environmentSubstitute(this.tableName));
                            String sql = db.getDDL(schemaTable, (RowMetaInterface)tableFields, null, false, null, true);
                            if (sql.length() == 0) {
                                retval.setSQL(null);
                                break block11;
                            }
                            retval.setSQL(sql);
                        }
                        catch (KettleException e) {
                            retval.setError(BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.GetSQL.ErrorOccurred", (String[])new String[0]) + e.getMessage());
                        }
                    } else {
                        retval.setError(BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.GetSQL.NoTableDefinedOnConnection", (String[])new String[0]));
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.GetSQL.NotReceivingAnyFields", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.GetSQL.NoConnectionDefined", (String[])new String[0]));
            }
        }
        return retval;
    }

    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (prev != null) {
            for (int i = 0; i < this.fieldTable.length; ++i) {
                ValueMetaInterface v = prev.searchValueMeta(this.fieldStream[i]);
                DatabaseImpact ii = new DatabaseImpact(3, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), transMeta.environmentSubstitute(this.tableName), this.fieldTable[i], this.fieldStream[i], v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                impact.add(ii);
            }
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new GPBulkLoader(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new GPBulkLoaderData();
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RowMetaInterface getRequiredFields(VariableSpace space) throws KettleException {
        String realTableName = space.environmentSubstitute(this.tableName);
        String realSchemaName = space.environmentSubstitute(this.schemaName);
        if (this.databaseMeta == null) throw new KettleException(BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
        Database db = new Database(loggingObject, this.databaseMeta);
        try {
            db.connect();
            if (Const.isEmpty((String)realTableName)) throw new KettleException(BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.Exception.TableNotSpecified", (String[])new String[0]));
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(realSchemaName, realTableName);
            if (db.checkTableExists(schemaTable)) {
                RowMetaInterface rowMetaInterface = db.getTableFields(schemaTable);
                return rowMetaInterface;
            }
            try {
                throw new KettleException(BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.Exception.TableNotFound", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"GPBulkLoaderMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
            }
        }
        finally {
            db.disconnect();
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getControlFile() {
        return this.controlFile;
    }

    public void setControlFile(String controlFile) {
        this.controlFile = controlFile;
    }

    public String getDataFile() {
        return this.dataFile;
    }

    public void setDataFile(String dataFile) {
        this.dataFile = dataFile;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public void setLoadAction(String action) {
        this.loadAction = action;
    }

    public String getLoadAction() {
        return this.loadAction;
    }

    public void setLoadMethod(String method) {
        this.loadMethod = method;
    }

    public String getLoadMethod() {
        return this.loadMethod;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getDelimiter() {
        return ",";
    }

    public String getEnclosure() {
        return "\"";
    }

    public boolean isEraseFiles() {
        return this.eraseFiles;
    }

    public void setEraseFiles(boolean eraseFiles) {
        this.eraseFiles = eraseFiles;
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    public void setMaxErrors(int maxErrors) {
        this.maxErrors = maxErrors;
    }

    public String getDbNameOverride() {
        return this.dbNameOverride;
    }

    public void setDbNameOverride(String dbNameOverride) {
        this.dbNameOverride = dbNameOverride;
    }

    public String getMissingDatabaseConnectionInformationMessage() {
        return null;
    }
}

