/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.security.impl;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecuredCommandConfigTransformer
implements ConfigurationListener {
    static final String PROXY_COMMAND_ACL_PID_PREFIX = "org.apache.karaf.command.acl.";
    static final String PROXY_SERVICE_ACL_PID_PREFIX = "org.apache.karaf.service.acl.command.";
    private static final Logger LOGGER = LoggerFactory.getLogger(SecuredCommandConfigTransformer.class);
    private static final String CONFIGURATION_FILTER = "(service.pid=org.apache.karaf.command.acl.*)";
    private static final String ACL_SCOPE_BUNDLE_MAP = "org.apache.karaf.command.acl.scope_bundle";
    private ConfigurationAdmin configAdmin;

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public void init() throws Exception {
        Configuration[] configs = this.configAdmin.listConfigurations(CONFIGURATION_FILTER);
        if (configs == null) {
            return;
        }
        for (Configuration config : configs) {
            this.generateServiceGuardConfig(config);
        }
    }

    void generateServiceGuardConfig(Configuration config) throws IOException {
        if (!config.getPid().startsWith(PROXY_COMMAND_ACL_PID_PREFIX)) {
            return;
        }
        String scopeName = config.getPid().substring(PROXY_COMMAND_ACL_PID_PREFIX.length());
        if (scopeName.indexOf(46) >= 0) {
            return;
        }
        scopeName = scopeName.trim();
        HashMap<String, Dictionary> configMaps = new HashMap<String, Dictionary>();
        Enumeration e = config.getProperties().keys();
        while (e.hasMoreElements()) {
            Dictionary map;
            String key;
            String bareCommand = key = (String)e.nextElement();
            String arguments = "";
            int idx = bareCommand.indexOf(91);
            if (idx >= 0) {
                arguments = this.convertArgs(bareCommand.substring(idx));
                bareCommand = bareCommand.substring(0, idx);
            }
            if (bareCommand.indexOf(46) >= 0) continue;
            bareCommand = bareCommand.trim();
            String pid = PROXY_SERVICE_ACL_PID_PREFIX + scopeName + "." + bareCommand;
            if (!configMaps.containsKey(pid)) {
                map = new Hashtable<String, String>();
                map.put("service.guard", "(&(osgi.command.scope=" + scopeName + ")(" + "osgi.command.function" + "=" + bareCommand + "))");
                configMaps.put(pid, map);
            } else {
                map = (Dictionary)configMaps.get(pid);
            }
            Object roleString = config.getProperties().get(key);
            map.put("execute" + arguments, roleString);
            map.put(key, roleString);
            map.put("*", "*");
        }
        LOGGER.info("Generating command ACL config {} into service ACL configs {}", (Object)config.getPid(), configMaps.keySet());
        for (Map.Entry entry : configMaps.entrySet()) {
            Configuration genConfig = this.configAdmin.getConfiguration((String)entry.getKey(), null);
            genConfig.update((Dictionary)entry.getValue());
        }
    }

    private String convertArgs(String commandACLArgs) {
        if (!commandACLArgs.startsWith("[/")) {
            throw new IllegalStateException("Badly formatted argument match: " + commandACLArgs + " Should start with '[/'");
        }
        if (!commandACLArgs.endsWith("/]")) {
            throw new IllegalStateException("Badly formatted argument match: " + commandACLArgs + " Should end with '/]'");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[/.*/,");
        sb.append(commandACLArgs.substring(1));
        return sb.toString();
    }

    void deleteServiceGuardConfig(String originatingPid, String scope) throws IOException, InvalidSyntaxException {
        if (scope.contains(".")) {
            return;
        }
        Configuration[] configs = this.configAdmin.listConfigurations("(service.pid=org.apache.karaf.service.acl.command." + scope + ".*)");
        if (configs == null) {
            return;
        }
        LOGGER.info("Config ACL deleted: {}. Deleting generated service ACL configs {}", (Object)originatingPid, (Object)configs);
        for (Configuration config : configs) {
            config.delete();
        }
    }

    public void configurationEvent(ConfigurationEvent event) {
        if (!event.getPid().startsWith(PROXY_COMMAND_ACL_PID_PREFIX)) {
            return;
        }
        try {
            switch (event.getType()) {
                case 2: {
                    this.deleteServiceGuardConfig(event.getPid(), event.getPid().substring(PROXY_COMMAND_ACL_PID_PREFIX.length()));
                    break;
                }
                case 1: {
                    this.generateServiceGuardConfig(this.configAdmin.getConfiguration(event.getPid(), null));
                    this.refreshTheAffectedShellCommandBundle(event, this.configAdmin.getConfiguration(event.getPid(), null));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Problem processing Configuration Event {}", (Object)event, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshTheAffectedShellCommandBundle(ConfigurationEvent event, Configuration config) {
        if (!config.getPid().startsWith(PROXY_COMMAND_ACL_PID_PREFIX)) {
            return;
        }
        String filter = "";
        String scopeName = config.getPid().substring(PROXY_COMMAND_ACL_PID_PREFIX.length());
        if (scopeName.indexOf(46) >= 0) {
            return;
        }
        scopeName = scopeName.trim();
        for (Map.Entry<String, String> entry : this.loadScopeBundleMaps().entrySet()) {
            if (!entry.getKey().equals(scopeName)) continue;
            filter = "(osgi.blueprint.container.symbolicname=" + entry.getValue() + ")";
            break;
        }
        if (filter.length() == 0) {
            return;
        }
        BundleContext bundleContext = event.getReference().getBundle().getBundleContext();
        try {
            ServiceReference[] sr = bundleContext.getServiceReferences("org.osgi.service.blueprint.container.BlueprintContainer", filter);
            if (sr == null) {
                LOGGER.error("can't find the command bundle for scope " + scopeName);
                return;
            }
            LOGGER.debug("the refreshed bundle is " + sr[0].getBundle().getSymbolicName());
            ServiceReference ref = bundleContext.getServiceReference(PackageAdmin.class.getName());
            if (ref == null) {
                LOGGER.error("PackageAdmin service is unavailable.");
                return;
            }
            try {
                PackageAdmin pa = (PackageAdmin)bundleContext.getService(ref);
                if (pa == null) {
                    LOGGER.error("PackageAdmin service is unavailable.");
                    return;
                }
                pa.refreshPackages(new Bundle[]{sr[0].getBundle()});
            }
            finally {
                bundleContext.ungetService(ref);
            }
        }
        catch (InvalidSyntaxException ex) {
            LOGGER.error("Problem refresh the affected shell command bundle", (Throwable)ex);
        }
    }

    private Map<String, String> loadScopeBundleMaps() {
        HashMap<String, String> scopeBundleMaps = new HashMap<String, String>();
        try {
            for (Configuration config : this.configAdmin.listConfigurations("(service.pid=org.apache.karaf.command.acl.scope_bundle)")) {
                Enumeration keys = config.getProperties().keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    scopeBundleMaps.put(key, (String)config.getProperties().get(key));
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Problem load the scope bundle map", (Throwable)ex);
        }
        return scopeBundleMaps;
    }
}

