/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import com.google.common.base.Joiner;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.OperationWithAttributes;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.thrift.CallQueue;
import org.apache.hadoop.hbase.thrift.HThreadedSelectorServerArgs;
import org.apache.hadoop.hbase.thrift.HbaseHandlerMetricsProxy;
import org.apache.hadoop.hbase.thrift.IncrementCoalescer;
import org.apache.hadoop.hbase.thrift.TBoundedThreadPoolServer;
import org.apache.hadoop.hbase.thrift.ThriftMetrics;
import org.apache.hadoop.hbase.thrift.ThriftUtilities;
import org.apache.hadoop.hbase.thrift.generated.AlreadyExists;
import org.apache.hadoop.hbase.thrift.generated.BatchMutation;
import org.apache.hadoop.hbase.thrift.generated.ColumnDescriptor;
import org.apache.hadoop.hbase.thrift.generated.Hbase;
import org.apache.hadoop.hbase.thrift.generated.IOError;
import org.apache.hadoop.hbase.thrift.generated.IllegalArgument;
import org.apache.hadoop.hbase.thrift.generated.Mutation;
import org.apache.hadoop.hbase.thrift.generated.TCell;
import org.apache.hadoop.hbase.thrift.generated.TIncrement;
import org.apache.hadoop.hbase.thrift.generated.TRegionInfo;
import org.apache.hadoop.hbase.thrift.generated.TRowResult;
import org.apache.hadoop.hbase.thrift.generated.TScan;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.AbstractNonblockingServer;
import org.apache.thrift.server.THsHaServer;
import org.apache.thrift.server.TNonblockingServer;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.server.TThreadedSelectorServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportFactory;

public class ThriftServerRunner
implements Runnable {
    private static final Log LOG = LogFactory.getLog(ThriftServerRunner.class);
    static final String SERVER_TYPE_CONF_KEY = "hbase.regionserver.thrift.server.type";
    static final String BIND_CONF_KEY = "hbase.regionserver.thrift.ipaddress";
    static final String COMPACT_CONF_KEY = "hbase.regionserver.thrift.compact";
    static final String FRAMED_CONF_KEY = "hbase.regionserver.thrift.framed";
    static final String PORT_CONF_KEY = "hbase.regionserver.thrift.port";
    static final String COALESCE_INC_KEY = "hbase.regionserver.thrift.coalesceIncrement";
    private static final String DEFAULT_BIND_ADDR = "0.0.0.0";
    public static final int DEFAULT_LISTEN_PORT = 9090;
    private final int listenPort;
    private Configuration conf;
    volatile TServer tserver;
    private final Hbase.Iface handler;
    private final ThriftMetrics metrics;

    public ThriftServerRunner(Configuration conf) throws IOException {
        this(conf, new HBaseHandler(conf));
    }

    public ThriftServerRunner(Configuration conf, HBaseHandler handler) {
        this.conf = HBaseConfiguration.create(conf);
        this.listenPort = conf.getInt(PORT_CONF_KEY, 9090);
        this.metrics = new ThriftMetrics(this.listenPort, conf, Hbase.Iface.class);
        handler.initMetrics(this.metrics);
        this.handler = HbaseHandlerMetricsProxy.newInstance(handler, this.metrics, conf);
    }

    @Override
    public void run() {
        try {
            this.setupServer();
            this.tserver.serve();
        }
        catch (Exception e) {
            LOG.fatal((Object)"Cannot run ThriftServer", (Throwable)e);
            System.exit(-1);
        }
    }

    public void shutdown() {
        if (this.tserver != null) {
            this.tserver.stop();
            this.tserver = null;
        }
    }

    private void setupServer() throws Exception {
        TFramedTransport.Factory transportFactory;
        TCompactProtocol.Factory protocolFactory;
        if (this.conf.getBoolean(COMPACT_CONF_KEY, false)) {
            LOG.debug((Object)"Using compact protocol");
            protocolFactory = new TCompactProtocol.Factory();
        } else {
            LOG.debug((Object)"Using binary protocol");
            protocolFactory = new TBinaryProtocol.Factory();
        }
        Hbase.Processor<Hbase.Iface> processor = new Hbase.Processor<Hbase.Iface>(this.handler);
        ImplType implType = ImplType.getServerImpl(this.conf);
        if (this.conf.getBoolean(FRAMED_CONF_KEY, false) || implType.isAlwaysFramed) {
            transportFactory = new TFramedTransport.Factory();
            LOG.debug((Object)"Using framed transport");
        } else {
            transportFactory = new TTransportFactory();
        }
        if (this.conf.get(BIND_CONF_KEY) != null && !implType.canSpecifyBindIP) {
            LOG.error((Object)("Server types " + Joiner.on((String)", ").join(ImplType.serversThatCannotSpecifyBindIP()) + " don't support IP " + "address binding at the moment. See " + "https://issues.apache.org/jira/browse/HBASE-2155 for details."));
            throw new RuntimeException("-hbase.regionserver.thrift.ipaddress not supported with " + (Object)((Object)implType));
        }
        if (implType == ImplType.HS_HA || implType == ImplType.NONBLOCKING || implType == ImplType.THREADED_SELECTOR) {
            TNonblockingServerSocket serverTransport = new TNonblockingServerSocket(this.listenPort);
            if (implType == ImplType.NONBLOCKING) {
                TNonblockingServer.Args serverArgs = new TNonblockingServer.Args((TNonblockingServerTransport)serverTransport);
                ((TNonblockingServer.Args)((TNonblockingServer.Args)serverArgs.processor(processor)).transportFactory((TTransportFactory)transportFactory)).protocolFactory((TProtocolFactory)protocolFactory);
                this.tserver = new TNonblockingServer((AbstractNonblockingServer.AbstractNonblockingServerArgs)serverArgs);
            } else if (implType == ImplType.HS_HA) {
                THsHaServer.Args serverArgs = new THsHaServer.Args((TNonblockingServerTransport)serverTransport);
                CallQueue callQueue = new CallQueue(new LinkedBlockingQueue<CallQueue.Call>(), this.metrics);
                ExecutorService executorService = this.createExecutor(callQueue, serverArgs.getWorkerThreads());
                ((THsHaServer.Args)((THsHaServer.Args)serverArgs.executorService(executorService).processor(processor)).transportFactory((TTransportFactory)transportFactory)).protocolFactory((TProtocolFactory)protocolFactory);
                this.tserver = new THsHaServer(serverArgs);
            } else {
                HThreadedSelectorServerArgs serverArgs = new HThreadedSelectorServerArgs((TNonblockingServerTransport)serverTransport, this.conf);
                CallQueue callQueue = new CallQueue(new LinkedBlockingQueue<CallQueue.Call>(), this.metrics);
                ExecutorService executorService = this.createExecutor(callQueue, serverArgs.getWorkerThreads());
                ((TThreadedSelectorServer.Args)((TThreadedSelectorServer.Args)serverArgs.executorService(executorService).processor(processor)).transportFactory((TTransportFactory)transportFactory)).protocolFactory((TProtocolFactory)protocolFactory);
                this.tserver = new TThreadedSelectorServer((TThreadedSelectorServer.Args)serverArgs);
            }
            LOG.info((Object)("starting HBase " + implType.simpleClassName() + " server on " + Integer.toString(this.listenPort)));
        } else if (implType == ImplType.THREAD_POOL) {
            InetAddress listenAddress = this.getBindAddress(this.conf);
            TServerSocket serverTransport = new TServerSocket(new InetSocketAddress(listenAddress, this.listenPort));
            TBoundedThreadPoolServer.Args serverArgs = new TBoundedThreadPoolServer.Args((TServerTransport)serverTransport, this.conf);
            ((TThreadPoolServer.Args)((TThreadPoolServer.Args)serverArgs.processor(processor)).transportFactory((TTransportFactory)transportFactory)).protocolFactory((TProtocolFactory)protocolFactory);
            LOG.info((Object)("starting " + ImplType.THREAD_POOL.simpleClassName() + " on " + listenAddress + ":" + Integer.toString(this.listenPort) + "; " + (Object)((Object)serverArgs)));
            TBoundedThreadPoolServer tserver = new TBoundedThreadPoolServer(serverArgs, this.metrics);
            this.tserver = tserver;
        } else {
            throw new AssertionError((Object)("Unsupported Thrift server implementation: " + implType.simpleClassName()));
        }
        if (this.tserver.getClass() != implType.serverClass) {
            throw new AssertionError((Object)("Expected to create Thrift server class " + implType.serverClass.getName() + " but got " + this.tserver.getClass().getName()));
        }
        ThriftServerRunner.registerFilters(this.conf);
    }

    ExecutorService createExecutor(BlockingQueue<Runnable> callQueue, int workerThreads) {
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder();
        tfb.setDaemon(true);
        tfb.setNameFormat("thrift-worker-%d");
        return new ThreadPoolExecutor(workerThreads, workerThreads, Long.MAX_VALUE, TimeUnit.SECONDS, callQueue, tfb.build());
    }

    private InetAddress getBindAddress(Configuration conf) throws UnknownHostException {
        String bindAddressStr = conf.get(BIND_CONF_KEY, DEFAULT_BIND_ADDR);
        return InetAddress.getByName(bindAddressStr);
    }

    private static void addAttributes(OperationWithAttributes op, Map<ByteBuffer, ByteBuffer> attributes) {
        if (attributes == null || attributes.size() == 0) {
            return;
        }
        for (Map.Entry<ByteBuffer, ByteBuffer> entry : attributes.entrySet()) {
            String name = Bytes.toStringBinary(Bytes.getBytes(entry.getKey()));
            byte[] value = Bytes.getBytes(entry.getValue());
            op.setAttribute(name, value);
        }
    }

    public static void registerFilters(Configuration conf) {
        String[] filters = conf.getStrings("hbase.thrift.filters");
        if (filters != null) {
            for (String filterClass : filters) {
                String[] filterPart = filterClass.split(":");
                if (filterPart.length != 2) {
                    LOG.warn((Object)("Invalid filter specification " + filterClass + " - skipping"));
                    continue;
                }
                ParseFilter.registerFilter(filterPart[0], filterPart[1]);
            }
        }
    }

    public static class HBaseHandler
    implements Hbase.Iface {
        protected Configuration conf;
        protected HBaseAdmin admin = null;
        protected final Log LOG = LogFactory.getLog((String)this.getClass().getName());
        protected int nextScannerId = 0;
        protected HashMap<Integer, ResultScannerWrapper> scannerMap = null;
        private ThriftMetrics metrics = null;
        private static ThreadLocal<Map<String, HTable>> threadLocalTables = new ThreadLocal<Map<String, HTable>>(){

            @Override
            protected Map<String, HTable> initialValue() {
                return new TreeMap<String, HTable>();
            }
        };
        IncrementCoalescer coalescer = null;

        byte[][] getAllColumns(HTable table) throws IOException {
            HColumnDescriptor[] cds = table.getTableDescriptor().getColumnFamilies();
            byte[][] columns = new byte[cds.length][];
            for (int i = 0; i < cds.length; ++i) {
                columns[i] = Bytes.add(cds[i].getName(), KeyValue.COLUMN_FAMILY_DELIM_ARRAY);
            }
            return columns;
        }

        public HTable getTable(byte[] tableName) throws IOException {
            String table = new String(tableName);
            Map<String, HTable> tables = threadLocalTables.get();
            if (!tables.containsKey(table)) {
                tables.put(table, new HTable(this.conf, tableName));
            }
            return tables.get(table);
        }

        public HTable getTable(ByteBuffer tableName) throws IOException {
            return this.getTable(Bytes.getBytes(tableName));
        }

        protected synchronized int addScanner(ResultScanner scanner, boolean sortColumns) {
            int id = this.nextScannerId++;
            ResultScannerWrapper resultScannerWrapper = new ResultScannerWrapper(scanner, sortColumns);
            this.scannerMap.put(id, resultScannerWrapper);
            return id;
        }

        protected synchronized ResultScannerWrapper getScanner(int id) {
            return this.scannerMap.get(id);
        }

        protected synchronized ResultScannerWrapper removeScanner(int id) {
            return this.scannerMap.remove(id);
        }

        protected HBaseHandler() throws IOException {
            this(HBaseConfiguration.create());
        }

        protected HBaseHandler(Configuration c) throws IOException {
            this.conf = c;
            this.admin = new HBaseAdmin(this.conf);
            this.scannerMap = new HashMap();
            this.coalescer = new IncrementCoalescer(this);
        }

        @Override
        public void enableTable(ByteBuffer tableName) throws IOError {
            try {
                this.admin.enableTable(Bytes.getBytes(tableName));
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public void disableTable(ByteBuffer tableName) throws IOError {
            try {
                this.admin.disableTable(Bytes.getBytes(tableName));
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public boolean isTableEnabled(ByteBuffer tableName) throws IOError {
            try {
                return HTable.isTableEnabled(this.conf, Bytes.getBytes(tableName));
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public void compact(ByteBuffer tableNameOrRegionName) throws IOError {
            try {
                this.admin.compact(Bytes.getBytes(tableNameOrRegionName));
            }
            catch (InterruptedException e) {
                throw new IOError(e.getMessage());
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public void majorCompact(ByteBuffer tableNameOrRegionName) throws IOError {
            try {
                this.admin.majorCompact(Bytes.getBytes(tableNameOrRegionName));
            }
            catch (InterruptedException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public List<ByteBuffer> getTableNames() throws IOError {
            try {
                String[] tableNames = this.admin.getTableNames();
                ArrayList<ByteBuffer> list = new ArrayList<ByteBuffer>(tableNames.length);
                for (int i = 0; i < tableNames.length; ++i) {
                    list.add(ByteBuffer.wrap(Bytes.toBytes(tableNames[i])));
                }
                return list;
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public List<TRegionInfo> getTableRegions(ByteBuffer tableName) throws IOError {
            try {
                HTable table = this.getTable(tableName);
                NavigableMap<HRegionInfo, ServerName> regionLocations = table.getRegionLocations();
                ArrayList<TRegionInfo> results = new ArrayList<TRegionInfo>();
                for (Map.Entry entry : regionLocations.entrySet()) {
                    HRegionInfo info = (HRegionInfo)((Object)entry.getKey());
                    ServerName serverName = (ServerName)entry.getValue();
                    TRegionInfo region = new TRegionInfo();
                    region.serverName = ByteBuffer.wrap(Bytes.toBytes(serverName.getHostname()));
                    region.port = serverName.getPort();
                    region.startKey = ByteBuffer.wrap(info.getStartKey());
                    region.endKey = ByteBuffer.wrap(info.getEndKey());
                    region.id = info.getRegionId();
                    region.name = ByteBuffer.wrap(info.getRegionName());
                    region.version = info.getVersion();
                    results.add(region);
                }
                return results;
            }
            catch (TableNotFoundException e) {
                return Collections.emptyList();
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
        }

        public static byte[] toBytes(ByteBuffer bb) {
            byte[] result = new byte[bb.remaining()];
            ByteBuffer dup = bb.duplicate();
            dup.get(result, 0, result.length);
            return result;
        }

        @Override
        @Deprecated
        public List<TCell> get(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            byte[][] famAndQf = KeyValue.parseColumn(Bytes.getBytes(column));
            if (famAndQf.length == 1) {
                return this.get(tableName, row, famAndQf[0], new byte[0], attributes);
            }
            return this.get(tableName, row, famAndQf[0], famAndQf[1], attributes);
        }

        protected List<TCell> get(ByteBuffer tableName, ByteBuffer row, byte[] family, byte[] qualifier, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            try {
                HTable table = this.getTable(tableName);
                Get get2 = new Get(Bytes.getBytes(row));
                ThriftServerRunner.addAttributes(get2, attributes);
                if (qualifier == null || qualifier.length == 0) {
                    get2.addFamily(family);
                } else {
                    get2.addColumn(family, qualifier);
                }
                Result result = table.get(get2);
                return ThriftUtilities.cellFromHBase(result.raw());
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
        }

        @Override
        @Deprecated
        public List<TCell> getVer(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, int numVersions, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            byte[][] famAndQf = KeyValue.parseColumn(Bytes.getBytes(column));
            if (famAndQf.length == 1) {
                return this.getVer(tableName, row, famAndQf[0], new byte[0], numVersions, attributes);
            }
            return this.getVer(tableName, row, famAndQf[0], famAndQf[1], numVersions, attributes);
        }

        public List<TCell> getVer(ByteBuffer tableName, ByteBuffer row, byte[] family, byte[] qualifier, int numVersions, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            try {
                HTable table = this.getTable(tableName);
                Get get2 = new Get(Bytes.getBytes(row));
                ThriftServerRunner.addAttributes(get2, attributes);
                get2.addColumn(family, qualifier);
                get2.setMaxVersions(numVersions);
                Result result = table.get(get2);
                return ThriftUtilities.cellFromHBase(result.raw());
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
        }

        @Override
        @Deprecated
        public List<TCell> getVerTs(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, long timestamp, int numVersions, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            byte[][] famAndQf = KeyValue.parseColumn(Bytes.getBytes(column));
            if (famAndQf.length == 1) {
                return this.getVerTs(tableName, row, famAndQf[0], new byte[0], timestamp, numVersions, attributes);
            }
            return this.getVerTs(tableName, row, famAndQf[0], famAndQf[1], timestamp, numVersions, attributes);
        }

        protected List<TCell> getVerTs(ByteBuffer tableName, ByteBuffer row, byte[] family, byte[] qualifier, long timestamp, int numVersions, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            try {
                HTable table = this.getTable(tableName);
                Get get2 = new Get(Bytes.getBytes(row));
                ThriftServerRunner.addAttributes(get2, attributes);
                get2.addColumn(family, qualifier);
                get2.setTimeRange(Long.MIN_VALUE, timestamp);
                get2.setMaxVersions(numVersions);
                Result result = table.get(get2);
                return ThriftUtilities.cellFromHBase(result.raw());
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public List<TRowResult> getRow(ByteBuffer tableName, ByteBuffer row, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            return this.getRowWithColumnsTs(tableName, row, null, Long.MAX_VALUE, attributes);
        }

        @Override
        public List<TRowResult> getRowWithColumns(ByteBuffer tableName, ByteBuffer row, List<ByteBuffer> columns, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            return this.getRowWithColumnsTs(tableName, row, columns, Long.MAX_VALUE, attributes);
        }

        @Override
        public List<TRowResult> getRowTs(ByteBuffer tableName, ByteBuffer row, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            return this.getRowWithColumnsTs(tableName, row, null, timestamp, attributes);
        }

        @Override
        public List<TRowResult> getRowWithColumnsTs(ByteBuffer tableName, ByteBuffer row, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            try {
                HTable table = this.getTable(tableName);
                if (columns == null) {
                    Get get2 = new Get(Bytes.getBytes(row));
                    ThriftServerRunner.addAttributes(get2, attributes);
                    get2.setTimeRange(Long.MIN_VALUE, timestamp);
                    Result result = table.get(get2);
                    return ThriftUtilities.rowResultFromHBase(result);
                }
                Get get3 = new Get(Bytes.getBytes(row));
                ThriftServerRunner.addAttributes(get3, attributes);
                for (ByteBuffer column : columns) {
                    byte[][] famAndQf = KeyValue.parseColumn(Bytes.getBytes(column));
                    if (famAndQf.length == 1) {
                        get3.addFamily(famAndQf[0]);
                        continue;
                    }
                    get3.addColumn(famAndQf[0], famAndQf[1]);
                }
                get3.setTimeRange(Long.MIN_VALUE, timestamp);
                Result result = table.get(get3);
                return ThriftUtilities.rowResultFromHBase(result);
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public List<TRowResult> getRows(ByteBuffer tableName, List<ByteBuffer> rows, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            return this.getRowsWithColumnsTs(tableName, rows, null, Long.MAX_VALUE, attributes);
        }

        @Override
        public List<TRowResult> getRowsWithColumns(ByteBuffer tableName, List<ByteBuffer> rows, List<ByteBuffer> columns, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            return this.getRowsWithColumnsTs(tableName, rows, columns, Long.MAX_VALUE, attributes);
        }

        @Override
        public List<TRowResult> getRowsTs(ByteBuffer tableName, List<ByteBuffer> rows, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            return this.getRowsWithColumnsTs(tableName, rows, null, timestamp, attributes);
        }

        @Override
        public List<TRowResult> getRowsWithColumnsTs(ByteBuffer tableName, List<ByteBuffer> rows, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            try {
                ArrayList<Get> gets = new ArrayList<Get>(rows.size());
                HTable table = this.getTable(tableName);
                if (this.metrics != null) {
                    this.metrics.incNumRowKeysInBatchGet(rows.size());
                }
                for (ByteBuffer row : rows) {
                    Get get2 = new Get(Bytes.getBytes(row));
                    ThriftServerRunner.addAttributes(get2, attributes);
                    if (columns != null) {
                        for (ByteBuffer column : columns) {
                            byte[][] famAndQf = KeyValue.parseColumn(Bytes.getBytes(column));
                            if (famAndQf.length == 1) {
                                get2.addFamily(famAndQf[0]);
                                continue;
                            }
                            get2.addColumn(famAndQf[0], famAndQf[1]);
                        }
                    }
                    get2.setTimeRange(Long.MIN_VALUE, timestamp);
                    gets.add(get2);
                }
                Result[] result = table.get(gets);
                return ThriftUtilities.rowResultFromHBase(result);
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public void deleteAll(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            this.deleteAllTs(tableName, row, column, Long.MAX_VALUE, attributes);
        }

        @Override
        public void deleteAllTs(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            try {
                HTable table = this.getTable(tableName);
                Delete delete = new Delete(Bytes.getBytes(row));
                ThriftServerRunner.addAttributes(delete, attributes);
                byte[][] famAndQf = KeyValue.parseColumn(Bytes.getBytes(column));
                if (famAndQf.length == 1) {
                    delete.deleteFamily(famAndQf[0], timestamp);
                } else {
                    delete.deleteColumns(famAndQf[0], famAndQf[1], timestamp);
                }
                table.delete(delete);
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public void deleteAllRow(ByteBuffer tableName, ByteBuffer row, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            this.deleteAllRowTs(tableName, row, Long.MAX_VALUE, attributes);
        }

        @Override
        public void deleteAllRowTs(ByteBuffer tableName, ByteBuffer row, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            try {
                HTable table = this.getTable(tableName);
                Delete delete = new Delete(Bytes.getBytes(row), timestamp, null);
                ThriftServerRunner.addAttributes(delete, attributes);
                table.delete(delete);
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public void createTable(ByteBuffer in_tableName, List<ColumnDescriptor> columnFamilies) throws IOError, IllegalArgument, AlreadyExists {
            byte[] tableName = Bytes.getBytes(in_tableName);
            try {
                if (this.admin.tableExists(tableName)) {
                    throw new AlreadyExists("table name already in use");
                }
                HTableDescriptor desc = new HTableDescriptor(tableName);
                for (ColumnDescriptor col : columnFamilies) {
                    HColumnDescriptor colDesc = ThriftUtilities.colDescFromThrift(col);
                    desc.addFamily(colDesc);
                }
                this.admin.createTable(desc);
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IllegalArgument(e.getMessage());
            }
        }

        @Override
        public void deleteTable(ByteBuffer in_tableName) throws IOError {
            byte[] tableName = Bytes.getBytes(in_tableName);
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("deleteTable: table=" + Bytes.toString(tableName)));
            }
            try {
                if (!this.admin.tableExists(tableName)) {
                    throw new IOException("table does not exist");
                }
                this.admin.deleteTable(tableName);
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public void mutateRow(ByteBuffer tableName, ByteBuffer row, List<Mutation> mutations, Map<ByteBuffer, ByteBuffer> attributes) throws IOError, IllegalArgument {
            this.mutateRowTs(tableName, row, mutations, Long.MAX_VALUE, attributes);
        }

        @Override
        public void mutateRowTs(ByteBuffer tableName, ByteBuffer row, List<Mutation> mutations, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError, IllegalArgument {
            HTable table = null;
            try {
                table = this.getTable(tableName);
                Put put2 = new Put(Bytes.getBytes(row), timestamp, null);
                ThriftServerRunner.addAttributes(put2, attributes);
                Delete delete = new Delete(Bytes.getBytes(row));
                ThriftServerRunner.addAttributes(delete, attributes);
                if (this.metrics != null) {
                    this.metrics.incNumRowKeysInBatchMutate(mutations.size());
                }
                for (Mutation m : mutations) {
                    byte[][] famAndQf = KeyValue.parseColumn(Bytes.getBytes(m.column));
                    if (m.isDelete) {
                        if (famAndQf.length == 1) {
                            delete.deleteFamily(famAndQf[0], timestamp);
                        } else {
                            delete.deleteColumns(famAndQf[0], famAndQf[1], timestamp);
                        }
                        delete.setWriteToWAL(m.writeToWAL);
                        continue;
                    }
                    if (famAndQf.length == 1) {
                        put2.add(famAndQf[0], HConstants.EMPTY_BYTE_ARRAY, m.value != null ? Bytes.getBytes(m.value) : HConstants.EMPTY_BYTE_ARRAY);
                    } else {
                        put2.add(famAndQf[0], famAndQf[1], m.value != null ? Bytes.getBytes(m.value) : HConstants.EMPTY_BYTE_ARRAY);
                    }
                    put2.setWriteToWAL(m.writeToWAL);
                }
                if (!delete.isEmpty()) {
                    table.delete(delete);
                }
                if (!put2.isEmpty()) {
                    table.put(put2);
                }
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IllegalArgument(e.getMessage());
            }
        }

        @Override
        public void mutateRows(ByteBuffer tableName, List<BatchMutation> rowBatches, Map<ByteBuffer, ByteBuffer> attributes) throws IOError, IllegalArgument, TException {
            this.mutateRowsTs(tableName, rowBatches, Long.MAX_VALUE, attributes);
        }

        @Override
        public void mutateRowsTs(ByteBuffer tableName, List<BatchMutation> rowBatches, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError, IllegalArgument, TException {
            ArrayList<Put> puts = new ArrayList<Put>();
            ArrayList<Delete> deletes = new ArrayList<Delete>();
            for (BatchMutation batch : rowBatches) {
                byte[] row = Bytes.getBytes(batch.row);
                List<Mutation> mutations = batch.mutations;
                Delete delete = new Delete(row);
                ThriftServerRunner.addAttributes(delete, attributes);
                Put put2 = new Put(row, timestamp, null);
                ThriftServerRunner.addAttributes(put2, attributes);
                for (Mutation m : mutations) {
                    byte[][] famAndQf = KeyValue.parseColumn(Bytes.getBytes(m.column));
                    if (m.isDelete) {
                        if (famAndQf.length == 1) {
                            delete.deleteFamily(famAndQf[0], timestamp);
                        } else {
                            delete.deleteColumns(famAndQf[0], famAndQf[1], timestamp);
                        }
                        delete.setWriteToWAL(m.writeToWAL);
                        continue;
                    }
                    if (famAndQf.length == 1) {
                        put2.add(famAndQf[0], HConstants.EMPTY_BYTE_ARRAY, m.value != null ? Bytes.getBytes(m.value) : HConstants.EMPTY_BYTE_ARRAY);
                    } else {
                        put2.add(famAndQf[0], famAndQf[1], m.value != null ? Bytes.getBytes(m.value) : HConstants.EMPTY_BYTE_ARRAY);
                    }
                    put2.setWriteToWAL(m.writeToWAL);
                }
                if (!delete.isEmpty()) {
                    deletes.add(delete);
                }
                if (put2.isEmpty()) continue;
                puts.add(put2);
            }
            HTable table = null;
            try {
                table = this.getTable(tableName);
                if (!puts.isEmpty()) {
                    table.put(puts);
                }
                if (!deletes.isEmpty()) {
                    table.delete(deletes);
                }
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IllegalArgument(e.getMessage());
            }
        }

        @Override
        @Deprecated
        public long atomicIncrement(ByteBuffer tableName, ByteBuffer row, ByteBuffer column, long amount) throws IOError, IllegalArgument, TException {
            byte[][] famAndQf = KeyValue.parseColumn(Bytes.getBytes(column));
            if (famAndQf.length == 1) {
                return this.atomicIncrement(tableName, row, famAndQf[0], new byte[0], amount);
            }
            return this.atomicIncrement(tableName, row, famAndQf[0], famAndQf[1], amount);
        }

        protected long atomicIncrement(ByteBuffer tableName, ByteBuffer row, byte[] family, byte[] qualifier, long amount) throws IOError, IllegalArgument, TException {
            try {
                HTable table = this.getTable(tableName);
                return table.incrementColumnValue(Bytes.getBytes(row), family, qualifier, amount);
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public void scannerClose(int id) throws IOError, IllegalArgument {
            this.LOG.debug((Object)("scannerClose: id=" + id));
            ResultScannerWrapper resultScannerWrapper = this.getScanner(id);
            if (resultScannerWrapper == null) {
                String message = "scanner ID is invalid";
                this.LOG.warn((Object)message);
                throw new IllegalArgument("scanner ID is invalid");
            }
            resultScannerWrapper.getScanner().close();
            this.removeScanner(id);
        }

        @Override
        public List<TRowResult> scannerGetList(int id, int nbRows) throws IllegalArgument, IOError {
            this.LOG.debug((Object)("scannerGetList: id=" + id));
            ResultScannerWrapper resultScannerWrapper = this.getScanner(id);
            if (null == resultScannerWrapper) {
                String message = "scanner ID is invalid";
                this.LOG.warn((Object)message);
                throw new IllegalArgument("scanner ID is invalid");
            }
            Result[] results = null;
            try {
                results = resultScannerWrapper.getScanner().next(nbRows);
                if (null == results) {
                    return new ArrayList<TRowResult>();
                }
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
            return ThriftUtilities.rowResultFromHBase(results, resultScannerWrapper.isColumnSorted());
        }

        @Override
        public List<TRowResult> scannerGet(int id) throws IllegalArgument, IOError {
            return this.scannerGetList(id, 1);
        }

        @Override
        public int scannerOpenWithScan(ByteBuffer tableName, TScan tScan, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            try {
                HTable table = this.getTable(tableName);
                Scan scan = new Scan();
                ThriftServerRunner.addAttributes(scan, attributes);
                if (tScan.isSetStartRow()) {
                    scan.setStartRow(tScan.getStartRow());
                }
                if (tScan.isSetStopRow()) {
                    scan.setStopRow(tScan.getStopRow());
                }
                if (tScan.isSetTimestamp()) {
                    scan.setTimeRange(Long.MIN_VALUE, tScan.getTimestamp());
                }
                if (tScan.isSetCaching()) {
                    scan.setCaching(tScan.getCaching());
                }
                if (tScan.isSetColumns() && tScan.getColumns().size() != 0) {
                    for (ByteBuffer column : tScan.getColumns()) {
                        byte[][] famQf = KeyValue.parseColumn(Bytes.getBytes(column));
                        if (famQf.length == 1) {
                            scan.addFamily(famQf[0]);
                            continue;
                        }
                        scan.addColumn(famQf[0], famQf[1]);
                    }
                }
                if (tScan.isSetFilterString()) {
                    ParseFilter parseFilter = new ParseFilter();
                    scan.setFilter(parseFilter.parseFilterString(tScan.getFilterString()));
                }
                return this.addScanner(table.getScanner(scan), tScan.sortColumns);
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public int scannerOpen(ByteBuffer tableName, ByteBuffer startRow, List<ByteBuffer> columns, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            try {
                HTable table = this.getTable(tableName);
                Scan scan = new Scan(Bytes.getBytes(startRow));
                ThriftServerRunner.addAttributes(scan, attributes);
                if (columns != null && columns.size() != 0) {
                    for (ByteBuffer column : columns) {
                        byte[][] famQf = KeyValue.parseColumn(Bytes.getBytes(column));
                        if (famQf.length == 1) {
                            scan.addFamily(famQf[0]);
                            continue;
                        }
                        scan.addColumn(famQf[0], famQf[1]);
                    }
                }
                return this.addScanner(table.getScanner(scan), false);
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public int scannerOpenWithStop(ByteBuffer tableName, ByteBuffer startRow, ByteBuffer stopRow, List<ByteBuffer> columns, Map<ByteBuffer, ByteBuffer> attributes) throws IOError, TException {
            try {
                HTable table = this.getTable(tableName);
                Scan scan = new Scan(Bytes.getBytes(startRow), Bytes.getBytes(stopRow));
                ThriftServerRunner.addAttributes(scan, attributes);
                if (columns != null && columns.size() != 0) {
                    for (ByteBuffer column : columns) {
                        byte[][] famQf = KeyValue.parseColumn(Bytes.getBytes(column));
                        if (famQf.length == 1) {
                            scan.addFamily(famQf[0]);
                            continue;
                        }
                        scan.addColumn(famQf[0], famQf[1]);
                    }
                }
                return this.addScanner(table.getScanner(scan), false);
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public int scannerOpenWithPrefix(ByteBuffer tableName, ByteBuffer startAndPrefix, List<ByteBuffer> columns, Map<ByteBuffer, ByteBuffer> attributes) throws IOError, TException {
            try {
                HTable table = this.getTable(tableName);
                Scan scan = new Scan(Bytes.getBytes(startAndPrefix));
                ThriftServerRunner.addAttributes(scan, attributes);
                WhileMatchFilter f = new WhileMatchFilter(new PrefixFilter(Bytes.getBytes(startAndPrefix)));
                scan.setFilter(f);
                if (columns != null && columns.size() != 0) {
                    for (ByteBuffer column : columns) {
                        byte[][] famQf = KeyValue.parseColumn(Bytes.getBytes(column));
                        if (famQf.length == 1) {
                            scan.addFamily(famQf[0]);
                            continue;
                        }
                        scan.addColumn(famQf[0], famQf[1]);
                    }
                }
                return this.addScanner(table.getScanner(scan), false);
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public int scannerOpenTs(ByteBuffer tableName, ByteBuffer startRow, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError, TException {
            try {
                HTable table = this.getTable(tableName);
                Scan scan = new Scan(Bytes.getBytes(startRow));
                ThriftServerRunner.addAttributes(scan, attributes);
                scan.setTimeRange(Long.MIN_VALUE, timestamp);
                if (columns != null && columns.size() != 0) {
                    for (ByteBuffer column : columns) {
                        byte[][] famQf = KeyValue.parseColumn(Bytes.getBytes(column));
                        if (famQf.length == 1) {
                            scan.addFamily(famQf[0]);
                            continue;
                        }
                        scan.addColumn(famQf[0], famQf[1]);
                    }
                }
                return this.addScanner(table.getScanner(scan), false);
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public int scannerOpenWithStopTs(ByteBuffer tableName, ByteBuffer startRow, ByteBuffer stopRow, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError, TException {
            try {
                HTable table = this.getTable(tableName);
                Scan scan = new Scan(Bytes.getBytes(startRow), Bytes.getBytes(stopRow));
                ThriftServerRunner.addAttributes(scan, attributes);
                scan.setTimeRange(Long.MIN_VALUE, timestamp);
                if (columns != null && columns.size() != 0) {
                    for (ByteBuffer column : columns) {
                        byte[][] famQf = KeyValue.parseColumn(Bytes.getBytes(column));
                        if (famQf.length == 1) {
                            scan.addFamily(famQf[0]);
                            continue;
                        }
                        scan.addColumn(famQf[0], famQf[1]);
                    }
                }
                scan.setTimeRange(Long.MIN_VALUE, timestamp);
                return this.addScanner(table.getScanner(scan), false);
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public Map<ByteBuffer, ColumnDescriptor> getColumnDescriptors(ByteBuffer tableName) throws IOError, TException {
            try {
                TreeMap<ByteBuffer, ColumnDescriptor> columns = new TreeMap<ByteBuffer, ColumnDescriptor>();
                HTable table = this.getTable(tableName);
                HTableDescriptor desc = table.getTableDescriptor();
                for (HColumnDescriptor e : desc.getFamilies()) {
                    ColumnDescriptor col = ThriftUtilities.colDescFromHbase(e);
                    columns.put(col.name, col);
                }
                return columns;
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public List<TCell> getRowOrBefore(ByteBuffer tableName, ByteBuffer row, ByteBuffer family) throws IOError {
            try {
                HTable table = this.getTable(Bytes.getBytes(tableName));
                Result result = table.getRowOrBefore(Bytes.getBytes(row), Bytes.getBytes(family));
                return ThriftUtilities.cellFromHBase(result.raw());
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public TRegionInfo getRegionInfo(ByteBuffer searchRow) throws IOError {
            try {
                HTable table = this.getTable(HConstants.META_TABLE_NAME);
                byte[] row = HBaseHandler.toBytes(searchRow);
                Result startRowResult = table.getRowOrBefore(row, HConstants.CATALOG_FAMILY);
                if (startRowResult == null) {
                    throw new IOException("Cannot find row in .META., row=" + Bytes.toString(searchRow.array()));
                }
                byte[] value = startRowResult.getValue(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER);
                if (value == null || value.length == 0) {
                    throw new IOException("HRegionInfo REGIONINFO was null or  empty in Meta for row=" + Bytes.toString(row));
                }
                HRegionInfo regionInfo = Writables.getHRegionInfo(value);
                TRegionInfo region = new TRegionInfo();
                region.setStartKey(regionInfo.getStartKey());
                region.setEndKey(regionInfo.getEndKey());
                region.id = regionInfo.getRegionId();
                region.setName(regionInfo.getRegionName());
                region.version = regionInfo.getVersion();
                value = startRowResult.getValue(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER);
                if (value != null && value.length > 0) {
                    String hostAndPort = Bytes.toString(value);
                    region.setServerName(Bytes.toBytes(Addressing.parseHostname(hostAndPort)));
                    region.port = Addressing.parsePort(hostAndPort);
                }
                return region;
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
        }

        private void initMetrics(ThriftMetrics metrics) {
            this.metrics = metrics;
        }

        @Override
        public void increment(TIncrement tincrement) throws IOError, TException {
            if (tincrement.getRow().length == 0 || tincrement.getTable().length == 0) {
                throw new TException("Must supply a table and a row key; can't increment");
            }
            if (this.conf.getBoolean(ThriftServerRunner.COALESCE_INC_KEY, false)) {
                this.coalescer.queueIncrement(tincrement);
                return;
            }
            try {
                HTable table = this.getTable(tincrement.getTable());
                Increment inc = ThriftUtilities.incrementFromThrift(tincrement);
                table.increment(inc);
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
        }

        @Override
        public void incrementRows(List<TIncrement> tincrements) throws IOError, TException {
            if (this.conf.getBoolean(ThriftServerRunner.COALESCE_INC_KEY, false)) {
                this.coalescer.queueIncrements(tincrements);
                return;
            }
            for (TIncrement tinc : tincrements) {
                this.increment(tinc);
            }
        }
    }

    protected static class ResultScannerWrapper {
        private final ResultScanner scanner;
        private final boolean sortColumns;

        public ResultScannerWrapper(ResultScanner resultScanner, boolean sortResultColumns) {
            this.scanner = resultScanner;
            this.sortColumns = sortResultColumns;
        }

        public ResultScanner getScanner() {
            return this.scanner;
        }

        public boolean isColumnSorted() {
            return this.sortColumns;
        }
    }

    static enum ImplType {
        HS_HA("hsha", true, THsHaServer.class, false),
        NONBLOCKING("nonblocking", true, TNonblockingServer.class, false),
        THREAD_POOL("threadpool", false, TBoundedThreadPoolServer.class, true),
        THREADED_SELECTOR("threadedselector", true, TThreadedSelectorServer.class, false);

        public static final ImplType DEFAULT;
        final String option;
        final boolean isAlwaysFramed;
        final Class<? extends TServer> serverClass;
        final boolean canSpecifyBindIP;

        private ImplType(String option, boolean isAlwaysFramed, Class<? extends TServer> serverClass, boolean canSpecifyBindIP) {
            this.option = option;
            this.isAlwaysFramed = isAlwaysFramed;
            this.serverClass = serverClass;
            this.canSpecifyBindIP = canSpecifyBindIP;
        }

        public String toString() {
            return "-" + this.option;
        }

        String getDescription() {
            StringBuilder sb = new StringBuilder("Use the " + this.serverClass.getSimpleName());
            if (this.isAlwaysFramed) {
                sb.append(" This implies the framed transport.");
            }
            if (this == DEFAULT) {
                sb.append("This is the default.");
            }
            return sb.toString();
        }

        static OptionGroup createOptionGroup() {
            OptionGroup group = new OptionGroup();
            for (ImplType t : ImplType.values()) {
                group.addOption(new Option(t.option, t.getDescription()));
            }
            return group;
        }

        static ImplType getServerImpl(Configuration conf) {
            String confType = conf.get(ThriftServerRunner.SERVER_TYPE_CONF_KEY, ImplType.THREAD_POOL.option);
            for (ImplType t : ImplType.values()) {
                if (!confType.equals(t.option)) continue;
                return t;
            }
            throw new AssertionError((Object)("Unknown server ImplType.option:" + confType));
        }

        static void setServerImpl(CommandLine cmd, Configuration conf) {
            ImplType chosenType = null;
            int numChosen = 0;
            for (ImplType t : ImplType.values()) {
                if (!cmd.hasOption(t.option)) continue;
                chosenType = t;
                ++numChosen;
            }
            if (numChosen < 1) {
                LOG.info((Object)"Using default thrift server type");
                chosenType = DEFAULT;
            } else if (numChosen > 1) {
                throw new AssertionError((Object)("Exactly one option out of " + Arrays.toString((Object[])ImplType.values()) + " has to be specified"));
            }
            LOG.info((Object)("Using thrift server type " + chosenType.option));
            conf.set(ThriftServerRunner.SERVER_TYPE_CONF_KEY, chosenType.option);
        }

        public String simpleClassName() {
            return this.serverClass.getSimpleName();
        }

        public static List<String> serversThatCannotSpecifyBindIP() {
            ArrayList<String> l = new ArrayList<String>();
            for (ImplType t : ImplType.values()) {
                if (t.canSpecifyBindIP) continue;
                l.add(t.simpleClassName());
            }
            return l;
        }

        static {
            DEFAULT = THREAD_POOL;
        }
    }
}

