/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.impl.message.modifier.hash;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.productivity.java.syslog4j.SyslogConfigIF;
import org.productivity.java.syslog4j.SyslogIF;
import org.productivity.java.syslog4j.SyslogMessageModifierIF;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.impl.message.modifier.hash.HashSyslogMessageModifierConfig;
import org.productivity.java.syslog4j.util.Base64;
import org.productivity.java.syslog4j.util.SyslogUtility;

public class HashSyslogMessageModifier
implements SyslogMessageModifierIF {
    private static final long serialVersionUID = 7335757344826206953L;
    protected HashSyslogMessageModifierConfig config = null;

    public static final HashSyslogMessageModifier createMD5() {
        HashSyslogMessageModifier hashSyslogMessageModifier = new HashSyslogMessageModifier(HashSyslogMessageModifierConfig.createMD5());
        return hashSyslogMessageModifier;
    }

    public static final HashSyslogMessageModifier createSHA1() {
        HashSyslogMessageModifier hashSyslogMessageModifier = new HashSyslogMessageModifier(HashSyslogMessageModifierConfig.createSHA1());
        return hashSyslogMessageModifier;
    }

    public static final HashSyslogMessageModifier createSHA160() {
        return HashSyslogMessageModifier.createSHA1();
    }

    public static final HashSyslogMessageModifier createSHA256() {
        HashSyslogMessageModifier hashSyslogMessageModifier = new HashSyslogMessageModifier(HashSyslogMessageModifierConfig.createSHA256());
        return hashSyslogMessageModifier;
    }

    public static final HashSyslogMessageModifier createSHA384() {
        HashSyslogMessageModifier hashSyslogMessageModifier = new HashSyslogMessageModifier(HashSyslogMessageModifierConfig.createSHA384());
        return hashSyslogMessageModifier;
    }

    public static final HashSyslogMessageModifier createSHA512() {
        HashSyslogMessageModifier hashSyslogMessageModifier = new HashSyslogMessageModifier(HashSyslogMessageModifierConfig.createSHA512());
        return hashSyslogMessageModifier;
    }

    public HashSyslogMessageModifier(HashSyslogMessageModifierConfig hashSyslogMessageModifierConfig) throws SyslogRuntimeException {
        this.config = hashSyslogMessageModifierConfig;
        if (this.config == null) {
            throw new SyslogRuntimeException("Hash config object cannot be null");
        }
        if (this.config.getHashAlgorithm() == null) {
            throw new SyslogRuntimeException("Hash algorithm cannot be null");
        }
        try {
            MessageDigest.getInstance(hashSyslogMessageModifierConfig.getHashAlgorithm());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SyslogRuntimeException(noSuchAlgorithmException);
        }
    }

    protected MessageDigest obtainMessageDigest() {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(this.config.getHashAlgorithm());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SyslogRuntimeException(noSuchAlgorithmException);
        }
        return messageDigest;
    }

    public HashSyslogMessageModifierConfig getConfig() {
        return this.config;
    }

    public String modify(SyslogIF syslogIF, SyslogConfigIF syslogConfigIF, int n, int n2, String string) {
        byte[] byArray = SyslogUtility.getBytes(syslogConfigIF, string);
        MessageDigest messageDigest = this.obtainMessageDigest();
        byte[] byArray2 = messageDigest.digest(byArray);
        String string2 = Base64.encodeBytes(byArray2, 8);
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(this.config.getPrefix());
        stringBuffer.append(string2);
        stringBuffer.append(this.config.getSuffix());
        return stringBuffer.toString();
    }
}

