/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.spark;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.spark.JobEntrySparkSubmit;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class JobEntrySparkSubmitDialog
extends JobEntryDialog
implements JobEntryDialogInterface {
    private static Class<?> PKG = JobEntrySparkSubmit.class;
    private static final int SHELL_MINIMUM_WIDTH = 400;
    private static final int MARGIN_LARGE = 15;
    private static final int MARGIN_MEDIUM = 10;
    private static final int MARGIN_SMALL = 5;
    private static final String[] FILEFORMATS = new String[]{BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.Fileformat.All", (String[])new String[0])};
    private static final String[] MASTER_URLS = new String[]{"yarn-cluster", "yarn-client"};
    private Shell shell;
    private JobEntrySparkSubmit jobEntry;
    private boolean backupChanged;
    private Text name;
    private TableView configParams;
    private TextVar sparkSubmit;
    private ComboVar masterUrl;
    private TextVar clazz;
    private TextVar jar;
    private TextVar args;
    private TextVar driverMemory;
    private TextVar executorMemory;
    private Button blockExecution;

    public JobEntrySparkSubmitDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.jobEntry = (JobEntrySparkSubmit)jobEntryInt;
    }

    public JobEntryInterface open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, this.props.getJobsDialogStyle());
        this.props.setLook((Control)this.shell);
        JobDialog.setShellImage((Shell)this.shell, (JobEntryInterface)this.jobEntry);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntrySparkSubmitDialog.this.jobEntry.setChanged();
            }
        };
        this.backupChanged = this.jobEntry.hasChanged();
        SelectionAdapter lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                JobEntrySparkSubmitDialog.this.ok();
            }
        };
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.Title", (String[])new String[0]));
        Label nameLabel = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)nameLabel);
        nameLabel.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.Name.Label", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        nameLabel.setLayoutData((Object)fdlName);
        this.name = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.name);
        this.name.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)nameLabel, 5);
        fdName.left = new FormAttachment((Control)nameLabel, 0, 16384);
        fdName.right = new FormAttachment(70, 0);
        this.name.setLayoutData((Object)fdName);
        Label stepIcon = new Label((Composite)this.shell, 0);
        this.props.setLook((Control)stepIcon);
        stepIcon.setImage(GUIResource.getInstance().getImage("org/pentaho/di/ui/job/entries/spark/img/spark.svg", ((Object)((Object)this)).getClass().getClassLoader(), 32, 32));
        FormData fdIcon = new FormData();
        fdIcon.right = new FormAttachment(100);
        fdIcon.top = new FormAttachment((Control)nameLabel, 0, 128);
        stepIcon.setLayoutData((Object)fdIcon);
        Label topSeparator = new Label((Composite)this.shell, 258);
        this.props.setLook((Control)topSeparator);
        FormData fdTopSeparator = new FormData();
        fdTopSeparator.top = new FormAttachment((Control)this.name, 15);
        fdTopSeparator.left = new FormAttachment(0);
        fdTopSeparator.right = new FormAttachment(100);
        topSeparator.setLayoutData((Object)fdTopSeparator);
        Button wCancel = new Button((Composite)this.shell, 8);
        this.props.setLook((Control)wCancel);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        FormData fdCancel = new FormData();
        fdCancel.right = new FormAttachment(100);
        fdCancel.bottom = new FormAttachment(100);
        wCancel.setLayoutData((Object)fdCancel);
        Button wOK = new Button((Composite)this.shell, 8);
        this.props.setLook((Control)wOK);
        wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        FormData fdOk = new FormData();
        fdOk.right = new FormAttachment((Control)wCancel, -5);
        fdOk.bottom = new FormAttachment((Control)wCancel, 0, 1024);
        wOK.setLayoutData((Object)fdOk);
        Label bottomSeparator = new Label((Composite)this.shell, 258);
        this.props.setLook((Control)bottomSeparator);
        FormData fdBottomSeparator = new FormData();
        fdBottomSeparator.bottom = new FormAttachment((Control)wCancel, -15);
        fdBottomSeparator.left = new FormAttachment(0);
        fdBottomSeparator.right = new FormAttachment(100);
        bottomSeparator.setLayoutData((Object)fdBottomSeparator);
        CTabFolder tabs = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)tabs, 5);
        FormData fdTabs = new FormData();
        fdTabs.left = new FormAttachment(0);
        fdTabs.right = new FormAttachment(100);
        fdTabs.top = new FormAttachment((Control)topSeparator, 15);
        fdTabs.bottom = new FormAttachment((Control)bottomSeparator, -15, 128);
        tabs.setLayoutData((Object)fdTabs);
        CTabItem jobConfigTab = new CTabItem(tabs, 0);
        jobConfigTab.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.JobSetupTab.Label", (String[])new String[0]));
        Composite jobConfigTabComposite = new Composite((Composite)tabs, 0);
        this.props.setLook((Control)jobConfigTabComposite);
        jobConfigTab.setControl((Control)jobConfigTabComposite);
        FormLayout jobConfigCompositeLayout = new FormLayout();
        jobConfigCompositeLayout.marginHeight = 15;
        jobConfigCompositeLayout.marginWidth = 15;
        jobConfigTabComposite.setLayout((Layout)jobConfigCompositeLayout);
        Label sparkSubmitLabel = new Label(jobConfigTabComposite, 131072);
        sparkSubmitLabel.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.ScriptPath.Label", (String[])new String[0]));
        this.props.setLook((Control)sparkSubmitLabel);
        FormData fdSparkSubmitLabel = new FormData();
        fdSparkSubmitLabel.left = new FormAttachment(0);
        fdSparkSubmitLabel.top = new FormAttachment(0);
        sparkSubmitLabel.setLayoutData((Object)fdSparkSubmitLabel);
        this.sparkSubmit = new TextVar((VariableSpace)this.jobMeta, jobConfigTabComposite, 18436);
        this.props.setLook((Control)this.sparkSubmit);
        this.sparkSubmit.addModifyListener(lsMod);
        this.sparkSubmit.addSelectionListener(lsDef);
        Button browseSparkSubmit = new Button(jobConfigTabComposite, 8);
        this.props.setLook((Control)browseSparkSubmit);
        browseSparkSubmit.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdBrowseSparkSubmit = new FormData();
        fdBrowseSparkSubmit.top = new FormAttachment((Control)sparkSubmitLabel, 5);
        fdBrowseSparkSubmit.right = new FormAttachment(100, 0);
        browseSparkSubmit.setLayoutData((Object)fdBrowseSparkSubmit);
        FormData fdSparkSubmit = new FormData();
        fdSparkSubmit.left = new FormAttachment(0);
        fdSparkSubmit.right = new FormAttachment((Control)browseSparkSubmit, -5);
        fdSparkSubmit.top = new FormAttachment((Control)sparkSubmitLabel, 5);
        this.sparkSubmit.setLayoutData((Object)fdSparkSubmit);
        browseSparkSubmit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(JobEntrySparkSubmitDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*;*.*"});
                dialog.setFilterNames(FILEFORMATS);
                if (JobEntrySparkSubmitDialog.this.sparkSubmit.getText() != null) {
                    dialog.setFileName(JobEntrySparkSubmitDialog.this.sparkSubmit.getText());
                }
                if (dialog.open() != null) {
                    JobEntrySparkSubmitDialog.this.sparkSubmit.setText(dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName());
                }
            }
        });
        Label masterUrlLabel = new Label(jobConfigTabComposite, 0);
        this.props.setLook((Control)masterUrlLabel);
        masterUrlLabel.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.SparkMaster.Label", (String[])new String[0]));
        FormData fdMasterUrlLabel = new FormData();
        fdMasterUrlLabel.left = new FormAttachment(0);
        fdMasterUrlLabel.top = new FormAttachment((Control)this.sparkSubmit, 10);
        masterUrlLabel.setLayoutData((Object)fdMasterUrlLabel);
        this.masterUrl = new ComboVar((VariableSpace)this.jobMeta, jobConfigTabComposite, 2048);
        this.props.setLook((Control)this.masterUrl);
        this.masterUrl.addModifyListener(lsMod);
        FormData fdMasterUrl = new FormData();
        fdMasterUrl.left = new FormAttachment(0);
        fdMasterUrl.right = new FormAttachment(100, 0);
        fdMasterUrl.top = new FormAttachment((Control)masterUrlLabel, 5);
        this.masterUrl.setLayoutData((Object)fdMasterUrl);
        Label jarLabel = new Label(jobConfigTabComposite, 131072);
        jarLabel.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.Jar.Label", (String[])new String[0]));
        this.props.setLook((Control)jarLabel);
        FormData fdJarLabel = new FormData();
        fdJarLabel.left = new FormAttachment(0);
        fdJarLabel.top = new FormAttachment((Control)this.masterUrl, 10);
        jarLabel.setLayoutData((Object)fdJarLabel);
        this.jar = new TextVar((VariableSpace)this.jobMeta, jobConfigTabComposite, 18436);
        this.props.setLook((Control)this.jar);
        this.jar.addModifyListener(lsMod);
        this.jar.addSelectionListener(lsDef);
        Button browseJar = new Button(jobConfigTabComposite, 0x1000008);
        this.props.setLook((Control)browseJar);
        browseJar.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdBrowseJar = new FormData();
        fdBrowseJar.top = new FormAttachment((Control)jarLabel, 5);
        fdBrowseJar.right = new FormAttachment(100, 0);
        browseJar.setLayoutData((Object)fdBrowseJar);
        FormData fdJar = new FormData();
        fdJar.left = new FormAttachment(0);
        fdJar.right = new FormAttachment((Control)browseJar, -5);
        fdJar.top = new FormAttachment((Control)jarLabel, 5);
        this.jar.setLayoutData((Object)fdJar);
        browseJar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(JobEntrySparkSubmitDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*;*.*"});
                dialog.setFilterNames(FILEFORMATS);
                if (JobEntrySparkSubmitDialog.this.jar.getText() != null) {
                    dialog.setFileName(JobEntrySparkSubmitDialog.this.jar.getText());
                }
                if (dialog.open() != null) {
                    JobEntrySparkSubmitDialog.this.jar.setText(dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName());
                }
            }
        });
        Label classLabel = new Label(jobConfigTabComposite, 131072);
        classLabel.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.Class.Label", (String[])new String[0]));
        this.props.setLook((Control)classLabel);
        FormData fdClassLabel = new FormData();
        fdClassLabel.left = new FormAttachment(0);
        fdClassLabel.top = new FormAttachment((Control)this.jar, 10);
        classLabel.setLayoutData((Object)fdClassLabel);
        this.clazz = new TextVar((VariableSpace)this.jobMeta, jobConfigTabComposite, 18436);
        this.props.setLook((Control)this.clazz);
        this.clazz.addModifyListener(lsMod);
        this.clazz.addSelectionListener(lsDef);
        FormData fdClass = new FormData();
        fdClass.left = new FormAttachment(0);
        fdClass.right = new FormAttachment(100, 0);
        fdClass.top = new FormAttachment((Control)classLabel, 5);
        this.clazz.setLayoutData((Object)fdClass);
        Label argsLabel = new Label(jobConfigTabComposite, 131072);
        argsLabel.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.Args.Label", (String[])new String[0]));
        this.props.setLook((Control)argsLabel);
        FormData fdArgsLabel = new FormData();
        fdArgsLabel.left = new FormAttachment(0);
        fdArgsLabel.top = new FormAttachment((Control)this.clazz, 10);
        argsLabel.setLayoutData((Object)fdArgsLabel);
        this.args = new TextVar((VariableSpace)this.jobMeta, jobConfigTabComposite, 18436);
        this.props.setLook((Control)this.args);
        this.args.addModifyListener(lsMod);
        this.args.addSelectionListener(lsDef);
        FormData fdArgs = new FormData();
        fdArgs.left = new FormAttachment(0);
        fdArgs.right = new FormAttachment(100, 0);
        fdArgs.top = new FormAttachment((Control)argsLabel, 5);
        this.args.setLayoutData((Object)fdArgs);
        Group group = new Group(jobConfigTabComposite, 0);
        this.props.setLook((Control)group);
        group.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.MemoryAllocation.Label", (String[])new String[0]));
        FormLayout groupLayout = new FormLayout();
        groupLayout.marginHeight = 15;
        groupLayout.marginWidth = 10;
        group.setLayout((Layout)groupLayout);
        FormData fdGroup = new FormData();
        fdGroup.left = new FormAttachment(0);
        fdGroup.right = new FormAttachment(100);
        fdGroup.top = new FormAttachment((Control)this.args, 15);
        group.setLayoutData((Object)fdGroup);
        Label executorMemoryLabel = new Label((Composite)group, 0);
        this.props.setLook((Control)executorMemoryLabel);
        executorMemoryLabel.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.MemoryAllocation.Executor.Label", (String[])new String[0]));
        FormData fdExecutorLabel = new FormData();
        fdExecutorLabel.top = new FormAttachment(0);
        fdExecutorLabel.left = new FormAttachment(0);
        executorMemoryLabel.setLayoutData((Object)fdExecutorLabel);
        this.executorMemory = new TextVar((VariableSpace)this.jobEntry, (Composite)group, 2048);
        this.props.setLook((Control)this.executorMemory);
        this.executorMemory.addModifyListener(lsMod);
        this.executorMemory.addSelectionListener(lsDef);
        FormData fdExecutorMemory = new FormData();
        fdExecutorMemory.top = new FormAttachment((Control)executorMemoryLabel, 10);
        fdExecutorMemory.left = new FormAttachment(0);
        this.executorMemory.setLayoutData((Object)fdExecutorMemory);
        Label driverMemoryLabel = new Label((Composite)group, 0);
        this.props.setLook((Control)driverMemoryLabel);
        driverMemoryLabel.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.MemoryAllocation.Driver.Label", (String[])new String[0]));
        FormData fdDriverMemoryLabel = new FormData();
        fdDriverMemoryLabel.top = new FormAttachment(0);
        fdDriverMemoryLabel.left = new FormAttachment((Control)this.executorMemory, 90);
        driverMemoryLabel.setLayoutData((Object)fdDriverMemoryLabel);
        this.driverMemory = new TextVar((VariableSpace)this.jobEntry, (Composite)group, 2048);
        this.props.setLook((Control)this.driverMemory);
        this.driverMemory.addModifyListener(lsMod);
        this.driverMemory.addSelectionListener(lsDef);
        FormData fdDriverMemory = new FormData();
        fdDriverMemory.top = new FormAttachment((Control)driverMemoryLabel, 10);
        fdDriverMemory.left = new FormAttachment((Control)driverMemoryLabel, 0, 16384);
        this.driverMemory.setLayoutData((Object)fdDriverMemory);
        this.blockExecution = new Button(jobConfigTabComposite, 32);
        this.props.setLook((Control)this.blockExecution);
        this.blockExecution.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.BlockExecution.Label", (String[])new String[0]));
        FormData fdBlockExecution = new FormData();
        fdBlockExecution.top = new FormAttachment((Control)group, 10);
        fdBlockExecution.left = new FormAttachment(0);
        this.blockExecution.setLayoutData((Object)fdBlockExecution);
        CTabItem parametersTab = new CTabItem(tabs, 0);
        parametersTab.setText(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.ParametersTab.Label", (String[])new String[0]));
        Composite parametersTabComposite = new Composite((Composite)tabs, 0);
        this.props.setLook((Control)parametersTabComposite);
        parametersTab.setControl((Control)parametersTabComposite);
        FormLayout parametersTabCompositeLayout = new FormLayout();
        parametersTabCompositeLayout.marginHeight = 15;
        parametersTabCompositeLayout.marginWidth = 15;
        parametersTabComposite.setLayout((Layout)parametersTabCompositeLayout);
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.NameColumn.Label", (String[])new String[0]), 1), new ColumnInfo(BaseMessages.getString(PKG, (String)"JobEntrySparkSubmit.ValueColumn.Label", (String[])new String[0]), 1)};
        this.configParams = new TableView((VariableSpace)this.jobEntry, parametersTabComposite, 67588, columns, this.jobEntry.getConfigParams().size(), null, this.props);
        this.props.setLook((Control)this.configParams);
        FormData fdConfigParams = new FormData();
        fdConfigParams.left = new FormAttachment(0);
        fdConfigParams.top = new FormAttachment(0);
        fdConfigParams.right = new FormAttachment(100);
        fdConfigParams.bottom = new FormAttachment(100);
        this.configParams.setLayoutData((Object)fdConfigParams);
        this.configParams.addModifyListener(lsMod);
        tabs.setSelection(jobConfigTab);
        Listener lsCancel = new Listener(){

            public void handleEvent(Event e) {
                JobEntrySparkSubmitDialog.this.cancel();
            }
        };
        Listener lsOK = new Listener(){

            public void handleEvent(Event e) {
                JobEntrySparkSubmitDialog.this.ok();
            }
        };
        wOK.addListener(13, lsOK);
        wCancel.addListener(13, lsCancel);
        this.name.addSelectionListener((SelectionListener)lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JobEntrySparkSubmitDialog.this.cancel();
            }
        });
        this.getData();
        this.setActive();
        BaseStepDialog.setSize((Shell)this.shell);
        this.shell.pack();
        this.shell.setMinimumSize(400, this.shell.getSize().y);
        this.shell.open();
        this.props.setDialogSize(this.shell, "JobEntrySparkSubmitDialogSize");
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.jobEntry;
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void setActive() {
    }

    public void getData() {
        this.name.setText(Const.nullToEmpty((String)this.jobEntry.getName()));
        this.sparkSubmit.setText(Const.nullToEmpty((String)this.jobEntry.getScriptPath()));
        this.clazz.setText(Const.nullToEmpty((String)this.jobEntry.getClassName()));
        for (String url : MASTER_URLS) {
            this.masterUrl.add(url);
        }
        this.masterUrl.setText(Const.nullToEmpty((String)this.jobEntry.getMaster()));
        this.jar.setText(Const.nullToEmpty((String)this.jobEntry.getJar()));
        this.args.setText(Const.nullToEmpty((String)this.jobEntry.getArgs()));
        this.blockExecution.setSelection(this.jobEntry.isBlockExecution());
        List<String> params = this.jobEntry.getConfigParams();
        for (int i = 0; i < params.size(); ++i) {
            TableItem ti = this.configParams.table.getItem(i);
            String[] nameValue = params.get(i).split("=");
            ti.setText(1, nameValue[0]);
            ti.setText(2, nameValue[1]);
        }
        this.configParams.setRowNums();
        this.configParams.optWidth(true);
        this.executorMemory.setText(Const.nullToEmpty((String)this.jobEntry.getExecutorMemory()));
        this.driverMemory.setText(Const.nullToEmpty((String)this.jobEntry.getDriverMemory()));
        this.name.selectAll();
        this.name.setFocus();
    }

    private void cancel() {
        this.jobEntry.setChanged(this.backupChanged);
        this.jobEntry = null;
        this.dispose();
    }

    protected void ok() {
        if (Const.isEmpty((String)this.name.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.StepJobEntryNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.JobEntryNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.jobEntry.setName(this.name.getText());
        this.jobEntry.setScriptPath(this.sparkSubmit.getText());
        this.jobEntry.setMaster(this.masterUrl.getText());
        this.jobEntry.setJar(this.jar.getText());
        this.jobEntry.setClassName(this.clazz.getText());
        this.jobEntry.setArgs(this.args.getText());
        this.jobEntry.setBlockExecution(this.blockExecution.getSelection());
        ArrayList<String> configParams = new ArrayList<String>(this.configParams.getItemCount());
        for (int i = 0; i < this.configParams.getItemCount(); ++i) {
            String[] item = this.configParams.getItem(i);
            if (Const.isEmpty((String)item[0]) || Const.isEmpty((String)item[1])) continue;
            configParams.add(item[0].trim() + "=" + item[1].trim());
        }
        this.jobEntry.setConfigParams(configParams);
        this.jobEntry.setDriverMemory(this.driverMemory.getText());
        this.jobEntry.setExecutorMemory(this.executorMemory.getText());
        this.dispose();
    }

    public static void main(String[] args) {
        Display display = new Display();
        PropsUI.init((Display)display, (int)1);
        Shell shell = new Shell(display);
        JobEntrySparkSubmitDialog dialog = new JobEntrySparkSubmitDialog(shell, new JobEntrySparkSubmit("Spark submit job entry"), null, new JobMeta());
        dialog.open();
    }
}

