/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.createfolder;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.createfolder.JobEntryCreateFolder;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class JobEntryCreateFolderDialog
extends JobEntryDialog
implements JobEntryDialogInterface {
    private static Class<?> PKG = JobEntryCreateFolder.class;
    private Label wlName;
    private Text wName;
    private FormData fdlName;
    private FormData fdName;
    private Label wlFoldername;
    private Button wbFoldername;
    private TextVar wFoldername;
    private FormData fdlFoldername;
    private FormData fdbFoldername;
    private FormData fdFoldername;
    private Label wlAbortExists;
    private Button wAbortExists;
    private FormData fdlAbortExists;
    private FormData fdAbortExists;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private JobEntryCreateFolder jobEntry;
    private Shell shell;
    private SelectionAdapter lsDef;
    private boolean changed;

    public JobEntryCreateFolderDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.jobEntry = (JobEntryCreateFolder)jobEntryInt;
        if (this.jobEntry.getName() == null) {
            this.jobEntry.setName(BaseMessages.getString(PKG, (String)"JobCreateFolder.Name.Default", (String[])new String[0]));
        }
    }

    public JobEntryInterface open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, this.props.getJobsDialogStyle());
        this.props.setLook((Control)this.shell);
        JobDialog.setShellImage(this.shell, (JobEntryInterface)this.jobEntry);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryCreateFolderDialog.this.jobEntry.setChanged();
            }
        };
        this.changed = this.jobEntry.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JobCreateFolder.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlName = new Label((Composite)this.shell, 131072);
        this.wlName.setText(BaseMessages.getString(PKG, (String)"JobCreateFolder.Name.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlName);
        this.fdlName = new FormData();
        this.fdlName.left = new FormAttachment(0, 0);
        this.fdlName.right = new FormAttachment(middle, -margin);
        this.fdlName.top = new FormAttachment(0, margin);
        this.wlName.setLayoutData((Object)this.fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        this.fdName = new FormData();
        this.fdName.left = new FormAttachment(middle, 0);
        this.fdName.top = new FormAttachment(0, margin);
        this.fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)this.fdName);
        this.wlFoldername = new Label((Composite)this.shell, 131072);
        this.wlFoldername.setText(BaseMessages.getString(PKG, (String)"JobCreateFolder.Foldername.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFoldername);
        this.fdlFoldername = new FormData();
        this.fdlFoldername.left = new FormAttachment(0, 0);
        this.fdlFoldername.top = new FormAttachment((Control)this.wName, margin);
        this.fdlFoldername.right = new FormAttachment(middle, -margin);
        this.wlFoldername.setLayoutData((Object)this.fdlFoldername);
        this.wbFoldername = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbFoldername);
        this.wbFoldername.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.fdbFoldername = new FormData();
        this.fdbFoldername.right = new FormAttachment(100, 0);
        this.fdbFoldername.top = new FormAttachment((Control)this.wName, 0);
        this.wbFoldername.setLayoutData((Object)this.fdbFoldername);
        this.wFoldername = new TextVar((VariableSpace)this.jobMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wFoldername);
        this.wFoldername.addModifyListener(lsMod);
        this.fdFoldername = new FormData();
        this.fdFoldername.left = new FormAttachment(middle, 0);
        this.fdFoldername.top = new FormAttachment((Control)this.wName, margin);
        this.fdFoldername.right = new FormAttachment((Control)this.wbFoldername, -margin);
        this.wFoldername.setLayoutData(this.fdFoldername);
        this.wFoldername.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryCreateFolderDialog.this.wFoldername.setToolTipText(JobEntryCreateFolderDialog.this.jobMeta.environmentSubstitute(JobEntryCreateFolderDialog.this.wFoldername.getText()));
            }
        });
        this.wbFoldername.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String dir;
                DirectoryDialog dialog = new DirectoryDialog(JobEntryCreateFolderDialog.this.shell, 4096);
                if (JobEntryCreateFolderDialog.this.wFoldername.getText() != null) {
                    dialog.setFilterPath(JobEntryCreateFolderDialog.this.jobMeta.environmentSubstitute(JobEntryCreateFolderDialog.this.wFoldername.getText()));
                }
                if ((dir = dialog.open()) != null) {
                    JobEntryCreateFolderDialog.this.wFoldername.setText(dir);
                }
            }
        });
        this.wlAbortExists = new Label((Composite)this.shell, 131072);
        this.wlAbortExists.setText(BaseMessages.getString(PKG, (String)"JobCreateFolder.FailIfExists.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAbortExists);
        this.fdlAbortExists = new FormData();
        this.fdlAbortExists.left = new FormAttachment(0, 0);
        this.fdlAbortExists.top = new FormAttachment((Control)this.wFoldername, margin);
        this.fdlAbortExists.right = new FormAttachment(middle, -margin);
        this.wlAbortExists.setLayoutData((Object)this.fdlAbortExists);
        this.wAbortExists = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wAbortExists);
        this.wAbortExists.setToolTipText(BaseMessages.getString(PKG, (String)"JobCreateFolder.FailIfExists.Tooltip", (String[])new String[0]));
        this.fdAbortExists = new FormData();
        this.fdAbortExists.left = new FormAttachment(middle, 0);
        this.fdAbortExists.top = new FormAttachment((Control)this.wFoldername, margin);
        this.fdAbortExists.right = new FormAttachment(100, 0);
        this.wAbortExists.setLayoutData((Object)this.fdAbortExists);
        this.wAbortExists.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobEntryCreateFolderDialog.this.jobEntry.setChanged();
            }
        });
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wAbortExists);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                JobEntryCreateFolderDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                JobEntryCreateFolderDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                JobEntryCreateFolderDialog.this.ok();
            }
        };
        this.wName.addSelectionListener((SelectionListener)this.lsDef);
        this.wFoldername.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JobEntryCreateFolderDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.jobEntry;
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        if (this.jobEntry.getName() != null) {
            this.wName.setText(this.jobEntry.getName());
        }
        if (this.jobEntry.getFoldername() != null) {
            this.wFoldername.setText(this.jobEntry.getFoldername());
        }
        this.wAbortExists.setSelection(this.jobEntry.isFailOfFolderExists());
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.jobEntry.setChanged(this.changed);
        this.jobEntry = null;
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.StepJobEntryNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.JobEntryNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.jobEntry.setName(this.wName.getText());
        this.jobEntry.setFoldername(this.wFoldername.getText());
        this.jobEntry.setFailOfFolderExists(this.wAbortExists.getSelection());
        this.dispose();
    }

    public boolean evaluates() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }
}

