/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.repositoryexplorer.model;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.repository.RepositoryObjectInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIJob;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIObjectCreationException;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIObjectRegistry;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryDirectories;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryObject;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryObjects;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UITransformation;

public class UIRepositoryDirectory
extends UIRepositoryObject {
    private static final long serialVersionUID = -2003651575793768451L;
    private RepositoryDirectoryInterface rd;
    private UIRepositoryDirectory uiParent = null;
    private UIRepositoryDirectories kidDirectoryCache = null;
    private UIRepositoryObjects kidElementCache = null;
    private boolean expanded = false;

    public UIRepositoryDirectory() {
        this.kidDirectoryCache = null;
        this.kidElementCache = null;
    }

    public UIRepositoryDirectory(RepositoryDirectoryInterface rd, UIRepositoryDirectory uiParent, Repository rep) {
        super((RepositoryObjectInterface)rd, rep);
        this.uiParent = uiParent;
        this.rd = rd;
        this.kidDirectoryCache = null;
        this.kidElementCache = null;
    }

    public UIRepositoryDirectories getChildren() {
        if (this.kidDirectoryCache != null) {
            return this.kidDirectoryCache;
        }
        if (this.kidDirectoryCache == null) {
            this.kidDirectoryCache = new UIRepositoryDirectories();
        }
        if (this.rd.getChildren() == null) {
            return this.kidDirectoryCache;
        }
        for (RepositoryDirectoryInterface child : this.rd.getChildren()) {
            try {
                this.kidDirectoryCache.add((Object)UIObjectRegistry.getInstance().constructUIRepositoryDirectory(child, this, this.rep));
            }
            catch (UIObjectCreationException e) {
                this.kidDirectoryCache.add((Object)new UIRepositoryDirectory(child, this, this.rep));
            }
        }
        return this.kidDirectoryCache;
    }

    public void setChildren(UIRepositoryDirectories children) {
        this.kidDirectoryCache = children;
    }

    public UIRepositoryObjects getRepositoryObjects() throws KettleException {
        if (this.kidElementCache != null) {
            return this.kidElementCache;
        }
        if (this.kidElementCache == null) {
            this.kidElementCache = new UIRepositoryObjects(){
                private static final long serialVersionUID = 6901479331535375165L;

                public void onRemove(UIRepositoryObject child) {
                    List dirRepoObjects = UIRepositoryDirectory.this.getDirectory().getRepositoryObjects();
                    if (dirRepoObjects != null) {
                        Iterator iter = dirRepoObjects.iterator();
                        while (iter.hasNext()) {
                            RepositoryElementMetaInterface e = (RepositoryElementMetaInterface)iter.next();
                            if (!child.getObjectId().equals(e.getObjectId())) continue;
                            iter.remove();
                            return;
                        }
                    }
                }
            };
        }
        Iterator i$ = this.getChildren().iterator();
        while (i$.hasNext()) {
            UIRepositoryObject child = (UIRepositoryObject)((Object)i$.next());
            this.kidElementCache.add((Object)child);
        }
        List jobsAndTransformations = this.getDirectory().getRepositoryObjects();
        if (jobsAndTransformations == null || jobsAndTransformations.size() == 0) {
            jobsAndTransformations = this.rep.getJobAndTransformationObjects((ObjectId)new StringObjectId(this.getId()), false);
        }
        for (RepositoryElementMetaInterface child : jobsAndTransformations) {
            if (child.getObjectType().equals((Object)RepositoryObjectType.TRANSFORMATION)) {
                try {
                    this.kidElementCache.add((Object)UIObjectRegistry.getInstance().constructUITransformation(child, this, this.rep));
                }
                catch (UIObjectCreationException e) {
                    this.kidElementCache.add((Object)new UITransformation(child, this, this.rep));
                }
                continue;
            }
            if (!child.getObjectType().equals((Object)RepositoryObjectType.JOB)) continue;
            try {
                this.kidElementCache.add((Object)UIObjectRegistry.getInstance().constructUIJob(child, this, this.rep));
            }
            catch (UIObjectCreationException e) {
                this.kidElementCache.add((Object)new UIJob(child, this, this.rep));
            }
        }
        return this.kidElementCache;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void setName(String name) throws Exception {
        if (this.getDirectory().getName().equalsIgnoreCase(name)) {
            return;
        }
        this.rep.renameRepositoryDirectory(this.getDirectory().getObjectId(), null, name);
        this.obj = this.rep.findDirectory(this.getObjectId());
        this.refresh();
    }

    @Override
    public String getDescription() {
        return null;
    }

    public String getLockMessage() {
        return null;
    }

    @Override
    public Date getModifiedDate() {
        return null;
    }

    @Override
    public String getModifiedUser() {
        return null;
    }

    @Override
    public RepositoryObjectType getRepositoryElementType() {
        return null;
    }

    @Override
    public boolean isDeleted() {
        return super.isDeleted();
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public String getFormatModifiedDate() {
        return null;
    }

    public RepositoryDirectory getDirectory() {
        return (RepositoryDirectory)this.rd;
    }

    @Override
    public String getImage() {
        return "ui/images/folder.svg";
    }

    @Override
    public void delete() throws Exception {
        if (this.uiParent.checkDirNameExistsInRepo(this.getName()) != null) {
            this.rep.deleteRepositoryDirectory((RepositoryDirectoryInterface)this.getDirectory());
        }
        this.uiParent.getChildren().remove((Object)this);
        if (this.uiParent.getRepositoryObjects().contains((Object)this)) {
            this.uiParent.getRepositoryObjects().remove((Object)this);
        }
        this.uiParent.refresh();
    }

    public String checkDirNameExistsInRepo(String name) throws KettleException {
        String[] dirNames;
        for (String dirName : dirNames = this.rep.getDirectoryNames(this.getObjectId())) {
            if (!dirName.equalsIgnoreCase(name)) continue;
            return dirName;
        }
        return null;
    }

    public UIRepositoryDirectory createFolder(String name) throws Exception {
        RepositoryDirectory thisDir = this.getDirectory();
        String dirName = this.checkDirNameExistsInRepo(name);
        RepositoryDirectoryInterface dir = dirName == null ? this.rep.createRepositoryDirectory((RepositoryDirectoryInterface)thisDir, name) : this.rep.findDirectory(thisDir.getPath() + "/" + dirName);
        UIRepositoryDirectory newDir = null;
        try {
            newDir = UIObjectRegistry.getInstance().constructUIRepositoryDirectory(dir, this, this.rep);
        }
        catch (UIObjectCreationException uoe) {
            newDir = new UIRepositoryDirectory(dir, this, this.rep);
        }
        UIRepositoryDirectories directories = this.getChildren();
        if (this.contains(directories, newDir)) {
            throw new KettleException("Unable to create folder with the same name [" + name + "]");
        }
        directories.add((Object)newDir);
        this.kidElementCache = null;
        return newDir;
    }

    public void fireCollectionChanged() {
        this.firePropertyChange("children", null, (Object)this.getChildren());
        this.getChildren();
        this.kidDirectoryCache.fireCollectionChanged();
        try {
            this.getRepositoryObjects();
            this.kidElementCache.fireCollectionChanged();
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
    }

    @Override
    public void move(UIRepositoryDirectory newParentDir) throws Exception {
        if (newParentDir != null) {
            this.rep.renameRepositoryDirectory(this.obj.getObjectId(), (RepositoryDirectoryInterface)newParentDir.getDirectory(), null);
            if (!newParentDir.equals((Object)this.getParent())) {
                this.getParent().getChildren().remove((Object)this);
                newParentDir.getChildren().add((Object)this);
                this.getParent().refresh();
                newParentDir.refresh();
            }
        }
    }

    protected UIRepositoryDirectory getParentDirectory() {
        return this.uiParent;
    }

    protected UIRepositoryDirectory getRootDirectory() {
        UIRepositoryDirectory result = this;
        for (UIRepositoryDirectory parent = this.uiParent; parent != null; parent = parent.getParentDirectory()) {
            result = parent;
        }
        return result;
    }

    public void refresh() {
        try {
            this.kidElementCache = null;
            this.kidDirectoryCache = null;
            if (this == this.getRootDirectory()) {
                RepositoryDirectoryInterface localRoot;
                this.rd = localRoot = this.rep.findDirectory(this.rd.getObjectId());
                this.fireCollectionChanged();
            } else {
                this.getRootDirectory().refresh();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getCategory() {
        return 10;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expand) {
        this.expanded = expand;
    }

    public void toggleExpanded() {
        this.setExpanded(!this.isExpanded());
        this.firePropertyChange("expanded", null, this.expanded);
    }

    @Override
    public UIRepositoryDirectory getParent() {
        return this.uiParent;
    }

    @Override
    public String getPath() {
        return ((RepositoryDirectory)this.rd).getPath();
    }

    public boolean isVisible() {
        return this.rd.isVisible();
    }

    public int size() {
        return this.getChildren().size();
    }

    public UIRepositoryObject get(int index) {
        return (UIRepositoryObject)((Object)this.getChildren().get(index));
    }

    public Iterator<UIRepositoryObject> iterator() {
        return this.getChildren().iterator();
    }

    public boolean contains(String dirName) {
        UIRepositoryDirectories directories = this.getChildren();
        for (int i = 0; i < directories.size(); ++i) {
            UIRepositoryObject dir = (UIRepositoryObject)((Object)directories.get(i));
            if (!(dir instanceof UIRepositoryDirectory)) continue;
            if (dir.getName() == null && dirName == null) {
                return true;
            }
            if (!dir.getName().equalsIgnoreCase(dirName)) continue;
            return true;
        }
        return false;
    }

    private boolean contains(UIRepositoryDirectories directories, UIRepositoryDirectory searchDir) {
        for (int i = 0; i < directories.size(); ++i) {
            UIRepositoryObject dir = (UIRepositoryObject)((Object)directories.get(i));
            if (!(dir instanceof UIRepositoryDirectory) || dir.getName() == null || !dir.getName().equals(searchDir.getName())) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        ObjectId id = this.getObjectId();
        result = 31 * result + (id == null ? 0 : id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        UIRepositoryDirectory other = (UIRepositoryDirectory)((Object)obj);
        ObjectId id = this.getObjectId();
        ObjectId otherId = other.getObjectId();
        return !(id == null ? otherId != null : !id.equals(otherId));
    }
}

