/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.accessoutput;

import com.healthmarketscience.jackcess.Database;
import java.io.File;
import java.net.URL;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.FileObject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.accessoutput.AccessOutputMeta;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class AccessOutputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = AccessOutputMeta.class;
    private Label wlFilename;
    private Button wbbFilename;
    private TextVar wFilename;
    private FormData fdlFilename;
    private FormData fdbFilename;
    private FormData fdFilename;
    private Label wlCreateFile;
    private Button wCreateFile;
    private FormData fdlCreateFile;
    private FormData fdCreateFile;
    private Label wlTablename;
    private TextVar wTablename;
    private Button wbbTablename;
    private FormData fdlTablename;
    private FormData fdTablename;
    private FormData fdbTablename;
    private Label wlCreateTable;
    private Button wCreateTable;
    private FormData fdlCreateTable;
    private FormData fdCreateTable;
    private Label wlCommitSize;
    private Text wCommitSize;
    private FormData fdlCommitSize;
    private FormData fdCommitSize;
    private Label wlAddToResult;
    private Button wAddToResult;
    private FormData fdlAddToResult;
    private FormData fdAddToResult;
    private Label wlDoNotOpenNewFileInit;
    private Button wDoNotOpenNewFileInit;
    private FormData fdlDoNotOpenNewFileInit;
    private FormData fdDoNotOpenNewFileInit;
    private AccessOutputMeta input;

    public AccessOutputDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (AccessOutputMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AccessOutputDialog.this.input.setChanged();
            }
        };
        SelectionAdapter lsSelMod = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AccessOutputDialog.this.input.setChanged();
            }
        };
        this.backupChanged = this.input.hasChanged();
        int middle = this.props.getMiddlePct();
        int margin = 4;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.DialogTitle", (String[])new String[0]));
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"System.Label.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, 0);
        this.fdlStepname.top = new FormAttachment(0, 0);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, margin);
        this.fdStepname.top = new FormAttachment(0, 0);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlFilename = new Label((Composite)this.shell, 131072);
        this.wlFilename.setText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.Filename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFilename);
        this.fdlFilename = new FormData();
        this.fdlFilename.left = new FormAttachment(0, 0);
        this.fdlFilename.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdlFilename.right = new FormAttachment(middle, 0);
        this.wlFilename.setLayoutData((Object)this.fdlFilename);
        this.wbbFilename = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbbFilename);
        this.wbbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.wbbFilename.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        this.fdbFilename = new FormData();
        this.fdbFilename.right = new FormAttachment(100, 0);
        this.fdbFilename.top = new FormAttachment((Control)this.wStepname, margin);
        this.wbbFilename.setLayoutData((Object)this.fdbFilename);
        this.wFilename = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.wFilename.setToolTipText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.Filename.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        this.fdFilename = new FormData();
        this.fdFilename.left = new FormAttachment(middle, margin);
        this.fdFilename.right = new FormAttachment((Control)this.wbbFilename, -margin);
        this.fdFilename.top = new FormAttachment((Control)this.wStepname, margin);
        this.wFilename.setLayoutData(this.fdFilename);
        this.wlDoNotOpenNewFileInit = new Label((Composite)this.shell, 131072);
        this.wlDoNotOpenNewFileInit.setText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.DoNotOpenNewFileInit.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDoNotOpenNewFileInit);
        this.fdlDoNotOpenNewFileInit = new FormData();
        this.fdlDoNotOpenNewFileInit.left = new FormAttachment(0, 0);
        this.fdlDoNotOpenNewFileInit.top = new FormAttachment((Control)this.wFilename, margin);
        this.fdlDoNotOpenNewFileInit.right = new FormAttachment(middle, -margin);
        this.wlDoNotOpenNewFileInit.setLayoutData((Object)this.fdlDoNotOpenNewFileInit);
        this.wDoNotOpenNewFileInit = new Button((Composite)this.shell, 32);
        this.wDoNotOpenNewFileInit.setToolTipText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.DoNotOpenNewFileInit.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wDoNotOpenNewFileInit);
        this.fdDoNotOpenNewFileInit = new FormData();
        this.fdDoNotOpenNewFileInit.left = new FormAttachment(middle, margin);
        this.fdDoNotOpenNewFileInit.top = new FormAttachment((Control)this.wFilename, margin);
        this.fdDoNotOpenNewFileInit.right = new FormAttachment(100, 0);
        this.wDoNotOpenNewFileInit.setLayoutData((Object)this.fdDoNotOpenNewFileInit);
        this.wDoNotOpenNewFileInit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccessOutputDialog.this.input.setChanged();
            }
        });
        this.wlCreateFile = new Label((Composite)this.shell, 131072);
        this.wlCreateFile.setText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.CreateFile.Label", (String[])new String[0]));
        this.wlCreateFile.setToolTipText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.CreateFile.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wlCreateFile);
        this.fdlCreateFile = new FormData();
        this.fdlCreateFile.left = new FormAttachment(0, 0);
        this.fdlCreateFile.top = new FormAttachment((Control)this.wDoNotOpenNewFileInit, margin);
        this.fdlCreateFile.right = new FormAttachment(middle, 0);
        this.wlCreateFile.setLayoutData((Object)this.fdlCreateFile);
        this.wCreateFile = new Button((Composite)this.shell, 32);
        this.wCreateFile.setToolTipText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.CreateFile.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCreateFile);
        this.fdCreateFile = new FormData();
        this.fdCreateFile.left = new FormAttachment(middle, margin);
        this.fdCreateFile.top = new FormAttachment((Control)this.wDoNotOpenNewFileInit, margin);
        this.fdCreateFile.right = new FormAttachment(100, 0);
        this.wCreateFile.setLayoutData((Object)this.fdCreateFile);
        this.wCreateFile.addSelectionListener((SelectionListener)lsSelMod);
        this.wbbTablename = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbbTablename);
        this.wbbTablename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.fdbTablename = new FormData();
        this.fdbTablename.right = new FormAttachment(100, 0);
        this.fdbTablename.top = new FormAttachment((Control)this.wCreateFile, margin);
        this.wbbTablename.setLayoutData((Object)this.fdbTablename);
        this.wlTablename = new Label((Composite)this.shell, 131072);
        this.wlTablename.setText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.TargetTable.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTablename);
        this.fdlTablename = new FormData();
        this.fdlTablename.left = new FormAttachment(0, 0);
        this.fdlTablename.top = new FormAttachment((Control)this.wCreateFile, margin);
        this.fdlTablename.right = new FormAttachment(middle, 0);
        this.wlTablename.setLayoutData((Object)this.fdlTablename);
        this.wTablename = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.wTablename.setToolTipText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.TargetTable.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wTablename);
        this.fdTablename = new FormData();
        this.fdTablename.left = new FormAttachment(middle, margin);
        this.fdTablename.right = new FormAttachment((Control)this.wbbTablename, -margin);
        this.fdTablename.top = new FormAttachment((Control)this.wCreateFile, margin);
        this.wTablename.setLayoutData(this.fdTablename);
        this.wlCreateTable = new Label((Composite)this.shell, 131072);
        this.wlCreateTable.setText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.CreateTable.Label", (String[])new String[0]));
        this.wlCreateTable.setToolTipText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.CreateTable.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wlCreateTable);
        this.fdlCreateTable = new FormData();
        this.fdlCreateTable.left = new FormAttachment(0, 0);
        this.fdlCreateTable.top = new FormAttachment((Control)this.wTablename, margin);
        this.fdlCreateTable.right = new FormAttachment(middle, 0);
        this.wlCreateTable.setLayoutData((Object)this.fdlCreateTable);
        this.wCreateTable = new Button((Composite)this.shell, 32);
        this.wCreateTable.setToolTipText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.CreateTable.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCreateTable);
        this.fdCreateTable = new FormData();
        this.fdCreateTable.left = new FormAttachment(middle, margin);
        this.fdCreateTable.top = new FormAttachment((Control)this.wTablename, margin);
        this.fdCreateTable.right = new FormAttachment(100, 0);
        this.wCreateTable.setLayoutData((Object)this.fdCreateTable);
        this.wCreateTable.addSelectionListener((SelectionListener)lsSelMod);
        this.wlCommitSize = new Label((Composite)this.shell, 131072);
        this.wlCommitSize.setText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.CommitSize.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCommitSize);
        this.fdlCommitSize = new FormData();
        this.fdlCommitSize.left = new FormAttachment(0, 0);
        this.fdlCommitSize.top = new FormAttachment((Control)this.wCreateTable, margin);
        this.fdlCommitSize.right = new FormAttachment(middle, 0);
        this.wlCommitSize.setLayoutData((Object)this.fdlCommitSize);
        this.wCommitSize = new Text((Composite)this.shell, 18436);
        this.wCommitSize.setToolTipText(BaseMessages.getString(PKG, (String)"AccessOutputDialog.CommitSize.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCommitSize);
        this.fdCommitSize = new FormData();
        this.fdCommitSize.left = new FormAttachment(middle, margin);
        this.fdCommitSize.right = new FormAttachment(100, 0);
        this.fdCommitSize.top = new FormAttachment((Control)this.wCreateTable, margin);
        this.wCommitSize.setLayoutData((Object)this.fdCommitSize);
        this.wCommitSize.addModifyListener(lsMod);
        this.wlAddToResult = new Label((Composite)this.shell, 131072);
        this.wlAddToResult.setText(BaseMessages.getString(PKG, (String)"AccessOutputMeta.AddFileToResult.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddToResult);
        this.fdlAddToResult = new FormData();
        this.fdlAddToResult.left = new FormAttachment(0, 0);
        this.fdlAddToResult.top = new FormAttachment((Control)this.wCommitSize, 2 * margin);
        this.fdlAddToResult.right = new FormAttachment(middle, -margin);
        this.wlAddToResult.setLayoutData((Object)this.fdlAddToResult);
        this.wAddToResult = new Button((Composite)this.shell, 32);
        this.wAddToResult.setToolTipText(BaseMessages.getString(PKG, (String)"AccessOutputMeta.AddFileToResult.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wAddToResult);
        this.fdAddToResult = new FormData();
        this.fdAddToResult.left = new FormAttachment(middle, margin);
        this.fdAddToResult.top = new FormAttachment((Control)this.wCommitSize, 2 * margin);
        this.fdAddToResult.right = new FormAttachment(100, 0);
        this.wAddToResult.setLayoutData((Object)this.fdAddToResult);
        SelectionAdapter lsSelR = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AccessOutputDialog.this.input.setChanged();
            }
        };
        this.wAddToResult.addSelectionListener((SelectionListener)lsSelR);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wAddToResult);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                AccessOutputDialog.this.ok();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                AccessOutputDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                AccessOutputDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wTablename.addSelectionListener(this.lsDef);
        this.wbbTablename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccessOutputDialog.this.getTableName();
            }
        });
        this.wbbFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(AccessOutputDialog.this.shell, 8192);
                dialog.setFilterExtensions(new String[]{"*.mdb;*.MDB;*.accdb;*.ACCDB", "*"});
                if (!Const.isEmpty((String)AccessOutputDialog.this.wFilename.getText())) {
                    String fname = AccessOutputDialog.this.transMeta.environmentSubstitute(AccessOutputDialog.this.wFilename.getText());
                    dialog.setFileName(fname);
                }
                dialog.setFilterNames(new String[]{BaseMessages.getString((Class)PKG, (String)"AccessOutputDialog.FileType.AccessFiles", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"System.FileType.AllFiles", (String[])new String[0])});
                if (dialog.open() != null) {
                    String str = dialog.getFilterPath() + System.getProperty("file.separator") + dialog.getFileName();
                    AccessOutputDialog.this.wFilename.setText(str);
                }
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                AccessOutputDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.input.setChanged(this.backupChanged);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData() {
        if (this.input.getFilename() != null) {
            this.wFilename.setText(this.input.getFilename());
        }
        if (this.input.getTablename() != null) {
            this.wTablename.setText(this.input.getTablename());
        }
        this.wCreateFile.setSelection(this.input.isFileCreated());
        this.wCreateTable.setSelection(this.input.isFileCreated());
        if (this.input.getCommitSize() > 0) {
            this.wCommitSize.setText(Integer.toString(this.input.getCommitSize()));
        }
        this.wAddToResult.setSelection(this.input.isAddToResultFiles());
        this.wDoNotOpenNewFileInit.setSelection(this.input.isDoNotOpenNewFileInit());
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void getInfo(AccessOutputMeta info) {
        info.setFilename(this.wFilename.getText());
        info.setTablename(this.wTablename.getText());
        info.setFileCreated(this.wCreateFile.getSelection());
        info.setTableCreated(this.wCreateTable.getSelection());
        info.setCommitSize(Const.toInt((String)this.wCommitSize.getText(), (int)-1));
        info.setAddToResultFiles(this.wAddToResult.getSelection());
        this.input.setDoNotOpenNewFileInit(this.wDoNotOpenNewFileInit.getSelection());
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.getInfo(this.input);
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTableName() {
        AccessOutputMeta meta = new AccessOutputMeta();
        this.getInfo(meta);
        Database database = null;
        try {
            String realFilename = this.transMeta.environmentSubstitute(meta.getFilename());
            FileObject fileObject = KettleVFS.getFileObject((String)realFilename, (VariableSpace)this.transMeta);
            File file = FileUtils.toFile((URL)fileObject.getURL());
            if (!file.exists() || !file.isFile()) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"AccessOutputMeta.Exception.FileDoesNotExist", (String[])new String[]{realFilename}));
            }
            database = Database.open((File)file);
            Set set = database.getTableNames();
            String[] tablenames = set.toArray(new String[set.size()]);
            EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, tablenames, BaseMessages.getString(PKG, (String)"AccessOutputDialog.Dialog.SelectATable.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AccessOutputDialog.Dialog.SelectATable.Message", (String[])new String[0]));
            String tablename = dialog.open();
            if (tablename != null) {
                this.wTablename.setText(tablename);
            }
        }
        catch (Throwable e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"AccessOutputDialog.UnableToGetListOfTables.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AccessOutputDialog.UnableToGetListOfTables.Message", (String[])new String[0]), e);
        }
        finally {
            try {
                if (database != null) {
                    database.close();
                }
            }
            catch (Exception realFilename) {}
        }
    }
}

