/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.delete;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.delete.DeleteMeta;
import org.pentaho.di.ui.core.database.dialog.DatabaseExplorerDialog;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;

public class DeleteDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = DeleteMeta.class;
    private CCombo wConnection;
    private Label wlKey;
    private TableView wKey;
    private FormData fdlKey;
    private FormData fdKey;
    private Label wlSchema;
    private TextVar wSchema;
    private FormData fdlSchema;
    private FormData fdSchema;
    private FormData fdbSchema;
    private Button wbSchema;
    private Label wlTable;
    private Button wbTable;
    private TextVar wTable;
    private FormData fdlTable;
    private FormData fdbTable;
    private FormData fdTable;
    private Label wlCommit;
    private TextVar wCommit;
    private FormData fdlCommit;
    private FormData fdCommit;
    private DeleteMeta input;
    private Map<String, Integer> inputFields;
    private ColumnInfo[] ciKey;
    private List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();

    public DeleteDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.input = (DeleteMeta)in;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DeleteDialog.this.input.setChanged();
            }
        };
        ModifyListener lsTableMod = new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                DeleteDialog.this.input.setChanged();
                DeleteDialog.this.setTableFieldCombo();
            }
        };
        SelectionAdapter lsSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeleteDialog.this.input.setChanged();
                DeleteDialog.this.setTableFieldCombo();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"DeleteDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"DeleteDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wStepname, middle, margin);
        if (this.input.getDatabaseMeta() == null && this.transMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        this.wConnection.addSelectionListener((SelectionListener)lsSelection);
        this.wlSchema = new Label((Composite)this.shell, 131072);
        this.wlSchema.setText(BaseMessages.getString(PKG, (String)"DeleteDialog.TargetSchema.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSchema);
        this.fdlSchema = new FormData();
        this.fdlSchema.left = new FormAttachment(0, 0);
        this.fdlSchema.right = new FormAttachment(middle, -margin);
        this.fdlSchema.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.wlSchema.setLayoutData((Object)this.fdlSchema);
        this.wbSchema = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbSchema);
        this.wbSchema.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.fdbSchema = new FormData();
        this.fdbSchema.top = new FormAttachment((Control)this.wConnection, 2 * margin);
        this.fdbSchema.right = new FormAttachment(100, 0);
        this.wbSchema.setLayoutData((Object)this.fdbSchema);
        this.wSchema = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wSchema);
        this.wSchema.addModifyListener(lsTableMod);
        this.fdSchema = new FormData();
        this.fdSchema.left = new FormAttachment(middle, 0);
        this.fdSchema.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.fdSchema.right = new FormAttachment((Control)this.wbSchema, -margin);
        this.wSchema.setLayoutData(this.fdSchema);
        this.wlTable = new Label((Composite)this.shell, 131072);
        this.wlTable.setText(BaseMessages.getString(PKG, (String)"DeleteDialog.TargetTable.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTable);
        this.fdlTable = new FormData();
        this.fdlTable.left = new FormAttachment(0, 0);
        this.fdlTable.right = new FormAttachment(middle, -margin);
        this.fdlTable.top = new FormAttachment((Control)this.wbSchema, margin);
        this.wlTable.setLayoutData((Object)this.fdlTable);
        this.wbTable = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbTable);
        this.wbTable.setText(BaseMessages.getString(PKG, (String)"DeleteDialog.Browse.Button", (String[])new String[0]));
        this.fdbTable = new FormData();
        this.fdbTable.right = new FormAttachment(100, 0);
        this.fdbTable.top = new FormAttachment((Control)this.wbSchema, margin);
        this.wbTable.setLayoutData((Object)this.fdbTable);
        this.wTable = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wTable);
        this.wTable.addModifyListener(lsTableMod);
        this.fdTable = new FormData();
        this.fdTable.left = new FormAttachment(middle, 0);
        this.fdTable.top = new FormAttachment((Control)this.wbSchema, margin);
        this.fdTable.right = new FormAttachment((Control)this.wbTable, -margin);
        this.wTable.setLayoutData(this.fdTable);
        this.wlCommit = new Label((Composite)this.shell, 131072);
        this.wlCommit.setText(BaseMessages.getString(PKG, (String)"DeleteDialog.Commit.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCommit);
        this.fdlCommit = new FormData();
        this.fdlCommit.left = new FormAttachment(0, 0);
        this.fdlCommit.top = new FormAttachment((Control)this.wTable, margin);
        this.fdlCommit.right = new FormAttachment(middle, -margin);
        this.wlCommit.setLayoutData((Object)this.fdlCommit);
        this.wCommit = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wCommit);
        this.wCommit.addModifyListener(lsMod);
        this.fdCommit = new FormData();
        this.fdCommit.left = new FormAttachment(middle, 0);
        this.fdCommit.top = new FormAttachment((Control)this.wTable, margin);
        this.fdCommit.right = new FormAttachment(100, 0);
        this.wCommit.setLayoutData(this.fdCommit);
        this.wlKey = new Label((Composite)this.shell, 0);
        this.wlKey.setText(BaseMessages.getString(PKG, (String)"DeleteDialog.Key.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlKey);
        this.fdlKey = new FormData();
        this.fdlKey.left = new FormAttachment(0, 0);
        this.fdlKey.top = new FormAttachment((Control)this.wCommit, margin);
        this.wlKey.setLayoutData((Object)this.fdlKey);
        int nrKeyCols = 4;
        int nrKeyRows = this.input.getKeyStream() != null ? this.input.getKeyStream().length : 1;
        this.ciKey = new ColumnInfo[nrKeyCols];
        this.ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DeleteDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciKey[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DeleteDialog.ColumnInfo.Comparator", (String[])new String[0]), 2, new String[]{"=", "<>", "<", "<=", ">", ">=", "LIKE", "BETWEEN", "IS NULL", "IS NOT NULL"});
        this.ciKey[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DeleteDialog.ColumnInfo.StreamField1", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciKey[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"DeleteDialog.ColumnInfo.StreamField2", (String[])new String[0]), 2, new String[]{""}, false);
        this.tableFieldColumns.add(this.ciKey[0]);
        this.wKey = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 68354, this.ciKey, nrKeyRows, lsMod, this.props);
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"DeleteDialog.GetFields.Button", (String[])new String[0]));
        this.fdGet = new FormData();
        this.fdGet.right = new FormAttachment(100, 0);
        this.fdGet.top = new FormAttachment((Control)this.wlKey, margin);
        this.wGet.setLayoutData((Object)this.fdGet);
        this.fdKey = new FormData();
        this.fdKey.left = new FormAttachment(0, 0);
        this.fdKey.top = new FormAttachment((Control)this.wlKey, margin);
        this.fdKey.right = new FormAttachment((Control)this.wGet, -margin);
        this.fdKey.bottom = new FormAttachment(100, -30);
        this.wKey.setLayoutData(this.fdKey);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StepMeta stepMeta = DeleteDialog.this.transMeta.findStep(DeleteDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = DeleteDialog.this.transMeta.getPrevStepFields(stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            DeleteDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        DeleteDialog.this.setComboBoxes();
                    }
                    catch (KettleException e) {
                        DeleteDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, null);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                DeleteDialog.this.ok();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                DeleteDialog.this.get();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                DeleteDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGet.addListener(13, this.lsGet);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                DeleteDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wSchema.addSelectionListener(this.lsDef);
        this.wTable.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                DeleteDialog.this.cancel();
            }
        });
        this.wbSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeleteDialog.this.getSchemaNames();
            }
        });
        this.wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeleteDialog.this.getTableName();
            }
        });
        this.setSize();
        this.getData();
        this.setTableFieldCombo();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciKey[2].setComboValues(fieldNames);
        this.ciKey[3].setComboValues(fieldNames);
    }

    public void getData() {
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"DeleteDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        this.wCommit.setText(this.input.getCommitSizeVar());
        if (this.input.getKeyStream() != null) {
            for (int i = 0; i < this.input.getKeyStream().length; ++i) {
                TableItem item = this.wKey.table.getItem(i);
                if (this.input.getKeyLookup()[i] != null) {
                    item.setText(1, this.input.getKeyLookup()[i]);
                }
                if (this.input.getKeyCondition()[i] != null) {
                    item.setText(2, this.input.getKeyCondition()[i]);
                }
                if (this.input.getKeyStream()[i] != null) {
                    item.setText(3, this.input.getKeyStream()[i]);
                }
                if (this.input.getKeyStream2()[i] == null) continue;
                item.setText(4, this.input.getKeyStream2()[i]);
            }
        }
        if (this.input.getSchemaName() != null) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (this.input.getTableName() != null) {
            this.wTable.setText(this.input.getTableName());
        }
        if (this.input.getDatabaseMeta() != null) {
            this.wConnection.setText(this.input.getDatabaseMeta().getName());
        } else if (this.transMeta.nrDatabases() == 1) {
            this.wConnection.setText(this.transMeta.getDatabase(0).getName());
        }
        this.wKey.setRowNums();
        this.wKey.optWidth(true);
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void setTableFieldCombo() {
        Runnable fieldLoader = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!(DeleteDialog.this.wTable.isDisposed() || DeleteDialog.this.wConnection.isDisposed() || DeleteDialog.this.wSchema.isDisposed())) {
                    DatabaseMeta ci;
                    String tableName = DeleteDialog.this.wTable.getText();
                    String connectionName = DeleteDialog.this.wConnection.getText();
                    String schemaName = DeleteDialog.this.wSchema.getText();
                    for (ColumnInfo colInfo : DeleteDialog.this.tableFieldColumns) {
                        colInfo.setComboValues(new String[0]);
                    }
                    if (!Const.isEmpty((String)tableName) && (ci = DeleteDialog.this.transMeta.findDatabase(connectionName)) != null) {
                        Database db = new Database(BaseStepDialog.loggingObject, ci);
                        try {
                            String[] fieldNames;
                            db.connect();
                            String schemaTable = ci.getQuotedSchemaTableCombination(DeleteDialog.this.transMeta.environmentSubstitute(schemaName), DeleteDialog.this.transMeta.environmentSubstitute(tableName));
                            RowMetaInterface r = db.getTableFields(schemaTable);
                            if (null != r && null != (fieldNames = r.getFieldNames())) {
                                for (ColumnInfo colInfo : DeleteDialog.this.tableFieldColumns) {
                                    colInfo.setComboValues(fieldNames);
                                }
                            }
                        }
                        catch (Exception e) {
                            for (ColumnInfo colInfo : DeleteDialog.this.tableFieldColumns) {
                                colInfo.setComboValues(new String[0]);
                            }
                        }
                        finally {
                            try {
                                if (db != null) {
                                    db.disconnect();
                                }
                            }
                            catch (Exception ignored) {
                                db = null;
                            }
                        }
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    private void getInfo(DeleteMeta inf) {
        int nrkeys = this.wKey.nrNonEmpty();
        inf.allocate(nrkeys);
        inf.setCommitSize(this.wCommit.getText());
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"DeleteDialog.Log.FoundKeys", (String[])new String[]{String.valueOf(nrkeys)}));
        }
        for (int i = 0; i < nrkeys; ++i) {
            TableItem item = this.wKey.getNonEmpty(i);
            inf.getKeyLookup()[i] = item.getText(1);
            inf.getKeyCondition()[i] = item.getText(2);
            inf.getKeyStream()[i] = item.getText(3);
            inf.getKeyStream2()[i] = item.getText(4);
        }
        inf.setSchemaName(this.wSchema.getText());
        inf.setTableName(this.wTable.getText());
        inf.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        this.stepname = this.wStepname.getText();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.getInfo(this.input);
        if (this.input.getDatabaseMeta() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"DeleteDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"DeleteDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
            return;
        }
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSchemaNames() {
        DatabaseMeta databaseMeta = this.transMeta.findDatabase(this.wConnection.getText());
        if (databaseMeta != null) {
            Database database = new Database(loggingObject, databaseMeta);
            try {
                database.connect();
                String[] schemas = database.getSchemas();
                if (null != schemas && schemas.length > 0) {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, schemas = Const.sortStrings((String[])schemas), BaseMessages.getString(PKG, (String)"DeleteDialog.AvailableSchemas.Title", (String[])new String[]{this.wConnection.getText()}), BaseMessages.getString(PKG, (String)"DeleteDialog.AvailableSchemas.Message", (String[])new String[]{this.wConnection.getText()}));
                    String d = dialog.open();
                    if (d != null) {
                        this.wSchema.setText(Const.NVL((String)d, (String)""));
                        this.setTableFieldCombo();
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"DeleteDialog.NoSchema.Error", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"DeleteDialog.GetSchemas.Error", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DeleteDialog.ErrorGettingSchemas", (String[])new String[0]), e);
            }
            finally {
                database.disconnect();
            }
        }
    }

    private void getTableName() {
        DatabaseMeta inf = null;
        int connr = this.wConnection.getSelectionIndex();
        if (connr >= 0) {
            inf = this.transMeta.getDatabase(connr);
        }
        if (inf != null) {
            this.logDebug(BaseMessages.getString(PKG, (String)"DeleteDialog.Log.LookingAtConnection", (String[])new String[0]) + inf.toString());
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, inf, this.transMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
                this.setTableFieldCombo();
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"DeleteDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"DeleteDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
    }

    private void get() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null && !r.isEmpty()) {
                TableItemInsertListener listener = new TableItemInsertListener(){

                    @Override
                    public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface v) {
                        tableItem.setText(2, "=");
                        return true;
                    }
                };
                BaseStepDialog.getFieldsFromPrevious(r, this.wKey, 1, new int[]{1, 3}, new int[0], -1, -1, listener);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"DeleteDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DeleteDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

