/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.IOUtils;

public final class XIOUtils {
    @Deprecated
    public static final Charset CHARSET_UTF_8 = StandardCharsets.UTF_8;
    public static final String UTF_8 = StandardCharsets.UTF_8.name();

    private XIOUtils() {
    }

    public static void close(Closeable ... objects) throws IOException {
        XIOUtils.close(Arrays.asList(objects));
    }

    public static void close(Iterable<? extends Closeable> objects) throws IOException {
        Throwable th = null;
        for (Closeable closeable : objects) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable t) {
                XIOUtils.addSuppressed(th, t);
                if (th != null) continue;
                th = t;
            }
        }
        XIOUtils.reThrow(th);
    }

    public static void closeWhileHandlingException(Closeable ... objects) {
        XIOUtils.closeWhileHandlingException(Arrays.asList(objects));
    }

    public static void closeWhileHandlingException(Iterable<? extends Closeable> objects) {
        for (Closeable closeable : objects) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private static void addSuppressed(Throwable exception, Throwable suppressed) {
        if (exception != null && suppressed != null) {
            exception.addSuppressed(suppressed);
        }
    }

    public static Reader getDecodingReader(InputStream stream, Charset charSet) {
        CharsetDecoder charSetDecoder = charSet.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        return new BufferedReader(new InputStreamReader(stream, charSetDecoder));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Reader getDecodingReader(Class<?> clazz, String resource, Charset charSet) throws IOException {
        Reader reader;
        block3: {
            InputStream stream = null;
            boolean success = false;
            try {
                stream = clazz.getResourceAsStream(resource);
                Reader reader2 = XIOUtils.getDecodingReader(stream, charSet);
                success = true;
                reader = reader2;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.close((Closeable[])new Closeable[]{stream});
                }
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{stream});
        }
        return reader;
    }

    public static void deleteFilesIgnoringExceptions(Directory dir, String ... files) {
        for (String name : files) {
            try {
                dir.deleteFile(name);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void deleteFilesIgnoringExceptions(Path ... files) {
        XIOUtils.deleteFilesIgnoringExceptions(Arrays.asList(files));
    }

    public static void deleteFilesIgnoringExceptions(Collection<? extends Path> files) {
        for (Path path : files) {
            if (path == null) continue;
            try {
                Files.delete(path);
            }
            catch (Throwable throwable) {}
        }
    }

    public static void deleteFilesIfExist(Path ... files) throws IOException {
        XIOUtils.deleteFilesIfExist(Arrays.asList(files));
    }

    public static void deleteFilesIfExist(Collection<? extends Path> files) throws IOException {
        Throwable th = null;
        for (Path path : files) {
            try {
                if (path == null) continue;
                Files.deleteIfExists(path);
            }
            catch (Throwable t) {
                XIOUtils.addSuppressed(th, t);
                if (th != null) continue;
                th = t;
            }
        }
        XIOUtils.reThrow(th);
    }

    public static void rm(Path ... locations) throws IOException {
        LinkedHashMap<Path, Throwable> unremoved = XIOUtils.rm(new LinkedHashMap<Path, Throwable>(), locations);
        if (!unremoved.isEmpty()) {
            StringBuilder b = new StringBuilder("Could not remove the following files (in the order of attempts):\n");
            for (Map.Entry<Path, Throwable> kv : unremoved.entrySet()) {
                b.append("   ").append(kv.getKey().toAbsolutePath()).append(": ").append(kv.getValue()).append("\n");
            }
            throw new IOException(b.toString());
        }
    }

    private static LinkedHashMap<Path, Throwable> rm(final LinkedHashMap<Path, Throwable> unremoved, Path ... locations) {
        if (locations != null) {
            for (Path location : locations) {
                if (location == null || !Files.exists(location, new LinkOption[0])) continue;
                try {
                    Files.walkFileTree(location, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                        @Override
                        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException impossible) throws IOException {
                            assert (impossible == null);
                            try {
                                Files.delete(dir);
                            }
                            catch (IOException e) {
                                unremoved.put(dir, e);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            try {
                                Files.delete(file);
                            }
                            catch (IOException exc) {
                                unremoved.put(file, exc);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                            if (exc != null) {
                                unremoved.put(file, exc);
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException impossible) {
                    throw new AssertionError("visitor threw exception", impossible);
                }
            }
        }
        return unremoved;
    }

    public static void reThrow(Throwable th) throws IOException {
        if (th != null) {
            if (th instanceof IOException) {
                throw (IOException)th;
            }
            XIOUtils.reThrowUnchecked(th);
        }
    }

    public static void reThrowUnchecked(Throwable th) {
        if (th != null) {
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            if (th instanceof Error) {
                throw (Error)th;
            }
            throw new RuntimeException(th);
        }
    }

    /*
     * Exception decompiling
     */
    public static void fsync(Path fileToSync, boolean isDir) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

