/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.indexedscripts.get;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.uid.Versions;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.search.fetch.source.FetchSourceContext;

public class GetIndexedScriptRequest
extends ActionRequest<GetIndexedScriptRequest>
implements IndicesRequest {
    protected String scriptLang;
    protected String id;
    private VersionType versionType = VersionType.INTERNAL;
    private long version = -3L;

    public GetIndexedScriptRequest() {
    }

    public GetIndexedScriptRequest(String scriptLang, String id) {
        this.scriptLang = scriptLang;
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.scriptLang == null) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (this.id == null) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        }
        if (!this.versionType.validateVersionForReads(this.version)) {
            validationException = ValidateActions.addValidationError("illegal version value [" + this.version + "] for version type [" + this.versionType.name() + "]", validationException);
        }
        return validationException;
    }

    @Override
    public String[] indices() {
        return new String[]{".scripts"};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    }

    public GetIndexedScriptRequest scriptLang(@Nullable String type) {
        this.scriptLang = type;
        return this;
    }

    public GetIndexedScriptRequest id(String id) {
        this.id = id;
        return this;
    }

    public String scriptLang() {
        return this.scriptLang;
    }

    public String id() {
        return this.id;
    }

    public long version() {
        return this.version;
    }

    public GetIndexedScriptRequest version(long version) {
        this.version = version;
        return this;
    }

    public GetIndexedScriptRequest versionType(VersionType versionType) {
        this.versionType = versionType;
        return this;
    }

    public VersionType versionType() {
        return this.versionType;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        if (in.getVersion().before(Version.V_1_4_0_Beta1)) {
            in.readString();
        }
        this.scriptLang = in.readString();
        this.id = in.readString();
        if (in.getVersion().before(Version.V_1_5_0)) {
            in.readOptionalString();
            in.readBoolean();
            in.readByte();
        }
        this.versionType = VersionType.fromValue(in.readByte());
        this.version = Versions.readVersionWithVLongForBW(in);
        if (in.getVersion().before(Version.V_1_5_0)) {
            FetchSourceContext.optionalReadFromStream(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().before(Version.V_1_4_0_Beta1)) {
            out.writeString(".scripts");
        }
        out.writeString(this.scriptLang);
        out.writeString(this.id);
        if (out.getVersion().before(Version.V_1_5_0)) {
            out.writeOptionalString("_local");
            out.writeBoolean(true);
            out.writeByte((byte)-1);
        }
        out.writeByte(this.versionType.getValue());
        Versions.writeVersionWithVLongForBW(this.version, out);
        if (out.getVersion().before(Version.V_1_5_0)) {
            FetchSourceContext.optionalWriteToStream(null, out);
        }
    }

    public String toString() {
        return "[.scripts][" + this.scriptLang + "][" + this.id + "]";
    }
}

