/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.lzf;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedIndexInput;
import org.elasticsearch.common.compress.CompressedStreamInput;
import org.elasticsearch.common.compress.CompressedStreamOutput;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.lzf.ChunkDecoder;
import org.elasticsearch.common.compress.lzf.LZFCompressedIndexInput;
import org.elasticsearch.common.compress.lzf.LZFCompressedStreamInput;
import org.elasticsearch.common.compress.lzf.LZFCompressedStreamOutput;
import org.elasticsearch.common.compress.lzf.LZFEncoder;
import org.elasticsearch.common.compress.lzf.util.ChunkDecoderFactory;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.settings.Settings;

public class LZFCompressor
implements Compressor {
    static final byte[] LUCENE_HEADER = new byte[]{76, 90, 70, 0};
    public static final String TYPE = "lzf";
    private ChunkDecoder decoder = ChunkDecoderFactory.safeInstance();

    public LZFCompressor() {
        Loggers.getLogger(LZFCompressor.class).debug("using encoder [{}] and decoder[{}] ", this.decoder.getClass().getSimpleName());
    }

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public void configure(Settings settings) {
    }

    @Override
    public boolean isCompressed(BytesReference bytes) {
        return bytes.length() >= 3 && bytes.get(0) == 90 && bytes.get(1) == 86 && (bytes.get(2) == 1 || bytes.get(2) == 0);
    }

    @Override
    public boolean isCompressed(byte[] data, int offset, int length) {
        return length >= 3 && data[offset] == 90 && data[offset + 1] == 86 && (data[offset + 2] == 1 || data[offset + 2] == 0);
    }

    @Override
    public boolean isCompressed(ChannelBuffer buffer) {
        int offset = buffer.readerIndex();
        return buffer.readableBytes() >= 3 && buffer.getByte(offset) == 90 && buffer.getByte(offset + 1) == 86 && (buffer.getByte(offset + 2) == 1 || buffer.getByte(offset + 2) == 0);
    }

    @Override
    public boolean isCompressed(IndexInput in) throws IOException {
        long currentPointer = in.getFilePointer();
        if (in.length() - currentPointer < (long)LUCENE_HEADER.length) {
            return false;
        }
        for (int i = 0; i < LUCENE_HEADER.length; ++i) {
            if (in.readByte() == LUCENE_HEADER[i]) continue;
            in.seek(currentPointer);
            return false;
        }
        in.seek(currentPointer);
        return true;
    }

    @Override
    public byte[] uncompress(byte[] data, int offset, int length) throws IOException {
        return this.decoder.decode(data, offset, length);
    }

    @Override
    public byte[] compress(byte[] data, int offset, int length) throws IOException {
        return LZFEncoder.safeEncode(data, offset, length);
    }

    @Override
    public CompressedStreamInput streamInput(StreamInput in) throws IOException {
        return new LZFCompressedStreamInput(in, this.decoder);
    }

    @Override
    public CompressedStreamOutput streamOutput(StreamOutput out) throws IOException {
        return new LZFCompressedStreamOutput(out);
    }

    @Override
    public CompressedIndexInput indexInput(IndexInput in) throws IOException {
        return new LZFCompressedIndexInput(in, this.decoder);
    }
}

