/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicOrdinalsFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.AbstractIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.search.MultiValueMode;

public abstract class AbstractIndexOrdinalsFieldData
extends AbstractIndexFieldData<AtomicOrdinalsFieldData>
implements IndexOrdinalsFieldData {
    protected Settings frequency;
    protected Settings regex;
    protected final CircuitBreakerService breakerService;

    protected AbstractIndexOrdinalsFieldData(Index index, Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache, CircuitBreakerService breakerService) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
        Map<String, Settings> groups = fieldDataType.getSettings().getGroups("filter");
        this.frequency = groups.get("frequency");
        this.regex = groups.get("regex");
        this.breakerService = breakerService;
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        return new BytesRefFieldComparatorSource(this, missingValue, sortMode, nested);
    }

    @Override
    public IndexOrdinalsFieldData loadGlobal(IndexReader indexReader) {
        if (indexReader.leaves().size() <= 1) {
            return this;
        }
        try {
            return this.cache.load(indexReader, this);
        }
        catch (Throwable e) {
            if (e instanceof ElasticsearchException) {
                throw (ElasticsearchException)e;
            }
            throw new ElasticsearchException(e.getMessage(), e);
        }
    }

    @Override
    public IndexOrdinalsFieldData localGlobalDirect(IndexReader indexReader) throws Exception {
        return GlobalOrdinalsBuilder.build(indexReader, this, this.indexSettings, this.breakerService, this.logger);
    }

    protected TermsEnum filter(Terms terms, AtomicReader reader) throws IOException {
        TermsEnum iterator = terms.iterator(null);
        if (iterator == null) {
            return null;
        }
        if (iterator != null && this.frequency != null) {
            iterator = FrequencyFilter.filter(iterator, terms, reader, this.frequency);
        }
        if (iterator != null && this.regex != null) {
            iterator = RegexFilter.filter(iterator, terms, reader, this.regex);
        }
        return iterator;
    }

    private static final class RegexFilter
    extends FilteredTermsEnum {
        private final Matcher matcher;
        private final CharsRefBuilder spare = new CharsRefBuilder();

        public RegexFilter(TermsEnum delegate, Matcher matcher) {
            super(delegate, false);
            this.matcher = matcher;
        }

        public static TermsEnum filter(TermsEnum iterator, Terms terms, AtomicReader reader, Settings regex) {
            String pattern = regex.get("pattern");
            if (pattern == null) {
                return iterator;
            }
            Pattern p = Pattern.compile(pattern);
            return new RegexFilter(iterator, p.matcher(""));
        }

        protected FilteredTermsEnum.AcceptStatus accept(BytesRef arg0) throws IOException {
            this.spare.copyUTF8Bytes(arg0);
            this.matcher.reset((CharSequence)this.spare.get());
            if (this.matcher.matches()) {
                return FilteredTermsEnum.AcceptStatus.YES;
            }
            return FilteredTermsEnum.AcceptStatus.NO;
        }
    }

    private static final class FrequencyFilter
    extends FilteredTermsEnum {
        private int minFreq;
        private int maxFreq;

        public FrequencyFilter(TermsEnum delegate, int minFreq, int maxFreq) {
            super(delegate, false);
            this.minFreq = minFreq;
            this.maxFreq = maxFreq;
        }

        public static TermsEnum filter(TermsEnum toFilter, Terms terms, AtomicReader reader, Settings settings) throws IOException {
            int docCount = terms.getDocCount();
            if (docCount == -1) {
                docCount = reader.maxDoc();
            }
            double minFrequency = settings.getAsDouble("min", (Double)0.0);
            double maxFrequency = settings.getAsDouble("max", (Double)((double)docCount + 1.0));
            double minSegmentSize = settings.getAsInt("min_segment_size", (Integer)0).intValue();
            if (minSegmentSize < (double)docCount) {
                int maxFreq;
                int minFreq = minFrequency >= 1.0 ? (int)minFrequency : (int)((double)docCount * minFrequency);
                int n = maxFreq = maxFrequency >= 1.0 ? (int)maxFrequency : (int)((double)docCount * maxFrequency);
                assert (minFreq < maxFreq);
                return new FrequencyFilter(toFilter, minFreq, maxFreq);
            }
            return toFilter;
        }

        protected FilteredTermsEnum.AcceptStatus accept(BytesRef arg0) throws IOException {
            int docFreq = this.docFreq();
            if (docFreq >= this.minFreq && docFreq <= this.maxFreq) {
                return FilteredTermsEnum.AcceptStatus.YES;
            }
            return FilteredTermsEnum.AcceptStatus.NO;
        }
    }
}

