/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.process;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.monitor.process.ProcessInfo;
import org.elasticsearch.monitor.process.ProcessProbe;
import org.elasticsearch.monitor.process.ProcessStats;

public class JmxProcessProbe
extends AbstractComponent
implements ProcessProbe {
    private static final OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
    private static final Method getMaxFileDescriptorCountField;
    private static final Method getOpenFileDescriptorCountField;

    public static long getMaxFileDescriptorCount() {
        if (getMaxFileDescriptorCountField == null) {
            return -1L;
        }
        try {
            return (Long)getMaxFileDescriptorCountField.invoke((Object)osMxBean, new Object[0]);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static long getOpenFileDescriptorCount() {
        if (getOpenFileDescriptorCountField == null) {
            return -1L;
        }
        try {
            return (Long)getOpenFileDescriptorCountField.invoke((Object)osMxBean, new Object[0]);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    @Inject
    public JmxProcessProbe(Settings settings) {
        super(settings);
    }

    @Override
    public ProcessInfo processInfo() {
        return new ProcessInfo(JvmInfo.jvmInfo().pid(), JmxProcessProbe.getMaxFileDescriptorCount());
    }

    @Override
    public ProcessStats processStats() {
        ProcessStats stats = new ProcessStats();
        stats.timestamp = System.currentTimeMillis();
        stats.openFileDescriptors = JmxProcessProbe.getOpenFileDescriptorCount();
        return stats;
    }

    static {
        Method method = null;
        try {
            method = osMxBean.getClass().getDeclaredMethod("getMaxFileDescriptorCount", new Class[0]);
            method.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        getMaxFileDescriptorCountField = method;
        method = null;
        try {
            method = osMxBean.getClass().getDeclaredMethod("getOpenFileDescriptorCount", new Class[0]);
            method.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        getOpenFileDescriptorCountField = method;
    }
}

