/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.upgrade;

import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.optimize.OptimizeRequest;
import org.elasticsearch.action.admin.indices.optimize.OptimizeResponse;
import org.elasticsearch.action.admin.indices.segments.IndexSegments;
import org.elasticsearch.action.admin.indices.segments.IndexShardSegments;
import org.elasticsearch.action.admin.indices.segments.IndicesSegmentResponse;
import org.elasticsearch.action.admin.indices.segments.IndicesSegmentsRequest;
import org.elasticsearch.action.admin.indices.segments.ShardSegments;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestBuilderListener;

public class RestUpgradeAction
extends BaseRestHandler {
    static final XContentBuilderString SIZE = new XContentBuilderString("size");
    static final XContentBuilderString SIZE_IN_BYTES = new XContentBuilderString("size_in_bytes");
    static final XContentBuilderString SIZE_TO_UPGRADE = new XContentBuilderString("size_to_upgrade");
    static final XContentBuilderString SIZE_TO_UPGRADE_IN_BYTES = new XContentBuilderString("size_to_upgrade_in_bytes");

    @Inject
    public RestUpgradeAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.POST, "/_upgrade", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_upgrade", this);
        controller.registerHandler(RestRequest.Method.GET, "/_upgrade", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_upgrade", this);
    }

    @Override
    protected void handleRequest(RestRequest request, RestChannel channel, Client client) throws Exception {
        if (request.method().equals((Object)RestRequest.Method.GET)) {
            this.handleGet(request, channel, client);
        } else if (request.method().equals((Object)RestRequest.Method.POST)) {
            this.handlePost(request, channel, client);
        }
    }

    void handleGet(RestRequest request, RestChannel channel, Client client) {
        IndicesSegmentsRequest segsReq = new IndicesSegmentsRequest(Strings.splitStringByCommaToArray(request.param("index")));
        client.admin().indices().segments(segsReq, (ActionListener<IndicesSegmentResponse>)new RestBuilderListener<IndicesSegmentResponse>(channel){

            @Override
            public RestResponse buildResponse(IndicesSegmentResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                for (IndexSegments indexSegments : response.getIndices().values()) {
                    Tuple<Long, Long> summary = RestUpgradeAction.this.calculateUpgradeStatus(indexSegments);
                    builder.startObject(indexSegments.getIndex());
                    builder.byteSizeField(SIZE_IN_BYTES, SIZE, summary.v1());
                    builder.byteSizeField(SIZE_TO_UPGRADE_IN_BYTES, SIZE_TO_UPGRADE, summary.v2());
                    builder.endObject();
                }
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    void handlePost(RestRequest request, RestChannel channel, Client client) {
        OptimizeRequest optimizeReq = new OptimizeRequest(Strings.splitStringByCommaToArray(request.param("index")));
        optimizeReq.flush(true);
        optimizeReq.upgrade(true);
        optimizeReq.maxNumSegments(Integer.MAX_VALUE);
        client.admin().indices().optimize(optimizeReq, (ActionListener<OptimizeResponse>)new RestBuilderListener<OptimizeResponse>(channel){

            @Override
            public RestResponse buildResponse(OptimizeResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                RestActions.buildBroadcastShardsHeader(builder, response);
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    Tuple<Long, Long> calculateUpgradeStatus(IndexSegments indexSegments) {
        long total_bytes = 0L;
        long to_upgrade_bytes = 0L;
        for (IndexShardSegments shard : indexSegments) {
            for (ShardSegments segs : shard.getShards()) {
                for (Segment seg : segs.getSegments()) {
                    total_bytes += seg.sizeInBytes;
                    if (seg.version.major == Version.CURRENT.luceneVersion.major && seg.version.minor == Version.CURRENT.luceneVersion.minor) continue;
                    to_upgrade_bytes += seg.sizeInBytes;
                }
            }
        }
        return new Tuple<Long, Long>(total_bytes, to_upgrade_bytes);
    }
}

